package io.qt.opengl;

import io.qt.*;


/**
 * <p>Describes the pixel storage modes that affect the unpacking of pixels during texture upload</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html">QOpenGLPixelTransferOptions</a></code></p>
 */
public class QOpenGLPixelTransferOptions extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#QOpenGLPixelTransferOptions">QOpenGLPixelTransferOptions::<wbr/>QOpenGLPixelTransferOptions()</a></code></p>
     */
    public QOpenGLPixelTransferOptions(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLPixelTransferOptions instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#QOpenGLPixelTransferOptions">QOpenGLPixelTransferOptions::<wbr/>QOpenGLPixelTransferOptions(QOpenGLPixelTransferOptions)</a></code></p>
     */
    public QOpenGLPixelTransferOptions(io.qt.opengl.@NonNull QOpenGLPixelTransferOptions arg__1){
        super((QPrivateConstructor)null);
        initialize_native(this, arg__1);
    }
    
    private native static void initialize_native(QOpenGLPixelTransferOptions instance, io.qt.opengl.QOpenGLPixelTransferOptions arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#alignment">QOpenGLPixelTransferOptions::<wbr/>alignment()const</a></code></p>
     */
    @QtUninvokable
    public final int alignment(){
        return alignment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int alignment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#imageHeight">QOpenGLPixelTransferOptions::<wbr/>imageHeight()const</a></code></p>
     */
    @QtUninvokable
    public final int imageHeight(){
        return imageHeight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int imageHeight_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#isLeastSignificantBitFirst">QOpenGLPixelTransferOptions::<wbr/>isLeastSignificantBitFirst()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isLeastSignificantBitFirst(){
        return isLeastSignificantBitFirst_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isLeastSignificantBitFirst_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#isSwapBytesEnabled">QOpenGLPixelTransferOptions::<wbr/>isSwapBytesEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isSwapBytesEnabled(){
        return isSwapBytesEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSwapBytesEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLPixelTransferOptions::<wbr/>operator=(QOpenGLPixelTransferOptions)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.opengl.@NonNull QOpenGLPixelTransferOptions arg__1){
        assign_native_cref_QOpenGLPixelTransferOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QOpenGLPixelTransferOptions(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#rowLength">QOpenGLPixelTransferOptions::<wbr/>rowLength()const</a></code></p>
     */
    @QtUninvokable
    public final int rowLength(){
        return rowLength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int rowLength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setAlignment">QOpenGLPixelTransferOptions::<wbr/>setAlignment(int)</a></code></p>
     */
    @QtUninvokable
    public final void setAlignment(int alignment){
        setAlignment_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), alignment);
    }
    
    @QtUninvokable
    private native void setAlignment_native_int(long __this__nativeId, int alignment);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setImageHeight">QOpenGLPixelTransferOptions::<wbr/>setImageHeight(int)</a></code></p>
     */
    @QtUninvokable
    public final void setImageHeight(int imageHeight){
        setImageHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), imageHeight);
    }
    
    @QtUninvokable
    private native void setImageHeight_native_int(long __this__nativeId, int imageHeight);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setLeastSignificantByteFirst">QOpenGLPixelTransferOptions::<wbr/>setLeastSignificantByteFirst(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setLeastSignificantByteFirst(boolean lsbFirst){
        setLeastSignificantByteFirst_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), lsbFirst);
    }
    
    @QtUninvokable
    private native void setLeastSignificantByteFirst_native_bool(long __this__nativeId, boolean lsbFirst);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setRowLength">QOpenGLPixelTransferOptions::<wbr/>setRowLength(int)</a></code></p>
     */
    @QtUninvokable
    public final void setRowLength(int rowLength){
        setRowLength_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), rowLength);
    }
    
    @QtUninvokable
    private native void setRowLength_native_int(long __this__nativeId, int rowLength);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setSkipImages">QOpenGLPixelTransferOptions::<wbr/>setSkipImages(int)</a></code></p>
     */
    @QtUninvokable
    public final void setSkipImages(int skipImages){
        setSkipImages_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), skipImages);
    }
    
    @QtUninvokable
    private native void setSkipImages_native_int(long __this__nativeId, int skipImages);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setSkipPixels">QOpenGLPixelTransferOptions::<wbr/>setSkipPixels(int)</a></code></p>
     */
    @QtUninvokable
    public final void setSkipPixels(int skipPixels){
        setSkipPixels_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), skipPixels);
    }
    
    @QtUninvokable
    private native void setSkipPixels_native_int(long __this__nativeId, int skipPixels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setSkipRows">QOpenGLPixelTransferOptions::<wbr/>setSkipRows(int)</a></code></p>
     */
    @QtUninvokable
    public final void setSkipRows(int skipRows){
        setSkipRows_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), skipRows);
    }
    
    @QtUninvokable
    private native void setSkipRows_native_int(long __this__nativeId, int skipRows);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#setSwapBytesEnabled">QOpenGLPixelTransferOptions::<wbr/>setSwapBytesEnabled(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setSwapBytesEnabled(boolean swapBytes){
        setSwapBytesEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), swapBytes);
    }
    
    @QtUninvokable
    private native void setSwapBytesEnabled_native_bool(long __this__nativeId, boolean swapBytes);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#skipImages">QOpenGLPixelTransferOptions::<wbr/>skipImages()const</a></code></p>
     */
    @QtUninvokable
    public final int skipImages(){
        return skipImages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int skipImages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#skipPixels">QOpenGLPixelTransferOptions::<wbr/>skipPixels()const</a></code></p>
     */
    @QtUninvokable
    public final int skipPixels(){
        return skipPixels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int skipPixels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglpixeltransferoptions.html#skipRows">QOpenGLPixelTransferOptions::<wbr/>skipRows()const</a></code></p>
     */
    @QtUninvokable
    public final int skipRows(){
        return skipRows_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int skipRows_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLPixelTransferOptions::<wbr/>swap(QOpenGLPixelTransferOptions&amp;)</code></p>
     */
    @QtUninvokable
    public final void swap(io.qt.opengl.@StrictNonNull QOpenGLPixelTransferOptions other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QOpenGLPixelTransferOptions(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QOpenGLPixelTransferOptions(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLPixelTransferOptions(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QOpenGLPixelTransferOptions clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOpenGLPixelTransferOptions clone_native(long __this_nativeId);
}
