package io.qt.opengl;

import io.qt.*;


/**
 * <p>Wraps an OpenGL Vertex Array Object</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html">QOpenGLVertexArrayObject</a></code></p>
 */
public class QOpenGLVertexArrayObject extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLVertexArrayObject.class);
    
    /**
     * <p>QOpenGLVertexArrayObject::Binder class is a convenience class to help with the binding and releasing of OpenGL Vertex Array Objects</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject-binder.html">QOpenGLVertexArrayObject::Binder</a></code></p>
     */
    public static class Binder extends QtObject
        implements AutoCloseable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject-binder.html#Binder">QOpenGLVertexArrayObject::Binder::<wbr>Binder(QOpenGLVertexArrayObject*)</a></code></p>
         */
        public Binder(io.qt.opengl.@Nullable QOpenGLVertexArrayObject v){
            super((QPrivateConstructor)null);
            initialize_native(this, v);
        }
        
        private native static void initialize_native(Binder instance, io.qt.opengl.QOpenGLVertexArrayObject v);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject-binder.html#rebind">QOpenGLVertexArrayObject::Binder::<wbr>rebind()</a></code></p>
         */
        @QtUninvokable
        public final void rebind(){
            rebind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native void rebind_native(long __this__nativeId);
        
        /**
         * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject-binder.html#release">QOpenGLVertexArrayObject::Binder::<wbr>release()</a></code></p>
         */
        @QtUninvokable
        public final void release(){
            release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native void release_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Binder(QPrivateConstructor p) { super(p); } 
        
        @Override
        @QtUninvokable
        public final void close(){
            dispose();
        }
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#QOpenGLVertexArrayObject">QOpenGLVertexArrayObject::<wbr>QOpenGLVertexArrayObject(QObject*)</a></code></p>
     */
    public QOpenGLVertexArrayObject(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOpenGLVertexArrayObject instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#bind">QOpenGLVertexArrayObject::<wbr>bind()</a></code></p>
     */
    @QtUninvokable
    public final void bind(){
        bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void bind_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#create">QOpenGLVertexArrayObject::<wbr>create()</a></code></p>
     */
    @QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#destroy">QOpenGLVertexArrayObject::<wbr>destroy()</a></code></p>
     */
    @QtUninvokable
    public final void destroy(){
        destroy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void destroy_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#isCreated">QOpenGLVertexArrayObject::<wbr>isCreated()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isCreated(){
        return isCreated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCreated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#objectId">QOpenGLVertexArrayObject::<wbr>objectId()const</a></code></p>
     */
    @QtUninvokable
    public final int objectId(){
        return objectId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int objectId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#release">QOpenGLVertexArrayObject::<wbr>release()</a></code></p>
     */
    @QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLVertexArrayObject(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QOpenGLVertexArrayObject(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QOpenGLVertexArrayObject instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLVertexArrayObject(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLVertexArrayObject() {
        this((io.qt.core.QObject)null);
    }
}
