package io.qt.opengl;

import io.qt.*;


/**
 * <p>Allows OpenGL shaders to be compiled</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglshader.html">QOpenGLShader</a></code></p>
 */
public class QOpenGLShader extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLShader.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopenglshader.html#ShaderTypeBit-enum">QOpenGLShader::ShaderTypeBit</a></code></p>
     * 
     * @see ShaderType
     */
    public enum ShaderTypeBit implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglshader.html#ShaderTypeBit-enum">QOpenGLShader::<wbr>Vertex</a></code></p>
         */
        Vertex(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglshader.html#ShaderTypeBit-enum">QOpenGLShader::<wbr>Fragment</a></code></p>
         */
        Fragment(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglshader.html#ShaderTypeBit-enum">QOpenGLShader::<wbr>Geometry</a></code></p>
         */
        Geometry(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglshader.html#ShaderTypeBit-enum">QOpenGLShader::<wbr>TessellationControl</a></code></p>
         */
        TessellationControl(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglshader.html#ShaderTypeBit-enum">QOpenGLShader::<wbr>TessellationEvaluation</a></code></p>
         */
        TessellationEvaluation(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopenglshader.html#ShaderTypeBit-enum">QOpenGLShader::<wbr>Compute</a></code></p>
         */
        Compute(32);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShaderTypeBit(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ShaderType asFlags() {
            return new ShaderType(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ShaderType combined(@NonNull ShaderTypeBit e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ShaderType cleared(@NonNull ShaderTypeBit e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link ShaderType} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ShaderType flags(@Nullable ShaderTypeBit @NonNull... values) {
            return new ShaderType(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ShaderTypeBit resolve(int value) {
            switch (value) {
            case 1: return Vertex;
            case 2: return Fragment;
            case 4: return Geometry;
            case 8: return TessellationControl;
            case 16: return TessellationEvaluation;
            case 32: return Compute;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link ShaderTypeBit}
     */
    public static final class ShaderType extends QFlags<ShaderTypeBit> implements Comparable<ShaderType> {
        private static final long serialVersionUID = 0x537faec4bcf3a495L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ShaderType where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ShaderType(@Nullable ShaderTypeBit @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ShaderType with given <code>value</code>.
         * @param value
         */
        public ShaderType(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ShaderType
         */
        @Override
        public final @NonNull ShaderType combined(@StrictNonNull ShaderTypeBit e){
            return new ShaderType(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ShaderType setFlag(@Nullable ShaderTypeBit e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ShaderType setFlag(@Nullable ShaderTypeBit e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ShaderType.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ShaderTypeBit @NonNull[] flags(){
            return super.flags(ShaderTypeBit.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ShaderType clone(){
            return new ShaderType(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ShaderType other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#QOpenGLShader">QOpenGLShader::<wbr>QOpenGLShader(QOpenGLShader::ShaderType,<wbr>QObject*)</a></code></p>
     */
    public QOpenGLShader(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, type, parent);
    }
    
    private native static void initialize_native(QOpenGLShader instance, io.qt.opengl.QOpenGLShader.ShaderType type, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#compileSourceCode-1">QOpenGLShader::<wbr>compileSourceCode(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final boolean compileSourceCode(io.qt.core.@NonNull QByteArray source){
        return compileSourceCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native boolean compileSourceCode_native_cref_QByteArray(long __this__nativeId, long source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#compileSourceCode-2">QOpenGLShader::<wbr>compileSourceCode(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean compileSourceCode(java.lang.@NonNull String source){
        return compileSourceCode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), source);
    }
    
    @QtUninvokable
    private native boolean compileSourceCode_native_cref_QString(long __this__nativeId, java.lang.String source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#compileSourceFile">QOpenGLShader::<wbr>compileSourceFile(QString)</a></code></p>
     */
    @QtUninvokable
    public final boolean compileSourceFile(java.lang.@NonNull String fileName){
        return compileSourceFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native boolean compileSourceFile_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#isCompiled">QOpenGLShader::<wbr>isCompiled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isCompiled(){
        return isCompiled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCompiled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#log">QOpenGLShader::<wbr>log()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String log(){
        return log_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String log_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#shaderId">QOpenGLShader::<wbr>shaderId()const</a></code></p>
     */
    @QtUninvokable
    public final int shaderId(){
        return shaderId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int shaderId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#shaderType">QOpenGLShader::<wbr>shaderType()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLShader.@NonNull ShaderType shaderType(){
        return new io.qt.opengl.QOpenGLShader.ShaderType(shaderType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int shaderType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#sourceCode">QOpenGLShader::<wbr>sourceCode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray sourceCode(){
        return sourceCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray sourceCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglshader.html#hasOpenGLShaders">QOpenGLShader::<wbr>hasOpenGLShaders(QOpenGLShader::ShaderType,<wbr>QOpenGLContext*)</a></code></p>
     */
    public static boolean hasOpenGLShaders(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, io.qt.gui.@Nullable QOpenGLContext context){
        return hasOpenGLShaders_native_QOpenGLShader_ShaderType_QOpenGLContext_ptr(type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    private native static boolean hasOpenGLShaders_native_QOpenGLShader_ShaderType_QOpenGLContext_ptr(int type, long context);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLShader(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLShader(io.qt.opengl.QOpenGLShader.ShaderType, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLShader(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type) {
        this(type, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #hasOpenGLShaders(io.qt.opengl.QOpenGLShader.ShaderType, io.qt.gui.QOpenGLContext)}
     *  with <code>context = null</code>.</p>
     */
    public static boolean hasOpenGLShaders(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type) {
        return hasOpenGLShaders(type, (io.qt.gui.QOpenGLContext)null);
    }
}
