package io.qt.opengl;

import io.qt.*;


/**
 * <p>All functions for OpenGL 3.2 compatibility profile</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglfunctions-3-2-compatibility.html">QOpenGLFunctions_3_2_Compatibility</a></code></p>
 */
public final class QOpenGLFunctions_3_2_Compatibility extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>QOpenGLFunctions_3_2_Compatibility()</code></p>
     */
    public QOpenGLFunctions_3_2_Compatibility(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_3_2_Compatibility instance);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glAccum(GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glAccum(int op, float value){
        glAccum_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), op, value);
    }
    
    @QtUninvokable
    private native void glAccum_native_GLenum_GLfloat(long __this__nativeId, int op, float value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glActiveTexture(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glAlphaFunc(GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glAlphaFunc(int func, float ref){
        glAlphaFunc_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref);
    }
    
    @QtUninvokable
    private native void glAlphaFunc_native_GLenum_GLfloat(long __this__nativeId, int func, float ref);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glAreTexturesResident(GLsizei,<wbr>const GLuint*,<wbr>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final boolean glAreTexturesResident(java.nio.IntBuffer textures, boolean[] residences){
        return glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), textures, residences);
    }
    
    @QtUninvokable
    private native boolean glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(long __this__nativeId, java.nio.IntBuffer textures, boolean[] residences);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glArrayElement(GLint)</code></p>
     */
    @QtUninvokable
    public final void glArrayElement(int i){
        glArrayElement_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void glArrayElement_native_GLint(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glAttachShader(GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBegin(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBegin(int mode){
        glBegin_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBegin_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBeginConditionalRender(GLuint,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBeginConditionalRender(int id, int mode){
        glBeginConditionalRender_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, mode);
    }
    
    @QtUninvokable
    private native void glBeginConditionalRender_native_GLuint_GLenum(long __this__nativeId, int id, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBeginQuery(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBeginQuery(int target, int id){
        glBeginQuery_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBeginQuery_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBeginTransformFeedback(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBeginTransformFeedback(int primitiveMode){
        glBeginTransformFeedback_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveMode);
    }
    
    @QtUninvokable
    private native void glBeginTransformFeedback_native_GLenum(long __this__nativeId, int primitiveMode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindAttribLocation(GLuint,<wbr>GLuint,<wbr>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.nio.CharBuffer name){
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindBuffer(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindBufferBase(GLenum,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindBufferBase(int target, int index, int buffer){
        glBindBufferBase_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer);
    }
    
    @QtUninvokable
    private native void glBindBufferBase_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindBufferRange(GLenum,<wbr>GLuint,<wbr>GLuint,<wbr>GLintptr,<wbr>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glBindBufferRange(int target, int index, int buffer, long offset, long size){
        glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int index, int buffer, long offset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindFragDataLocation(GLuint,<wbr>GLuint,<wbr>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glBindFragDataLocation(int program, int color, java.nio.CharBuffer name){
        glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, color, name);
    }
    
    @QtUninvokable
    private native void glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int color, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindFramebuffer(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindFramebuffer(int target, int framebuffer){
        glBindFramebuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, framebuffer);
    }
    
    @QtUninvokable
    private native void glBindFramebuffer_native_GLenum_GLuint(long __this__nativeId, int target, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindRenderbuffer(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindRenderbuffer(int target, int renderbuffer){
        glBindRenderbuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, renderbuffer);
    }
    
    @QtUninvokable
    private native void glBindRenderbuffer_native_GLenum_GLuint(long __this__nativeId, int target, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindTexture(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBindVertexArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindVertexArray(int array){
        glBindVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glBindVertexArray_native_GLuint(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBitmap(GLsizei,<wbr>GLsizei,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glBitmap(int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.ByteBuffer bitmap){
        glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, xorig, yorig, xmove, ymove, bitmap);
    }
    
    @QtUninvokable
    private native void glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(long __this__nativeId, int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.ByteBuffer bitmap);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBlendColor(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBlendEquation(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBlendEquationSeparate(GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBlendFunc(GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBlendFuncSeparate(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBlitFramebuffer(GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLbitfield,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter){
        glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    
    @QtUninvokable
    private native void glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(long __this__nativeId, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBufferData(GLenum,<wbr>GLsizeiptr,<wbr>const GLvoid*,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBufferData(int target, long size, java.nio.Buffer data, int usage){
        glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glBufferSubData(GLenum,<wbr>GLintptr,<wbr>GLsizeiptr,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCallList(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glCallList(int list){
        glCallList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native void glCallList_native_GLuint(long __this__nativeId, int list);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCallLists(GLsizei,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCallLists(int n, int type, java.nio.Buffer lists){
        glCallLists_native_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, type, lists);
    }
    
    @QtUninvokable
    private native void glCallLists_native_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int n, int type, java.nio.Buffer lists);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCheckFramebufferStatus(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glCheckFramebufferStatus(int target){
        return glCheckFramebufferStatus_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native int glCheckFramebufferStatus_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClampColor(GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glClampColor(int target, int clamp){
        glClampColor_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, clamp);
    }
    
    @QtUninvokable
    private native void glClampColor_native_GLenum_GLenum(long __this__nativeId, int target, int clamp);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClear(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearAccum(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearAccum(float red, float green, float blue, float alpha){
        glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearBufferfi(GLenum,<wbr>GLint,<wbr>GLfloat,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil){
        glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, depth, stencil);
    }
    
    @QtUninvokable
    private native void glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(long __this__nativeId, int buffer, int drawbuffer, float depth, int stencil);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearBufferfv(GLenum,<wbr>GLint,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferfv(int buffer, int drawbuffer, java.nio.FloatBuffer value){
        glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearBufferiv(GLenum,<wbr>GLint,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferiv(int buffer, int drawbuffer, java.nio.IntBuffer value){
        glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearBufferuiv(GLenum,<wbr>GLint,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferuiv(int buffer, int drawbuffer, java.nio.IntBuffer value){
        glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearColor(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearDepth(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearIndex(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearIndex(float c){
        glClearIndex_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glClearIndex_native_GLfloat(long __this__nativeId, float c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClearStencil(GLint)</code></p>
     */
    @QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClientActiveTexture(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glClientActiveTexture(int texture){
        glClientActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glClientActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClientWaitSync(GLsync,<wbr>GLbitfield,<wbr>GLuint64)</code></p>
     */
    @QtUninvokable
    public final int glClientWaitSync(io.qt.gui.gl.@Nullable GLsync sync, int flags, long timeout){
        return glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @QtUninvokable
    private native int glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glClipPlane(GLenum,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glClipPlane(int plane, double[] equation){
        if(equation!=null && equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glClipPlane_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @QtUninvokable
    private native void glClipPlane_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3b(GLbyte,<wbr>GLbyte,<wbr>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glColor3b(byte red, byte green, byte blue){
        glColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glColor3bv(byte[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3d(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glColor3d(double red, double green, double blue){
        glColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glColor3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3f(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glColor3f(float red, float green, float blue){
        glColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColor3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3i(GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glColor3i(int red, int green, int blue){
        glColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColor3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3s(GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glColor3s(short red, short green, short blue){
        glColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glColor3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4b(GLbyte,<wbr>GLbyte,<wbr>GLbyte,<wbr>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glColor4b(byte red, byte green, byte blue, byte alpha){
        glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue, byte alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glColor4bv(byte[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4d(GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glColor4d(double red, double green, double blue, double alpha){
        glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue, double alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glColor4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4f(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glColor4f(float red, float green, float blue, float alpha){
        glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColor4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4i(GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glColor4i(int red, int green, int blue, int alpha){
        glColor4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue, int alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColor4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4s(GLshort,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glColor4s(short red, short green, short blue, short alpha){
        glColor4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue, short alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColor4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glColor4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColorMask(GLboolean,<wbr>GLboolean,<wbr>GLboolean,<wbr>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColorMaski(GLuint,<wbr>GLboolean,<wbr>GLboolean,<wbr>GLboolean,<wbr>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glColorMaski(int index, boolean r, boolean g, boolean b, boolean a){
        glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), index, r, g, b, a);
    }
    
    @QtUninvokable
    private native void glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, int index, boolean r, boolean g, boolean b, boolean a);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColorMaterial(GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glColorMaterial(int face, int mode){
        glColorMaterial_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glColorMaterial_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColorPointer(GLint,<wbr>GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glColorPointer(int size, int type, int stride, java.nio.Buffer pointer){
        glColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColorSubTable(GLenum,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glColorSubTable(int target, int start, int count, int format, int type, java.nio.Buffer data){
        glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, count, format, type, data);
    }
    
    @QtUninvokable
    private native void glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int start, int count, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColorTable(GLenum,<wbr>GLenum,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glColorTable(int target, int internalformat, int width, int format, int type, java.nio.Buffer table){
        glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, table);
    }
    
    @QtUninvokable
    private native void glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColorTableParameterfv(GLenum,<wbr>GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColorTableParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glColorTableParameteriv(GLenum,<wbr>GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColorTableParameteriv(int target, int pname, java.nio.IntBuffer params){
        glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCompileShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCompressedTexImage1D(GLenum,<wbr>GLint,<wbr>GLenum,<wbr>GLsizei,<wbr>GLint,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data){
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCompressedTexImage2D(GLenum,<wbr>GLint,<wbr>GLenum,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLint,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCompressedTexImage3D(GLenum,<wbr>GLint,<wbr>GLenum,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLint,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data){
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCompressedTexSubImage1D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data){
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCompressedTexSubImage2D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCompressedTexSubImage3D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data){
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glConvolutionFilter1D(GLenum,<wbr>GLenum,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, java.nio.Buffer image){
        glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, image);
    }
    
    @QtUninvokable
    private native void glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glConvolutionFilter2D(GLenum,<wbr>GLenum,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer image){
        glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, image);
    }
    
    @QtUninvokable
    private native void glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glConvolutionParameterf(GLenum,<wbr>GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameterf(int target, int pname, float params){
        glConvolutionParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glConvolutionParameterfv(GLenum,<wbr>GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glConvolutionParameteri(GLenum,<wbr>GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameteri(int target, int pname, int params){
        glConvolutionParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glConvolutionParameteriv(GLenum,<wbr>GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameteriv(int target, int pname, java.nio.IntBuffer params){
        glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyBufferSubData(GLenum,<wbr>GLenum,<wbr>GLintptr,<wbr>GLintptr,<wbr>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size){
        glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), readTarget, writeTarget, readOffset, writeOffset, size);
    }
    
    @QtUninvokable
    private native void glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(long __this__nativeId, int readTarget, int writeTarget, long readOffset, long writeOffset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyColorSubTable(GLenum,<wbr>GLsizei,<wbr>GLint,<wbr>GLint,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyColorSubTable(int target, int start, int x, int y, int width){
        glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(long __this__nativeId, int target, int start, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyColorTable(GLenum,<wbr>GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyColorTable(int target, int internalformat, int x, int y, int width){
        glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyConvolutionFilter1D(GLenum,<wbr>GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyConvolutionFilter1D(int target, int internalformat, int x, int y, int width){
        glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyConvolutionFilter2D(GLenum,<wbr>GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyConvolutionFilter2D(int target, int internalformat, int x, int y, int width, int height){
        glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyPixels(GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glCopyPixels(int x, int y, int width, int height, int type){
        glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, type);
    }
    
    @QtUninvokable
    private native void glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(long __this__nativeId, int x, int y, int width, int height, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyTexImage1D(GLenum,<wbr>GLint,<wbr>GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyTexImage2D(GLenum,<wbr>GLint,<wbr>GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyTexSubImage1D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyTexSubImage2D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCopyTexSubImage3D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCreateProgram()</code></p>
     */
    @QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCreateShader(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glCullFace(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteBuffers(GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.IntBuffer buffers){
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteFramebuffers(GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteFramebuffers(int n, java.nio.IntBuffer framebuffers){
        glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteLists(GLuint,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDeleteLists(int list, int range){
        glDeleteLists_native_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), list, range);
    }
    
    @QtUninvokable
    private native void glDeleteLists_native_GLuint_GLsizei(long __this__nativeId, int list, int range);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteQueries(GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteQueries(int n, java.nio.IntBuffer ids){
        glDeleteQueries_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteQueries_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteRenderbuffers(GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteRenderbuffers(int n, java.nio.IntBuffer renderbuffers){
        glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteSync(GLsync)</code></p>
     */
    @QtUninvokable
    public final void glDeleteSync(io.qt.gui.gl.@Nullable GLsync sync){
        glDeleteSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @QtUninvokable
    private native void glDeleteSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteTextures(GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteTextures(int n, java.nio.IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDeleteVertexArrays(GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteVertexArrays(int n, java.nio.IntBuffer arrays){
        glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDepthFunc(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDepthMask(GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDepthRange(GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDetachShader(GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDisable(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDisableClientState(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDisableClientState(int array){
        glDisableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glDisableClientState_native_GLenum(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDisableVertexAttribArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDisablei(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDisablei(int target, int index){
        glDisablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glDisablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawArrays(GLenum,<wbr>GLint,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawArraysInstanced(GLenum,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawArraysInstanced(int mode, int first, int count, int instancecount){
        glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(long __this__nativeId, int mode, int first, int count, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDrawBuffer(int mode){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawBuffers(GLsizei,<wbr>const GLenum*)</code></p>
     */
    @QtUninvokable
    public final void glDrawBuffers(int n, java.nio.IntBuffer bufs){
        glDrawBuffers_native_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, bufs);
    }
    
    @QtUninvokable
    private native void glDrawBuffers_native_GLsizei_const_GLenum_ptr(long __this__nativeId, int n, java.nio.IntBuffer bufs);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawElements(GLenum,<wbr>GLsizei,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawElementsBaseVertex(GLenum,<wbr>GLsizei,<wbr>GLenum,<wbr>const GLvoid*,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsBaseVertex(int mode, int count, int type, java.nio.Buffer indices, int basevertex){
        glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawElementsInstanced(GLenum,<wbr>GLsizei,<wbr>GLenum,<wbr>const GLvoid*,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsInstanced(int mode, int count, int type, java.nio.Buffer indices, int instancecount){
        glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawElementsInstancedBaseVertex(GLenum,<wbr>GLsizei,<wbr>GLenum,<wbr>const GLvoid*,<wbr>GLsizei,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsInstancedBaseVertex(int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex){
        glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawPixels(GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glDrawPixels(int width, int height, int format, int type, java.nio.Buffer pixels){
        glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawRangeElements(GLenum,<wbr>GLuint,<wbr>GLuint,<wbr>GLsizei,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.Buffer indices){
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glDrawRangeElementsBaseVertex(GLenum,<wbr>GLuint,<wbr>GLuint,<wbr>GLsizei,<wbr>GLenum,<wbr>const GLvoid*,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, java.nio.Buffer indices, int basevertex){
        glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr_GLint(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices, int basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEdgeFlag(GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glEdgeFlag(boolean flag){
        glEdgeFlag_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glEdgeFlag_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEdgeFlagPointer(GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glEdgeFlagPointer(int stride, java.nio.Buffer pointer){
        glEdgeFlagPointer_native_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), stride, pointer);
    }
    
    @QtUninvokable
    private native void glEdgeFlagPointer_native_GLsizei_const_GLvoid_ptr(long __this__nativeId, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEnable(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEnableClientState(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEnableClientState(int array){
        glEnableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glEnableClientState_native_GLenum(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEnableVertexAttribArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEnablei(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glEnablei(int target, int index){
        glEnablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glEnablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEnd()</code></p>
     */
    @QtUninvokable
    public final void glEnd(){
        glEnd_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEnd_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEndConditionalRender()</code></p>
     */
    @QtUninvokable
    public final void glEndConditionalRender(){
        glEndConditionalRender_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndConditionalRender_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEndList()</code></p>
     */
    @QtUninvokable
    public final void glEndList(){
        glEndList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndList_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEndQuery(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEndQuery(int target){
        glEndQuery_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glEndQuery_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEndTransformFeedback()</code></p>
     */
    @QtUninvokable
    public final void glEndTransformFeedback(){
        glEndTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndTransformFeedback_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalCoord1d(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1d(double u){
        glEvalCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1d_native_GLdouble(long __this__nativeId, double u);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalCoord1dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1dv(double[] u){
        if(u!=null && u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalCoord1f(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1f(float u){
        glEvalCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1f_native_GLfloat(long __this__nativeId, float u);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalCoord1fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1fv(float[] u){
        if(u!=null && u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalCoord2d(GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2d(double u, double v){
        glEvalCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @QtUninvokable
    private native void glEvalCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double u, double v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalCoord2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2dv(double[] u){
        if(u!=null && u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalCoord2f(GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2f(float u, float v){
        glEvalCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @QtUninvokable
    private native void glEvalCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float u, float v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalCoord2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2fv(float[] u){
        if(u!=null && u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalMesh1(GLenum,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalMesh1(int mode, int i1, int i2){
        glEvalMesh1_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2);
    }
    
    @QtUninvokable
    private native void glEvalMesh1_native_GLenum_GLint_GLint(long __this__nativeId, int mode, int i1, int i2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalMesh2(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalMesh2(int mode, int i1, int i2, int j1, int j2){
        glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2, j1, j2);
    }
    
    @QtUninvokable
    private native void glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int mode, int i1, int i2, int j1, int j2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalPoint1(GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalPoint1(int i){
        glEvalPoint1_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void glEvalPoint1_native_GLint(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glEvalPoint2(GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalPoint2(int i, int j){
        glEvalPoint2_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i, j);
    }
    
    @QtUninvokable
    private native void glEvalPoint2_native_GLint_GLint(long __this__nativeId, int i, int j);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFeedbackBuffer(GLsizei,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glFeedbackBuffer(int type, java.nio.FloatBuffer buffer){
        glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, buffer);
    }
    
    @QtUninvokable
    private native void glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(long __this__nativeId, int type, java.nio.FloatBuffer buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFenceSync(GLenum,<wbr>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final io.qt.gui.gl.@Nullable GLsync glFenceSync(int condition, int flags){
        return glFenceSync_native_GLenum_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), condition, flags);
    }
    
    @QtUninvokable
    private native io.qt.gui.gl.GLsync glFenceSync_native_GLenum_GLbitfield(long __this__nativeId, int condition, int flags);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFinish()</code></p>
     */
    @QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFlush()</code></p>
     */
    @QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFlushMappedBufferRange(GLenum,<wbr>GLintptr,<wbr>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glFlushMappedBufferRange(int target, long offset, long length){
        glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, length);
    }
    
    @QtUninvokable
    private native void glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(long __this__nativeId, int target, long offset, long length);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogCoordPointer(GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glFogCoordPointer(int type, int stride, java.nio.Buffer pointer){
        glFogCoordPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glFogCoordPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogCoordd(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glFogCoordd(double coord){
        glFogCoordd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordd_native_GLdouble(long __this__nativeId, double coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogCoorddv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glFogCoorddv(java.nio.DoubleBuffer coord){
        glFogCoorddv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoorddv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogCoordf(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glFogCoordf(float coord){
        glFogCoordf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordf_native_GLfloat(long __this__nativeId, float coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogCoordfv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glFogCoordfv(java.nio.FloatBuffer coord){
        glFogCoordfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @QtUninvokable
    private native void glFogCoordfv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer coord);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogf(GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glFogf(int pname, float param){
        glFogf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glFogf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogfv(GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glFogfv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glFogfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogi(GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFogi(int pname, int param){
        glFogi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glFogi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFogiv(GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glFogiv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogiv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glFogiv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFramebufferRenderbuffer(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer){
        glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, renderbuffertarget, renderbuffer);
    }
    
    @QtUninvokable
    private native void glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(long __this__nativeId, int target, int attachment, int renderbuffertarget, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFramebufferTexture(GLenum,<wbr>GLenum,<wbr>GLuint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture(int target, int attachment, int texture, int level){
        glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFramebufferTexture1D(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLuint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture1D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFramebufferTexture2D(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLuint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFramebufferTexture3D(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLuint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset){
        glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level, zoffset);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level, int zoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFramebufferTextureLayer(GLenum,<wbr>GLenum,<wbr>GLuint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer){
        glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level, layer);
    }
    
    @QtUninvokable
    private native void glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int texture, int level, int layer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFrontFace(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glFrustum(GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glFrustum(double left, double right, double bottom, double top, double zNear, double zFar){
        glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @QtUninvokable
    private native void glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGenBuffers(GLsizei,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenBuffers(int n, java.nio.IntBuffer buffers){
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGenFramebuffers(GLsizei,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenFramebuffers(int n, java.nio.IntBuffer framebuffers){
        glGenFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glGenFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGenLists(GLsizei)</code></p>
     */
    @QtUninvokable
    public final int glGenLists(int range){
        return glGenLists_native_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), range);
    }
    
    @QtUninvokable
    private native int glGenLists_native_GLsizei(long __this__nativeId, int range);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGenQueries(GLsizei,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenQueries(int n, java.nio.IntBuffer ids){
        glGenQueries_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenQueries_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGenRenderbuffers(GLsizei,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenRenderbuffers(int n, java.nio.IntBuffer renderbuffers){
        glGenRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glGenRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGenTextures(GLsizei,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenTextures(int n, java.nio.IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGenVertexArrays(GLsizei,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenVertexArrays(int n, java.nio.IntBuffer arrays){
        glGenVertexArrays_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glGenVertexArrays_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGenerateMipmap(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glGenerateMipmap(int target){
        glGenerateMipmap_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glGenerateMipmap_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetActiveAttrib(GLuint,<wbr>GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLint*,<wbr>GLenum*,<wbr>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetActiveUniform(GLuint,<wbr>GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLint*,<wbr>GLenum*,<wbr>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetActiveUniformBlockName(GLuint,<wbr>GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName){
        glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetActiveUniformBlockiv(GLuint,<wbr>GLuint,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params){
        glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetActiveUniformName(GLuint,<wbr>GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformName(int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName){
        glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformIndex, bufSize, length, uniformName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetActiveUniformsiv(GLuint,<wbr>GLsizei,<wbr>const GLuint*,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformsiv(int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params){
        glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformCount, uniformIndices, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetAttachedShaders(GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetAttachedShaders(int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj){
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxCount, count, obj);
    }
    
    @QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetAttribLocation(GLuint,<wbr>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetAttribLocation(int program, java.nio.CharBuffer name){
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetBooleani_v(GLenum,<wbr>GLuint,<wbr>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final void glGetBooleani_v(int target, int index, java.nio.IntBuffer data){
        glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetBooleanv(GLenum,<wbr>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetBufferParameteri64v(GLenum,<wbr>GLenum,<wbr>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferParameteri64v(int target, int pname, java.nio.LongBuffer params){
        glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(long __this__nativeId, int target, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetBufferParameteriv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetBufferPointerv(GLenum,<wbr>GLenum,<wbr>GLvoid**)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferPointerv(int target, int pname, java.nio.Buffer[] params){
        glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int target, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetBufferSubData(GLenum,<wbr>GLintptr,<wbr>GLsizeiptr,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetClipPlane(GLenum,<wbr>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetClipPlane(int plane, double[] equation){
        if(equation!=null && equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glGetClipPlane_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @QtUninvokable
    private native void glGetClipPlane_native_GLenum_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetColorTable(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTable(int target, int format, int type, java.nio.Buffer table){
        glGetColorTable_native_GLenum_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, table);
    }
    
    @QtUninvokable
    private native void glGetColorTable_native_GLenum_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetColorTableParameterfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTableParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetColorTableParameteriv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTableParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetCompressedTexImage(GLenum,<wbr>GLint,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.Buffer img){
        glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetConvolutionFilter(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionFilter(int target, int format, int type, java.nio.Buffer image){
        glGetConvolutionFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, image);
    }
    
    @QtUninvokable
    private native void glGetConvolutionFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetConvolutionParameterfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetConvolutionParameteriv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetDoublev(GLenum,<wbr>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetDoublev(int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetError()</code></p>
     */
    @QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetFloatv(GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetFloatv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetFragDataLocation(GLuint,<wbr>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetFragDataLocation(int program, java.nio.CharBuffer name){
        return glGetFragDataLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetFragDataLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetFramebufferAttachmentParameteriv(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, java.nio.IntBuffer params){
        glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, pname, params);
    }
    
    @QtUninvokable
    private native void glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int attachment, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetHistogram(GLenum,<wbr>GLboolean,<wbr>GLenum,<wbr>GLenum,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogram(int target, boolean reset, int format, int type, java.nio.Buffer values){
        glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @QtUninvokable
    private native void glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetHistogramParameterfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogramParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetHistogramParameteriv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogramParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetInteger64i_v(GLenum,<wbr>GLuint,<wbr>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetInteger64i_v(int target, int index, java.nio.LongBuffer data){
        glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(long __this__nativeId, int target, int index, java.nio.LongBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetInteger64v(GLenum,<wbr>GLint64*)</code></p>
     */
    @QtUninvokable
    public final void glGetInteger64v(int pname, java.nio.LongBuffer params){
        glGetInteger64v_native_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetInteger64v_native_GLenum_GLint64_ptr(long __this__nativeId, int pname, java.nio.LongBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetIntegeri_v(GLenum,<wbr>GLuint,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetIntegeri_v(int target, int index, java.nio.IntBuffer data){
        glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetIntegerv(GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetIntegerv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetLightfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetLightfv(int light, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetLightiv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetLightiv(int light, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glGetLightiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMapdv(GLenum,<wbr>GLenum,<wbr>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapdv(int target, int query, double[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int target, int query, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMapfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapfv(int target, int query, float[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int query, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMapiv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapiv(int target, int query, int[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int query, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMaterialfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMaterialfv(int face, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMaterialiv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMaterialiv(int face, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMinmax(GLenum,<wbr>GLboolean,<wbr>GLenum,<wbr>GLenum,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmax(int target, boolean reset, int format, int type, java.nio.Buffer values){
        glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @QtUninvokable
    private native void glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMinmaxParameterfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmaxParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMinmaxParameteriv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmaxParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetMultisamplefv(GLenum,<wbr>GLuint,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMultisamplefv(int pname, int index, java.nio.FloatBuffer val){
        glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, index, val);
    }
    
    @QtUninvokable
    private native void glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(long __this__nativeId, int pname, int index, java.nio.FloatBuffer val);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetPixelMapfv(GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapfv(int map, java.nio.FloatBuffer values){
        glGetPixelMapfv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapfv_native_GLenum_GLfloat_ptr(long __this__nativeId, int map, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetPixelMapuiv(GLenum,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapuiv(int map, java.nio.IntBuffer values){
        glGetPixelMapuiv_native_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapuiv_native_GLenum_GLuint_ptr(long __this__nativeId, int map, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetPixelMapusv(GLenum,<wbr>GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapusv(int map, java.nio.ShortBuffer values){
        glGetPixelMapusv_native_GLenum_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapusv_native_GLenum_GLushort_ptr(long __this__nativeId, int map, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetPointerv(GLenum,<wbr>GLvoid**)</code></p>
     */
    @QtUninvokable
    public final void glGetPointerv(int pname, java.nio.Buffer @StrictNonNull[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetPointerv_native_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetPointerv_native_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetPolygonStipple(GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glGetPolygonStipple(java.nio.ByteBuffer mask){
        glGetPolygonStipple_native_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glGetPolygonStipple_native_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetProgramInfoLog(GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog){
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetProgramiv(GLuint,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.IntBuffer params){
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetQueryObjectiv(GLuint,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryObjectiv(int id, int pname, java.nio.IntBuffer params){
        glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetQueryObjectuiv(GLuint,<wbr>GLenum,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryObjectuiv(int id, int pname, java.nio.IntBuffer params){
        glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetQueryiv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryiv(int target, int pname, java.nio.IntBuffer params){
        glGetQueryiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetRenderbufferParameteriv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetRenderbufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetSeparableFilter(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLvoid*,<wbr>GLvoid*,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetSeparableFilter(int target, int format, int type, java.nio.Buffer row, java.nio.Buffer column, java.nio.Buffer span){
        glGetSeparableFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr_GLvoid_ptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, row, column, span);
    }
    
    @QtUninvokable
    private native void glGetSeparableFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr_GLvoid_ptr_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer row, java.nio.Buffer column, java.nio.Buffer span);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetShaderInfoLog(GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog){
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetShaderSource(GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderSource(int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source){
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, source);
    }
    
    @QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetShaderiv(GLuint,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.IntBuffer params){
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetString(GLenum)</code></p>
     */
    @QtUninvokable
    public final java.lang.String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.String glGetString_native_GLenum(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetStringi(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final java.lang.String glGetStringi(int name, int index){
        return glGetStringi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name, index);
    }
    
    @QtUninvokable
    private native java.lang.String glGetStringi_native_GLenum_GLuint(long __this__nativeId, int name, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetSynciv(GLsync,<wbr>GLenum,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetSynciv(io.qt.gui.gl.@Nullable GLsync sync, int pname, int[] length, java.nio.IntBuffer values){
        if(length!=null && length.length < 1)
            throw new IllegalArgumentException("Argument 'length': Wrong number of elements in array. Found: " + length.length + ", expected: 1");
        glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), pname, length, values);
    }
    
    @QtUninvokable
    private native void glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(long __this__nativeId, long sync, int pname, int[] length, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexEnvfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexEnvfv(int target, int pname, java.nio.FloatBuffer params){
        glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexEnviv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexEnviv(int target, int pname, java.nio.IntBuffer params){
        glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexGendv(GLenum,<wbr>GLenum,<wbr>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGendv(int coord, int pname, java.nio.DoubleBuffer params){
        glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int coord, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexGenfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGenfv(int coord, int pname, java.nio.FloatBuffer params){
        glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int coord, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexGeniv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGeniv(int coord, int pname, java.nio.IntBuffer params){
        glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int coord, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexImage(GLenum,<wbr>GLint,<wbr>GLenum,<wbr>GLenum,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.Buffer pixels){
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexLevelParameterfv(GLenum,<wbr>GLint,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.FloatBuffer params){
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexLevelParameteriv(GLenum,<wbr>GLint,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.IntBuffer params){
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexParameterIiv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterIiv(int target, int pname, java.nio.IntBuffer params){
        glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexParameterIuiv(GLenum,<wbr>GLenum,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterIuiv(int target, int pname, java.nio.IntBuffer params){
        glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexParameterfv(GLenum,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTexParameteriv(GLenum,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetTransformFeedbackVarying(GLuint,<wbr>GLuint,<wbr>GLsizei,<wbr>GLsizei*,<wbr>GLsizei*,<wbr>GLenum*,<wbr>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetTransformFeedbackVarying(int program, int index, int[] size, int[] type, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        if(size!=null && size.length < 1)
            throw new IllegalArgumentException("Argument 'size': Wrong number of elements in array. Found: " + size.length + ", expected: 1");
        if(type!=null && type.length < 1)
            throw new IllegalArgumentException("Argument 'type': Wrong number of elements in array. Found: " + type.length + ", expected: 1");
        glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int[] size, int[] type, java.lang.String[] name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetUniformBlockIndex(GLuint,<wbr>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetUniformBlockIndex(int program, java.nio.CharBuffer uniformBlockName){
        return glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockName);
    }
    
    @QtUninvokable
    private native int glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer uniformBlockName);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetUniformIndices(GLuint,<wbr>GLsizei,<wbr>const GLchar*const*,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformIndices(int program, java.lang.String[] uniformNames, int[] uniformIndices){
        glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformNames, uniformIndices);
    }
    
    @QtUninvokable
    private native void glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(long __this__nativeId, int program, java.lang.String[] uniformNames, int[] uniformIndices);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetUniformLocation(GLuint,<wbr>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetUniformLocation(int program, java.nio.CharBuffer name){
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetUniformfv(GLuint,<wbr>GLint,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.FloatBuffer params){
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetUniformiv(GLuint,<wbr>GLint,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.IntBuffer params){
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetUniformuiv(GLuint,<wbr>GLint,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformuiv(int program, int location, java.nio.IntBuffer params){
        glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetVertexAttribIiv(GLuint,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribIiv(int index, int pname, java.nio.IntBuffer params){
        glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetVertexAttribIuiv(GLuint,<wbr>GLenum,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribIuiv(int index, int pname, java.nio.IntBuffer params){
        glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetVertexAttribPointerv(GLuint,<wbr>GLenum,<wbr>GLvoid**)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetVertexAttribdv(GLuint,<wbr>GLenum,<wbr>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribdv(int index, int pname, java.nio.DoubleBuffer params){
        glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetVertexAttribfv(GLuint,<wbr>GLenum,<wbr>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.FloatBuffer params){
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glGetVertexAttribiv(GLuint,<wbr>GLenum,<wbr>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.IntBuffer params){
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glHint(GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glHistogram(GLenum,<wbr>GLsizei,<wbr>GLenum,<wbr>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glHistogram(int target, int width, int internalformat, boolean sink){
        glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, width, internalformat, sink);
    }
    
    @QtUninvokable
    private native void glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(long __this__nativeId, int target, int width, int internalformat, boolean sink);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexMask(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glIndexMask(int mask){
        glIndexMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glIndexMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexPointer(GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glIndexPointer(int type, int stride, java.nio.Buffer pointer){
        glIndexPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glIndexPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexd(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glIndexd(double c){
        glIndexd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexd_native_GLdouble(long __this__nativeId, double c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexdv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glIndexdv(double[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexdv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexdv_native_const_GLdouble_ptr(long __this__nativeId, double[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexf(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glIndexf(float c){
        glIndexf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexf_native_GLfloat(long __this__nativeId, float c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexfv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glIndexfv(float[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexfv_native_const_GLfloat_ptr(long __this__nativeId, float[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexi(GLint)</code></p>
     */
    @QtUninvokable
    public final void glIndexi(int c){
        glIndexi_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexi_native_GLint(long __this__nativeId, int c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexiv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glIndexiv(int[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexiv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexiv_native_const_GLint_ptr(long __this__nativeId, int[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexs(GLshort)</code></p>
     */
    @QtUninvokable
    public final void glIndexs(short c){
        glIndexs_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexs_native_GLshort(long __this__nativeId, short c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexsv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glIndexsv(short[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexsv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexsv_native_const_GLshort_ptr(long __this__nativeId, short[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexub(GLubyte)</code></p>
     */
    @QtUninvokable
    public final void glIndexub(byte c){
        glIndexub_native_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexub_native_GLubyte(long __this__nativeId, byte c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIndexubv(const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glIndexubv(byte[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexubv_native_const_GLubyte_ptr(long __this__nativeId, byte[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glInitNames()</code></p>
     */
    @QtUninvokable
    public final void glInitNames(){
        glInitNames_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glInitNames_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glInterleavedArrays(GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glInterleavedArrays(int format, int stride, java.nio.Buffer pointer){
        glInterleavedArrays_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), format, stride, pointer);
    }
    
    @QtUninvokable
    private native void glInterleavedArrays_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int format, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsBuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsEnabled(GLenum)</code></p>
     */
    @QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsEnabledi(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsEnabledi(int target, int index){
        return glIsEnabledi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native boolean glIsEnabledi_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsFramebuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsFramebuffer(int framebuffer){
        return glIsFramebuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer);
    }
    
    @QtUninvokable
    private native boolean glIsFramebuffer_native_GLuint(long __this__nativeId, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsList(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsList(int list){
        return glIsList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native boolean glIsList_native_GLuint(long __this__nativeId, int list);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsQuery(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsQuery(int id){
        return glIsQuery_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsQuery_native_GLuint(long __this__nativeId, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsRenderbuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsRenderbuffer(int renderbuffer){
        return glIsRenderbuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer);
    }
    
    @QtUninvokable
    private native boolean glIsRenderbuffer_native_GLuint(long __this__nativeId, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsSync(GLsync)</code></p>
     */
    @QtUninvokable
    public final boolean glIsSync(io.qt.gui.gl.@Nullable GLsync sync){
        return glIsSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @QtUninvokable
    private native boolean glIsSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsTexture(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glIsVertexArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsVertexArray(int array){
        return glIsVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native boolean glIsVertexArray_native_GLuint(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLightModelf(GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLightModelf(int pname, float param){
        glLightModelf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glLightModelf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLightModelfv(GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLightModelfv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModelfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glLightModelfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLightModeli(GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glLightModeli(int pname, int param){
        glLightModeli_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glLightModeli_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLightModeliv(GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glLightModeliv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModeliv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glLightModeliv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLightf(GLenum,<wbr>GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLightf(int light, int pname, float param){
        glLightf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @QtUninvokable
    private native void glLightf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int light, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLightfv(GLenum,<wbr>GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLightfv(int light, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLighti(GLenum,<wbr>GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glLighti(int light, int pname, int param){
        glLighti_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @QtUninvokable
    private native void glLighti_native_GLenum_GLenum_GLint(long __this__nativeId, int light, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLightiv(GLenum,<wbr>GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glLightiv(int light, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glLightiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLineStipple(GLint,<wbr>GLushort)</code></p>
     */
    @QtUninvokable
    public final void glLineStipple(int factor, short pattern){
        glLineStipple_native_GLint_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), factor, pattern);
    }
    
    @QtUninvokable
    private native void glLineStipple_native_GLint_GLushort(long __this__nativeId, int factor, short pattern);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLineWidth(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLinkProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glListBase(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glListBase(int base){
        glListBase_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), base);
    }
    
    @QtUninvokable
    private native void glListBase_native_GLuint(long __this__nativeId, int base);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLoadIdentity()</code></p>
     */
    @QtUninvokable
    public final void glLoadIdentity(){
        glLoadIdentity_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glLoadIdentity_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLoadMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glLoadMatrixd(double[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLoadMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLoadMatrixf(float[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLoadName(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glLoadName(int name){
        glLoadName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void glLoadName_native_GLuint(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLoadTransposeMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glLoadTransposeMatrixd(java.nio.DoubleBuffer m){
        glLoadTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLoadTransposeMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLoadTransposeMatrixf(java.nio.FloatBuffer m){
        glLoadTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glLogicOp(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMap1d(GLenum,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLint,<wbr>GLint,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMap1d(int target, double u1, double u2, int stride, int order, java.nio.DoubleBuffer points){
        glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @QtUninvokable
    private native void glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int stride, int order, java.nio.DoubleBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMap1f(GLenum,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLint,<wbr>GLint,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMap1f(int target, float u1, float u2, int stride, int order, java.nio.FloatBuffer points){
        glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @QtUninvokable
    private native void glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int stride, int order, java.nio.FloatBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMap2d(GLenum,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLint,<wbr>GLint,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLint,<wbr>GLint,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.DoubleBuffer points){
        glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @QtUninvokable
    private native void glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.DoubleBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMap2f(GLenum,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLint,<wbr>GLint,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLint,<wbr>GLint,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.FloatBuffer points){
        glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @QtUninvokable
    private native void glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.FloatBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMapBuffer(GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBuffer(int target, int access){
        return glMapBuffer_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, access);
    }
    
    @QtUninvokable
    private native java.nio.@Nullable Buffer glMapBuffer_native_GLenum_GLenum(long __this__nativeId, int target, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMapBufferRange(GLenum,<wbr>GLintptr,<wbr>GLsizeiptr,<wbr>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final java.nio.Buffer glMapBufferRange(int target, long offset, int access){
        return glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(long __this__nativeId, int target, long offset, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMapGrid1d(GLint,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid1d(int un, double u1, double u2){
        glMapGrid1d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @QtUninvokable
    private native void glMapGrid1d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMapGrid1f(GLint,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid1f(int un, float u1, float u2){
        glMapGrid1f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @QtUninvokable
    private native void glMapGrid1f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMapGrid2d(GLint,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLint,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid2d(int un, double u1, double u2, int vn, double v1, double v2){
        glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @QtUninvokable
    private native void glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2, int vn, double v1, double v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMapGrid2f(GLint,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLint,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid2f(int un, float u1, float u2, int vn, float v1, float v2){
        glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @QtUninvokable
    private native void glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2, int vn, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMaterialf(GLenum,<wbr>GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMaterialf(int face, int pname, float param){
        glMaterialf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @QtUninvokable
    private native void glMaterialf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int face, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMaterialfv(GLenum,<wbr>GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMaterialfv(int face, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMateriali(GLenum,<wbr>GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMateriali(int face, int pname, int param){
        glMateriali_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @QtUninvokable
    private native void glMateriali_native_GLenum_GLenum_GLint(long __this__nativeId, int face, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMaterialiv(GLenum,<wbr>GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMaterialiv(int face, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMatrixMode(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glMatrixMode(int mode){
        glMatrixMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glMatrixMode_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMinmax(GLenum,<wbr>GLenum,<wbr>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glMinmax(int target, int internalformat, boolean sink){
        glMinmax_native_GLenum_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, sink);
    }
    
    @QtUninvokable
    private native void glMinmax_native_GLenum_GLenum_GLboolean(long __this__nativeId, int target, int internalformat, boolean sink);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultMatrixd(double[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultMatrixf(float[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultTransposeMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultTransposeMatrixd(java.nio.DoubleBuffer m){
        glMultTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultTransposeMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultTransposeMatrixf(java.nio.FloatBuffer m){
        glMultTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiDrawArrays(GLenum,<wbr>const GLint*,<wbr>const GLsizei*,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawArrays(int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount){
        glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiDrawElements(GLenum,<wbr>const GLsizei*,<wbr>GLenum,<wbr>const GLvoid*const*,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawElements(int mode, java.nio.IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiDrawElementsBaseVertex(GLenum,<wbr>const GLsizei*,<wbr>GLenum,<wbr>const GLvoid*const*,<wbr>GLsizei,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawElementsBaseVertex(int mode, java.nio.IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount, java.nio.IntBuffer basevertex){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount, basevertex);
    }
    
    @QtUninvokable
    private native void glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei_const_GLint_ptr(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount, java.nio.IntBuffer basevertex);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord1d(GLenum,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1d(int target, double s){
        glMultiTexCoord1d_native_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1d_native_GLenum_GLdouble(long __this__nativeId, int target, double s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord1dv(GLenum,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1dv(int target, java.nio.DoubleBuffer v){
        glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord1f(GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1f(int target, float s){
        glMultiTexCoord1f_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1f_native_GLenum_GLfloat(long __this__nativeId, int target, float s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord1fv(GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1fv(int target, java.nio.FloatBuffer v){
        glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord1i(GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1i(int target, int s){
        glMultiTexCoord1i_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1i_native_GLenum_GLint(long __this__nativeId, int target, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord1iv(GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1iv(int target, java.nio.IntBuffer v){
        glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord1s(GLenum,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1s(int target, short s){
        glMultiTexCoord1s_native_GLenum_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1s_native_GLenum_GLshort(long __this__nativeId, int target, short s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord1sv(GLenum,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1sv(int target, java.nio.ShortBuffer v){
        glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord2d(GLenum,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2d(int target, double s, double t){
        glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord2dv(GLenum,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2dv(int target, java.nio.DoubleBuffer v){
        glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord2f(GLenum,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2f(int target, float s, float t){
        glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord2fv(GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2fv(int target, java.nio.FloatBuffer v){
        glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord2i(GLenum,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2i(int target, int s, int t){
        glMultiTexCoord2i_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2i_native_GLenum_GLint_GLint(long __this__nativeId, int target, int s, int t);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord2iv(GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2iv(int target, java.nio.IntBuffer v){
        glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord2s(GLenum,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2s(int target, short s, short t){
        glMultiTexCoord2s_native_GLenum_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2s_native_GLenum_GLshort_GLshort(long __this__nativeId, int target, short s, short t);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord2sv(GLenum,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2sv(int target, java.nio.ShortBuffer v){
        glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord3d(GLenum,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3d(int target, double s, double t, double r){
        glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord3dv(GLenum,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3dv(int target, java.nio.DoubleBuffer v){
        glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord3f(GLenum,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3f(int target, float s, float t, float r){
        glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord3fv(GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3fv(int target, java.nio.FloatBuffer v){
        glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord3i(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3i(int target, int s, int t, int r){
        glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord3iv(GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3iv(int target, java.nio.IntBuffer v){
        glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord3s(GLenum,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3s(int target, short s, short t, short r){
        glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord3sv(GLenum,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3sv(int target, java.nio.ShortBuffer v){
        glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord4d(GLenum,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4d(int target, double s, double t, double r, double q){
        glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r, double q);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord4dv(GLenum,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4dv(int target, java.nio.DoubleBuffer v){
        glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord4f(GLenum,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4f(int target, float s, float t, float r, float q){
        glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r, float q);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord4fv(GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4fv(int target, java.nio.FloatBuffer v){
        glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord4i(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4i(int target, int s, int t, int r, int q){
        glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r, int q);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord4iv(GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4iv(int target, java.nio.IntBuffer v){
        glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord4s(GLenum,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4s(int target, short s, short t, short r, short q){
        glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r, short q);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glMultiTexCoord4sv(GLenum,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4sv(int target, java.nio.ShortBuffer v){
        glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNewList(GLuint,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glNewList(int list, int mode){
        glNewList_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), list, mode);
    }
    
    @QtUninvokable
    private native void glNewList_native_GLuint_GLenum(long __this__nativeId, int list, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3b(GLbyte,<wbr>GLbyte,<wbr>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glNormal3b(byte nx, byte ny, byte nz){
        glNormal3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte nx, byte ny, byte nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3bv(byte[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3d(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glNormal3d(double nx, double ny, double nz){
        glNormal3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double nx, double ny, double nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3f(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glNormal3f(float nx, float ny, float nz){
        glNormal3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float nx, float ny, float nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3i(GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glNormal3i(int nx, int ny, int nz){
        glNormal3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3i_native_GLint_GLint_GLint(long __this__nativeId, int nx, int ny, int nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3s(GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glNormal3s(short nx, short ny, short nz){
        glNormal3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short nx, short ny, short nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormal3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glNormalPointer(GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glNormalPointer(int type, int stride, java.nio.Buffer pointer){
        glNormalPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glNormalPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glOrtho(GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar){
        glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @QtUninvokable
    private native void glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPassThrough(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPassThrough(float token){
        glPassThrough_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), token);
    }
    
    @QtUninvokable
    private native void glPassThrough_native_GLfloat(long __this__nativeId, float token);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPixelMapfv(GLenum,<wbr>GLint,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapfv(int map, int mapsize, java.nio.FloatBuffer values){
        glPixelMapfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int map, int mapsize, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPixelMapuiv(GLenum,<wbr>GLint,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapuiv(int map, int mapsize, java.nio.IntBuffer values){
        glPixelMapuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int map, int mapsize, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPixelMapusv(GLenum,<wbr>GLint,<wbr>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapusv(int map, int mapsize, java.nio.ShortBuffer values){
        glPixelMapusv_native_GLenum_GLint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapusv_native_GLenum_GLint_const_GLushort_ptr(long __this__nativeId, int map, int mapsize, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPixelStoref(GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPixelStorei(GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPixelTransferf(GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelTransferf(int pname, float param){
        glPixelTransferf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelTransferf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPixelTransferi(GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPixelTransferi(int pname, int param){
        glPixelTransferi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelTransferi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPixelZoom(GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelZoom(float xfactor, float yfactor){
        glPixelZoom_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), xfactor, yfactor);
    }
    
    @QtUninvokable
    private native void glPixelZoom_native_GLfloat_GLfloat(long __this__nativeId, float xfactor, float yfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPointParameterf(GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPointParameterf(int pname, float param){
        glPointParameterf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameterf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPointParameterfv(GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPointParameterfv(int pname, java.nio.FloatBuffer params){
        glPointParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPointParameteri(GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPointParameteri(int pname, int param){
        glPointParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPointParameteriv(GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glPointParameteriv(int pname, java.nio.IntBuffer params){
        glPointParameteriv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameteriv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPointSize(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPolygonMode(GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPolygonOffset(GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPolygonStipple(const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glPolygonStipple(java.nio.ByteBuffer mask){
        glPolygonStipple_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPolygonStipple_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPopAttrib()</code></p>
     */
    @QtUninvokable
    public final void glPopAttrib(){
        glPopAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopAttrib_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPopClientAttrib()</code></p>
     */
    @QtUninvokable
    public final void glPopClientAttrib(){
        glPopClientAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopClientAttrib_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPopMatrix()</code></p>
     */
    @QtUninvokable
    public final void glPopMatrix(){
        glPopMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopMatrix_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPopName()</code></p>
     */
    @QtUninvokable
    public final void glPopName(){
        glPopName_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopName_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPrimitiveRestartIndex(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glPrimitiveRestartIndex(int index){
        glPrimitiveRestartIndex_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glPrimitiveRestartIndex_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPrioritizeTextures(GLsizei,<wbr>const GLuint*,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPrioritizeTextures(int n, java.nio.IntBuffer textures, java.nio.FloatBuffer priorities){
        glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures, priorities);
    }
    
    @QtUninvokable
    private native void glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures, java.nio.FloatBuffer priorities);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glProvokingVertex(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glProvokingVertex(int mode){
        glProvokingVertex_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glProvokingVertex_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPushAttrib(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glPushAttrib(int mask){
        glPushAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPushAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPushClientAttrib(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glPushClientAttrib(int mask){
        glPushClientAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPushClientAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPushMatrix()</code></p>
     */
    @QtUninvokable
    public final void glPushMatrix(){
        glPushMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPushMatrix_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glPushName(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glPushName(int name){
        glPushName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void glPushName_native_GLuint(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos2d(GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2d(double x, double y){
        glRasterPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos2f(GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2f(float x, float y){
        glRasterPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos2i(GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2i(int x, int y){
        glRasterPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos2s(GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2s(short x, short y){
        glRasterPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos3d(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3d(double x, double y, double z){
        glRasterPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos3f(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3f(float x, float y, float z){
        glRasterPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos3i(GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3i(int x, int y, int z){
        glRasterPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos3s(GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3s(short x, short y, short z){
        glRasterPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos4d(GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4d(double x, double y, double z, double w){
        glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos4f(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4f(float x, float y, float z, float w){
        glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos4i(GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4i(int x, int y, int z, int w){
        glRasterPos4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos4s(GLshort,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4s(short x, short y, short z, short w){
        glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRasterPos4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glReadBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glReadBuffer(int mode){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glReadPixels(GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRectd(GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRectd(double x1, double y1, double x2, double y2){
        glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x1, double y1, double x2, double y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRectdv(const GLdouble*,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRectdv(double[] v1, double[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(long __this__nativeId, double[] v1, double[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRectf(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRectf(float x1, float y1, float x2, float y2){
        glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x1, float y1, float x2, float y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRectfv(const GLfloat*,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRectfv(float[] v1, float[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(long __this__nativeId, float[] v1, float[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRecti(GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRecti(int x1, int y1, int x2, int y2){
        glRecti_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRecti_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x1, int y1, int x2, int y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRectiv(const GLint*,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRectiv(int[] v1, int[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectiv_native_const_GLint_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectiv_native_const_GLint_ptr_const_GLint_ptr(long __this__nativeId, int[] v1, int[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRects(GLshort,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRects(short x1, short y1, short x2, short y2){
        glRects_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRects_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x1, short y1, short x2, short y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRectsv(const GLshort*,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRectsv(short[] v1, short[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(long __this__nativeId, short[] v1, short[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRenderMode(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glRenderMode(int mode){
        return glRenderMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native int glRenderMode_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRenderbufferStorage(GLenum,<wbr>GLenum,<wbr>GLsizei,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glRenderbufferStorage(int target, int internalformat, int width, int height){
        glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRenderbufferStorageMultisample(GLenum,<wbr>GLsizei,<wbr>GLenum,<wbr>GLsizei,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height){
        glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int samples, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glResetHistogram(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glResetHistogram(int target){
        glResetHistogram_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glResetHistogram_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glResetMinmax(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glResetMinmax(int target){
        glResetMinmax_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glResetMinmax_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRotated(GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRotated(double angle, double x, double y, double z){
        glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @QtUninvokable
    private native void glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double angle, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glRotatef(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRotatef(float angle, float x, float y, float z){
        glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @QtUninvokable
    private native void glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float angle, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSampleCoverage(GLfloat,<wbr>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSampleMaski(GLuint,<wbr>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glSampleMaski(int index, int mask){
        glSampleMaski_native_GLuint_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), index, mask);
    }
    
    @QtUninvokable
    private native void glSampleMaski_native_GLuint_GLbitfield(long __this__nativeId, int index, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glScaled(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glScaled(double x, double y, double z){
        glScaled_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glScaled_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glScalef(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glScalef(float x, float y, float z){
        glScalef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glScalef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glScissor(GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3b(GLbyte,<wbr>GLbyte,<wbr>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3b(byte red, byte green, byte blue){
        glSecondaryColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3bv(java.nio.ByteBuffer v){
        glSecondaryColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3bv_native_const_GLbyte_ptr(long __this__nativeId, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3d(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3d(double red, double green, double blue){
        glSecondaryColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3dv(java.nio.DoubleBuffer v){
        glSecondaryColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3f(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3f(float red, float green, float blue){
        glSecondaryColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3fv(java.nio.FloatBuffer v){
        glSecondaryColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3i(GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3i(int red, int green, int blue){
        glSecondaryColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3iv(java.nio.IntBuffer v){
        glSecondaryColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3s(GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3s(short red, short green, short blue){
        glSecondaryColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3sv(java.nio.ShortBuffer v){
        glSecondaryColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3ub(GLubyte,<wbr>GLubyte,<wbr>GLubyte)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3ub(byte red, byte green, byte blue){
        glSecondaryColor3ub_native_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ub_native_GLubyte_GLubyte_GLubyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3ubv(const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3ubv(java.nio.ByteBuffer v){
        glSecondaryColor3ubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ubv_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3ui(GLuint,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3ui(int red, int green, int blue){
        glSecondaryColor3ui_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3ui_native_GLuint_GLuint_GLuint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3uiv(const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3uiv(java.nio.IntBuffer v){
        glSecondaryColor3uiv_native_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3uiv_native_const_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3us(GLushort,<wbr>GLushort,<wbr>GLushort)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3us(short red, short green, short blue){
        glSecondaryColor3us_native_GLushort_GLushort_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3us_native_GLushort_GLushort_GLushort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColor3usv(const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColor3usv(java.nio.ShortBuffer v){
        glSecondaryColor3usv_native_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glSecondaryColor3usv_native_const_GLushort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSecondaryColorPointer(GLint,<wbr>GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glSecondaryColorPointer(int size, int type, int stride, java.nio.Buffer pointer){
        glSecondaryColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glSecondaryColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSelectBuffer(GLsizei,<wbr>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glSelectBuffer(java.nio.IntBuffer buffer){
        glSelectBuffer_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native void glSelectBuffer_native_GLsizei_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glSeparableFilter2D(GLenum,<wbr>GLenum,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glSeparableFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer row, java.nio.Buffer column){
        glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, row, column);
    }
    
    @QtUninvokable
    private native void glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer row, java.nio.Buffer column);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glShadeModel(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glShadeModel(int mode){
        glShadeModel_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glShadeModel_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glShaderSource(GLuint,<wbr>GLsizei,<wbr>const GLchar*const*,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string, java.nio.IntBuffer length){
        glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string, length);
    }
    
    @QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string, java.nio.IntBuffer length);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glStencilFunc(GLenum,<wbr>GLint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glStencilFuncSeparate(GLenum,<wbr>GLenum,<wbr>GLint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glStencilMask(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glStencilMaskSeparate(GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glStencilOp(GLenum,<wbr>GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glStencilOpSeparate(GLenum,<wbr>GLenum,<wbr>GLenum,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, sfail, dpfail, dppass);
    }
    
    @QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int sfail, int dpfail, int dppass);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexBuffer(GLenum,<wbr>GLenum,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTexBuffer(int target, int internalformat, int buffer){
        glTexBuffer_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer);
    }
    
    @QtUninvokable
    private native void glTexBuffer_native_GLenum_GLenum_GLuint(long __this__nativeId, int target, int internalformat, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord1d(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1d(double s){
        glTexCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1d_native_GLdouble(long __this__nativeId, double s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord1dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1dv(double[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord1f(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1f(float s){
        glTexCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1f_native_GLfloat(long __this__nativeId, float s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord1fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1fv(float[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord1i(GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1i(int s){
        glTexCoord1i_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1i_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord1iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1iv(int[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord1s(GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1s(short s){
        glTexCoord1s_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1s_native_GLshort(long __this__nativeId, short s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord1sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1sv(short[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord2d(GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2d(double s, double t){
        glTexCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double s, double t);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord2f(GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2f(float s, float t){
        glTexCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float s, float t);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord2i(GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2i(int s, int t){
        glTexCoord2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2i_native_GLint_GLint(long __this__nativeId, int s, int t);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord2s(GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2s(short s, short t){
        glTexCoord2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2s_native_GLshort_GLshort(long __this__nativeId, short s, short t);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord3d(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3d(double s, double t, double r){
        glTexCoord3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord3f(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3f(float s, float t, float r){
        glTexCoord3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord3i(GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3i(int s, int t, int r){
        glTexCoord3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3i_native_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord3s(GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3s(short s, short t, short r){
        glTexCoord3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord4d(GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4d(double s, double t, double r, double q){
        glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r, double q);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord4f(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4f(float s, float t, float r, float q){
        glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r, float q);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord4i(GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4i(int s, int t, int r, int q){
        glTexCoord4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r, int q);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord4s(GLshort,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4s(short s, short t, short r, short q){
        glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r, short q);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoord4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexCoordPointer(GLint,<wbr>GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordPointer(int size, int type, int stride, java.nio.Buffer pointer){
        glTexCoordPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glTexCoordPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexEnvf(GLenum,<wbr>GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvf(int target, int pname, float param){
        glTexEnvf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexEnvf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexEnvfv(GLenum,<wbr>GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvfv(int target, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexEnvi(GLenum,<wbr>GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvi(int target, int pname, int param){
        glTexEnvi_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexEnvi_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexEnviv(GLenum,<wbr>GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexEnviv(int target, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexGend(GLenum,<wbr>GLenum,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexGend(int coord, int pname, double param){
        glTexGend_native_GLenum_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGend_native_GLenum_GLenum_GLdouble(long __this__nativeId, int coord, int pname, double param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexGendv(GLenum,<wbr>GLenum,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexGendv(int coord, int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(long __this__nativeId, int coord, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexGenf(GLenum,<wbr>GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexGenf(int coord, int pname, float param){
        glTexGenf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGenf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int coord, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexGenfv(GLenum,<wbr>GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexGenfv(int coord, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int coord, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexGeni(GLenum,<wbr>GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexGeni(int coord, int pname, int param){
        glTexGeni_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGeni_native_GLenum_GLenum_GLint(long __this__nativeId, int coord, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexGeniv(GLenum,<wbr>GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexGeniv(int coord, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int coord, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexImage1D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLint,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels){
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexImage2D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLint,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexImage2DMultisample(GLenum,<wbr>GLsizei,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTexImage2DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexImage2DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexImage3D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLint,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels){
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexImage3DMultisample(GLenum,<wbr>GLsizei,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTexImage3DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexImage3DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexParameterIiv(GLenum,<wbr>GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterIiv(int target, int pname, java.nio.IntBuffer params){
        glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexParameterIuiv(GLenum,<wbr>GLenum,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterIuiv(int target, int pname, java.nio.IntBuffer params){
        glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexParameterf(GLenum,<wbr>GLenum,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexParameterfv(GLenum,<wbr>GLenum,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexParameteri(GLenum,<wbr>GLenum,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexParameteriv(GLenum,<wbr>GLenum,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexSubImage1D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels){
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexSubImage2D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTexSubImage3D(GLenum,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLsizei,<wbr>GLenum,<wbr>GLenum,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels){
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTransformFeedbackVaryings(GLuint,<wbr>GLsizei,<wbr>const GLchar*const*,<wbr>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glTransformFeedbackVaryings(int program, java.lang.String[] varyings, int bufferMode){
        glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), program, varyings, bufferMode);
    }
    
    @QtUninvokable
    private native void glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(long __this__nativeId, int program, java.lang.String[] varyings, int bufferMode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTranslated(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTranslated(double x, double y, double z){
        glTranslated_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glTranslated_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glTranslatef(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTranslatef(float x, float y, float z){
        glTranslatef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glTranslatef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform1f(GLint,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform1f(int location, float v0){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform1fv(GLint,<wbr>GLsizei,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.FloatBuffer value){
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform1i(GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform1i(int location, int v0){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform1iv(GLint,<wbr>GLsizei,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.IntBuffer value){
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform1ui(GLint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform1ui(int location, int v0){
        glUniform1ui_native_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1ui_native_GLint_GLuint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform1uiv(GLint,<wbr>GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1uiv(int location, int count, java.nio.IntBuffer value){
        glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform2f(GLint,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform2f(int location, float v0, float v1){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform2fv(GLint,<wbr>GLsizei,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.FloatBuffer value){
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform2i(GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform2i(int location, int v0, int v1){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform2iv(GLint,<wbr>GLsizei,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.IntBuffer value){
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform2ui(GLint,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform2ui(int location, int v0, int v1){
        glUniform2ui_native_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2ui_native_GLint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform2uiv(GLint,<wbr>GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2uiv(int location, int count, java.nio.IntBuffer value){
        glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform3f(GLint,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform3f(int location, float v0, float v1, float v2){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform3fv(GLint,<wbr>GLsizei,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.FloatBuffer value){
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform3i(GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform3i(int location, int v0, int v1, int v2){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform3iv(GLint,<wbr>GLsizei,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.IntBuffer value){
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform3ui(GLint,<wbr>GLuint,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform3ui(int location, int v0, int v1, int v2){
        glUniform3ui_native_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3ui_native_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform3uiv(GLint,<wbr>GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3uiv(int location, int count, java.nio.IntBuffer value){
        glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform4f(GLint,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform4f(int location, float v0, float v1, float v2, float v3){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2, float v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform4fv(GLint,<wbr>GLsizei,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.FloatBuffer value){
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform4i(GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform4i(int location, int v0, int v1, int v2, int v3){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform4iv(GLint,<wbr>GLsizei,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.IntBuffer value){
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform4ui(GLint,<wbr>GLuint,<wbr>GLuint,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform4ui(int location, int v0, int v1, int v2, int v3){
        glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniform4uiv(GLint,<wbr>GLsizei,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4uiv(int location, int count, java.nio.IntBuffer value){
        glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformBlockBinding(GLuint,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding){
        glUniformBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, uniformBlockBinding);
    }
    
    @QtUninvokable
    private native void glUniformBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int uniformBlockIndex, int uniformBlockBinding);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix2fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix2x3fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2x3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix2x4fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2x4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix3fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix3x2fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3x2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix3x4fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3x4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix4fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix4x2fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4x2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUniformMatrix4x3fv(GLint,<wbr>GLsizei,<wbr>GLboolean,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4x3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUnmapBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final boolean glUnmapBuffer(int target){
        return glUnmapBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native boolean glUnmapBuffer_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glUseProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glValidateProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex2d(GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex2d(double x, double y){
        glVertex2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex2f(GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex2f(float x, float y){
        glVertex2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex2i(GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex2i(int x, int y){
        glVertex2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex2s(GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex2s(short x, short y){
        glVertex2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex3d(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex3d(double x, double y, double z){
        glVertex3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex3f(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex3f(float x, float y, float z){
        glVertex3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex3i(GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex3i(int x, int y, int z){
        glVertex3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex3s(GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex3s(short x, short y, short z){
        glVertex3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex4d(GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex4d(double x, double y, double z, double w){
        glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex4f(GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex4f(float x, float y, float z, float w){
        glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex4i(GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex4i(int x, int y, int z, int w){
        glVertex4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex4s(GLshort,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex4s(short x, short y, short z, short w){
        glVertex4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertex4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib1d(GLuint,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1d(int index, double x){
        glVertexAttrib1d_native_GLuint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1d_native_GLuint_GLdouble(long __this__nativeId, int index, double x);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib1dv(GLuint,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1dv(int index, java.nio.DoubleBuffer v){
        glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib1f(GLuint,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1f(int index, float x){
        glVertexAttrib1f_native_GLuint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1f_native_GLuint_GLfloat(long __this__nativeId, int index, float x);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib1fv(GLuint,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1fv(int index, java.nio.FloatBuffer v){
        glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib1s(GLuint,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1s(int index, short x){
        glVertexAttrib1s_native_GLuint_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1s_native_GLuint_GLshort(long __this__nativeId, int index, short x);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib1sv(GLuint,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib1sv(int index, java.nio.ShortBuffer v){
        glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib2d(GLuint,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2d(int index, double x, double y){
        glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib2dv(GLuint,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2dv(int index, java.nio.DoubleBuffer v){
        glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib2f(GLuint,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2f(int index, float x, float y){
        glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib2fv(GLuint,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2fv(int index, java.nio.FloatBuffer v){
        glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib2s(GLuint,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2s(int index, short x, short y){
        glVertexAttrib2s_native_GLuint_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2s_native_GLuint_GLshort_GLshort(long __this__nativeId, int index, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib2sv(GLuint,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib2sv(int index, java.nio.ShortBuffer v){
        glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib3d(GLuint,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3d(int index, double x, double y, double z){
        glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib3dv(GLuint,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3dv(int index, java.nio.DoubleBuffer v){
        glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib3f(GLuint,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3f(int index, float x, float y, float z){
        glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib3fv(GLuint,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3fv(int index, java.nio.FloatBuffer v){
        glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib3s(GLuint,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3s(int index, short x, short y, short z){
        glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib3sv(GLuint,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib3sv(int index, java.nio.ShortBuffer v){
        glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4Nbv(GLuint,<wbr>const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nbv(int index, java.nio.ByteBuffer v){
        glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4Niv(GLuint,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Niv(int index, java.nio.IntBuffer v){
        glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4Nsv(GLuint,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nsv(int index, java.nio.ShortBuffer v){
        glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4Nub(GLuint,<wbr>GLubyte,<wbr>GLubyte,<wbr>GLubyte,<wbr>GLubyte)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w){
        glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(long __this__nativeId, int index, byte x, byte y, byte z, byte w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4Nubv(GLuint,<wbr>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nubv(int index, java.nio.ByteBuffer v){
        glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4Nuiv(GLuint,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nuiv(int index, java.nio.IntBuffer v){
        glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4Nusv(GLuint,<wbr>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4Nusv(int index, java.nio.ShortBuffer v){
        glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4bv(GLuint,<wbr>const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4bv(int index, java.nio.ByteBuffer v){
        glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4d(GLuint,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4d(int index, double x, double y, double z, double w){
        glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4dv(GLuint,<wbr>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4dv(int index, java.nio.DoubleBuffer v){
        glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4f(GLuint,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4f(int index, float x, float y, float z, float w){
        glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4fv(GLuint,<wbr>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4fv(int index, java.nio.FloatBuffer v){
        glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4iv(GLuint,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4iv(int index, java.nio.IntBuffer v){
        glVertexAttrib4iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4s(GLuint,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4s(int index, short x, short y, short z, short w){
        glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4sv(GLuint,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4sv(int index, java.nio.ShortBuffer v){
        glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4ubv(GLuint,<wbr>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4ubv(int index, java.nio.ByteBuffer v){
        glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4uiv(GLuint,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4uiv(int index, java.nio.IntBuffer v){
        glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttrib4usv(GLuint,<wbr>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttrib4usv(int index, java.nio.ShortBuffer v){
        glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI1i(GLuint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI1i(int index, int x){
        glVertexAttribI1i_native_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttribI1i_native_GLuint_GLint(long __this__nativeId, int index, int x);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI1iv(GLuint,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI1iv(int index, java.nio.IntBuffer v){
        glVertexAttribI1iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI1iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI1ui(GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI1ui(int index, int x){
        glVertexAttribI1ui_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @QtUninvokable
    private native void glVertexAttribI1ui_native_GLuint_GLuint(long __this__nativeId, int index, int x);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI1uiv(GLuint,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI1uiv(int index, java.nio.IntBuffer v){
        glVertexAttribI1uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI1uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI2i(GLuint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI2i(int index, int x, int y){
        glVertexAttribI2i_native_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttribI2i_native_GLuint_GLint_GLint(long __this__nativeId, int index, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI2iv(GLuint,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI2iv(int index, java.nio.IntBuffer v){
        glVertexAttribI2iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI2iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI2ui(GLuint,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI2ui(int index, int x, int y){
        glVertexAttribI2ui_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttribI2ui_native_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI2uiv(GLuint,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI2uiv(int index, java.nio.IntBuffer v){
        glVertexAttribI2uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI2uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI3i(GLuint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI3i(int index, int x, int y, int z){
        glVertexAttribI3i_native_GLuint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttribI3i_native_GLuint_GLint_GLint_GLint(long __this__nativeId, int index, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI3iv(GLuint,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI3iv(int index, java.nio.IntBuffer v){
        glVertexAttribI3iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI3iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI3ui(GLuint,<wbr>GLuint,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI3ui(int index, int x, int y, int z){
        glVertexAttribI3ui_native_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttribI3ui_native_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI3uiv(GLuint,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI3uiv(int index, java.nio.IntBuffer v){
        glVertexAttribI3uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI3uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI4bv(GLuint,<wbr>const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4bv(int index, java.nio.ByteBuffer v){
        glVertexAttribI4bv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4bv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI4i(GLuint,<wbr>GLint,<wbr>GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4i(int index, int x, int y, int z, int w){
        glVertexAttribI4i_native_GLuint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4i_native_GLuint_GLint_GLint_GLint_GLint(long __this__nativeId, int index, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI4iv(GLuint,<wbr>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4iv(int index, java.nio.IntBuffer v){
        glVertexAttribI4iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI4sv(GLuint,<wbr>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4sv(int index, java.nio.ShortBuffer v){
        glVertexAttribI4sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI4ubv(GLuint,<wbr>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4ubv(int index, java.nio.ByteBuffer v){
        glVertexAttribI4ubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4ubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI4ui(GLuint,<wbr>GLuint,<wbr>GLuint,<wbr>GLuint,<wbr>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4ui(int index, int x, int y, int z, int w){
        glVertexAttribI4ui_native_GLuint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4ui_native_GLuint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI4uiv(GLuint,<wbr>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4uiv(int index, java.nio.IntBuffer v){
        glVertexAttribI4uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribI4usv(GLuint,<wbr>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribI4usv(int index, java.nio.ShortBuffer v){
        glVertexAttribI4usv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @QtUninvokable
    private native void glVertexAttribI4usv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribIPointer(GLuint,<wbr>GLint,<wbr>GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribIPointer(int index, int size, int type, int stride, java.nio.Buffer pointer){
        glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexAttribPointer(GLuint,<wbr>GLint,<wbr>GLenum,<wbr>GLboolean,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer){
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, normalized, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glVertexPointer(GLint,<wbr>GLenum,<wbr>GLsizei,<wbr>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glVertexPointer(int size, int type, int stride, java.nio.Buffer pointer){
        glVertexPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glViewport(GLint,<wbr>GLint,<wbr>GLsizei,<wbr>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWaitSync(GLsync,<wbr>GLbitfield,<wbr>GLuint64)</code></p>
     */
    @QtUninvokable
    public final void glWaitSync(io.qt.gui.gl.@Nullable GLsync sync, int flags, long timeout){
        glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @QtUninvokable
    private native void glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos2d(GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2d(double x, double y){
        glWindowPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2dv(java.nio.DoubleBuffer v){
        glWindowPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos2f(GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2f(float x, float y){
        glWindowPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2fv(java.nio.FloatBuffer v){
        glWindowPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos2i(GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2i(int x, int y){
        glWindowPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2iv(java.nio.IntBuffer v){
        glWindowPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos2s(GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2s(short x, short y){
        glWindowPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glWindowPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos2sv(java.nio.ShortBuffer v){
        glWindowPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos2sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos3d(GLdouble,<wbr>GLdouble,<wbr>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3d(double x, double y, double z){
        glWindowPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3dv(java.nio.DoubleBuffer v){
        glWindowPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos3f(GLfloat,<wbr>GLfloat,<wbr>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3f(float x, float y, float z){
        glWindowPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3fv(java.nio.FloatBuffer v){
        glWindowPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos3i(GLint,<wbr>GLint,<wbr>GLint)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3i(int x, int y, int z){
        glWindowPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3iv(java.nio.IntBuffer v){
        glWindowPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos3s(GLshort,<wbr>GLshort,<wbr>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3s(short x, short y, short z){
        glWindowPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glWindowPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_2_Compatibility::<wbr>glWindowPos3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glWindowPos3sv(java.nio.ShortBuffer v){
        glWindowPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glWindowPos3sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr>initializeOpenGLFunctions()</code></p>
     */
    @QtUninvokable
    @Override
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFunctions_3_2_Compatibility(QPrivateConstructor p) { super(p); } 
    
}
