package io.qt.opengl;

import io.qt.*;


/**
 * <p>All functions for OpenGL ES 2</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglfunctions-es2.html">QOpenGLFunctions_ES2</a></code></p>
 */
public class QOpenGLFunctions_ES2 extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>QOpenGLFunctions_ES2()</code></p>
     */
    public QOpenGLFunctions_ES2(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_ES2 instance);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glActiveTexture(GLenum)</code></p>
     * @param texture
     */
    @QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glAttachShader(GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param shader
     */
    @QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBindAttribLocation(GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param index
     * @param name
     */
    @QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.lang.String name){
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.lang.String name);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBindBuffer(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param buffer
     */
    @QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBindFramebuffer(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param framebuffer
     */
    @QtUninvokable
    public final void glBindFramebuffer(int target, int framebuffer){
        glBindFramebuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, framebuffer);
    }
    
    @QtUninvokable
    private native void glBindFramebuffer_native_GLenum_GLuint(long __this__nativeId, int target, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBindRenderbuffer(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param renderbuffer
     */
    @QtUninvokable
    public final void glBindRenderbuffer(int target, int renderbuffer){
        glBindRenderbuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, renderbuffer);
    }
    
    @QtUninvokable
    private native void glBindRenderbuffer_native_GLenum_GLuint(long __this__nativeId, int target, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBindTexture(GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param texture
     */
    @QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBlendColor(GLclampf,<wbr/>GLclampf,<wbr/>GLclampf,<wbr/>GLclampf)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLclampf_GLclampf_GLclampf_GLclampf(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glBlendColor_native_GLclampf_GLclampf_GLclampf_GLclampf(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBlendEquation(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBlendEquationSeparate(GLenum,<wbr/>GLenum)</code></p>
     * @param modeRGB
     * @param modeAlpha
     */
    @QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBlendFunc(GLenum,<wbr/>GLenum)</code></p>
     * @param sfactor
     * @param dfactor
     */
    @QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBlendFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param srcRGB
     * @param dstRGB
     * @param srcAlpha
     * @param dstAlpha
     */
    @QtUninvokable
    public final void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), srcRGB, dstRGB, srcAlpha, dstAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBufferData(GLenum,<wbr/>GLsizeiptr,<wbr/>const GLvoid*,<wbr/>GLenum)</code></p>
     * @param target
     * @param size
     * @param data
     * @param usage
     */
    @QtUninvokable
    public final void glBufferData(int target, long size, java.nio.@Nullable Buffer data, int usage){
        glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param offset
     * @param size
     * @param data
     */
    @QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCheckFramebufferStatus(GLenum)</code></p>
     * @param target
     * @return
     */
    @QtUninvokable
    public final int glCheckFramebufferStatus(int target){
        return glCheckFramebufferStatus_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native int glCheckFramebufferStatus_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glClear(GLbitfield)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glClearColor(GLclampf,<wbr/>GLclampf,<wbr/>GLclampf,<wbr/>GLclampf)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLclampf_GLclampf_GLclampf_GLclampf(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearColor_native_GLclampf_GLclampf_GLclampf_GLclampf(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glClearDepthf(GLclampf)</code></p>
     * @param depth
     */
    @QtUninvokable
    public final void glClearDepthf(float depth){
        glClearDepthf_native_GLclampf(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void glClearDepthf_native_GLclampf(long __this__nativeId, float depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glClearStencil(GLint)</code></p>
     * @param s
     */
    @QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glColorMask(GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     * @param red
     * @param green
     * @param blue
     * @param alpha
     */
    @QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCompileShader(GLuint)</code></p>
     * @param shader
     */
    @QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCompressedTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param border
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCompressedTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param width
     * @param height
     * @param format
     * @param imageSize
     * @param data
     */
    @QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCopyTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param x
     * @param y
     * @param width
     * @param height
     * @param border
     */
    @QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCopyTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCreateProgram()</code></p>
     * @return
     */
    @QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCreateShader(GLenum)</code></p>
     * @param type
     * @return
     */
    @QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glCullFace(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDeleteBuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param buffers
     */
    @QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDeleteFramebuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param framebuffers
     */
    @QtUninvokable
    public final void glDeleteFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDeleteProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDeleteRenderbuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param renderbuffers
     */
    @QtUninvokable
    public final void glDeleteRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDeleteShader(GLuint)</code></p>
     * @param shader
     */
    @QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDeleteTextures(GLsizei,<wbr/>const GLuint*)</code></p>
     * @param n
     * @param textures
     */
    @QtUninvokable
    public final void glDeleteTextures(int n, java.nio.@Nullable IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDepthFunc(GLenum)</code></p>
     * @param func
     */
    @QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDepthMask(GLboolean)</code></p>
     * @param flag
     */
    @QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDepthRangef(GLclampf,<wbr/>GLclampf)</code></p>
     * @param zNear
     * @param zFar
     */
    @QtUninvokable
    public final void glDepthRangef(float zNear, float zFar){
        glDepthRangef_native_GLclampf_GLclampf(QtJambi_LibraryUtilities.internal.nativeId(this), zNear, zFar);
    }
    
    @QtUninvokable
    private native void glDepthRangef_native_GLclampf_GLclampf(long __this__nativeId, float zNear, float zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDetachShader(GLuint,<wbr/>GLuint)</code></p>
     * @param program
     * @param shader
     */
    @QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDisable(GLenum)</code></p>
     * @param cap
     */
    @QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDisableVertexAttribArray(GLuint)</code></p>
     * @param index
     */
    @QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDrawArrays(GLenum,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     * @param mode
     * @param first
     * @param count
     */
    @QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glDrawElements(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param mode
     * @param count
     * @param type
     * @param indices
     */
    @QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glEnable(GLenum)</code></p>
     * @param cap
     */
    @QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glEnableVertexAttribArray(GLuint)</code></p>
     * @param index
     */
    @QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glFinish()</code></p>
     */
    @QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glFlush()</code></p>
     */
    @QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glFramebufferRenderbuffer(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     * @param target
     * @param attachment
     * @param renderbuffertarget
     * @param renderbuffer
     */
    @QtUninvokable
    public final void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer){
        glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, renderbuffertarget, renderbuffer);
    }
    
    @QtUninvokable
    private native void glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(long __this__nativeId, int target, int attachment, int renderbuffertarget, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glFramebufferTexture2D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     * @param target
     * @param attachment
     * @param textarget
     * @param texture
     * @param level
     */
    @QtUninvokable
    public final void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glFrontFace(GLenum)</code></p>
     * @param mode
     */
    @QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGenBuffers(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param buffers
     */
    @QtUninvokable
    public final void glGenBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGenFramebuffers(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param framebuffers
     */
    @QtUninvokable
    public final void glGenFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glGenFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glGenFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGenRenderbuffers(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param renderbuffers
     */
    @QtUninvokable
    public final void glGenRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glGenRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glGenRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGenTextures(GLsizei,<wbr/>GLuint*)</code></p>
     * @param n
     * @param textures
     */
    @QtUninvokable
    public final void glGenTextures(int n, java.nio.@Nullable IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGenerateMipmap(GLenum)</code></p>
     * @param target
     */
    @QtUninvokable
    public final void glGenerateMipmap(int target){
        glGenerateMipmap_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glGenerateMipmap_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetActiveAttrib(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param index
     * @param bufsize
     * @param length
     * @param size
     * @param type
     * @param name
     */
    @QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufsize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufsize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetActiveUniform(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param index
     * @param bufsize
     * @param length
     * @param size
     * @param type
     * @param name
     */
    @QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufsize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufsize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetAttachedShaders(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLuint*)</code></p>
     * @param program
     * @param maxcount
     * @param count
     * @param shaders
     */
    @QtUninvokable
    public final void glGetAttachedShaders(int program, int maxcount, java.nio.@Nullable IntBuffer count, java.nio.@Nullable IntBuffer shaders){
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxcount, count, shaders);
    }
    
    @QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxcount, java.nio.IntBuffer count, java.nio.IntBuffer shaders);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetAttribLocation(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetAttribLocation(int program, java.lang.String name){
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.lang.String name);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetBooleanv(GLenum,<wbr/>GLboolean*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBooleanv(int pname, java.nio.@Nullable Buffer params){
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, java.nio.Buffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetBufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetError()</code></p>
     * @return
     */
    @QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetFloatv(GLenum,<wbr/>GLfloat*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetFloatv(int pname, java.nio.@Nullable FloatBuffer params){
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetFramebufferAttachmentParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param attachment
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, java.nio.@Nullable IntBuffer params){
        glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, pname, params);
    }
    
    @QtUninvokable
    private native void glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int attachment, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetIntegerv(GLenum,<wbr/>GLint*)</code></p>
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetIntegerv(int pname, java.nio.@Nullable IntBuffer params){
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetProgramInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param program
     * @param bufsize
     * @param length
     * @param infolog
     */
    @QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infolog){
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufsize, length, infolog);
    }
    
    @QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer infolog);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetProgramiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param program
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetRenderbufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetRenderbufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetShaderInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param shader
     * @param bufsize
     * @param length
     * @param infolog
     */
    @QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infolog){
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufsize, length, infolog);
    }
    
    @QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer infolog);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetShaderPrecisionFormat(GLenum,<wbr/>GLenum,<wbr/>GLint*,<wbr/>GLint*)</code></p>
     * @param shadertype
     * @param precisiontype
     * @param range
     * @param precision
     */
    @QtUninvokable
    public final void glGetShaderPrecisionFormat(int shadertype, int precisiontype, java.nio.@Nullable IntBuffer range, java.nio.@Nullable IntBuffer precision){
        glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, precisiontype, range, precision);
    }
    
    @QtUninvokable
    private native void glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(long __this__nativeId, int shadertype, int precisiontype, java.nio.IntBuffer range, java.nio.IntBuffer precision);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetShaderSource(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     * @param shader
     * @param bufsize
     * @param length
     * @param source
     */
    @QtUninvokable
    public final void glGetShaderSource(int shader, int bufsize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer source){
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufsize, length, source);
    }
    
    @QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetShaderiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param shader
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.@Nullable IntBuffer params){
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetString(GLenum)</code></p>
     * @param name
     * @return
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetString_native_GLenum(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetUniformLocation(GLuint,<wbr/>const GLchar*)</code></p>
     * @param program
     * @param name
     * @return
     */
    @QtUninvokable
    public final int glGetUniformLocation(int program, java.lang.String name){
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.lang.String name);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetUniformfv(GLuint,<wbr/>GLint,<wbr/>GLfloat*)</code></p>
     * @param program
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.@Nullable FloatBuffer params){
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetUniformiv(GLuint,<wbr/>GLint,<wbr/>GLint*)</code></p>
     * @param program
     * @param location
     * @param params
     */
    @QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetVertexAttribPointerv(GLuint,<wbr/>GLenum,<wbr/>GLvoid**)</code></p>
     * @param index
     * @param pname
     * @param pointer
     */
    @QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.@Nullable Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetVertexAttribfv(GLuint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.@Nullable FloatBuffer params){
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glGetVertexAttribiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     * @param index
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glHint(GLenum,<wbr/>GLenum)</code></p>
     * @param target
     * @param mode
     */
    @QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glIsBuffer(GLuint)</code></p>
     * @param buffer
     * @return
     */
    @QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glIsEnabled(GLenum)</code></p>
     * @param cap
     * @return
     */
    @QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glIsFramebuffer(GLuint)</code></p>
     * @param framebuffer
     * @return
     */
    @QtUninvokable
    public final boolean glIsFramebuffer(int framebuffer){
        return glIsFramebuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer);
    }
    
    @QtUninvokable
    private native boolean glIsFramebuffer_native_GLuint(long __this__nativeId, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glIsProgram(GLuint)</code></p>
     * @param program
     * @return
     */
    @QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glIsRenderbuffer(GLuint)</code></p>
     * @param renderbuffer
     * @return
     */
    @QtUninvokable
    public final boolean glIsRenderbuffer(int renderbuffer){
        return glIsRenderbuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer);
    }
    
    @QtUninvokable
    private native boolean glIsRenderbuffer_native_GLuint(long __this__nativeId, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glIsShader(GLuint)</code></p>
     * @param shader
     * @return
     */
    @QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glIsTexture(GLuint)</code></p>
     * @param texture
     * @return
     */
    @QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glLineWidth(GLfloat)</code></p>
     * @param width
     */
    @QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glLinkProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glPixelStorei(GLenum,<wbr/>GLint)</code></p>
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glPolygonOffset(GLfloat,<wbr/>GLfloat)</code></p>
     * @param factor
     * @param units
     */
    @QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glReadPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glReleaseShaderCompiler()</code></p>
     */
    @QtUninvokable
    public final void glReleaseShaderCompiler(){
        glReleaseShaderCompiler_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glReleaseShaderCompiler_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glRenderbufferStorage(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param target
     * @param internalformat
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glRenderbufferStorage(int target, int internalformat, int width, int height){
        glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glSampleCoverage(GLclampf,<wbr/>GLboolean)</code></p>
     * @param value
     * @param invert
     */
    @QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLclampf_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @QtUninvokable
    private native void glSampleCoverage_native_GLclampf_GLboolean(long __this__nativeId, float value, boolean invert);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glScissor(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glShaderBinary(GLsizei,<wbr/>const GLuint*,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>GLsizei)</code></p>
     * @param n
     * @param shaders
     * @param binaryformat
     * @param binary
     * @param length
     */
    @QtUninvokable
    public final void glShaderBinary(int n, java.nio.@Nullable IntBuffer shaders, int binaryformat, java.nio.@Nullable Buffer binary, int length){
        glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_GLvoid_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), n, shaders, binaryformat, binary, length);
    }
    
    @QtUninvokable
    private native void glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_GLvoid_ptr_GLsizei(long __this__nativeId, int n, java.nio.IntBuffer shaders, int binaryformat, java.nio.Buffer binary, int length);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glShaderSource(GLuint,<wbr/>GLsizei,<wbr/>const GLchar**,<wbr/>const GLint*)</code></p>
     * @param shader
     * @param string
     */
    @QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string){
        glShaderSource_native_GLuint_GLsizei_const_GLchar_ptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string);
    }
    
    @QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_ptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glStencilFunc(GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     * @param func
     * @param ref
     * @param mask
     */
    @QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glStencilFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     * @param face
     * @param func
     * @param ref
     * @param mask
     */
    @QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glStencilMask(GLuint)</code></p>
     * @param mask
     */
    @QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glStencilMaskSeparate(GLenum,<wbr/>GLuint)</code></p>
     * @param face
     * @param mask
     */
    @QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glStencilOp(GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param fail
     * @param zfail
     * @param zpass
     */
    @QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glStencilOpSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     * @param face
     * @param fail
     * @param zfail
     * @param zpass
     */
    @QtUninvokable
    public final void glStencilOpSeparate(int face, int fail, int zfail, int zpass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int fail, int zfail, int zpass);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param internalformat
     * @param width
     * @param height
     * @param border
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glTexParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glTexParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     * @param target
     * @param pname
     * @param param
     */
    @QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     * @param target
     * @param pname
     * @param params
     */
    @QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     * @param target
     * @param level
     * @param xoffset
     * @param yoffset
     * @param width
     * @param height
     * @param format
     * @param type
     * @param pixels
     */
    @QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform1f(GLint,<wbr/>GLfloat)</code></p>
     * @param location
     * @param x
     */
    @QtUninvokable
    public final void glUniform1f(int location, float x){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x);
    }
    
    @QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float x);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform1fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.@Nullable FloatBuffer v){
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform1i(GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param x
     */
    @QtUninvokable
    public final void glUniform1i(int location, int x){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, x);
    }
    
    @QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int x);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform1iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.@Nullable IntBuffer v){
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform2f(GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glUniform2f(int location, float x, float y){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform2fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.@Nullable FloatBuffer v){
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform2i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glUniform2i(int location, int x, int y){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform2iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.@Nullable IntBuffer v){
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform3f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glUniform3f(int location, float x, float y, float z){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform3fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.@Nullable FloatBuffer v){
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform3i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glUniform3i(int location, int x, int y, int z){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform3iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.@Nullable IntBuffer v){
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform4f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param location
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glUniform4f(int location, float x, float y, float z, float w){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform4fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.@Nullable FloatBuffer v){
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     * @param location
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glUniform4i(int location, int x, int y, int z, int w){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniform4iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     * @param location
     * @param count
     * @param v
     */
    @QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.@Nullable IntBuffer v){
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniformMatrix2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniformMatrix3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUniformMatrix4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     * @param location
     * @param count
     * @param transpose
     * @param value
     */
    @QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glUseProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glValidateProgram(GLuint)</code></p>
     * @param program
     */
    @QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttrib1f(GLuint,<wbr/>GLfloat)</code></p>
     * @param indx
     * @param x
     */
    @QtUninvokable
    public final void glVertexAttrib1f(int indx, float x){
        glVertexAttrib1f_native_GLuint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), indx, x);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1f_native_GLuint_GLfloat(long __this__nativeId, int indx, float x);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttrib1fv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param indx
     * @param values
     */
    @QtUninvokable
    public final void glVertexAttrib1fv(int indx, java.nio.@Nullable FloatBuffer values){
        glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, values);
    }
    
    @QtUninvokable
    private native void glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int indx, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttrib2f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param indx
     * @param x
     * @param y
     */
    @QtUninvokable
    public final void glVertexAttrib2f(int indx, float x, float y){
        glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), indx, x, y);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(long __this__nativeId, int indx, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttrib2fv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param indx
     * @param values
     */
    @QtUninvokable
    public final void glVertexAttrib2fv(int indx, java.nio.@Nullable FloatBuffer values){
        glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, values);
    }
    
    @QtUninvokable
    private native void glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int indx, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttrib3f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param indx
     * @param x
     * @param y
     * @param z
     */
    @QtUninvokable
    public final void glVertexAttrib3f(int indx, float x, float y, float z){
        glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), indx, x, y, z);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int indx, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttrib3fv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param indx
     * @param values
     */
    @QtUninvokable
    public final void glVertexAttrib3fv(int indx, java.nio.@Nullable FloatBuffer values){
        glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, values);
    }
    
    @QtUninvokable
    private native void glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int indx, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttrib4f(GLuint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     * @param indx
     * @param x
     * @param y
     * @param z
     * @param w
     */
    @QtUninvokable
    public final void glVertexAttrib4f(int indx, float x, float y, float z, float w){
        glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), indx, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int indx, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttrib4fv(GLuint,<wbr/>const GLfloat*)</code></p>
     * @param indx
     * @param values
     */
    @QtUninvokable
    public final void glVertexAttrib4fv(int indx, java.nio.@Nullable FloatBuffer values){
        glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, values);
    }
    
    @QtUninvokable
    private native void glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int indx, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glVertexAttribPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     * @param indx
     * @param size
     * @param type
     * @param normalized
     * @param stride
     * @param ptr
     */
    @QtUninvokable
    public final void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, java.nio.@Nullable Buffer ptr){
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, size, type, normalized, stride, ptr);
    }
    
    @QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(long __this__nativeId, int indx, int size, int type, boolean normalized, int stride, java.nio.Buffer ptr);
    
    /**
     * <p>See <code>QOpenGLFunctions_ES2::<wbr/>glViewport(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     * @param x
     * @param y
     * @param width
     * @param height
     */
    @QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>initializeOpenGLFunctions()</code></p>
     * @return
     */
    @QtUninvokable
    @Override
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFunctions_ES2(QPrivateConstructor p) { super(p); } 
    
}
