package io.qt.opengl;

import io.qt.*;


/**
 * <p>Specifies the format of an OpenGL framebuffer object</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html">QOpenGLFramebufferObjectFormat</a></code></p>
 */
public class QOpenGLFramebufferObjectFormat extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#QOpenGLFramebufferObjectFormat">QOpenGLFramebufferObjectFormat::<wbr/>QOpenGLFramebufferObjectFormat()</a></code></p>
     */
    public QOpenGLFramebufferObjectFormat(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObjectFormat instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#QOpenGLFramebufferObjectFormat-1">QOpenGLFramebufferObjectFormat::<wbr/>QOpenGLFramebufferObjectFormat(QOpenGLFramebufferObjectFormat)</a></code></p>
     * @param other
     */
    public QOpenGLFramebufferObjectFormat(io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObjectFormat instance, io.qt.opengl.QOpenGLFramebufferObjectFormat other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#attachment">QOpenGLFramebufferObjectFormat::<wbr/>attachment()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment(){
        return io.qt.opengl.QOpenGLFramebufferObject.Attachment.resolve(attachment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int attachment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#internalTextureFormat">QOpenGLFramebufferObjectFormat::<wbr/>internalTextureFormat()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int internalTextureFormat(){
        return internalTextureFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int internalTextureFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#mipmap">QOpenGLFramebufferObjectFormat::<wbr/>mipmap()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final boolean mipmap(){
        return mipmap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean mipmap_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#operator-eq">QOpenGLFramebufferObjectFormat::<wbr/>operator=(QOpenGLFramebufferObjectFormat)</a></code></p>
     * @param other
     */
    @QtUninvokable
    public final void assign(io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat other){
        assign_native_cref_QOpenGLFramebufferObjectFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QOpenGLFramebufferObjectFormat(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#operator-eq-eq">QOpenGLFramebufferObjectFormat::<wbr/>operator==(QOpenGLFramebufferObjectFormat)const</a></code></p>
     * @param other
     * @return
     */
    @QtUninvokable
    public final boolean equals(io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat other){
        return equals_native_cref_QOpenGLFramebufferObjectFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QOpenGLFramebufferObjectFormat_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#samples">QOpenGLFramebufferObjectFormat::<wbr/>samples()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int samples(){
        return samples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int samples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setAttachment">QOpenGLFramebufferObjectFormat::<wbr/>setAttachment(QOpenGLFramebufferObject::Attachment)</a></code></p>
     * @param attachment
     */
    @QtUninvokable
    public final void setAttachment(io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment){
        setAttachment_native_QOpenGLFramebufferObject_Attachment(QtJambi_LibraryUtilities.internal.nativeId(this), attachment.value());
    }
    
    @QtUninvokable
    private native void setAttachment_native_QOpenGLFramebufferObject_Attachment(long __this__nativeId, int attachment);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setInternalTextureFormat">QOpenGLFramebufferObjectFormat::<wbr/>setInternalTextureFormat(GLenum)</a></code></p>
     * @param internalTextureFormat
     */
    @QtUninvokable
    public final void setInternalTextureFormat(int internalTextureFormat){
        setInternalTextureFormat_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), internalTextureFormat);
    }
    
    @QtUninvokable
    private native void setInternalTextureFormat_native_GLenum(long __this__nativeId, int internalTextureFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setMipmap">QOpenGLFramebufferObjectFormat::<wbr/>setMipmap(bool)</a></code></p>
     * @param enabled
     */
    @QtUninvokable
    public final void setMipmap(boolean enabled){
        setMipmap_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setMipmap_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setSamples">QOpenGLFramebufferObjectFormat::<wbr/>setSamples(int)</a></code></p>
     * @param samples
     */
    @QtUninvokable
    public final void setSamples(int samples){
        setSamples_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), samples);
    }
    
    @QtUninvokable
    private native void setSamples_native_int(long __this__nativeId, int samples);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setTextureTarget">QOpenGLFramebufferObjectFormat::<wbr/>setTextureTarget(GLenum)</a></code></p>
     * @param target
     */
    @QtUninvokable
    public final void setTextureTarget(int target){
        setTextureTarget_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void setTextureTarget_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#textureTarget">QOpenGLFramebufferObjectFormat::<wbr/>textureTarget()const</a></code></p>
     * @return
     */
    @QtUninvokable
    public final int textureTarget(){
        return textureTarget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureTarget_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFramebufferObjectFormat(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#operator-eq-eq">QOpenGLFramebufferObjectFormat::<wbr/>operator==(QOpenGLFramebufferObjectFormat)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other==null || other instanceof io.qt.opengl.QOpenGLFramebufferObjectFormat) {
            return equals((io.qt.opengl.QOpenGLFramebufferObjectFormat) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QOpenGLFramebufferObjectFormat)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#QOpenGLFramebufferObjectFormat-1">QOpenGLFramebufferObjectFormat::<wbr/>QOpenGLFramebufferObjectFormat(QOpenGLFramebufferObjectFormat)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QOpenGLFramebufferObjectFormat clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOpenGLFramebufferObjectFormat clone_native(long __this_nativeId);
}
