package io.qt.opengl;

import io.qt.*;


/**
 * <p>Convenient way to draw textured quads via OpenGL</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html">QOpenGLTextureBlitter</a></code></p>
 */
public class QOpenGLTextureBlitter extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#Origin-enum">QOpenGLTextureBlitter::Origin</a></code></p>
     */
    public enum Origin implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#Origin-enum">QOpenGLTextureBlitter::<wbr/>OriginBottomLeft</a></code></p>
         */
        OriginBottomLeft(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#Origin-enum">QOpenGLTextureBlitter::<wbr/>OriginTopLeft</a></code></p>
         */
        OriginTopLeft(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Origin(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Origin resolve(int value) {
            switch (value) {
            case 0: return OriginBottomLeft;
            case 1: return OriginTopLeft;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#QOpenGLTextureBlitter">QOpenGLTextureBlitter::<wbr/>QOpenGLTextureBlitter()</a></code></p>
     */
    public QOpenGLTextureBlitter(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLTextureBlitter instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#bind">QOpenGLTextureBlitter::<wbr/>bind(GLenum)</a></code></p>
     */
    @QtUninvokable
    public final void bind(int target){
        bind_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void bind_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#blit-1">QOpenGLTextureBlitter::<wbr/>blit(GLuint,<wbr/>QMatrix4x4,<wbr/>QMatrix3x3)</a></code></p>
     */
    @QtUninvokable
    public final void blit(int texture, io.qt.gui.@NonNull QMatrix4x4 targetTransform, io.qt.gui.@NonNull QMatrix3x3 sourceTransform){
        blit_native_GLuint_cref_QMatrix4x4_cref_QMatrix3x3(QtJambi_LibraryUtilities.internal.nativeId(this), texture, QtJambi_LibraryUtilities.internal.checkedNativeId(targetTransform), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceTransform));
    }
    
    @QtUninvokable
    private native void blit_native_GLuint_cref_QMatrix4x4_cref_QMatrix3x3(long __this__nativeId, int texture, long targetTransform, long sourceTransform);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#blit">QOpenGLTextureBlitter::<wbr/>blit(GLuint,<wbr/>QMatrix4x4,<wbr/>QOpenGLTextureBlitter::Origin)</a></code></p>
     */
    @QtUninvokable
    public final void blit(int texture, io.qt.gui.@NonNull QMatrix4x4 targetTransform, io.qt.opengl.QOpenGLTextureBlitter.@NonNull Origin sourceOrigin){
        blit_native_GLuint_cref_QMatrix4x4_QOpenGLTextureBlitter_Origin(QtJambi_LibraryUtilities.internal.nativeId(this), texture, QtJambi_LibraryUtilities.internal.checkedNativeId(targetTransform), sourceOrigin.value());
    }
    
    @QtUninvokable
    private native void blit_native_GLuint_cref_QMatrix4x4_QOpenGLTextureBlitter_Origin(long __this__nativeId, int texture, long targetTransform, int sourceOrigin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#create">QOpenGLTextureBlitter::<wbr/>create()</a></code></p>
     */
    @QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#destroy">QOpenGLTextureBlitter::<wbr/>destroy()</a></code></p>
     */
    @QtUninvokable
    public final void destroy(){
        destroy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void destroy_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#isCreated">QOpenGLTextureBlitter::<wbr/>isCreated()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isCreated(){
        return isCreated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCreated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#release">QOpenGLTextureBlitter::<wbr/>release()</a></code></p>
     */
    @QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#setOpacity">QOpenGLTextureBlitter::<wbr/>setOpacity(float)</a></code></p>
     */
    @QtUninvokable
    public final void setOpacity(float opacity){
        setOpacity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), opacity);
    }
    
    @QtUninvokable
    private native void setOpacity_native_float(long __this__nativeId, float opacity);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#setRedBlueSwizzle">QOpenGLTextureBlitter::<wbr/>setRedBlueSwizzle(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setRedBlueSwizzle(boolean swizzle){
        setRedBlueSwizzle_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), swizzle);
    }
    
    @QtUninvokable
    private native void setRedBlueSwizzle_native_bool(long __this__nativeId, boolean swizzle);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#supportsExternalOESTarget">QOpenGLTextureBlitter::<wbr/>supportsExternalOESTarget()const</a></code></p>
     */
    @QtUninvokable
    public final boolean supportsExternalOESTarget(){
        return supportsExternalOESTarget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsExternalOESTarget_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#supportsRectangleTarget">QOpenGLTextureBlitter::<wbr/>supportsRectangleTarget()const</a></code></p>
     */
    @QtUninvokable
    public final boolean supportsRectangleTarget(){
        return supportsRectangleTarget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsRectangleTarget_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#sourceTransform">QOpenGLTextureBlitter::<wbr/>sourceTransform(QRectF,<wbr/>QSize,<wbr/>QOpenGLTextureBlitter::Origin)</a></code></p>
     */
    public static io.qt.gui.@NonNull QMatrix3x3 sourceTransform(io.qt.core.@NonNull QRectF subTexture, io.qt.core.@NonNull QSize textureSize, io.qt.opengl.QOpenGLTextureBlitter.@NonNull Origin origin){
        return sourceTransform_native_cref_QRectF_cref_QSize_QOpenGLTextureBlitter_Origin(QtJambi_LibraryUtilities.internal.checkedNativeId(subTexture), QtJambi_LibraryUtilities.internal.checkedNativeId(textureSize), origin.value());
    }
    
    private native static io.qt.gui.QMatrix3x3 sourceTransform_native_cref_QRectF_cref_QSize_QOpenGLTextureBlitter_Origin(long subTexture, long textureSize, int origin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qopengltextureblitter.html#targetTransform">QOpenGLTextureBlitter::<wbr/>targetTransform(QRectF,<wbr/>QRect)</a></code></p>
     */
    public static io.qt.gui.@NonNull QMatrix4x4 targetTransform(io.qt.core.@NonNull QRectF target, io.qt.core.@NonNull QRect viewport){
        return targetTransform_native_cref_QRectF_cref_QRect(QtJambi_LibraryUtilities.internal.checkedNativeId(target), QtJambi_LibraryUtilities.internal.checkedNativeId(viewport));
    }
    
    private native static io.qt.gui.QMatrix4x4 targetTransform_native_cref_QRectF_cref_QRect(long target, long viewport);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLTextureBlitter(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #bind(int)}
     *  with <code>target = 0x0DE1</code>.</p>
     */
    @QtUninvokable
    public final void bind() {
        bind((int)0x0DE1);
    }
    
    /**
     * <p>Overloaded function for {@link #blit(int, io.qt.gui.QMatrix4x4, io.qt.gui.QMatrix3x3)}.</p>
     */
    @QtUninvokable
    public final void blit(int texture, io.qt.gui.@NonNull QTransform targetTransform, io.qt.gui.@NonNull QMatrix3x3 sourceTransform) {
        blit(texture, new io.qt.gui.QMatrix4x4(targetTransform), sourceTransform);
    }
    
    /**
     * <p>Overloaded function for {@link #blit(int, io.qt.gui.QMatrix4x4, io.qt.opengl.QOpenGLTextureBlitter.Origin)}.</p>
     */
    @QtUninvokable
    public final void blit(int texture, io.qt.gui.@NonNull QTransform targetTransform, io.qt.opengl.QOpenGLTextureBlitter.@NonNull Origin sourceOrigin) {
        blit(texture, new io.qt.gui.QMatrix4x4(targetTransform), sourceOrigin);
    }
    
    /**
     * <p>Overloaded function for {@link #sourceTransform(io.qt.core.QRectF, io.qt.core.QSize, io.qt.opengl.QOpenGLTextureBlitter.Origin)}.</p>
     */
    public static io.qt.gui.@NonNull QMatrix3x3 sourceTransform(io.qt.core.@NonNull QRect subTexture, io.qt.core.@NonNull QSize textureSize, io.qt.opengl.QOpenGLTextureBlitter.@NonNull Origin origin) {
        return sourceTransform(new io.qt.core.QRectF(subTexture), textureSize, origin);
    }
    
    /**
     * <p>Overloaded function for {@link #targetTransform(io.qt.core.QRectF, io.qt.core.QRect)}.</p>
     */
    public static io.qt.gui.@NonNull QMatrix4x4 targetTransform(io.qt.core.@NonNull QRect target, io.qt.core.@NonNull QRect viewport) {
        return targetTransform(new io.qt.core.QRectF(target), viewport);
    }
}
