package io.qt.opengl;

import io.qt.*;


/**
 * <p>All functions for OpenGL 3.1 specification</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglfunctions-3-1.html">QOpenGLFunctions_3_1</a></code></p>
 */
public class QOpenGLFunctions_3_1 extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>QOpenGLFunctions_3_1()</code></p>
     */
    public QOpenGLFunctions_3_1(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_3_1 instance);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glActiveTexture(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glAttachShader(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBeginConditionalRender(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBeginConditionalRender(int id, int mode){
        glBeginConditionalRender_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, mode);
    }
    
    @QtUninvokable
    private native void glBeginConditionalRender_native_GLuint_GLenum(long __this__nativeId, int id, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBeginQuery(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBeginQuery(int target, int id){
        glBeginQuery_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBeginQuery_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBeginTransformFeedback(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBeginTransformFeedback(int primitiveMode){
        glBeginTransformFeedback_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveMode);
    }
    
    @QtUninvokable
    private native void glBeginTransformFeedback_native_GLenum(long __this__nativeId, int primitiveMode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindAttribLocation(GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.nio.@Nullable CharBuffer name){
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindBuffer(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindBufferBase(GLenum,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindBufferBase(int target, int index, int buffer){
        glBindBufferBase_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer);
    }
    
    @QtUninvokable
    private native void glBindBufferBase_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindBufferRange(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glBindBufferRange(int target, int index, int buffer, long offset, long size){
        glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int index, int buffer, long offset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindFragDataLocation(GLuint,<wbr/>GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glBindFragDataLocation(int program, int color, java.nio.@Nullable CharBuffer name){
        glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, color, name);
    }
    
    @QtUninvokable
    private native void glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int color, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindFramebuffer(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindFramebuffer(int target, int framebuffer){
        glBindFramebuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, framebuffer);
    }
    
    @QtUninvokable
    private native void glBindFramebuffer_native_GLenum_GLuint(long __this__nativeId, int target, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindRenderbuffer(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindRenderbuffer(int target, int renderbuffer){
        glBindRenderbuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, renderbuffer);
    }
    
    @QtUninvokable
    private native void glBindRenderbuffer_native_GLenum_GLuint(long __this__nativeId, int target, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindTexture(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBindVertexArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindVertexArray(int array){
        glBindVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glBindVertexArray_native_GLuint(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBlendColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBlendEquation(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBlendEquationSeparate(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBlendFunc(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBlendFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBlitFramebuffer(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLbitfield,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter){
        glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    
    @QtUninvokable
    private native void glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(long __this__nativeId, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBufferData(GLenum,<wbr/>GLsizeiptr,<wbr/>const GLvoid*,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBufferData(int target, long size, java.nio.@Nullable Buffer data, int usage){
        glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCheckFramebufferStatus(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glCheckFramebufferStatus(int target){
        return glCheckFramebufferStatus_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native int glCheckFramebufferStatus_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClampColor(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glClampColor(int target, int clamp){
        glClampColor_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, clamp);
    }
    
    @QtUninvokable
    private native void glClampColor_native_GLenum_GLenum(long __this__nativeId, int target, int clamp);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClear(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClearBufferfi(GLenum,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil){
        glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, depth, stencil);
    }
    
    @QtUninvokable
    private native void glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(long __this__nativeId, int buffer, int drawbuffer, float depth, int stencil);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClearBufferfv(GLenum,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferfv(int buffer, int drawbuffer, java.nio.@Nullable FloatBuffer value){
        glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClearBufferiv(GLenum,<wbr/>GLint,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferiv(int buffer, int drawbuffer, java.nio.@Nullable IntBuffer value){
        glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClearBufferuiv(GLenum,<wbr/>GLint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glClearBufferuiv(int buffer, int drawbuffer, java.nio.@Nullable IntBuffer value){
        glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClearColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClearDepth(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glClearStencil(GLint)</code></p>
     */
    @QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glColorMask(GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glColorMaski(GLuint,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glColorMaski(int index, boolean r, boolean g, boolean b, boolean a){
        glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), index, r, g, b, a);
    }
    
    @QtUninvokable
    private native void glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, int index, boolean r, boolean g, boolean b, boolean a);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCompileShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCompressedTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCompressedTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCompressedTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCompressedTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCompressedTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCompressedTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCopyBufferSubData(GLenum,<wbr/>GLenum,<wbr/>GLintptr,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size){
        glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), readTarget, writeTarget, readOffset, writeOffset, size);
    }
    
    @QtUninvokable
    private native void glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(long __this__nativeId, int readTarget, int writeTarget, long readOffset, long writeOffset, long size);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCopyTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCopyTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCopyTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCopyTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCopyTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCreateProgram()</code></p>
     */
    @QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCreateShader(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glCullFace(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDeleteBuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDeleteFramebuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDeleteProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDeleteQueries(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteQueries(int n, java.nio.@Nullable IntBuffer ids){
        glDeleteQueries_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteQueries_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDeleteRenderbuffers(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDeleteShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDeleteTextures(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteTextures(int n, java.nio.@Nullable IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDeleteVertexArrays(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteVertexArrays(int n, java.nio.@Nullable IntBuffer arrays){
        glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDepthFunc(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDepthMask(GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDepthRange(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDetachShader(GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDisable(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDisableVertexAttribArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDisablei(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glDisablei(int target, int index){
        glDisablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glDisablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDrawArrays(GLenum,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDrawArraysInstanced(GLenum,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawArraysInstanced(int mode, int first, int count, int instancecount){
        glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(long __this__nativeId, int mode, int first, int count, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDrawBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDrawBuffer(int mode){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDrawBuffers(GLsizei,<wbr/>const GLenum*)</code></p>
     */
    @QtUninvokable
    public final void glDrawBuffers(int n, java.nio.@Nullable IntBuffer bufs){
        glDrawBuffers_native_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, bufs);
    }
    
    @QtUninvokable
    private native void glDrawBuffers_native_GLsizei_const_GLenum_ptr(long __this__nativeId, int n, java.nio.IntBuffer bufs);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDrawElements(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDrawElementsInstanced(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawElementsInstanced(int mode, int count, int type, java.nio.@Nullable Buffer indices, int instancecount){
        glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glDrawRangeElements(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glEnable(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glEnableVertexAttribArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glEnablei(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glEnablei(int target, int index){
        glEnablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glEnablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glEndConditionalRender()</code></p>
     */
    @QtUninvokable
    public final void glEndConditionalRender(){
        glEndConditionalRender_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndConditionalRender_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glEndQuery(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEndQuery(int target){
        glEndQuery_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glEndQuery_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glEndTransformFeedback()</code></p>
     */
    @QtUninvokable
    public final void glEndTransformFeedback(){
        glEndTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndTransformFeedback_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFinish()</code></p>
     */
    @QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFlush()</code></p>
     */
    @QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFlushMappedBufferRange(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr)</code></p>
     */
    @QtUninvokable
    public final void glFlushMappedBufferRange(int target, long offset, long length){
        glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, length);
    }
    
    @QtUninvokable
    private native void glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(long __this__nativeId, int target, long offset, long length);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFramebufferRenderbuffer(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer){
        glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, renderbuffertarget, renderbuffer);
    }
    
    @QtUninvokable
    private native void glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(long __this__nativeId, int target, int attachment, int renderbuffertarget, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFramebufferTexture1D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture1D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFramebufferTexture2D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFramebufferTexture3D(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset){
        glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level, zoffset);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level, int zoffset);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFramebufferTextureLayer(GLenum,<wbr/>GLenum,<wbr/>GLuint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer){
        glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level, layer);
    }
    
    @QtUninvokable
    private native void glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int texture, int level, int layer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glFrontFace(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGenBuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenBuffers(int n, java.nio.@Nullable IntBuffer buffers){
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGenFramebuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenFramebuffers(int n, java.nio.@Nullable IntBuffer framebuffers){
        glGenFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glGenFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGenQueries(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenQueries(int n, java.nio.@Nullable IntBuffer ids){
        glGenQueries_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenQueries_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGenRenderbuffers(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenRenderbuffers(int n, java.nio.@Nullable IntBuffer renderbuffers){
        glGenRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glGenRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGenTextures(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenTextures(int n, java.nio.@Nullable IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGenVertexArrays(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenVertexArrays(int n, java.nio.@Nullable IntBuffer arrays){
        glGenVertexArrays_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glGenVertexArrays_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGenerateMipmap(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glGenerateMipmap(int target){
        glGenerateMipmap_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glGenerateMipmap_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetActiveAttrib(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetActiveUniform(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLint*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable IntBuffer size, java.nio.@Nullable IntBuffer type, java.nio.@Nullable CharBuffer name){
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetActiveUniformBlockName(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer uniformBlockName){
        glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetActiveUniformBlockiv(GLuint,<wbr/>GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, java.nio.@Nullable IntBuffer params){
        glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetActiveUniformName(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformName(int program, int uniformIndex, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer uniformName){
        glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformIndex, bufSize, length, uniformName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetActiveUniformsiv(GLuint,<wbr/>GLsizei,<wbr/>const GLuint*,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetActiveUniformsiv(int program, int uniformCount, java.nio.@Nullable IntBuffer uniformIndices, int pname, java.nio.@Nullable IntBuffer params){
        glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformCount, uniformIndices, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetAttachedShaders(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetAttachedShaders(int program, int maxCount, java.nio.@Nullable IntBuffer count, java.nio.@Nullable IntBuffer obj){
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxCount, count, obj);
    }
    
    @QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetAttribLocation(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetAttribLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetBooleani_v(GLenum,<wbr/>GLuint,<wbr/>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final void glGetBooleani_v(int target, int index, java.nio.@Nullable IntBuffer data){
        glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetBooleanv(GLenum,<wbr/>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetBufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetBufferPointerv(GLenum,<wbr/>GLenum,<wbr/>GLvoid**)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferPointerv(int target, int pname, java.nio.@Nullable Buffer[] params){
        glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int target, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetBufferSubData(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetBufferSubData(int target, long offset, long size, java.nio.@Nullable Buffer data){
        glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetCompressedTexImage(GLenum,<wbr/>GLint,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.@Nullable Buffer img){
        glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetDoublev(GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetDoublev(int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetError()</code></p>
     */
    @QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetFloatv(GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetFloatv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetFragDataLocation(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetFragDataLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetFragDataLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetFragDataLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetFramebufferAttachmentParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, java.nio.@Nullable IntBuffer params){
        glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, pname, params);
    }
    
    @QtUninvokable
    private native void glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int attachment, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetIntegeri_v(GLenum,<wbr/>GLuint,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetIntegeri_v(int target, int index, java.nio.@Nullable IntBuffer data){
        glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetIntegerv(GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetIntegerv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetProgramInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infoLog){
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetProgramiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.@Nullable IntBuffer params){
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetQueryObjectiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryObjectiv(int id, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetQueryObjectuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryObjectuiv(int id, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetQueryiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetQueryiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetQueryiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetRenderbufferParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetRenderbufferParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetShaderInfoLog(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer infoLog){
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetShaderSource(GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderSource(int shader, int bufSize, java.nio.@Nullable IntBuffer length, java.nio.@Nullable CharBuffer source){
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, source);
    }
    
    @QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetShaderiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.@Nullable IntBuffer params){
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetString(GLenum)</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetString_native_GLenum(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetStringi(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetStringi(int name, int index){
        return glGetStringi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name, index);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetStringi_native_GLenum_GLuint(long __this__nativeId, int name, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetTexImage(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.@Nullable Buffer pixels){
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetTexLevelParameterfv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetTexLevelParameteriv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetTexParameterIiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterIiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetTexParameterIuiv(GLenum,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterIuiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetTransformFeedbackVarying(GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLsizei*,<wbr/>GLsizei*,<wbr/>GLenum*,<wbr/>GLchar*)</code></p>
     */
    @QtUninvokable
    public final void glGetTransformFeedbackVarying(int program, int index, int[] size, int[] type, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        if(size!=null && size.length < 1)
            throw new IllegalArgumentException("Argument 'size': Wrong number of elements in array. Found: " + size.length + ", expected: 1");
        if(type!=null && type.length < 1)
            throw new IllegalArgumentException("Argument 'type': Wrong number of elements in array. Found: " + type.length + ", expected: 1");
        glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int[] size, int[] type, java.lang.String[] name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetUniformBlockIndex(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetUniformBlockIndex(int program, java.nio.@Nullable CharBuffer uniformBlockName){
        return glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockName);
    }
    
    @QtUninvokable
    private native int glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer uniformBlockName);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetUniformIndices(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformIndices(int program, java.lang.String[] uniformNames, int[] uniformIndices){
        glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformNames, uniformIndices);
    }
    
    @QtUninvokable
    private native void glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(long __this__nativeId, int program, java.lang.String[] uniformNames, int[] uniformIndices);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetUniformLocation(GLuint,<wbr/>const GLchar*)</code></p>
     */
    @QtUninvokable
    public final int glGetUniformLocation(int program, java.nio.@Nullable CharBuffer name){
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetUniformfv(GLuint,<wbr/>GLint,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.@Nullable FloatBuffer params){
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetUniformiv(GLuint,<wbr/>GLint,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetUniformuiv(GLuint,<wbr/>GLint,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetUniformuiv(int program, int location, java.nio.@Nullable IntBuffer params){
        glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetVertexAttribIiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribIiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetVertexAttribIuiv(GLuint,<wbr/>GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribIuiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetVertexAttribPointerv(GLuint,<wbr/>GLenum,<wbr/>GLvoid**)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.@Nullable Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetVertexAttribdv(GLuint,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribdv(int index, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetVertexAttribfv(GLuint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.@Nullable FloatBuffer params){
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glGetVertexAttribiv(GLuint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.@Nullable IntBuffer params){
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glHint(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsBuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsEnabled(GLenum)</code></p>
     */
    @QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsEnabledi(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsEnabledi(int target, int index){
        return glIsEnabledi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native boolean glIsEnabledi_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsFramebuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsFramebuffer(int framebuffer){
        return glIsFramebuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer);
    }
    
    @QtUninvokable
    private native boolean glIsFramebuffer_native_GLuint(long __this__nativeId, int framebuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsQuery(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsQuery(int id){
        return glIsQuery_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsQuery_native_GLuint(long __this__nativeId, int id);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsRenderbuffer(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsRenderbuffer(int renderbuffer){
        return glIsRenderbuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer);
    }
    
    @QtUninvokable
    private native boolean glIsRenderbuffer_native_GLuint(long __this__nativeId, int renderbuffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsShader(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsTexture(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glIsVertexArray(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsVertexArray(int array){
        return glIsVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native boolean glIsVertexArray_native_GLuint(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glLineWidth(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glLinkProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glLogicOp(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glMapBuffer(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBuffer(int target, int access){
        return glMapBuffer_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBuffer_native_GLenum_GLenum(long __this__nativeId, int target, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glMapBufferRange(GLenum,<wbr/>GLintptr,<wbr/>GLsizeiptr,<wbr/>GLbitfield)</code></p>
     */
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBufferRange(int target, long offset, int access){
        return glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(long __this__nativeId, int target, long offset, int access);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glMultiDrawArrays(GLenum,<wbr/>const GLint*,<wbr/>const GLsizei*,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawArrays(int mode, java.nio.@Nullable IntBuffer first, java.nio.@Nullable IntBuffer count, int drawcount){
        glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glMultiDrawElements(GLenum,<wbr/>const GLsizei*,<wbr/>GLenum,<wbr/>const GLvoid*const*,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glMultiDrawElements(int mode, java.nio.@Nullable IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPixelStoref(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPixelStorei(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPointParameterf(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPointParameterf(int pname, float param){
        glPointParameterf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameterf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPointParameterfv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPointParameterfv(int pname, java.nio.@Nullable FloatBuffer params){
        glPointParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPointParameteri(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPointParameteri(int pname, int param){
        glPointParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPointParameteriv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glPointParameteriv(int pname, java.nio.@Nullable IntBuffer params){
        glPointParameteriv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameteriv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPointSize(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPolygonMode(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPolygonOffset(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glPrimitiveRestartIndex(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glPrimitiveRestartIndex(int index){
        glPrimitiveRestartIndex_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glPrimitiveRestartIndex_native_GLuint(long __this__nativeId, int index);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glReadBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glReadBuffer(int mode){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glReadPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glRenderbufferStorage(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glRenderbufferStorage(int target, int internalformat, int width, int height){
        glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glRenderbufferStorageMultisample(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height){
        glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int samples, int internalformat, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glSampleCoverage(GLfloat,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glScissor(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glShaderSource(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string, java.nio.@Nullable IntBuffer length){
        glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string, length);
    }
    
    @QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string, java.nio.IntBuffer length);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glStencilFunc(GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glStencilFuncSeparate(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glStencilMask(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glStencilMaskSeparate(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glStencilOp(GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glStencilOpSeparate(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, sfail, dpfail, dppass);
    }
    
    @QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int sfail, int dpfail, int dppass);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexBuffer(GLenum,<wbr/>GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glTexBuffer(int target, int internalformat, int buffer){
        glTexBuffer_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer);
    }
    
    @QtUninvokable
    private native void glTexBuffer_native_GLenum_GLenum_GLuint(long __this__nativeId, int target, int internalformat, int buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexParameterIiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterIiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexParameterIuiv(GLenum,<wbr/>GLenum,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterIuiv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glTransformFeedbackVaryings(GLuint,<wbr/>GLsizei,<wbr/>const GLchar*const*,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glTransformFeedbackVaryings(int program, java.lang.String[] varyings, int bufferMode){
        glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), program, varyings, bufferMode);
    }
    
    @QtUninvokable
    private native void glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(long __this__nativeId, int program, java.lang.String[] varyings, int bufferMode);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform1f(GLint,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform1f(int location, float v0){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform1fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform1i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform1i(int location, int v0){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform1iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform1ui(GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform1ui(int location, int v0){
        glUniform1ui_native_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1ui_native_GLint_GLuint(long __this__nativeId, int location, int v0);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform1uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform1uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform2f(GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform2f(int location, float v0, float v1){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform2fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform2i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform2i(int location, int v0, int v1){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform2iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform2ui(GLint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform2ui(int location, int v0, int v1){
        glUniform2ui_native_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2ui_native_GLint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform2uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform2uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform3f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform3f(int location, float v0, float v1, float v2){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform3fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform3i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform3i(int location, int v0, int v1, int v2){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform3iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform3ui(GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform3ui(int location, int v0, int v1, int v2){
        glUniform3ui_native_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3ui_native_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform3uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform3uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform4f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glUniform4f(int location, float v0, float v1, float v2, float v3){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2, float v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform4fv(GLint,<wbr/>GLsizei,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.@Nullable FloatBuffer value){
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glUniform4i(int location, int v0, int v1, int v2, int v3){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform4iv(GLint,<wbr/>GLsizei,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform4ui(GLint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniform4ui(int location, int v0, int v1, int v2, int v3){
        glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniform4uiv(GLint,<wbr/>GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glUniform4uiv(int location, int count, java.nio.@Nullable IntBuffer value){
        glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformBlockBinding(GLuint,<wbr/>GLuint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding){
        glUniformBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, uniformBlockBinding);
    }
    
    @QtUninvokable
    private native void glUniformBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int uniformBlockIndex, int uniformBlockBinding);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix2x3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2x3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix2x4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix2x4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix3x2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3x2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix3x4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix3x4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix4fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix4x2fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4x2fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUniformMatrix4x3fv(GLint,<wbr/>GLsizei,<wbr/>GLboolean,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glUniformMatrix4x3fv(int location, int count, boolean transpose, java.nio.@Nullable FloatBuffer value){
        glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUnmapBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final boolean glUnmapBuffer(int target){
        return glUnmapBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native boolean glUnmapBuffer_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glUseProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glValidateProgram(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glVertexAttribIPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribIPointer(int index, int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glVertexAttribPointer(GLuint,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLboolean,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, java.nio.@Nullable Buffer pointer){
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, normalized, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_3_1::<wbr/>glViewport(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>initializeOpenGLFunctions()</code></p>
     */
    @QtUninvokable
    @Override
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFunctions_3_1(QPrivateConstructor p) { super(p); } 
    
}
