package io.qt.opengl;

import io.qt.*;


/**
 * <p>All functions for OpenGL 1.3 specification</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qopenglfunctions-1-3.html">QOpenGLFunctions_1_3</a></code></p>
 */
public class QOpenGLFunctions_1_3 extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>QOpenGLFunctions_1_3()</code></p>
     */
    public QOpenGLFunctions_1_3(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_1_3 instance);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glAccum(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glAccum(int op, float value){
        glAccum_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), op, value);
    }
    
    @QtUninvokable
    private native void glAccum_native_GLenum_GLfloat(long __this__nativeId, int op, float value);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glActiveTexture(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glAlphaFunc(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glAlphaFunc(int func, float ref){
        glAlphaFunc_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref);
    }
    
    @QtUninvokable
    private native void glAlphaFunc_native_GLenum_GLfloat(long __this__nativeId, int func, float ref);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glAreTexturesResident(GLsizei,<wbr/>const GLuint*,<wbr/>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final boolean glAreTexturesResident(java.nio.@Nullable IntBuffer textures, boolean[] residences){
        return glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), textures, residences);
    }
    
    @QtUninvokable
    private native boolean glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(long __this__nativeId, java.nio.IntBuffer textures, boolean[] residences);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glArrayElement(GLint)</code></p>
     */
    @QtUninvokable
    public final void glArrayElement(int i){
        glArrayElement_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void glArrayElement_native_GLint(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glBegin(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBegin(int mode){
        glBegin_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBegin_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glBindTexture(GLenum,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glBitmap(GLsizei,<wbr/>GLsizei,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glBitmap(int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.@Nullable ByteBuffer bitmap){
        glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, xorig, yorig, xmove, ymove, bitmap);
    }
    
    @QtUninvokable
    private native void glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(long __this__nativeId, int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.ByteBuffer bitmap);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glBlendColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glBlendEquation(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glBlendFunc(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCallList(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glCallList(int list){
        glCallList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native void glCallList_native_GLuint(long __this__nativeId, int list);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCallLists(GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCallLists(int n, int type, java.nio.@Nullable Buffer lists){
        glCallLists_native_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, type, lists);
    }
    
    @QtUninvokable
    private native void glCallLists_native_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int n, int type, java.nio.Buffer lists);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glClear(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glClearAccum(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearAccum(float red, float green, float blue, float alpha){
        glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glClearColor(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glClearDepth(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glClearIndex(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glClearIndex(float c){
        glClearIndex_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glClearIndex_native_GLfloat(long __this__nativeId, float c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glClearStencil(GLint)</code></p>
     */
    @QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glClientActiveTexture(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glClientActiveTexture(int texture){
        glClientActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glClientActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glClipPlane(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glClipPlane(int plane, double[] equation){
        if(equation!=null && equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glClipPlane_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @QtUninvokable
    private native void glClipPlane_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glColor3b(byte red, byte green, byte blue){
        glColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glColor3bv(byte[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glColor3d(double red, double green, double blue){
        glColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glColor3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glColor3f(float red, float green, float blue){
        glColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColor3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glColor3i(int red, int green, int blue){
        glColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColor3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glColor3s(short red, short green, short blue){
        glColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @QtUninvokable
    private native void glColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glColor3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glColor4b(byte red, byte green, byte blue, byte alpha){
        glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue, byte alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glColor4bv(byte[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glColor4d(double red, double green, double blue, double alpha){
        glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue, double alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glColor4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glColor4f(float red, float green, float blue, float alpha){
        glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColor4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glColor4i(int red, int green, int blue, int alpha){
        glColor4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue, int alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColor4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glColor4s(short red, short green, short blue, short alpha){
        glColor4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColor4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue, short alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColor4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glColor4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glColor4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColorMask(GLboolean,<wbr/>GLboolean,<wbr/>GLboolean,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColorMaterial(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glColorMaterial(int face, int mode){
        glColorMaterial_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glColorMaterial_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColorPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glColorPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColorSubTable(GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glColorSubTable(int target, int start, int count, int format, int type, java.nio.@Nullable Buffer data){
        glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, count, format, type, data);
    }
    
    @QtUninvokable
    private native void glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int start, int count, int format, int type, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColorTable(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glColorTable(int target, int internalformat, int width, int format, int type, java.nio.@Nullable Buffer table){
        glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, table);
    }
    
    @QtUninvokable
    private native void glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColorTableParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glColorTableParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glColorTableParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glColorTableParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCompressedTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCompressedTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCompressedTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCompressedTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCompressedTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCompressedTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.@Nullable Buffer data){
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glConvolutionFilter1D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, java.nio.@Nullable Buffer image){
        glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, image);
    }
    
    @QtUninvokable
    private native void glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glConvolutionFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.@Nullable Buffer image){
        glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, image);
    }
    
    @QtUninvokable
    private native void glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glConvolutionParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameterf(int target, int pname, float params){
        glConvolutionParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glConvolutionParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glConvolutionParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameteri(int target, int pname, int params){
        glConvolutionParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glConvolutionParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glConvolutionParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyColorSubTable(GLenum,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyColorSubTable(int target, int start, int x, int y, int width){
        glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(long __this__nativeId, int target, int start, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyColorTable(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyColorTable(int target, int internalformat, int x, int y, int width){
        glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyConvolutionFilter1D(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyConvolutionFilter1D(int target, int internalformat, int x, int y, int width){
        glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyConvolutionFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyConvolutionFilter2D(int target, int internalformat, int x, int y, int width, int height){
        glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glCopyPixels(int x, int y, int width, int height, int type){
        glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, type);
    }
    
    @QtUninvokable
    private native void glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(long __this__nativeId, int x, int y, int width, int height, int type);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCopyTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glCullFace(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDeleteLists(GLuint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDeleteLists(int list, int range){
        glDeleteLists_native_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), list, range);
    }
    
    @QtUninvokable
    private native void glDeleteLists_native_GLuint_GLsizei(long __this__nativeId, int list, int range);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDeleteTextures(GLsizei,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glDeleteTextures(int n, java.nio.@Nullable IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDepthFunc(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDepthMask(GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDepthRange(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDisable(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDisableClientState(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDisableClientState(int array){
        glDisableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glDisableClientState_native_GLenum(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDrawArrays(GLenum,<wbr/>GLint,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDrawBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glDrawBuffer(int mode){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDrawElements(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDrawPixels(GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glDrawPixels(int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glDrawRangeElements(GLenum,<wbr/>GLuint,<wbr/>GLuint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.@Nullable Buffer indices){
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEdgeFlag(GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glEdgeFlag(boolean flag){
        glEdgeFlag_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glEdgeFlag_native_GLboolean(long __this__nativeId, boolean flag);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEdgeFlagPointer(GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glEdgeFlagPointer(int stride, java.nio.@Nullable Buffer pointer){
        glEdgeFlagPointer_native_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), stride, pointer);
    }
    
    @QtUninvokable
    private native void glEdgeFlagPointer_native_GLsizei_const_GLvoid_ptr(long __this__nativeId, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEnable(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEnableClientState(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glEnableClientState(int array){
        glEnableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glEnableClientState_native_GLenum(long __this__nativeId, int array);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEnd()</code></p>
     */
    @QtUninvokable
    public final void glEnd(){
        glEnd_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEnd_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEndList()</code></p>
     */
    @QtUninvokable
    public final void glEndList(){
        glEndList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndList_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalCoord1d(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1d(double u){
        glEvalCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1d_native_GLdouble(long __this__nativeId, double u);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalCoord1dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1dv(double[] u){
        if(u!=null && u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalCoord1f(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1f(float u){
        glEvalCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1f_native_GLfloat(long __this__nativeId, float u);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalCoord1fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord1fv(float[] u){
        if(u!=null && u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalCoord2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2d(double u, double v){
        glEvalCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @QtUninvokable
    private native void glEvalCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double u, double v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalCoord2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2dv(double[] u){
        if(u!=null && u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalCoord2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2f(float u, float v){
        glEvalCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @QtUninvokable
    private native void glEvalCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float u, float v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalCoord2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glEvalCoord2fv(float[] u){
        if(u!=null && u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @QtUninvokable
    private native void glEvalCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalMesh1(GLenum,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalMesh1(int mode, int i1, int i2){
        glEvalMesh1_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2);
    }
    
    @QtUninvokable
    private native void glEvalMesh1_native_GLenum_GLint_GLint(long __this__nativeId, int mode, int i1, int i2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalMesh2(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalMesh2(int mode, int i1, int i2, int j1, int j2){
        glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2, j1, j2);
    }
    
    @QtUninvokable
    private native void glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int mode, int i1, int i2, int j1, int j2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalPoint1(GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalPoint1(int i){
        glEvalPoint1_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native void glEvalPoint1_native_GLint(long __this__nativeId, int i);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glEvalPoint2(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glEvalPoint2(int i, int j){
        glEvalPoint2_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i, j);
    }
    
    @QtUninvokable
    private native void glEvalPoint2_native_GLint_GLint(long __this__nativeId, int i, int j);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFeedbackBuffer(GLsizei,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glFeedbackBuffer(int type, java.nio.@Nullable FloatBuffer buffer){
        glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, buffer);
    }
    
    @QtUninvokable
    private native void glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(long __this__nativeId, int type, java.nio.FloatBuffer buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFinish()</code></p>
     */
    @QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFlush()</code></p>
     */
    @QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFogf(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glFogf(int pname, float param){
        glFogf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glFogf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFogfv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glFogfv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glFogfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFogi(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glFogi(int pname, int param){
        glFogi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glFogi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFogiv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glFogiv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogiv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glFogiv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFrontFace(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glFrustum(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glFrustum(double left, double right, double bottom, double top, double zNear, double zFar){
        glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @QtUninvokable
    private native void glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGenLists(GLsizei)</code></p>
     */
    @QtUninvokable
    public final int glGenLists(int range){
        return glGenLists_native_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), range);
    }
    
    @QtUninvokable
    private native int glGenLists_native_GLsizei(long __this__nativeId, int range);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGenTextures(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGenTextures(int n, java.nio.@Nullable IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetBooleanv(GLenum,<wbr/>GLboolean*)</code></p>
     */
    @QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetClipPlane(GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetClipPlane(int plane, double[] equation){
        if(equation!=null && equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glGetClipPlane_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @QtUninvokable
    private native void glGetClipPlane_native_GLenum_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetColorTable(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTable(int target, int format, int type, java.nio.@Nullable Buffer table){
        glGetColorTable_native_GLenum_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, table);
    }
    
    @QtUninvokable
    private native void glGetColorTable_native_GLenum_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer table);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetColorTableParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTableParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetColorTableParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetColorTableParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetCompressedTexImage(GLenum,<wbr/>GLint,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.@Nullable Buffer img){
        glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetConvolutionFilter(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionFilter(int target, int format, int type, java.nio.@Nullable Buffer image){
        glGetConvolutionFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, image);
    }
    
    @QtUninvokable
    private native void glGetConvolutionFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer image);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetConvolutionParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetConvolutionParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetConvolutionParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetDoublev(GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetDoublev(int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetError()</code></p>
     */
    @QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetFloatv(GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetFloatv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetHistogram(GLenum,<wbr/>GLboolean,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogram(int target, boolean reset, int format, int type, java.nio.@Nullable Buffer values){
        glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @QtUninvokable
    private native void glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetHistogramParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogramParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetHistogramParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetHistogramParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetIntegerv(GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetIntegerv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetLightfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetLightfv(int light, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetLightiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetLightiv(int light, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glGetLightiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetMapdv(GLenum,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapdv(int target, int query, double[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int target, int query, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetMapfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapfv(int target, int query, float[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int query, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetMapiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMapiv(int target, int query, int[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @QtUninvokable
    private native void glGetMapiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int query, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetMaterialfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMaterialfv(int face, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetMaterialiv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMaterialiv(int face, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetMinmax(GLenum,<wbr/>GLboolean,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmax(int target, boolean reset, int format, int type, java.nio.@Nullable Buffer values){
        glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @QtUninvokable
    private native void glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetMinmaxParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmaxParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetMinmaxParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetMinmaxParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetPixelMapfv(GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapfv(int map, java.nio.@Nullable FloatBuffer values){
        glGetPixelMapfv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapfv_native_GLenum_GLfloat_ptr(long __this__nativeId, int map, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetPixelMapuiv(GLenum,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapuiv(int map, java.nio.@Nullable IntBuffer values){
        glGetPixelMapuiv_native_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapuiv_native_GLenum_GLuint_ptr(long __this__nativeId, int map, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetPixelMapusv(GLenum,<wbr/>GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glGetPixelMapusv(int map, java.nio.@Nullable ShortBuffer values){
        glGetPixelMapusv_native_GLenum_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @QtUninvokable
    private native void glGetPixelMapusv_native_GLenum_GLushort_ptr(long __this__nativeId, int map, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetPointerv(GLenum,<wbr/>GLvoid**)</code></p>
     */
    @QtUninvokable
    public final void glGetPointerv(int pname, java.nio.Buffer @StrictNonNull[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetPointerv_native_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetPointerv_native_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int pname, java.nio.Buffer[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetPolygonStipple(GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glGetPolygonStipple(java.nio.@Nullable ByteBuffer mask){
        glGetPolygonStipple_native_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glGetPolygonStipple_native_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetSeparableFilter(GLenum,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*,<wbr/>GLvoid*,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetSeparableFilter(int target, int format, int type, java.nio.@Nullable Buffer row, java.nio.@Nullable Buffer column, java.nio.@Nullable Buffer span){
        glGetSeparableFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr_GLvoid_ptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, row, column, span);
    }
    
    @QtUninvokable
    private native void glGetSeparableFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr_GLvoid_ptr_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer row, java.nio.Buffer column, java.nio.Buffer span);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetString(GLenum)</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.@NonNull String glGetString_native_GLenum(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexEnvfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexEnvfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexEnviv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexEnviv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexGendv(GLenum,<wbr/>GLenum,<wbr/>GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGendv(int coord, int pname, java.nio.@Nullable DoubleBuffer params){
        glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int coord, int pname, java.nio.DoubleBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexGenfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGenfv(int coord, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int coord, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexGeniv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexGeniv(int coord, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int coord, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexImage(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.@Nullable Buffer pixels){
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexLevelParameterfv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexLevelParameteriv(GLenum,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glGetTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>GLint*)</code></p>
     */
    @QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glHint(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glHistogram(GLenum,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glHistogram(int target, int width, int internalformat, boolean sink){
        glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, width, internalformat, sink);
    }
    
    @QtUninvokable
    private native void glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(long __this__nativeId, int target, int width, int internalformat, boolean sink);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexMask(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glIndexMask(int mask){
        glIndexMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glIndexMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexPointer(GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glIndexPointer(int type, int stride, java.nio.@Nullable Buffer pointer){
        glIndexPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glIndexPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexd(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glIndexd(double c){
        glIndexd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexd_native_GLdouble(long __this__nativeId, double c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexdv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glIndexdv(double[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexdv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexdv_native_const_GLdouble_ptr(long __this__nativeId, double[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexf(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glIndexf(float c){
        glIndexf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexf_native_GLfloat(long __this__nativeId, float c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexfv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glIndexfv(float[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexfv_native_const_GLfloat_ptr(long __this__nativeId, float[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexi(GLint)</code></p>
     */
    @QtUninvokable
    public final void glIndexi(int c){
        glIndexi_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexi_native_GLint(long __this__nativeId, int c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexiv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glIndexiv(int[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexiv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexiv_native_const_GLint_ptr(long __this__nativeId, int[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexs(GLshort)</code></p>
     */
    @QtUninvokable
    public final void glIndexs(short c){
        glIndexs_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexs_native_GLshort(long __this__nativeId, short c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexsv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glIndexsv(short[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexsv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexsv_native_const_GLshort_ptr(long __this__nativeId, short[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexub(GLubyte)</code></p>
     */
    @QtUninvokable
    public final void glIndexub(byte c){
        glIndexub_native_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexub_native_GLubyte(long __this__nativeId, byte c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIndexubv(const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glIndexubv(byte[] c){
        if(c!=null && c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @QtUninvokable
    private native void glIndexubv_native_const_GLubyte_ptr(long __this__nativeId, byte[] c);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glInitNames()</code></p>
     */
    @QtUninvokable
    public final void glInitNames(){
        glInitNames_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glInitNames_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glInterleavedArrays(GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glInterleavedArrays(int format, int stride, java.nio.@Nullable Buffer pointer){
        glInterleavedArrays_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), format, stride, pointer);
    }
    
    @QtUninvokable
    private native void glInterleavedArrays_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int format, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIsEnabled(GLenum)</code></p>
     */
    @QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIsList(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsList(int list){
        return glIsList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native boolean glIsList_native_GLuint(long __this__nativeId, int list);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glIsTexture(GLuint)</code></p>
     */
    @QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLightModelf(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLightModelf(int pname, float param){
        glLightModelf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glLightModelf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLightModelfv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLightModelfv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModelfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glLightModelfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLightModeli(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glLightModeli(int pname, int param){
        glLightModeli_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glLightModeli_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLightModeliv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glLightModeliv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModeliv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glLightModeliv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLightf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLightf(int light, int pname, float param){
        glLightf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @QtUninvokable
    private native void glLightf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int light, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLightfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLightfv(int light, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLighti(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glLighti(int light, int pname, int param){
        glLighti_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @QtUninvokable
    private native void glLighti_native_GLenum_GLenum_GLint(long __this__nativeId, int light, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLightiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glLightiv(int light, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @QtUninvokable
    private native void glLightiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLineStipple(GLint,<wbr/>GLushort)</code></p>
     */
    @QtUninvokable
    public final void glLineStipple(int factor, short pattern){
        glLineStipple_native_GLint_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), factor, pattern);
    }
    
    @QtUninvokable
    private native void glLineStipple_native_GLint_GLushort(long __this__nativeId, int factor, short pattern);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLineWidth(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glListBase(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glListBase(int base){
        glListBase_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), base);
    }
    
    @QtUninvokable
    private native void glListBase_native_GLuint(long __this__nativeId, int base);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLoadIdentity()</code></p>
     */
    @QtUninvokable
    public final void glLoadIdentity(){
        glLoadIdentity_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glLoadIdentity_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLoadMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glLoadMatrixd(double[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLoadMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLoadMatrixf(float[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLoadName(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glLoadName(int name){
        glLoadName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void glLoadName_native_GLuint(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLoadTransposeMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glLoadTransposeMatrixd(java.nio.@Nullable DoubleBuffer m){
        glLoadTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLoadTransposeMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glLoadTransposeMatrixf(java.nio.@Nullable FloatBuffer m){
        glLoadTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glLoadTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glLogicOp(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMap1d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMap1d(int target, double u1, double u2, int stride, int order, java.nio.@Nullable DoubleBuffer points){
        glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @QtUninvokable
    private native void glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int stride, int order, java.nio.DoubleBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMap1f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMap1f(int target, float u1, float u2, int stride, int order, java.nio.@Nullable FloatBuffer points){
        glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @QtUninvokable
    private native void glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int stride, int order, java.nio.FloatBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMap2d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.@Nullable DoubleBuffer points){
        glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @QtUninvokable
    private native void glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.DoubleBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMap2f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.@Nullable FloatBuffer points){
        glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @QtUninvokable
    private native void glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.FloatBuffer points);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMapGrid1d(GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid1d(int un, double u1, double u2){
        glMapGrid1d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @QtUninvokable
    private native void glMapGrid1d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMapGrid1f(GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid1f(int un, float u1, float u2){
        glMapGrid1f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @QtUninvokable
    private native void glMapGrid1f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMapGrid2d(GLint,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLint,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid2d(int un, double u1, double u2, int vn, double v1, double v2){
        glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @QtUninvokable
    private native void glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2, int vn, double v1, double v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMapGrid2f(GLint,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLint,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMapGrid2f(int un, float u1, float u2, int vn, float v1, float v2){
        glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @QtUninvokable
    private native void glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2, int vn, float v1, float v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMaterialf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMaterialf(int face, int pname, float param){
        glMaterialf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @QtUninvokable
    private native void glMaterialf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int face, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMaterialfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMaterialfv(int face, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMateriali(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMateriali(int face, int pname, int param){
        glMateriali_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @QtUninvokable
    private native void glMateriali_native_GLenum_GLenum_GLint(long __this__nativeId, int face, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMaterialiv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMaterialiv(int face, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @QtUninvokable
    private native void glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMatrixMode(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glMatrixMode(int mode){
        glMatrixMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glMatrixMode_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMinmax(GLenum,<wbr/>GLenum,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glMinmax(int target, int internalformat, boolean sink){
        glMinmax_native_GLenum_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, sink);
    }
    
    @QtUninvokable
    private native void glMinmax_native_GLenum_GLenum_GLboolean(long __this__nativeId, int target, int internalformat, boolean sink);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultMatrixd(double[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultMatrixf(float[] m){
        if(m!=null && m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultTransposeMatrixd(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultTransposeMatrixd(java.nio.@Nullable DoubleBuffer m){
        glMultTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultTransposeMatrixf(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultTransposeMatrixf(java.nio.@Nullable FloatBuffer m){
        glMultTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @QtUninvokable
    private native void glMultTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord1d(GLenum,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1d(int target, double s){
        glMultiTexCoord1d_native_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1d_native_GLenum_GLdouble(long __this__nativeId, int target, double s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord1dv(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord1f(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1f(int target, float s){
        glMultiTexCoord1f_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1f_native_GLenum_GLfloat(long __this__nativeId, int target, float s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord1fv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord1i(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1i(int target, int s){
        glMultiTexCoord1i_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1i_native_GLenum_GLint(long __this__nativeId, int target, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord1iv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord1s(GLenum,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1s(int target, short s){
        glMultiTexCoord1s_native_GLenum_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1s_native_GLenum_GLshort(long __this__nativeId, int target, short s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord1sv(GLenum,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord1sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord2d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2d(int target, double s, double t){
        glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord2dv(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord2f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2f(int target, float s, float t){
        glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord2fv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord2i(GLenum,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2i(int target, int s, int t){
        glMultiTexCoord2i_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2i_native_GLenum_GLint_GLint(long __this__nativeId, int target, int s, int t);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord2iv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord2s(GLenum,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2s(int target, short s, short t){
        glMultiTexCoord2s_native_GLenum_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2s_native_GLenum_GLshort_GLshort(long __this__nativeId, int target, short s, short t);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord2sv(GLenum,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord2sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord3d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3d(int target, double s, double t, double r){
        glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord3dv(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord3f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3f(int target, float s, float t, float r){
        glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord3fv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord3i(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3i(int target, int s, int t, int r){
        glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord3iv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord3s(GLenum,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3s(int target, short s, short t, short r){
        glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord3sv(GLenum,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord3sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord4d(GLenum,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4d(int target, double s, double t, double r, double q){
        glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r, double q);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord4dv(GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4dv(int target, java.nio.@Nullable DoubleBuffer v){
        glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord4f(GLenum,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4f(int target, float s, float t, float r, float q){
        glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r, float q);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord4fv(GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4fv(int target, java.nio.@Nullable FloatBuffer v){
        glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord4i(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4i(int target, int s, int t, int r, int q){
        glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r, int q);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord4iv(GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4iv(int target, java.nio.@Nullable IntBuffer v){
        glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord4s(GLenum,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4s(int target, short s, short t, short r, short q){
        glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r, short q);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glMultiTexCoord4sv(GLenum,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glMultiTexCoord4sv(int target, java.nio.@Nullable ShortBuffer v){
        glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @QtUninvokable
    private native void glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNewList(GLuint,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glNewList(int list, int mode){
        glNewList_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), list, mode);
    }
    
    @QtUninvokable
    private native void glNewList_native_GLuint_GLenum(long __this__nativeId, int list, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3b(GLbyte,<wbr/>GLbyte,<wbr/>GLbyte)</code></p>
     */
    @QtUninvokable
    public final void glNormal3b(byte nx, byte ny, byte nz){
        glNormal3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte nx, byte ny, byte nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3bv(const GLbyte*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3bv(byte[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glNormal3d(double nx, double ny, double nz){
        glNormal3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double nx, double ny, double nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glNormal3f(float nx, float ny, float nz){
        glNormal3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float nx, float ny, float nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glNormal3i(int nx, int ny, int nz){
        glNormal3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3i_native_GLint_GLint_GLint(long __this__nativeId, int nx, int ny, int nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glNormal3s(short nx, short ny, short nz){
        glNormal3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @QtUninvokable
    private native void glNormal3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short nx, short ny, short nz);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormal3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glNormal3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glNormal3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glNormalPointer(GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glNormalPointer(int type, int stride, java.nio.@Nullable Buffer pointer){
        glNormalPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glNormalPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glOrtho(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar){
        glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @QtUninvokable
    private native void glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPassThrough(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPassThrough(float token){
        glPassThrough_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), token);
    }
    
    @QtUninvokable
    private native void glPassThrough_native_GLfloat(long __this__nativeId, float token);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPixelMapfv(GLenum,<wbr/>GLint,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapfv(int map, int mapsize, java.nio.@Nullable FloatBuffer values){
        glPixelMapfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int map, int mapsize, java.nio.FloatBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPixelMapuiv(GLenum,<wbr/>GLint,<wbr/>const GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapuiv(int map, int mapsize, java.nio.@Nullable IntBuffer values){
        glPixelMapuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int map, int mapsize, java.nio.IntBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPixelMapusv(GLenum,<wbr/>GLint,<wbr/>const GLushort*)</code></p>
     */
    @QtUninvokable
    public final void glPixelMapusv(int map, int mapsize, java.nio.@Nullable ShortBuffer values){
        glPixelMapusv_native_GLenum_GLint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @QtUninvokable
    private native void glPixelMapusv_native_GLenum_GLint_const_GLushort_ptr(long __this__nativeId, int map, int mapsize, java.nio.ShortBuffer values);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPixelStoref(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPixelStorei(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPixelTransferf(GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelTransferf(int pname, float param){
        glPixelTransferf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelTransferf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPixelTransferi(GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glPixelTransferi(int pname, int param){
        glPixelTransferi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelTransferi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPixelZoom(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPixelZoom(float xfactor, float yfactor){
        glPixelZoom_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), xfactor, yfactor);
    }
    
    @QtUninvokable
    private native void glPixelZoom_native_GLfloat_GLfloat(long __this__nativeId, float xfactor, float yfactor);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPointSize(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPolygonMode(GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPolygonOffset(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPolygonStipple(const GLubyte*)</code></p>
     */
    @QtUninvokable
    public final void glPolygonStipple(java.nio.@Nullable ByteBuffer mask){
        glPolygonStipple_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPolygonStipple_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPopAttrib()</code></p>
     */
    @QtUninvokable
    public final void glPopAttrib(){
        glPopAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopAttrib_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPopClientAttrib()</code></p>
     */
    @QtUninvokable
    public final void glPopClientAttrib(){
        glPopClientAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopClientAttrib_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPopMatrix()</code></p>
     */
    @QtUninvokable
    public final void glPopMatrix(){
        glPopMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopMatrix_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPopName()</code></p>
     */
    @QtUninvokable
    public final void glPopName(){
        glPopName_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPopName_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPrioritizeTextures(GLsizei,<wbr/>const GLuint*,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glPrioritizeTextures(int n, java.nio.@Nullable IntBuffer textures, java.nio.@Nullable FloatBuffer priorities){
        glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures, priorities);
    }
    
    @QtUninvokable
    private native void glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures, java.nio.FloatBuffer priorities);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPushAttrib(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glPushAttrib(int mask){
        glPushAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPushAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPushClientAttrib(GLbitfield)</code></p>
     */
    @QtUninvokable
    public final void glPushClientAttrib(int mask){
        glPushClientAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glPushClientAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPushMatrix()</code></p>
     */
    @QtUninvokable
    public final void glPushMatrix(){
        glPushMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPushMatrix_native(long __this__nativeId);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glPushName(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glPushName(int name){
        glPushName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native void glPushName_native_GLuint(long __this__nativeId, int name);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2d(double x, double y){
        glRasterPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2f(float x, float y){
        glRasterPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos2i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2i(int x, int y){
        glRasterPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos2s(GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2s(short x, short y){
        glRasterPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glRasterPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3d(double x, double y, double z){
        glRasterPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3f(float x, float y, float z){
        glRasterPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3i(int x, int y, int z){
        glRasterPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3s(short x, short y, short z){
        glRasterPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glRasterPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4d(double x, double y, double z, double w){
        glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4f(float x, float y, float z, float w){
        glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4i(int x, int y, int z, int w){
        glRasterPos4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4s(short x, short y, short z, short w){
        glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRasterPos4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRasterPos4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glRasterPos4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glReadBuffer(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glReadBuffer(int mode){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glReadPixels(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRectd(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRectd(double x1, double y1, double x2, double y2){
        glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x1, double y1, double x2, double y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRectdv(const GLdouble*,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glRectdv(double[] v1, double[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(long __this__nativeId, double[] v1, double[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRectf(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRectf(float x1, float y1, float x2, float y2){
        glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x1, float y1, float x2, float y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRectfv(const GLfloat*,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glRectfv(float[] v1, float[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(long __this__nativeId, float[] v1, float[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRecti(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glRecti(int x1, int y1, int x2, int y2){
        glRecti_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRecti_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x1, int y1, int x2, int y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRectiv(const GLint*,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glRectiv(int[] v1, int[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectiv_native_const_GLint_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectiv_native_const_GLint_ptr_const_GLint_ptr(long __this__nativeId, int[] v1, int[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRects(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glRects(short x1, short y1, short x2, short y2){
        glRects_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @QtUninvokable
    private native void glRects_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x1, short y1, short x2, short y2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRectsv(const GLshort*,<wbr/>const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glRectsv(short[] v1, short[] v2){
        if(v1!=null && v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        if(v2!=null && v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @QtUninvokable
    private native void glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(long __this__nativeId, short[] v1, short[] v2);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRenderMode(GLenum)</code></p>
     */
    @QtUninvokable
    public final int glRenderMode(int mode){
        return glRenderMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native int glRenderMode_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glResetHistogram(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glResetHistogram(int target){
        glResetHistogram_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glResetHistogram_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glResetMinmax(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glResetMinmax(int target){
        glResetMinmax_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glResetMinmax_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRotated(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glRotated(double angle, double x, double y, double z){
        glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @QtUninvokable
    private native void glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double angle, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glRotatef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glRotatef(float angle, float x, float y, float z){
        glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @QtUninvokable
    private native void glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float angle, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glSampleCoverage(GLfloat,<wbr/>GLboolean)</code></p>
     */
    @QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glScaled(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glScaled(double x, double y, double z){
        glScaled_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glScaled_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glScalef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glScalef(float x, float y, float z){
        glScalef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glScalef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glScissor(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glSelectBuffer(GLsizei,<wbr/>GLuint*)</code></p>
     */
    @QtUninvokable
    public final void glSelectBuffer(java.nio.@Nullable IntBuffer buffer){
        glSelectBuffer_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native void glSelectBuffer_native_GLsizei_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer buffer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glSeparableFilter2D(GLenum,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glSeparableFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.@Nullable Buffer row, java.nio.@Nullable Buffer column){
        glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, row, column);
    }
    
    @QtUninvokable
    private native void glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer row, java.nio.Buffer column);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glShadeModel(GLenum)</code></p>
     */
    @QtUninvokable
    public final void glShadeModel(int mode){
        glShadeModel_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glShadeModel_native_GLenum(long __this__nativeId, int mode);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glStencilFunc(GLenum,<wbr/>GLint,<wbr/>GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glStencilMask(GLuint)</code></p>
     */
    @QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glStencilOp(GLenum,<wbr/>GLenum,<wbr/>GLenum)</code></p>
     */
    @QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord1d(GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1d(double s){
        glTexCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1d_native_GLdouble(long __this__nativeId, double s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord1dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1dv(double[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord1f(GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1f(float s){
        glTexCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1f_native_GLfloat(long __this__nativeId, float s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord1fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1fv(float[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord1i(GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1i(int s){
        glTexCoord1i_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1i_native_GLint(long __this__nativeId, int s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord1iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1iv(int[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord1s(GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1s(short s){
        glTexCoord1s_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glTexCoord1s_native_GLshort(long __this__nativeId, short s);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord1sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord1sv(short[] v){
        if(v!=null && v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord1sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2d(double s, double t){
        glTexCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double s, double t);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2f(float s, float t){
        glTexCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float s, float t);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord2i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2i(int s, int t){
        glTexCoord2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2i_native_GLint_GLint(long __this__nativeId, int s, int t);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord2s(GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2s(short s, short t){
        glTexCoord2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @QtUninvokable
    private native void glTexCoord2s_native_GLshort_GLshort(long __this__nativeId, short s, short t);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3d(double s, double t, double r){
        glTexCoord3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3f(float s, float t, float r){
        glTexCoord3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3i(int s, int t, int r){
        glTexCoord3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3i_native_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3s(short s, short t, short r){
        glTexCoord3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @QtUninvokable
    private native void glTexCoord3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4d(double s, double t, double r, double q){
        glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r, double q);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4f(float s, float t, float r, float q){
        glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r, float q);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4i(int s, int t, int r, int q){
        glTexCoord4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r, int q);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4s(short s, short t, short r, short q){
        glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @QtUninvokable
    private native void glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r, short q);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoord4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoord4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glTexCoord4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexCoordPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexCoordPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glTexCoordPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glTexCoordPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexEnvf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvf(int target, int pname, float param){
        glTexEnvf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexEnvf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexEnvfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvfv(int target, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexEnvi(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexEnvi(int target, int pname, int param){
        glTexEnvi_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexEnvi_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexEnviv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexEnviv(int target, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexGend(GLenum,<wbr/>GLenum,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTexGend(int coord, int pname, double param){
        glTexGend_native_GLenum_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGend_native_GLenum_GLenum_GLdouble(long __this__nativeId, int coord, int pname, double param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexGendv(GLenum,<wbr/>GLenum,<wbr/>const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glTexGendv(int coord, int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(long __this__nativeId, int coord, int pname, double[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexGenf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexGenf(int coord, int pname, float param){
        glTexGenf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGenf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int coord, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexGenfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexGenfv(int coord, int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int coord, int pname, float[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexGeni(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexGeni(int coord, int pname, int param){
        glTexGeni_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @QtUninvokable
    private native void glTexGeni_native_GLenum_GLenum_GLint(long __this__nativeId, int coord, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexGeniv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexGeniv(int coord, int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @QtUninvokable
    private native void glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int coord, int pname, int[] params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLint,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexParameterf(GLenum,<wbr/>GLenum,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexParameterfv(GLenum,<wbr/>GLenum,<wbr/>const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.@Nullable FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexParameteri(GLenum,<wbr/>GLenum,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexParameteriv(GLenum,<wbr/>GLenum,<wbr/>const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.@Nullable IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexSubImage1D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexSubImage2D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTexSubImage3D(GLenum,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLsizei,<wbr/>GLenum,<wbr/>GLenum,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.@Nullable Buffer pixels){
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTranslated(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glTranslated(double x, double y, double z){
        glTranslated_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glTranslated_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glTranslatef(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glTranslatef(float x, float y, float z){
        glTranslatef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glTranslatef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex2d(GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex2d(double x, double y){
        glVertex2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex2dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2dv(double[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex2f(GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex2f(float x, float y){
        glVertex2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex2fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2fv(float[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex2i(GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex2i(int x, int y){
        glVertex2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex2iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2iv(int[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex2s(GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex2s(short x, short y){
        glVertex2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @QtUninvokable
    private native void glVertex2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex2sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex2sv(short[] v){
        if(v!=null && v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex3d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex3d(double x, double y, double z){
        glVertex3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex3dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3dv(double[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex3f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex3f(float x, float y, float z){
        glVertex3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex3fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3fv(float[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex3i(GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex3i(int x, int y, int z){
        glVertex3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex3iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3iv(int[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex3s(GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex3s(short x, short y, short z){
        glVertex3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @QtUninvokable
    private native void glVertex3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex3sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex3sv(short[] v){
        if(v!=null && v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex4d(GLdouble,<wbr/>GLdouble,<wbr/>GLdouble,<wbr/>GLdouble)</code></p>
     */
    @QtUninvokable
    public final void glVertex4d(double x, double y, double z, double w){
        glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex4dv(const GLdouble*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4dv(double[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex4f(GLfloat,<wbr/>GLfloat,<wbr/>GLfloat,<wbr/>GLfloat)</code></p>
     */
    @QtUninvokable
    public final void glVertex4f(float x, float y, float z, float w){
        glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex4fv(const GLfloat*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4fv(float[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex4i(GLint,<wbr/>GLint,<wbr/>GLint,<wbr/>GLint)</code></p>
     */
    @QtUninvokable
    public final void glVertex4i(int x, int y, int z, int w){
        glVertex4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex4iv(const GLint*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4iv(int[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex4s(GLshort,<wbr/>GLshort,<wbr/>GLshort,<wbr/>GLshort)</code></p>
     */
    @QtUninvokable
    public final void glVertex4s(short x, short y, short z, short w){
        glVertex4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @QtUninvokable
    private native void glVertex4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertex4sv(const GLshort*)</code></p>
     */
    @QtUninvokable
    public final void glVertex4sv(short[] v){
        if(v!=null && v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @QtUninvokable
    private native void glVertex4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glVertexPointer(GLint,<wbr/>GLenum,<wbr/>GLsizei,<wbr/>const GLvoid*)</code></p>
     */
    @QtUninvokable
    public final void glVertexPointer(int size, int type, int stride, java.nio.@Nullable Buffer pointer){
        glVertexPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    /**
     * <p>See <code>QOpenGLFunctions_1_3::<wbr/>glViewport(GLint,<wbr/>GLint,<wbr/>GLsizei,<wbr/>GLsizei)</code></p>
     */
    @QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    /**
     * <p>See <code>QAbstractOpenGLFunctions::<wbr/>initializeOpenGLFunctions()</code></p>
     */
    @QtUninvokable
    @Override
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOpenGLFunctions_1_3(QPrivateConstructor p) { super(p); } 
    
}
