package io.qt.opengl;

import io.qt.*;


/**
 * <p>All functions for OpenGL 4.0 core profile</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglfunctions-4-0-core.html">QOpenGLFunctions_4_0_Core</a></p>
 */
public final class QOpenGLFunctions_4_0_Core extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    public QOpenGLFunctions_4_0_Core(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_4_0_Core instance);
    
    @QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    @QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    @QtUninvokable
    public final void glBeginConditionalRender(int id, int mode){
        glBeginConditionalRender_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, mode);
    }
    
    @QtUninvokable
    private native void glBeginConditionalRender_native_GLuint_GLenum(long __this__nativeId, int id, int mode);
    
    @QtUninvokable
    public final void glBeginQuery(int target, int id){
        glBeginQuery_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBeginQuery_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    @QtUninvokable
    public final void glBeginQueryIndexed(int target, int index, int id){
        glBeginQueryIndexed_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, id);
    }
    
    @QtUninvokable
    private native void glBeginQueryIndexed_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int id);
    
    @QtUninvokable
    public final void glBeginTransformFeedback(int primitiveMode){
        glBeginTransformFeedback_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveMode);
    }
    
    @QtUninvokable
    private native void glBeginTransformFeedback_native_GLenum(long __this__nativeId, int primitiveMode);
    
    @QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.nio.CharBuffer name){
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    @QtUninvokable
    public final void glBindBufferBase(int target, int index, int buffer){
        glBindBufferBase_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer);
    }
    
    @QtUninvokable
    private native void glBindBufferBase_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int buffer);
    
    @QtUninvokable
    public final void glBindBufferRange(int target, int index, int buffer, long offset, long size){
        glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer, offset, size);
    }
    
    @QtUninvokable
    private native void glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int index, int buffer, long offset, long size);
    
    @QtUninvokable
    public final void glBindFragDataLocation(int program, int color, java.nio.CharBuffer name){
        glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, color, name);
    }
    
    @QtUninvokable
    private native void glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int color, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glBindFragDataLocationIndexed(int program, int colorNumber, int index, java.nio.CharBuffer name){
        glBindFragDataLocationIndexed_native_GLuint_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, colorNumber, index, name);
    }
    
    @QtUninvokable
    private native void glBindFragDataLocationIndexed_native_GLuint_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int colorNumber, int index, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glBindFramebuffer(int target, int framebuffer){
        glBindFramebuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, framebuffer);
    }
    
    @QtUninvokable
    private native void glBindFramebuffer_native_GLenum_GLuint(long __this__nativeId, int target, int framebuffer);
    
    @QtUninvokable
    public final void glBindRenderbuffer(int target, int renderbuffer){
        glBindRenderbuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, renderbuffer);
    }
    
    @QtUninvokable
    private native void glBindRenderbuffer_native_GLenum_GLuint(long __this__nativeId, int target, int renderbuffer);
    
    @QtUninvokable
    public final void glBindSampler(int unit, int sampler){
        glBindSampler_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), unit, sampler);
    }
    
    @QtUninvokable
    private native void glBindSampler_native_GLuint_GLuint(long __this__nativeId, int unit, int sampler);
    
    @QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    @QtUninvokable
    public final void glBindTransformFeedback(int target, int id){
        glBindTransformFeedback_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @QtUninvokable
    private native void glBindTransformFeedback_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    @QtUninvokable
    public final void glBindVertexArray(int array){
        glBindVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native void glBindVertexArray_native_GLuint(long __this__nativeId, int array);
    
    @QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    @QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    @QtUninvokable
    public final void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha){
        glBlendEquationSeparatei_native_GLuint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, modeRGB, modeAlpha);
    }
    
    @QtUninvokable
    private native void glBlendEquationSeparatei_native_GLuint_GLenum_GLenum(long __this__nativeId, int buf, int modeRGB, int modeAlpha);
    
    @QtUninvokable
    public final void glBlendEquationi(int buf, int mode){
        glBlendEquationi_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, mode);
    }
    
    @QtUninvokable
    private native void glBlendEquationi_native_GLuint_GLenum(long __this__nativeId, int buf, int mode);
    
    @QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    @QtUninvokable
    public final void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);
    
    @QtUninvokable
    public final void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha){
        glBlendFuncSeparatei_native_GLuint_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }
    
    @QtUninvokable
    private native void glBlendFuncSeparatei_native_GLuint_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);
    
    @QtUninvokable
    public final void glBlendFunci(int buf, int src, int dst){
        glBlendFunci_native_GLuint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, src, dst);
    }
    
    @QtUninvokable
    private native void glBlendFunci_native_GLuint_GLenum_GLenum(long __this__nativeId, int buf, int src, int dst);
    
    @QtUninvokable
    public final void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter){
        glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    
    @QtUninvokable
    private native void glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(long __this__nativeId, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter);
    
    @QtUninvokable
    public final void glBufferData(int target, long size, java.nio.Buffer data, int usage){
        glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    @QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    @QtUninvokable
    public final int glCheckFramebufferStatus(int target){
        return glCheckFramebufferStatus_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native int glCheckFramebufferStatus_native_GLenum(long __this__nativeId, int target);
    
    @QtUninvokable
    public final void glClampColor(int target, int clamp){
        glClampColor_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, clamp);
    }
    
    @QtUninvokable
    private native void glClampColor_native_GLenum_GLenum(long __this__nativeId, int target, int clamp);
    
    @QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    @QtUninvokable
    public final void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil){
        glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, depth, stencil);
    }
    
    @QtUninvokable
    private native void glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(long __this__nativeId, int buffer, int drawbuffer, float depth, int stencil);
    
    @QtUninvokable
    public final void glClearBufferfv(int buffer, int drawbuffer, java.nio.FloatBuffer value){
        glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glClearBufferiv(int buffer, int drawbuffer, java.nio.IntBuffer value){
        glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glClearBufferuiv(int buffer, int drawbuffer, java.nio.IntBuffer value){
        glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @QtUninvokable
    private native void glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    @QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    @QtUninvokable
    public final int glClientWaitSync(io.qt.gui.gl.@Nullable GLsync sync, int flags, long timeout){
        return glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @QtUninvokable
    private native int glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    @QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    @QtUninvokable
    public final void glColorMaski(int index, boolean r, boolean g, boolean b, boolean a){
        glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), index, r, g, b, a);
    }
    
    @QtUninvokable
    private native void glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, int index, boolean r, boolean g, boolean b, boolean a);
    
    @QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    @QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data){
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    @QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    @QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data){
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    @QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data){
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    @QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    @QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data){
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    @QtUninvokable
    public final void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size){
        glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), readTarget, writeTarget, readOffset, writeOffset, size);
    }
    
    @QtUninvokable
    private native void glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(long __this__nativeId, int readTarget, int writeTarget, long readOffset, long writeOffset, long size);
    
    @QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    @QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    @QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    @QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    @QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    @QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    @QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    @QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    @QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.IntBuffer buffers){
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    @QtUninvokable
    public final void glDeleteFramebuffers(int n, java.nio.IntBuffer framebuffers){
        glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    @QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    @QtUninvokable
    public final void glDeleteQueries(int n, java.nio.IntBuffer ids){
        glDeleteQueries_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteQueries_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @QtUninvokable
    public final void glDeleteRenderbuffers(int n, java.nio.IntBuffer renderbuffers){
        glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    @QtUninvokable
    public final void glDeleteSamplers(int count, java.nio.IntBuffer samplers){
        glDeleteSamplers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), count, samplers);
    }
    
    @QtUninvokable
    private native void glDeleteSamplers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int count, java.nio.IntBuffer samplers);
    
    @QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    @QtUninvokable
    public final void glDeleteSync(io.qt.gui.gl.@Nullable GLsync sync){
        glDeleteSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @QtUninvokable
    private native void glDeleteSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    @QtUninvokable
    public final void glDeleteTextures(int n, java.nio.IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    @QtUninvokable
    public final void glDeleteTransformFeedbacks(int n, java.nio.IntBuffer ids){
        glDeleteTransformFeedbacks_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glDeleteTransformFeedbacks_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @QtUninvokable
    public final void glDeleteVertexArrays(int n, java.nio.IntBuffer arrays){
        glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    @QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    @QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    @QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    @QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    @QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    @QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    @QtUninvokable
    public final void glDisablei(int target, int index){
        glDisablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glDisablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    @QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    @QtUninvokable
    public final void glDrawArraysIndirect(int mode, java.nio.Buffer indirect){
        glDrawArraysIndirect_native_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, indirect);
    }
    
    @QtUninvokable
    private native void glDrawArraysIndirect_native_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, java.nio.Buffer indirect);
    
    @QtUninvokable
    public final void glDrawArraysInstanced(int mode, int first, int count, int instancecount){
        glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(long __this__nativeId, int mode, int first, int count, int instancecount);
    
    @QtUninvokable
    public final void glDrawBuffer(int mode){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int mode);
    
    @QtUninvokable
    public final void glDrawBuffers(int n, java.nio.IntBuffer bufs){
        glDrawBuffers_native_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, bufs);
    }
    
    @QtUninvokable
    private native void glDrawBuffers_native_GLsizei_const_GLenum_ptr(long __this__nativeId, int n, java.nio.IntBuffer bufs);
    
    @QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    @QtUninvokable
    public final void glDrawElementsBaseVertex(int mode, int count, int type, java.nio.Buffer indices, int basevertex){
        glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int basevertex);
    
    @QtUninvokable
    public final void glDrawElementsIndirect(int mode, int type, java.nio.Buffer indirect){
        glDrawElementsIndirect_native_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, type, indirect);
    }
    
    @QtUninvokable
    private native void glDrawElementsIndirect_native_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int type, java.nio.Buffer indirect);
    
    @QtUninvokable
    public final void glDrawElementsInstanced(int mode, int count, int type, java.nio.Buffer indices, int instancecount){
        glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount);
    
    @QtUninvokable
    public final void glDrawElementsInstancedBaseVertex(int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex){
        glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr_GLsizei_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex);
    
    @QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.Buffer indices){
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    @QtUninvokable
    public final void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, java.nio.Buffer indices, int basevertex){
        glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices, basevertex);
    }
    
    @QtUninvokable
    private native void glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr_GLint(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices, int basevertex);
    
    @QtUninvokable
    public final void glDrawTransformFeedback(int mode, int id){
        glDrawTransformFeedback_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedback_native_GLenum_GLuint(long __this__nativeId, int mode, int id);
    
    @QtUninvokable
    public final void glDrawTransformFeedbackStream(int mode, int id, int stream){
        glDrawTransformFeedbackStream_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, stream);
    }
    
    @QtUninvokable
    private native void glDrawTransformFeedbackStream_native_GLenum_GLuint_GLuint(long __this__nativeId, int mode, int id, int stream);
    
    @QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    @QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    @QtUninvokable
    public final void glEnablei(int target, int index){
        glEnablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glEnablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    @QtUninvokable
    public final void glEndConditionalRender(){
        glEndConditionalRender_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndConditionalRender_native(long __this__nativeId);
    
    @QtUninvokable
    public final void glEndQuery(int target){
        glEndQuery_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glEndQuery_native_GLenum(long __this__nativeId, int target);
    
    @QtUninvokable
    public final void glEndQueryIndexed(int target, int index){
        glEndQueryIndexed_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native void glEndQueryIndexed_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    @QtUninvokable
    public final void glEndTransformFeedback(){
        glEndTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glEndTransformFeedback_native(long __this__nativeId);
    
    @QtUninvokable
    public final io.qt.gui.gl.@Nullable GLsync glFenceSync(int condition, int flags){
        return glFenceSync_native_GLenum_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), condition, flags);
    }
    
    @QtUninvokable
    private native io.qt.gui.gl.GLsync glFenceSync_native_GLenum_GLbitfield(long __this__nativeId, int condition, int flags);
    
    @QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    @QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    @QtUninvokable
    public final void glFlushMappedBufferRange(int target, long offset, long length){
        glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, length);
    }
    
    @QtUninvokable
    private native void glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(long __this__nativeId, int target, long offset, long length);
    
    @QtUninvokable
    public final void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer){
        glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, renderbuffertarget, renderbuffer);
    }
    
    @QtUninvokable
    private native void glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(long __this__nativeId, int target, int attachment, int renderbuffertarget, int renderbuffer);
    
    @QtUninvokable
    public final void glFramebufferTexture(int target, int attachment, int texture, int level){
        glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int texture, int level);
    
    @QtUninvokable
    public final void glFramebufferTexture1D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    @QtUninvokable
    public final void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    @QtUninvokable
    public final void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset){
        glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level, zoffset);
    }
    
    @QtUninvokable
    private native void glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level, int zoffset);
    
    @QtUninvokable
    public final void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer){
        glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level, layer);
    }
    
    @QtUninvokable
    private native void glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int texture, int level, int layer);
    
    @QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    @QtUninvokable
    public final void glGenBuffers(int n, java.nio.IntBuffer buffers){
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    @QtUninvokable
    public final void glGenFramebuffers(int n, java.nio.IntBuffer framebuffers){
        glGenFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @QtUninvokable
    private native void glGenFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    @QtUninvokable
    public final void glGenQueries(int n, java.nio.IntBuffer ids){
        glGenQueries_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenQueries_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @QtUninvokable
    public final void glGenRenderbuffers(int n, java.nio.IntBuffer renderbuffers){
        glGenRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @QtUninvokable
    private native void glGenRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    @QtUninvokable
    public final void glGenSamplers(int count, java.nio.IntBuffer samplers){
        glGenSamplers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), count, samplers);
    }
    
    @QtUninvokable
    private native void glGenSamplers_native_GLsizei_GLuint_ptr(long __this__nativeId, int count, java.nio.IntBuffer samplers);
    
    @QtUninvokable
    public final void glGenTextures(int n, java.nio.IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    @QtUninvokable
    public final void glGenTransformFeedbacks(int n, java.nio.IntBuffer ids){
        glGenTransformFeedbacks_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @QtUninvokable
    private native void glGenTransformFeedbacks_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @QtUninvokable
    public final void glGenVertexArrays(int n, java.nio.IntBuffer arrays){
        glGenVertexArrays_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @QtUninvokable
    private native void glGenVertexArrays_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    @QtUninvokable
    public final void glGenerateMipmap(int target){
        glGenerateMipmap_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void glGenerateMipmap_native_GLenum(long __this__nativeId, int target);
    
    @QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name){
        glGetActiveSubroutineName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, bufsize, length, name);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name){
        glGetActiveSubroutineUniformName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, bufsize, length, name);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineUniformName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, java.nio.IntBuffer values){
        glGetActiveSubroutineUniformiv_native_GLuint_GLenum_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, pname, values);
    }
    
    @QtUninvokable
    private native void glGetActiveSubroutineUniformiv_native_GLuint_GLenum_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int shadertype, int index, int pname, java.nio.IntBuffer values);
    
    @QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName){
        glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName);
    
    @QtUninvokable
    public final void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params){
        glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetActiveUniformName(int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName){
        glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformIndex, bufSize, length, uniformName);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName);
    
    @QtUninvokable
    public final void glGetActiveUniformsiv(int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params){
        glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformCount, uniformIndices, pname, params);
    }
    
    @QtUninvokable
    private native void glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetAttachedShaders(int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj){
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxCount, count, obj);
    }
    
    @QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj);
    
    @QtUninvokable
    public final int glGetAttribLocation(int program, java.nio.CharBuffer name){
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glGetBooleani_v(int target, int index, java.nio.IntBuffer data){
        glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    @QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] params);
    
    @QtUninvokable
    public final void glGetBufferParameteri64v(int target, int pname, java.nio.LongBuffer params){
        glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(long __this__nativeId, int target, int pname, java.nio.LongBuffer params);
    
    @QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetBufferPointerv(int target, int pname, java.nio.Buffer[] params){
        glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int target, int pname, java.nio.Buffer[] params);
    
    @QtUninvokable
    public final void glGetBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @QtUninvokable
    private native void glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    @QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.Buffer img){
        glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    @QtUninvokable
    public final void glGetDoublev(int pname, double[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] params);
    
    @QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    @QtUninvokable
    public final void glGetFloatv(int pname, float[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    @QtUninvokable
    public final int glGetFragDataIndex(int program, java.nio.CharBuffer name){
        return glGetFragDataIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetFragDataIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final int glGetFragDataLocation(int program, java.nio.CharBuffer name){
        return glGetFragDataLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetFragDataLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, java.nio.IntBuffer params){
        glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, pname, params);
    }
    
    @QtUninvokable
    private native void glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int attachment, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetInteger64i_v(int target, int index, java.nio.LongBuffer data){
        glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(long __this__nativeId, int target, int index, java.nio.LongBuffer data);
    
    @QtUninvokable
    public final void glGetInteger64v(int pname, java.nio.LongBuffer params){
        glGetInteger64v_native_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetInteger64v_native_GLenum_GLint64_ptr(long __this__nativeId, int pname, java.nio.LongBuffer params);
    
    @QtUninvokable
    public final void glGetIntegeri_v(int target, int index, java.nio.IntBuffer data){
        glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @QtUninvokable
    private native void glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    @QtUninvokable
    public final void glGetIntegerv(int pname, int[] params){
        if(params!=null && params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    @QtUninvokable
    public final void glGetMultisamplefv(int pname, int index, java.nio.FloatBuffer val){
        glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, index, val);
    }
    
    @QtUninvokable
    private native void glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(long __this__nativeId, int pname, int index, java.nio.FloatBuffer val);
    
    @QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog){
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    @QtUninvokable
    public final void glGetProgramStageiv(int program, int shadertype, int pname, java.nio.IntBuffer values){
        glGetProgramStageiv_native_GLuint_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, pname, values);
    }
    
    @QtUninvokable
    private native void glGetProgramStageiv_native_GLuint_GLenum_GLenum_GLint_ptr(long __this__nativeId, int program, int shadertype, int pname, java.nio.IntBuffer values);
    
    @QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.IntBuffer params){
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetQueryIndexediv(int target, int index, int pname, java.nio.IntBuffer params){
        glGetQueryIndexediv_native_GLenum_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryIndexediv_native_GLenum_GLuint_GLenum_GLint_ptr(long __this__nativeId, int target, int index, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetQueryObjecti64v(int id, int pname, java.nio.LongBuffer params){
        glGetQueryObjecti64v_native_GLuint_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjecti64v_native_GLuint_GLenum_GLint64_ptr(long __this__nativeId, int id, int pname, java.nio.LongBuffer params);
    
    @QtUninvokable
    public final void glGetQueryObjectiv(int id, int pname, java.nio.IntBuffer params){
        glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetQueryObjectui64v(int id, int pname, java.nio.LongBuffer params){
        glGetQueryObjectui64v_native_GLuint_GLenum_GLuint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectui64v_native_GLuint_GLenum_GLuint64_ptr(long __this__nativeId, int id, int pname, java.nio.LongBuffer params);
    
    @QtUninvokable
    public final void glGetQueryObjectuiv(int id, int pname, java.nio.IntBuffer params){
        glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetQueryiv(int target, int pname, java.nio.IntBuffer params){
        glGetQueryiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetQueryiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetRenderbufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetSamplerParameterIiv(int sampler, int pname, java.nio.IntBuffer params){
        glGetSamplerParameterIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetSamplerParameterIuiv(int sampler, int pname, java.nio.IntBuffer params){
        glGetSamplerParameterIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetSamplerParameterfv(int sampler, int pname, java.nio.FloatBuffer params){
        glGetSamplerParameterfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameterfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int sampler, int pname, java.nio.FloatBuffer params);
    
    @QtUninvokable
    public final void glGetSamplerParameteriv(int sampler, int pname, java.nio.IntBuffer params){
        glGetSamplerParameteriv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @QtUninvokable
    private native void glGetSamplerParameteriv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog){
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, infoLog);
    }
    
    @QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    @QtUninvokable
    public final void glGetShaderSource(int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source){
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, source);
    }
    
    @QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    @QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.IntBuffer params){
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final java.lang.String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native java.lang.String glGetString_native_GLenum(long __this__nativeId, int name);
    
    @QtUninvokable
    public final java.lang.String glGetStringi(int name, int index){
        return glGetStringi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name, index);
    }
    
    @QtUninvokable
    private native java.lang.String glGetStringi_native_GLenum_GLuint(long __this__nativeId, int name, int index);
    
    @QtUninvokable
    public final int glGetSubroutineIndex(int program, int shadertype, java.nio.CharBuffer name){
        return glGetSubroutineIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, name);
    }
    
    @QtUninvokable
    private native int glGetSubroutineIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int shadertype, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final int glGetSubroutineUniformLocation(int program, int shadertype, java.nio.CharBuffer name){
        return glGetSubroutineUniformLocation_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, name);
    }
    
    @QtUninvokable
    private native int glGetSubroutineUniformLocation_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int shadertype, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glGetSynciv(io.qt.gui.gl.@Nullable GLsync sync, int pname, int[] length, java.nio.IntBuffer values){
        if(length!=null && length.length < 1)
            throw new IllegalArgumentException("Argument 'length': Wrong number of elements in array. Found: " + length.length + ", expected: 1");
        glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), pname, length, values);
    }
    
    @QtUninvokable
    private native void glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(long __this__nativeId, long sync, int pname, int[] length, java.nio.IntBuffer values);
    
    @QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.Buffer pixels){
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    @QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.FloatBuffer params){
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    @QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.IntBuffer params){
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetTexParameterIiv(int target, int pname, java.nio.IntBuffer params){
        glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetTexParameterIuiv(int target, int pname, java.nio.IntBuffer params){
        glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetTransformFeedbackVarying(int program, int index, int[] size, int[] type, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        if(size!=null && size.length < 1)
            throw new IllegalArgumentException("Argument 'size': Wrong number of elements in array. Found: " + size.length + ", expected: 1");
        if(type!=null && type.length < 1)
            throw new IllegalArgumentException("Argument 'type': Wrong number of elements in array. Found: " + type.length + ", expected: 1");
        glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, size, type, name);
    }
    
    @QtUninvokable
    private native void glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int[] size, int[] type, java.lang.String[] name);
    
    @QtUninvokable
    public final int glGetUniformBlockIndex(int program, java.nio.CharBuffer uniformBlockName){
        return glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockName);
    }
    
    @QtUninvokable
    private native int glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer uniformBlockName);
    
    @QtUninvokable
    public final void glGetUniformIndices(int program, java.lang.String[] uniformNames, int[] uniformIndices){
        glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformNames, uniformIndices);
    }
    
    @QtUninvokable
    private native void glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(long __this__nativeId, int program, java.lang.String[] uniformNames, int[] uniformIndices);
    
    @QtUninvokable
    public final int glGetUniformLocation(int program, java.nio.CharBuffer name){
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @QtUninvokable
    public final void glGetUniformSubroutineuiv(int shadertype, int location, java.nio.IntBuffer params){
        glGetUniformSubroutineuiv_native_GLenum_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformSubroutineuiv_native_GLenum_GLint_GLuint_ptr(long __this__nativeId, int shadertype, int location, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetUniformdv(int program, int location, java.nio.DoubleBuffer params){
        glGetUniformdv_native_GLuint_GLint_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformdv_native_GLuint_GLint_GLdouble_ptr(long __this__nativeId, int program, int location, java.nio.DoubleBuffer params);
    
    @QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.FloatBuffer params){
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    @QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.IntBuffer params){
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetUniformuiv(int program, int location, java.nio.IntBuffer params){
        glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @QtUninvokable
    private native void glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetVertexAttribIiv(int index, int pname, java.nio.IntBuffer params){
        glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetVertexAttribIuiv(int index, int pname, java.nio.IntBuffer params){
        glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    @QtUninvokable
    public final void glGetVertexAttribdv(int index, int pname, java.nio.DoubleBuffer params){
        glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    @QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.FloatBuffer params){
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    @QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.IntBuffer params){
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    @QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    @QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    @QtUninvokable
    public final boolean glIsEnabledi(int target, int index){
        return glIsEnabledi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @QtUninvokable
    private native boolean glIsEnabledi_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    @QtUninvokable
    public final boolean glIsFramebuffer(int framebuffer){
        return glIsFramebuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer);
    }
    
    @QtUninvokable
    private native boolean glIsFramebuffer_native_GLuint(long __this__nativeId, int framebuffer);
    
    @QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    @QtUninvokable
    public final boolean glIsQuery(int id){
        return glIsQuery_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsQuery_native_GLuint(long __this__nativeId, int id);
    
    @QtUninvokable
    public final boolean glIsRenderbuffer(int renderbuffer){
        return glIsRenderbuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer);
    }
    
    @QtUninvokable
    private native boolean glIsRenderbuffer_native_GLuint(long __this__nativeId, int renderbuffer);
    
    @QtUninvokable
    public final boolean glIsSampler(int sampler){
        return glIsSampler_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), sampler);
    }
    
    @QtUninvokable
    private native boolean glIsSampler_native_GLuint(long __this__nativeId, int sampler);
    
    @QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    @QtUninvokable
    public final boolean glIsSync(io.qt.gui.gl.@Nullable GLsync sync){
        return glIsSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @QtUninvokable
    private native boolean glIsSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    @QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    @QtUninvokable
    public final boolean glIsTransformFeedback(int id){
        return glIsTransformFeedback_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @QtUninvokable
    private native boolean glIsTransformFeedback_native_GLuint(long __this__nativeId, int id);
    
    @QtUninvokable
    public final boolean glIsVertexArray(int array){
        return glIsVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @QtUninvokable
    private native boolean glIsVertexArray_native_GLuint(long __this__nativeId, int array);
    
    @QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    @QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    @QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    @QtUninvokable
    public final java.nio.@Nullable Buffer glMapBuffer(int target, int access){
        return glMapBuffer_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, access);
    }
    
    @QtUninvokable
    private native java.nio.@Nullable Buffer glMapBuffer_native_GLenum_GLenum(long __this__nativeId, int target, int access);
    
    @QtUninvokable
    public final java.nio.Buffer glMapBufferRange(int target, long offset, int access){
        return glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, access);
    }
    
    @QtUninvokable
    private native java.nio.Buffer glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(long __this__nativeId, int target, long offset, int access);
    
    @QtUninvokable
    public final void glMinSampleShading(float value){
        glMinSampleShading_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @QtUninvokable
    private native void glMinSampleShading_native_GLfloat(long __this__nativeId, float value);
    
    @QtUninvokable
    public final void glMultiDrawArrays(int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount){
        glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount);
    
    @QtUninvokable
    public final void glMultiDrawElements(int mode, java.nio.IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount);
    }
    
    @QtUninvokable
    private native void glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount);
    
    @QtUninvokable
    public final void glMultiDrawElementsBaseVertex(int mode, java.nio.IntBuffer count, int type, java.nio.Buffer @StrictNonNull[] indices, int drawcount, java.nio.IntBuffer basevertex){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount, basevertex);
    }
    
    @QtUninvokable
    private native void glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei_const_GLint_ptr(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount, java.nio.IntBuffer basevertex);
    
    @QtUninvokable
    public final void glPatchParameterfv(int pname, java.nio.FloatBuffer values){
        glPatchParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, values);
    }
    
    @QtUninvokable
    private native void glPatchParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer values);
    
    @QtUninvokable
    public final void glPatchParameteri(int pname, int value){
        glPatchParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, value);
    }
    
    @QtUninvokable
    private native void glPatchParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int value);
    
    @QtUninvokable
    public final void glPauseTransformFeedback(){
        glPauseTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glPauseTransformFeedback_native(long __this__nativeId);
    
    @QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @QtUninvokable
    public final void glPointParameterf(int pname, float param){
        glPointParameterf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameterf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @QtUninvokable
    public final void glPointParameterfv(int pname, java.nio.FloatBuffer params){
        glPointParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    @QtUninvokable
    public final void glPointParameteri(int pname, int param){
        glPointParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @QtUninvokable
    private native void glPointParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @QtUninvokable
    public final void glPointParameteriv(int pname, java.nio.IntBuffer params){
        glPointParameteriv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @QtUninvokable
    private native void glPointParameteriv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    @QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    @QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    @QtUninvokable
    public final void glPrimitiveRestartIndex(int index){
        glPrimitiveRestartIndex_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native void glPrimitiveRestartIndex_native_GLuint(long __this__nativeId, int index);
    
    @QtUninvokable
    public final void glProvokingVertex(int mode){
        glProvokingVertex_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glProvokingVertex_native_GLenum(long __this__nativeId, int mode);
    
    @QtUninvokable
    public final void glQueryCounter(int id, int target){
        glQueryCounter_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, target);
    }
    
    @QtUninvokable
    private native void glQueryCounter_native_GLuint_GLenum(long __this__nativeId, int id, int target);
    
    @QtUninvokable
    public final void glReadBuffer(int mode){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int mode);
    
    @QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @QtUninvokable
    public final void glRenderbufferStorage(int target, int internalformat, int width, int height){
        glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int width, int height);
    
    @QtUninvokable
    public final void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height){
        glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height);
    }
    
    @QtUninvokable
    private native void glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int samples, int internalformat, int width, int height);
    
    @QtUninvokable
    public final void glResumeTransformFeedback(){
        glResumeTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void glResumeTransformFeedback_native(long __this__nativeId);
    
    @QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    @QtUninvokable
    public final void glSampleMaski(int index, int mask){
        glSampleMaski_native_GLuint_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), index, mask);
    }
    
    @QtUninvokable
    private native void glSampleMaski_native_GLuint_GLbitfield(long __this__nativeId, int index, int mask);
    
    @QtUninvokable
    public final void glSamplerParameterIiv(int sampler, int pname, java.nio.IntBuffer param){
        glSamplerParameterIiv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterIiv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    @QtUninvokable
    public final void glSamplerParameterIuiv(int sampler, int pname, java.nio.IntBuffer param){
        glSamplerParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    @QtUninvokable
    public final void glSamplerParameterf(int sampler, int pname, float param){
        glSamplerParameterf_native_GLuint_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterf_native_GLuint_GLenum_GLfloat(long __this__nativeId, int sampler, int pname, float param);
    
    @QtUninvokable
    public final void glSamplerParameterfv(int sampler, int pname, java.nio.FloatBuffer param){
        glSamplerParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(long __this__nativeId, int sampler, int pname, java.nio.FloatBuffer param);
    
    @QtUninvokable
    public final void glSamplerParameteri(int sampler, int pname, int param){
        glSamplerParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int sampler, int pname, int param);
    
    @QtUninvokable
    public final void glSamplerParameteriv(int sampler, int pname, java.nio.IntBuffer param){
        glSamplerParameteriv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @QtUninvokable
    private native void glSamplerParameteriv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    @QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    @QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string, java.nio.IntBuffer length){
        glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string, length);
    }
    
    @QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string, java.nio.IntBuffer length);
    
    @QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    @QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    @QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    @QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    @QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    @QtUninvokable
    public final void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, sfail, dpfail, dppass);
    }
    
    @QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int sfail, int dpfail, int dppass);
    
    @QtUninvokable
    public final void glTexBuffer(int target, int internalformat, int buffer){
        glTexBuffer_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer);
    }
    
    @QtUninvokable
    private native void glTexBuffer_native_GLenum_GLenum_GLuint(long __this__nativeId, int target, int internalformat, int buffer);
    
    @QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels){
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    @QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    @QtUninvokable
    public final void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTexImage2DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexImage2DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    @QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels){
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    @QtUninvokable
    public final void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTexImage3DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @QtUninvokable
    private native void glTexImage3DMultisample_native_GLenum_GLsizei_GLint_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    @QtUninvokable
    public final void glTexParameterIiv(int target, int pname, java.nio.IntBuffer params){
        glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glTexParameterIuiv(int target, int pname, java.nio.IntBuffer params){
        glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    @QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    @QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels){
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    @QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels){
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    @QtUninvokable
    public final void glTransformFeedbackVaryings(int program, java.lang.String[] varyings, int bufferMode){
        glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), program, varyings, bufferMode);
    }
    
    @QtUninvokable
    private native void glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(long __this__nativeId, int program, java.lang.String[] varyings, int bufferMode);
    
    @QtUninvokable
    public final void glUniform1d(int location, double x){
        glUniform1d_native_GLint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x);
    }
    
    @QtUninvokable
    private native void glUniform1d_native_GLint_GLdouble(long __this__nativeId, int location, double x);
    
    @QtUninvokable
    public final void glUniform1dv(int location, int count, java.nio.DoubleBuffer value){
        glUniform1dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniform1f(int location, float v0){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float v0);
    
    @QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.FloatBuffer value){
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniform1i(int location, int v0){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int v0);
    
    @QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.IntBuffer value){
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glUniform1ui(int location, int v0){
        glUniform1ui_native_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @QtUninvokable
    private native void glUniform1ui_native_GLint_GLuint(long __this__nativeId, int location, int v0);
    
    @QtUninvokable
    public final void glUniform1uiv(int location, int count, java.nio.IntBuffer value){
        glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glUniform2d(int location, double x, double y){
        glUniform2d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @QtUninvokable
    private native void glUniform2d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y);
    
    @QtUninvokable
    public final void glUniform2dv(int location, int count, java.nio.DoubleBuffer value){
        glUniform2dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniform2f(int location, float v0, float v1){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1);
    
    @QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.FloatBuffer value){
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniform2i(int location, int v0, int v1){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1);
    
    @QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.IntBuffer value){
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glUniform2ui(int location, int v0, int v1){
        glUniform2ui_native_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @QtUninvokable
    private native void glUniform2ui_native_GLint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1);
    
    @QtUninvokable
    public final void glUniform2uiv(int location, int count, java.nio.IntBuffer value){
        glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glUniform3d(int location, double x, double y, double z){
        glUniform3d_native_GLint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @QtUninvokable
    private native void glUniform3d_native_GLint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y, double z);
    
    @QtUninvokable
    public final void glUniform3dv(int location, int count, java.nio.DoubleBuffer value){
        glUniform3dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniform3f(int location, float v0, float v1, float v2){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2);
    
    @QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.FloatBuffer value){
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniform3i(int location, int v0, int v1, int v2){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    @QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.IntBuffer value){
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glUniform3ui(int location, int v0, int v1, int v2){
        glUniform3ui_native_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @QtUninvokable
    private native void glUniform3ui_native_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    @QtUninvokable
    public final void glUniform3uiv(int location, int count, java.nio.IntBuffer value){
        glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glUniform4d(int location, double x, double y, double z, double w){
        glUniform4d_native_GLint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @QtUninvokable
    private native void glUniform4d_native_GLint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y, double z, double w);
    
    @QtUninvokable
    public final void glUniform4dv(int location, int count, java.nio.DoubleBuffer value){
        glUniform4dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniform4f(int location, float v0, float v1, float v2, float v3){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2, float v3);
    
    @QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.FloatBuffer value){
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniform4i(int location, int v0, int v1, int v2, int v3){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    @QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.IntBuffer value){
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glUniform4ui(int location, int v0, int v1, int v2, int v3){
        glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @QtUninvokable
    private native void glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    @QtUninvokable
    public final void glUniform4uiv(int location, int count, java.nio.IntBuffer value){
        glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @QtUninvokable
    private native void glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding){
        glUniformBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, uniformBlockBinding);
    }
    
    @QtUninvokable
    private native void glUniformBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int uniformBlockIndex, int uniformBlockBinding);
    
    @QtUninvokable
    public final void glUniformMatrix2dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix2x3dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix2x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix2x3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix2x4dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix2x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix2x4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix3dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix3x2dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix3x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix3x2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix3x4dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix3x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix3x4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix4dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix4x2dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix4x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix4x2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix4x3dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        glUniformMatrix4x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @QtUninvokable
    public final void glUniformMatrix4x3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @QtUninvokable
    private native void glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @QtUninvokable
    public final void glUniformSubroutinesuiv(int shadertype, int count, java.nio.IntBuffer indices){
        glUniformSubroutinesuiv_native_GLenum_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, count, indices);
    }
    
    @QtUninvokable
    private native void glUniformSubroutinesuiv_native_GLenum_GLsizei_const_GLuint_ptr(long __this__nativeId, int shadertype, int count, java.nio.IntBuffer indices);
    
    @QtUninvokable
    public final boolean glUnmapBuffer(int target){
        return glUnmapBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native boolean glUnmapBuffer_native_GLenum(long __this__nativeId, int target);
    
    @QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    @QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    @QtUninvokable
    public final void glVertexAttribDivisor(int index, int divisor){
        glVertexAttribDivisor_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, divisor);
    }
    
    @QtUninvokable
    private native void glVertexAttribDivisor_native_GLuint_GLuint(long __this__nativeId, int index, int divisor);
    
    @QtUninvokable
    public final void glVertexAttribIPointer(int index, int size, int type, int stride, java.nio.Buffer pointer){
        glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    @QtUninvokable
    public final void glVertexAttribP1ui(int index, int type, boolean normalized, int value){
        glVertexAttribP1ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP1ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    @QtUninvokable
    public final void glVertexAttribP1uiv(int index, int type, boolean normalized, java.nio.IntBuffer value){
        glVertexAttribP1uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP1uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glVertexAttribP2ui(int index, int type, boolean normalized, int value){
        glVertexAttribP2ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP2ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    @QtUninvokable
    public final void glVertexAttribP2uiv(int index, int type, boolean normalized, java.nio.IntBuffer value){
        glVertexAttribP2uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP2uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glVertexAttribP3ui(int index, int type, boolean normalized, int value){
        glVertexAttribP3ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP3ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    @QtUninvokable
    public final void glVertexAttribP3uiv(int index, int type, boolean normalized, java.nio.IntBuffer value){
        glVertexAttribP3uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP3uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glVertexAttribP4ui(int index, int type, boolean normalized, int value){
        glVertexAttribP4ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP4ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    @QtUninvokable
    public final void glVertexAttribP4uiv(int index, int type, boolean normalized, java.nio.IntBuffer value){
        glVertexAttribP4uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @QtUninvokable
    private native void glVertexAttribP4uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    @QtUninvokable
    public final void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer){
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, normalized, stride, pointer);
    }
    
    @QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer);
    
    @QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    @QtUninvokable
    public final void glWaitSync(io.qt.gui.gl.@Nullable GLsync sync, int flags, long timeout){
        glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @QtUninvokable
    private native void glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    @QtUninvokable
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOpenGLFunctions_4_0_Core(QPrivateConstructor p) { super(p); } 
    
}
