package io.qt.opengl;

import io.qt.*;


/**
 * <p>Convenience subclass of QWindow to perform OpenGL painting</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglwindow.html">QOpenGLWindow</a></p>
 */
public class QOpenGLWindow extends io.qt.gui.QPaintDeviceWindow
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLWindow.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopenglwindow.html#UpdateBehavior-enum">QOpenGLWindow::UpdateBehavior</a></p>
     */
    @QtUnlistedEnum
    public enum UpdateBehavior implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopenglwindow.html#UpdateBehavior-enum">QOpenGLWindow::NoPartialUpdate</a></p>
         */
        NoPartialUpdate(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopenglwindow.html#UpdateBehavior-enum">QOpenGLWindow::PartialUpdateBlit</a></p>
         */
        PartialUpdateBlit(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopenglwindow.html#UpdateBehavior-enum">QOpenGLWindow::PartialUpdateBlend</a></p>
         */
        PartialUpdateBlend(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UpdateBehavior(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull UpdateBehavior resolve(int value) {
            switch (value) {
            case 0: return NoPartialUpdate;
            case 1: return PartialUpdateBlit;
            case 2: return PartialUpdateBlend;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#frameSwapped">QOpenGLWindow::frameSwapped()</a></p>
     */
    public final @NonNull Signal0 frameSwapped = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWindow(io.qt.gui.QOpenGLContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLWindow(io.qt.gui.@Nullable QOpenGLContext shareContext, io.qt.opengl.QOpenGLWindow.@NonNull UpdateBehavior updateBehavior) {
        this(shareContext, updateBehavior, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWindow(io.qt.gui.QOpenGLContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>updateBehavior = io.qt.opengl.QOpenGLWindow.UpdateBehavior.NoPartialUpdate</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QOpenGLWindow(io.qt.gui.@Nullable QOpenGLContext shareContext) {
        this(shareContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior.NoPartialUpdate, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#QOpenGLWindow-1">QOpenGLWindow::QOpenGLWindow(QOpenGLContext*,QOpenGLWindow::UpdateBehavior,QWindow*)</a></p>
     */
    public QOpenGLWindow(io.qt.gui.@Nullable QOpenGLContext shareContext, io.qt.opengl.QOpenGLWindow.@NonNull UpdateBehavior updateBehavior, io.qt.gui.@Nullable QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, shareContext, updateBehavior, parent);
    }
    
    private native static void initialize_native(QOpenGLWindow instance, io.qt.gui.QOpenGLContext shareContext, io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior, io.qt.gui.QWindow parent);
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWindow(io.qt.opengl.QOpenGLWindow.UpdateBehavior, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLWindow(io.qt.opengl.QOpenGLWindow.@NonNull UpdateBehavior updateBehavior) {
        this(updateBehavior, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLWindow(io.qt.opengl.QOpenGLWindow.UpdateBehavior, io.qt.gui.QWindow)}</p>
     * <p>with: </p><ul>
     * <li><code>updateBehavior = io.qt.opengl.QOpenGLWindow.UpdateBehavior.NoPartialUpdate</code></li>
     * <li><code>parent = null</code></li>
     * </ul>
     */
    public QOpenGLWindow() {
        this(io.qt.opengl.QOpenGLWindow.UpdateBehavior.NoPartialUpdate, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#QOpenGLWindow">QOpenGLWindow::QOpenGLWindow(QOpenGLWindow::UpdateBehavior,QWindow*)</a></p>
     */
    public QOpenGLWindow(io.qt.opengl.QOpenGLWindow.@NonNull UpdateBehavior updateBehavior, io.qt.gui.@Nullable QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, updateBehavior, parent);
    }
    
    private native static void initialize_native(QOpenGLWindow instance, io.qt.opengl.QOpenGLWindow.UpdateBehavior updateBehavior, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#context">QOpenGLWindow::context()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@Nullable QOpenGLContext context(){
        return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QOpenGLContext context_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#defaultFramebufferObject">QOpenGLWindow::defaultFramebufferObject()const</a></p>
     */
    @QtUninvokable
    public final int defaultFramebufferObject(){
        return defaultFramebufferObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int defaultFramebufferObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#doneCurrent">QOpenGLWindow::doneCurrent()</a></p>
     */
    @QtUninvokable
    public final void doneCurrent(){
        doneCurrent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void doneCurrent_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#grabFramebuffer">QOpenGLWindow::grabFramebuffer()</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage grabFramebuffer(){
        return grabFramebuffer_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage grabFramebuffer_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#isValid">QOpenGLWindow::isValid()const</a></p>
     */
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#makeCurrent">QOpenGLWindow::makeCurrent()</a></p>
     */
    @QtUninvokable
    public final void makeCurrent(){
        makeCurrent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void makeCurrent_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#shareContext">QOpenGLWindow::shareContext()const</a></p>
     */
    @QtUninvokable
    public final io.qt.gui.@Nullable QOpenGLContext shareContext(){
        return shareContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QOpenGLContext shareContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#updateBehavior">QOpenGLWindow::updateBehavior()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLWindow.@NonNull UpdateBehavior updateBehavior(){
        return io.qt.opengl.QOpenGLWindow.UpdateBehavior.resolve(updateBehavior_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int updateBehavior_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#initializeGL">QOpenGLWindow::initializeGL()</a></p>
     */
    @QtUninvokable
    protected void initializeGL(){
        initializeGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void initializeGL_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#metric">QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const</a></p>
     */
    @QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.@NonNull PaintDeviceMetric metric){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metric.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int metric);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#paintEvent">QWindow::paintEvent(QPaintEvent*)</a></p>
     */
    @QtUninvokable
    protected void paintEvent(io.qt.gui.@Nullable QPaintEvent event){
        paintEvent_native_QPaintEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void paintEvent_native_QPaintEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#paintGL">QOpenGLWindow::paintGL()</a></p>
     */
    @QtUninvokable
    protected void paintGL(){
        paintGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void paintGL_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#paintOverGL">QOpenGLWindow::paintOverGL()</a></p>
     */
    @QtUninvokable
    protected void paintOverGL(){
        paintOverGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void paintOverGL_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#paintUnderGL">QOpenGLWindow::paintUnderGL()</a></p>
     */
    @QtUninvokable
    protected void paintUnderGL(){
        paintUnderGL_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void paintUnderGL_native(long __this__nativeId);
    
    @QtUninvokable
    protected io.qt.gui.@Nullable QPaintDevice redirected(io.qt.core.@Nullable QPoint arg__1){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwindow.html#resizeEvent">QWindow::resizeEvent(QResizeEvent*)</a></p>
     */
    @QtUninvokable
    protected void resizeEvent(io.qt.gui.@Nullable QResizeEvent event){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglwindow.html#resizeGL">QOpenGLWindow::resizeGL(int,int)</a></p>
     */
    @QtUninvokable
    protected void resizeGL(int w, int h){
        resizeGL_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), w, h);
    }
    
    @QtUninvokable
    private native void resizeGL_native_int_int(long __this__nativeId, int w, int h);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOpenGLWindow(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QOpenGLWindow(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QOpenGLWindow instance, QDeclarativeConstructor constructor);
    
}
