package io.qt.opengl;

import io.qt.*;


/**
 * <p>Provides access to OpenGL functions for a specified version and profile</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglversionfunctionsfactory.html">QOpenGLVersionFunctionsFactory</a></p>
 */
public class QOpenGLVersionFunctionsFactory extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    public QOpenGLVersionFunctionsFactory(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLVersionFunctionsFactory instance);
    
    /**
     * <p>Overloaded function for {@link #get(java.lang.Class, io.qt.gui.QOpenGLContext)}
     *  with <code>context = null</code>.</p>
     */
    public static <T extends io.qt.opengl.QAbstractOpenGLFunctions> T get(java.lang.Class<T> type) {
        return get(type, (io.qt.gui.QOpenGLContext)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionfunctionsfactory.html#get-1">QOpenGLVersionFunctionsFactory::get(QOpenGLContext*)</a></p>
     */
    public static <T extends io.qt.opengl.QAbstractOpenGLFunctions> T get(java.lang.Class<T> type, io.qt.gui.@Nullable QOpenGLContext context){
        return get_native_QOpenGLContext_ptr(type, QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    private native static <T extends io.qt.opengl.QAbstractOpenGLFunctions> T get_native_QOpenGLContext_ptr(java.lang.Class<T> type, long context);
    
    /**
     * <p>Overloaded function for {@link #get(io.qt.opengl.QOpenGLVersionProfile, io.qt.gui.QOpenGLContext)}
     *  with <code>context = null</code>.</p>
     */
    public static io.qt.opengl.@Nullable QAbstractOpenGLFunctions get(io.qt.opengl.@NonNull QOpenGLVersionProfile versionProfile) {
        return get(versionProfile, (io.qt.gui.QOpenGLContext)null);
    }
    
    /**
     * <p>Overloaded function for {@link #get(io.qt.opengl.QOpenGLVersionProfile, io.qt.gui.QOpenGLContext)}</p>
     * <p>with: </p><ul>
     * <li><code>versionProfile = new io.qt.opengl.QOpenGLVersionProfile()</code></li>
     * <li><code>context = null</code></li>
     * </ul>
     */
    public static io.qt.opengl.@Nullable QAbstractOpenGLFunctions get() {
        return get(new io.qt.opengl.QOpenGLVersionProfile(), (io.qt.gui.QOpenGLContext)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionfunctionsfactory.html#get">QOpenGLVersionFunctionsFactory::get(QOpenGLVersionProfile,QOpenGLContext*)</a></p>
     */
    public static io.qt.opengl.@Nullable QAbstractOpenGLFunctions get(io.qt.opengl.@NonNull QOpenGLVersionProfile versionProfile, io.qt.gui.@Nullable QOpenGLContext context){
        return get_native_cref_QOpenGLVersionProfile_QOpenGLContext_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(versionProfile), QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    private native static io.qt.opengl.QAbstractOpenGLFunctions get_native_cref_QOpenGLVersionProfile_QOpenGLContext_ptr(long versionProfile, long context);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOpenGLVersionFunctionsFactory(QPrivateConstructor p) { super(p); } 
    
}
