package io.qt.opengl;

import io.qt.*;


/**
 * <p>Wraps an OpenGL debug message</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopengldebugmessage.html">QOpenGLDebugMessage</a></p>
 */
public class QOpenGLDebugMessage extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::Severity</a></p>
     * 
     * @see Severities
     */
    @QtRejectedEntries({"LastSeverity"})
    public enum Severity implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::InvalidSeverity</a></p>
         */
        InvalidSeverity(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::HighSeverity</a></p>
         */
        HighSeverity(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::MediumSeverity</a></p>
         */
        MediumSeverity(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::LowSeverity</a></p>
         */
        LowSeverity(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::NotificationSeverity</a></p>
         */
        NotificationSeverity(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::LastSeverity</a></p>
         */
        LastSeverity(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::AnySeverity</a></p>
         */
        AnySeverity(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Severity(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull Severities asFlags() {
            return new Severities(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Severities combined(@NonNull Severity e) {
            return new Severities(this, e);
        }

        /**
         * Creates a new {@link Severities} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Severities flags(@Nullable Severity @NonNull... values) {
            return new Severities(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Severity resolve(int value) {
            switch (value) {
            case 0: return InvalidSeverity;
            case 1: return HighSeverity;
            case 2: return MediumSeverity;
            case 4: return LowSeverity;
            case 8: return NotificationSeverity;
            case -1: return AnySeverity;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Severity}
     */
    public static final class Severities extends QFlags<Severity> implements Comparable<Severities> {
        private static final long serialVersionUID = 0x771f7ddce3a2bab8L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Severities where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Severities(@Nullable Severity @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Severities with given <code>value</code>.
         * @param value
         */
        public Severities(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Severities
         */
        @Override
        public final @NonNull Severities combined(@StrictNonNull Severity e){
            return new Severities(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull Severities setFlag(@Nullable Severity e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull Severities setFlag(@Nullable Severity e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Severities.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Severity @NonNull[] flags(){
            return super.flags(Severity.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Severities clone(){
            return new Severities(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Severities other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::Source</a></p>
     * 
     * @see Sources
     */
    @QtRejectedEntries({"LastSource"})
    public enum Source implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::InvalidSource</a></p>
         */
        InvalidSource(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::APISource</a></p>
         */
        APISource(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::WindowSystemSource</a></p>
         */
        WindowSystemSource(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::ShaderCompilerSource</a></p>
         */
        ShaderCompilerSource(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::ThirdPartySource</a></p>
         */
        ThirdPartySource(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::ApplicationSource</a></p>
         */
        ApplicationSource(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::OtherSource</a></p>
         */
        OtherSource(32),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::LastSource</a></p>
         */
        LastSource(32),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::AnySource</a></p>
         */
        AnySource(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Source(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull Sources asFlags() {
            return new Sources(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Sources combined(@NonNull Source e) {
            return new Sources(this, e);
        }

        /**
         * Creates a new {@link Sources} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Sources flags(@Nullable Source @NonNull... values) {
            return new Sources(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Source resolve(int value) {
            switch (value) {
            case 0: return InvalidSource;
            case 1: return APISource;
            case 2: return WindowSystemSource;
            case 4: return ShaderCompilerSource;
            case 8: return ThirdPartySource;
            case 16: return ApplicationSource;
            case 32: return OtherSource;
            case -1: return AnySource;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Source}
     */
    public static final class Sources extends QFlags<Source> implements Comparable<Sources> {
        private static final long serialVersionUID = 0x7fe7c1666616fb32L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Sources where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Sources(@Nullable Source @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Sources with given <code>value</code>.
         * @param value
         */
        public Sources(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Sources
         */
        @Override
        public final @NonNull Sources combined(@StrictNonNull Source e){
            return new Sources(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull Sources setFlag(@Nullable Source e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull Sources setFlag(@Nullable Source e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Sources.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Source @NonNull[] flags(){
            return super.flags(Source.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Sources clone(){
            return new Sources(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Sources other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::Type</a></p>
     * 
     * @see Types
     */
    @QtRejectedEntries({"LastType"})
    public enum Type implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::InvalidType</a></p>
         */
        InvalidType(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::ErrorType</a></p>
         */
        ErrorType(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::DeprecatedBehaviorType</a></p>
         */
        DeprecatedBehaviorType(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::UndefinedBehaviorType</a></p>
         */
        UndefinedBehaviorType(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::PortabilityType</a></p>
         */
        PortabilityType(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::PerformanceType</a></p>
         */
        PerformanceType(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::OtherType</a></p>
         */
        OtherType(32),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::MarkerType</a></p>
         */
        MarkerType(64),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::GroupPushType</a></p>
         */
        GroupPushType(128),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::GroupPopType</a></p>
         */
        GroupPopType(256),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::LastType</a></p>
         */
        LastType(256),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::AnyType</a></p>
         */
        AnyType(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull Types asFlags() {
            return new Types(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Types combined(@NonNull Type e) {
            return new Types(this, e);
        }

        /**
         * Creates a new {@link Types} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Types flags(@Nullable Type @NonNull... values) {
            return new Types(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Type resolve(int value) {
            switch (value) {
            case 0: return InvalidType;
            case 1: return ErrorType;
            case 2: return DeprecatedBehaviorType;
            case 4: return UndefinedBehaviorType;
            case 8: return PortabilityType;
            case 16: return PerformanceType;
            case 32: return OtherType;
            case 64: return MarkerType;
            case 128: return GroupPushType;
            case 256: return GroupPopType;
            case -1: return AnyType;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Type}
     */
    public static final class Types extends QFlags<Type> implements Comparable<Types> {
        private static final long serialVersionUID = 0x74d0fb9231ed2833L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Types where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Types(@Nullable Type @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Types with given <code>value</code>.
         * @param value
         */
        public Types(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Types
         */
        @Override
        public final @NonNull Types combined(@StrictNonNull Type e){
            return new Types(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull Types setFlag(@Nullable Type e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull Types setFlag(@Nullable Type e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Types.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Type @NonNull[] flags(){
            return super.flags(Type.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Types clone(){
            return new Types(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Types other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#QOpenGLDebugMessage">QOpenGLDebugMessage::QOpenGLDebugMessage()</a></p>
     */
    public QOpenGLDebugMessage(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLDebugMessage instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#QOpenGLDebugMessage-1">QOpenGLDebugMessage::QOpenGLDebugMessage(QOpenGLDebugMessage)</a></p>
     */
    public QOpenGLDebugMessage(io.qt.opengl.@NonNull QOpenGLDebugMessage debugMessage){
        super((QPrivateConstructor)null);
        initialize_native(this, debugMessage);
    }
    
    private native static void initialize_native(QOpenGLDebugMessage instance, io.qt.opengl.QOpenGLDebugMessage debugMessage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#id">QOpenGLDebugMessage::id()const</a></p>
     */
    @QtUninvokable
    public final int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#message">QOpenGLDebugMessage::message()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String message(){
        return message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String message_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#operator-eq">QOpenGLDebugMessage::operator=(QOpenGLDebugMessage)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.opengl.@NonNull QOpenGLDebugMessage debugMessage){
        assign_native_cref_QOpenGLDebugMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(debugMessage));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QOpenGLDebugMessage(long __this__nativeId, long debugMessage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#operator-eq-eq">QOpenGLDebugMessage::operator==(QOpenGLDebugMessage)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.opengl.@NonNull QOpenGLDebugMessage debugMessage){
        return operator_equal_native_cref_QOpenGLDebugMessage_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(debugMessage));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QOpenGLDebugMessage_constfct(long __this__nativeId, long debugMessage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#severity">QOpenGLDebugMessage::severity()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLDebugMessage.@NonNull Severity severity(){
        return io.qt.opengl.QOpenGLDebugMessage.Severity.resolve(severity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int severity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#source">QOpenGLDebugMessage::source()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLDebugMessage.@NonNull Source source(){
        return io.qt.opengl.QOpenGLDebugMessage.Source.resolve(source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#swap">QOpenGLDebugMessage::swap(QOpenGLDebugMessage&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.opengl.@StrictNonNull QOpenGLDebugMessage other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QOpenGLDebugMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QOpenGLDebugMessage(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#type">QOpenGLDebugMessage::type()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLDebugMessage.@NonNull Type type(){
        return io.qt.opengl.QOpenGLDebugMessage.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #createApplicationMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}
     *  with <code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code>.</p>
     */
    public static io.qt.opengl.@NonNull QOpenGLDebugMessage createApplicationMessage(java.lang.@NonNull String text, int id, io.qt.opengl.QOpenGLDebugMessage.@NonNull Severity severity) {
        return createApplicationMessage(text, id, severity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>Overloaded function for {@link #createApplicationMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>severity = io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity</code></li>
     * <li><code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code></li>
     * </ul>
     */
    public static io.qt.opengl.@NonNull QOpenGLDebugMessage createApplicationMessage(java.lang.@NonNull String text, int id) {
        return createApplicationMessage(text, id, io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>Overloaded function for {@link #createApplicationMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>id = 0</code></li>
     * <li><code>severity = io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity</code></li>
     * <li><code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code></li>
     * </ul>
     */
    public static io.qt.opengl.@NonNull QOpenGLDebugMessage createApplicationMessage(java.lang.@NonNull String text) {
        return createApplicationMessage(text, (int)0, io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#createApplicationMessage">QOpenGLDebugMessage::createApplicationMessage(QString,GLuint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)</a></p>
     */
    public static io.qt.opengl.@NonNull QOpenGLDebugMessage createApplicationMessage(java.lang.@NonNull String text, int id, io.qt.opengl.QOpenGLDebugMessage.@NonNull Severity severity, io.qt.opengl.QOpenGLDebugMessage.@NonNull Type type){
        return createApplicationMessage_native_cref_QString_GLuint_QOpenGLDebugMessage_Severity_QOpenGLDebugMessage_Type(text, id, severity.value(), type.value());
    }
    
    private native static io.qt.opengl.QOpenGLDebugMessage createApplicationMessage_native_cref_QString_GLuint_QOpenGLDebugMessage_Severity_QOpenGLDebugMessage_Type(java.lang.String text, int id, int severity, int type);
    
    /**
     * <p>Overloaded function for {@link #createThirdPartyMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}
     *  with <code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code>.</p>
     */
    public static io.qt.opengl.@NonNull QOpenGLDebugMessage createThirdPartyMessage(java.lang.@NonNull String text, int id, io.qt.opengl.QOpenGLDebugMessage.@NonNull Severity severity) {
        return createThirdPartyMessage(text, id, severity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>Overloaded function for {@link #createThirdPartyMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>severity = io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity</code></li>
     * <li><code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code></li>
     * </ul>
     */
    public static io.qt.opengl.@NonNull QOpenGLDebugMessage createThirdPartyMessage(java.lang.@NonNull String text, int id) {
        return createThirdPartyMessage(text, id, io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>Overloaded function for {@link #createThirdPartyMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>id = 0</code></li>
     * <li><code>severity = io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity</code></li>
     * <li><code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code></li>
     * </ul>
     */
    public static io.qt.opengl.@NonNull QOpenGLDebugMessage createThirdPartyMessage(java.lang.@NonNull String text) {
        return createThirdPartyMessage(text, (int)0, io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#createThirdPartyMessage">QOpenGLDebugMessage::createThirdPartyMessage(QString,GLuint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)</a></p>
     */
    public static io.qt.opengl.@NonNull QOpenGLDebugMessage createThirdPartyMessage(java.lang.@NonNull String text, int id, io.qt.opengl.QOpenGLDebugMessage.@NonNull Severity severity, io.qt.opengl.QOpenGLDebugMessage.@NonNull Type type){
        return createThirdPartyMessage_native_cref_QString_GLuint_QOpenGLDebugMessage_Severity_QOpenGLDebugMessage_Type(text, id, severity.value(), type.value());
    }
    
    private native static io.qt.opengl.QOpenGLDebugMessage createThirdPartyMessage_native_cref_QString_GLuint_QOpenGLDebugMessage_Severity_QOpenGLDebugMessage_Type(java.lang.String text, int id, int severity, int type);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOpenGLDebugMessage(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.opengl.QOpenGLDebugMessage) {
            return operator_equal((io.qt.opengl.QOpenGLDebugMessage) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @QtUninvokable
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QOpenGLDebugMessage clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOpenGLDebugMessage clone_native(long __this_nativeId);
}
