package io.qt.opengl;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class QOpenGLVersionStatus</p>
 */
public class QOpenGLVersionStatus extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum QOpenGLVersionStatus::OpenGLStatus</p>
     */
    public enum OpenGLStatus implements QtEnumerator {
        CoreStatus(0),
        DeprecatedStatus(1),
        InvalidStatus(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private OpenGLStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static OpenGLStatus resolve(int value) {
            switch (value) {
            case 0: return CoreStatus;
            case 1: return DeprecatedStatus;
            case 2: return InvalidStatus;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QOpenGLVersionStatus(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLVersionStatus instance);
    
    public QOpenGLVersionStatus(int majorVersion, int minorVersion, io.qt.opengl.QOpenGLVersionStatus.@NonNull OpenGLStatus functionStatus){
        super((QPrivateConstructor)null);
        initialize_native(this, majorVersion, minorVersion, functionStatus);
    }
    
    private native static void initialize_native(QOpenGLVersionStatus instance, int majorVersion, int minorVersion, io.qt.opengl.QOpenGLVersionStatus.OpenGLStatus functionStatus);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.opengl.@NonNull QOpenGLVersionStatus rhs){
        return operator_equal_native_cref_QOpenGLVersionStatus(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QOpenGLVersionStatus(long __this__nativeId, long rhs);
    
    @QtUninvokable
    public final void setStatus(io.qt.opengl.QOpenGLVersionStatus.@NonNull OpenGLStatus status){
        setStatus_native_cref_QOpenGLVersionStatus_OpenGLStatus(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @QtUninvokable
    private native void setStatus_native_cref_QOpenGLVersionStatus_OpenGLStatus(long __this__nativeId, int status);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLVersionStatus.@NonNull OpenGLStatus getStatus() {
        return status();
    }
    
    @QtUninvokable
    public final io.qt.opengl.QOpenGLVersionStatus.@NonNull OpenGLStatus status(){
        return io.qt.opengl.QOpenGLVersionStatus.OpenGLStatus.resolve(status_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native(long __this__nativeId);
    
    @QtUninvokable
    public final void setVersion(io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> version){
        setVersion_native_cref_QPair(QtJambi_LibraryUtilities.internal.nativeId(this), version);
    }
    
    @QtUninvokable
    private native void setVersion_native_cref_QPair(long __this__nativeId, io.qt.core.QPair<java.lang.@QtPrimitiveType Integer, java.lang.@QtPrimitiveType Integer> version);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #version()} instead.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> getVersion() {
        return version();
    }
    
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<java.lang.@QtPrimitiveType@NonNull Integer, java.lang.@QtPrimitiveType@NonNull Integer> version(){
        return version_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPair<java.lang.@QtPrimitiveType Integer, java.lang.@QtPrimitiveType Integer> version_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOpenGLVersionStatus(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.opengl.QOpenGLVersionStatus) {
            return operator_equal((io.qt.opengl.QOpenGLVersionStatus) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QOpenGLVersionStatus clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOpenGLVersionStatus clone_native(long __this_nativeId);
}
