package io.qt.opengl;

import io.qt.*;


/**
 * <p>Specifies the format of an OpenGL framebuffer object</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html">QOpenGLFramebufferObjectFormat</a></p>
 */
public class QOpenGLFramebufferObjectFormat extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#QOpenGLFramebufferObjectFormat">QOpenGLFramebufferObjectFormat::QOpenGLFramebufferObjectFormat()</a></p>
     */
    public QOpenGLFramebufferObjectFormat(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObjectFormat instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#QOpenGLFramebufferObjectFormat-1">QOpenGLFramebufferObjectFormat::QOpenGLFramebufferObjectFormat(QOpenGLFramebufferObjectFormat)</a></p>
     */
    public QOpenGLFramebufferObjectFormat(io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QOpenGLFramebufferObjectFormat instance, io.qt.opengl.QOpenGLFramebufferObjectFormat other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#attachment">QOpenGLFramebufferObjectFormat::attachment()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment(){
        return io.qt.opengl.QOpenGLFramebufferObject.Attachment.resolve(attachment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int attachment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#internalTextureFormat">QOpenGLFramebufferObjectFormat::internalTextureFormat()const</a></p>
     */
    @QtUninvokable
    public final int internalTextureFormat(){
        return internalTextureFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int internalTextureFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#mipmap">QOpenGLFramebufferObjectFormat::mipmap()const</a></p>
     */
    @QtUninvokable
    public final boolean mipmap(){
        return mipmap_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean mipmap_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#operator-eq">QOpenGLFramebufferObjectFormat::operator=(QOpenGLFramebufferObjectFormat)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat other){
        assign_native_cref_QOpenGLFramebufferObjectFormat(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QOpenGLFramebufferObjectFormat(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#operator-eq-eq">QOpenGLFramebufferObjectFormat::operator==(QOpenGLFramebufferObjectFormat)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.opengl.@NonNull QOpenGLFramebufferObjectFormat other){
        return operator_equal_native_cref_QOpenGLFramebufferObjectFormat_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QOpenGLFramebufferObjectFormat_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#samples">QOpenGLFramebufferObjectFormat::samples()const</a></p>
     */
    @QtUninvokable
    public final int samples(){
        return samples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int samples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setAttachment">QOpenGLFramebufferObjectFormat::setAttachment(QOpenGLFramebufferObject::Attachment)</a></p>
     */
    @QtUninvokable
    public final void setAttachment(io.qt.opengl.QOpenGLFramebufferObject.@NonNull Attachment attachment){
        setAttachment_native_QOpenGLFramebufferObject_Attachment(QtJambi_LibraryUtilities.internal.nativeId(this), attachment.value());
    }
    
    @QtUninvokable
    private native void setAttachment_native_QOpenGLFramebufferObject_Attachment(long __this__nativeId, int attachment);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setInternalTextureFormat">QOpenGLFramebufferObjectFormat::setInternalTextureFormat(GLenum)</a></p>
     */
    @QtUninvokable
    public final void setInternalTextureFormat(int internalTextureFormat){
        setInternalTextureFormat_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), internalTextureFormat);
    }
    
    @QtUninvokable
    private native void setInternalTextureFormat_native_GLenum(long __this__nativeId, int internalTextureFormat);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setMipmap">QOpenGLFramebufferObjectFormat::setMipmap(bool)</a></p>
     */
    @QtUninvokable
    public final void setMipmap(boolean enabled){
        setMipmap_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @QtUninvokable
    private native void setMipmap_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setSamples">QOpenGLFramebufferObjectFormat::setSamples(int)</a></p>
     */
    @QtUninvokable
    public final void setSamples(int samples){
        setSamples_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), samples);
    }
    
    @QtUninvokable
    private native void setSamples_native_int(long __this__nativeId, int samples);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#setTextureTarget">QOpenGLFramebufferObjectFormat::setTextureTarget(GLenum)</a></p>
     */
    @QtUninvokable
    public final void setTextureTarget(int target){
        setTextureTarget_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @QtUninvokable
    private native void setTextureTarget_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglframebufferobjectformat.html#textureTarget">QOpenGLFramebufferObjectFormat::textureTarget()const</a></p>
     */
    @QtUninvokable
    public final int textureTarget(){
        return textureTarget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int textureTarget_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOpenGLFramebufferObjectFormat(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.opengl.QOpenGLFramebufferObjectFormat) {
            return operator_equal((io.qt.opengl.QOpenGLFramebufferObjectFormat) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QOpenGLFramebufferObjectFormat clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QOpenGLFramebufferObjectFormat clone_native(long __this_nativeId);
}
