package io.qt.opengl;


/**
 * <p>Wraps an OpenGL debug message</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopengldebugmessage.html">QOpenGLDebugMessage</a></p>
 */
public class QOpenGLDebugMessage extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Severity-enum">QOpenGLDebugMessage::Severity</a></p>
     * 
     * @see Severities
     */
    @io.qt.QtRejectedEntries({"LastSeverity"})
    public enum Severity implements io.qt.QtFlagEnumerator {
        InvalidSeverity(0),
        HighSeverity(1),
        MediumSeverity(2),
        LowSeverity(4),
        NotificationSeverity(8),
        LastSeverity(8),
        AnySeverity(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Severity(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Severities asFlags() {
            return new Severities(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Severities combined(Severity e) {
            return new Severities(this, e);
        }

        /**
         * Creates a new {@link Severities} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Severities flags(Severity ... values) {
            return new Severities(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Severity resolve(int value) {
            switch (value) {
            case 0: return InvalidSeverity;
            case 1: return HighSeverity;
            case 2: return MediumSeverity;
            case 4: return LowSeverity;
            case 8: return NotificationSeverity;
            case -1: return AnySeverity;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Severity}
     */
    public static final class Severities extends io.qt.QFlags<Severity> implements Comparable<Severities> {
        private static final long serialVersionUID = 0x771f7ddce3a2bab8L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Severities where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Severities(Severity ... args){
            super(args);
        }

        /**
         * Creates a new Severities with given <code>value</code>.
         * @param value
         */
        public Severities(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Severities
         */
        @Override
        public final Severities combined(Severity e){
            return new Severities(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Severities setFlag(Severity e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Severities setFlag(Severity e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Severities.
         * @return array of enum entries
         */
        @Override
        public final Severity[] flags(){
            return super.flags(Severity.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Severities clone(){
            return new Severities(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Severities other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Source-enum">QOpenGLDebugMessage::Source</a></p>
     * 
     * @see Sources
     */
    @io.qt.QtRejectedEntries({"LastSource"})
    public enum Source implements io.qt.QtFlagEnumerator {
        InvalidSource(0),
        APISource(1),
        WindowSystemSource(2),
        ShaderCompilerSource(4),
        ThirdPartySource(8),
        ApplicationSource(16),
        OtherSource(32),
        LastSource(32),
        AnySource(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Source(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Sources asFlags() {
            return new Sources(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Sources combined(Source e) {
            return new Sources(this, e);
        }

        /**
         * Creates a new {@link Sources} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Sources flags(Source ... values) {
            return new Sources(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Source resolve(int value) {
            switch (value) {
            case 0: return InvalidSource;
            case 1: return APISource;
            case 2: return WindowSystemSource;
            case 4: return ShaderCompilerSource;
            case 8: return ThirdPartySource;
            case 16: return ApplicationSource;
            case 32: return OtherSource;
            case -1: return AnySource;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Source}
     */
    public static final class Sources extends io.qt.QFlags<Source> implements Comparable<Sources> {
        private static final long serialVersionUID = 0x7fe7c1666616fb32L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Sources where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Sources(Source ... args){
            super(args);
        }

        /**
         * Creates a new Sources with given <code>value</code>.
         * @param value
         */
        public Sources(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Sources
         */
        @Override
        public final Sources combined(Source e){
            return new Sources(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Sources setFlag(Source e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Sources setFlag(Source e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Sources.
         * @return array of enum entries
         */
        @Override
        public final Source[] flags(){
            return super.flags(Source.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Sources clone(){
            return new Sources(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Sources other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengldebugmessage.html#Type-enum">QOpenGLDebugMessage::Type</a></p>
     * 
     * @see Types
     */
    @io.qt.QtRejectedEntries({"LastType"})
    public enum Type implements io.qt.QtFlagEnumerator {
        InvalidType(0),
        ErrorType(1),
        DeprecatedBehaviorType(2),
        UndefinedBehaviorType(4),
        PortabilityType(8),
        PerformanceType(16),
        OtherType(32),
        MarkerType(64),
        GroupPushType(128),
        GroupPopType(256),
        LastType(256),
        AnyType(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Types asFlags() {
            return new Types(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Types combined(Type e) {
            return new Types(this, e);
        }

        /**
         * Creates a new {@link Types} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Types flags(Type ... values) {
            return new Types(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case 0: return InvalidType;
            case 1: return ErrorType;
            case 2: return DeprecatedBehaviorType;
            case 4: return UndefinedBehaviorType;
            case 8: return PortabilityType;
            case 16: return PerformanceType;
            case 32: return OtherType;
            case 64: return MarkerType;
            case 128: return GroupPushType;
            case 256: return GroupPopType;
            case -1: return AnyType;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Type}
     */
    public static final class Types extends io.qt.QFlags<Type> implements Comparable<Types> {
        private static final long serialVersionUID = 0x74d0fb9231ed2833L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Types where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Types(Type ... args){
            super(args);
        }

        /**
         * Creates a new Types with given <code>value</code>.
         * @param value
         */
        public Types(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Types
         */
        @Override
        public final Types combined(Type e){
            return new Types(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Types setFlag(Type e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Types setFlag(Type e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Types.
         * @return array of enum entries
         */
        @Override
        public final Type[] flags(){
            return super.flags(Type.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Types clone(){
            return new Types(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Types other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#QOpenGLDebugMessage">QOpenGLDebugMessage::QOpenGLDebugMessage()</a></p>
     */
    public QOpenGLDebugMessage(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLDebugMessage instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#QOpenGLDebugMessage-1">QOpenGLDebugMessage::QOpenGLDebugMessage(QOpenGLDebugMessage)</a></p>
     */
    public QOpenGLDebugMessage(io.qt.opengl.QOpenGLDebugMessage debugMessage){
        super((QPrivateConstructor)null);
        initialize_native(this, debugMessage);
    }
    
    private native static void initialize_native(QOpenGLDebugMessage instance, io.qt.opengl.QOpenGLDebugMessage debugMessage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#id">QOpenGLDebugMessage::id()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#message">QOpenGLDebugMessage::message()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String message(){
        return message_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String message_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#operator-eq-eq">QOpenGLDebugMessage::operator==(QOpenGLDebugMessage)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.opengl.QOpenGLDebugMessage debugMessage){
        return operator_equal_native_cref_QOpenGLDebugMessage_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(debugMessage));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QOpenGLDebugMessage_constfct(long __this__nativeId, long debugMessage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#severity">QOpenGLDebugMessage::severity()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.opengl.QOpenGLDebugMessage.Severity severity(){
        return io.qt.opengl.QOpenGLDebugMessage.Severity.resolve(severity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int severity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#source">QOpenGLDebugMessage::source()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.opengl.QOpenGLDebugMessage.Source source(){
        return io.qt.opengl.QOpenGLDebugMessage.Source.resolve(source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#swap">QOpenGLDebugMessage::swap(QOpenGLDebugMessage&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.opengl.QOpenGLDebugMessage other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QOpenGLDebugMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QOpenGLDebugMessage(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#type">QOpenGLDebugMessage::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.opengl.QOpenGLDebugMessage.Type type(){
        return io.qt.opengl.QOpenGLDebugMessage.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #createApplicationMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}
     *  with <code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code>.</p>
     */
    public static io.qt.opengl.QOpenGLDebugMessage createApplicationMessage(java.lang.String text, int id, io.qt.opengl.QOpenGLDebugMessage.Severity severity) {
        return createApplicationMessage(text, id, severity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>Overloaded function for {@link #createApplicationMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>severity = io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity</code></li>
     * <li><code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code></li>
     * </ul>
     */
    public static io.qt.opengl.QOpenGLDebugMessage createApplicationMessage(java.lang.String text, int id) {
        return createApplicationMessage(text, id, io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>Overloaded function for {@link #createApplicationMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>id = 0</code></li>
     * <li><code>severity = io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity</code></li>
     * <li><code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code></li>
     * </ul>
     */
    public static io.qt.opengl.QOpenGLDebugMessage createApplicationMessage(java.lang.String text) {
        return createApplicationMessage(text, (int)0, io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#createApplicationMessage">QOpenGLDebugMessage::createApplicationMessage(QString,GLuint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)</a></p>
     */
    public static io.qt.opengl.QOpenGLDebugMessage createApplicationMessage(java.lang.String text, int id, io.qt.opengl.QOpenGLDebugMessage.Severity severity, io.qt.opengl.QOpenGLDebugMessage.Type type){
        return createApplicationMessage_native_cref_QString_GLuint_QOpenGLDebugMessage_Severity_QOpenGLDebugMessage_Type(text, id, severity.value(), type.value());
    }
    
    private native static io.qt.opengl.QOpenGLDebugMessage createApplicationMessage_native_cref_QString_GLuint_QOpenGLDebugMessage_Severity_QOpenGLDebugMessage_Type(java.lang.String text, int id, int severity, int type);
    
    /**
     * <p>Overloaded function for {@link #createThirdPartyMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}
     *  with <code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code>.</p>
     */
    public static io.qt.opengl.QOpenGLDebugMessage createThirdPartyMessage(java.lang.String text, int id, io.qt.opengl.QOpenGLDebugMessage.Severity severity) {
        return createThirdPartyMessage(text, id, severity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>Overloaded function for {@link #createThirdPartyMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>severity = io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity</code></li>
     * <li><code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code></li>
     * </ul>
     */
    public static io.qt.opengl.QOpenGLDebugMessage createThirdPartyMessage(java.lang.String text, int id) {
        return createThirdPartyMessage(text, id, io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>Overloaded function for {@link #createThirdPartyMessage(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Severity, io.qt.opengl.QOpenGLDebugMessage.Type)}</p>
     * <p>with: </p><ul>
     * <li><code>id = 0</code></li>
     * <li><code>severity = io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity</code></li>
     * <li><code>type = io.qt.opengl.QOpenGLDebugMessage.Type.OtherType</code></li>
     * </ul>
     */
    public static io.qt.opengl.QOpenGLDebugMessage createThirdPartyMessage(java.lang.String text) {
        return createThirdPartyMessage(text, (int)0, io.qt.opengl.QOpenGLDebugMessage.Severity.NotificationSeverity, io.qt.opengl.QOpenGLDebugMessage.Type.OtherType);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebugmessage.html#createThirdPartyMessage">QOpenGLDebugMessage::createThirdPartyMessage(QString,GLuint,QOpenGLDebugMessage::Severity,QOpenGLDebugMessage::Type)</a></p>
     */
    public static io.qt.opengl.QOpenGLDebugMessage createThirdPartyMessage(java.lang.String text, int id, io.qt.opengl.QOpenGLDebugMessage.Severity severity, io.qt.opengl.QOpenGLDebugMessage.Type type){
        return createThirdPartyMessage_native_cref_QString_GLuint_QOpenGLDebugMessage_Severity_QOpenGLDebugMessage_Type(text, id, severity.value(), type.value());
    }
    
    private native static io.qt.opengl.QOpenGLDebugMessage createThirdPartyMessage_native_cref_QString_GLuint_QOpenGLDebugMessage_Severity_QOpenGLDebugMessage_Type(java.lang.String text, int id, int severity, int type);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLDebugMessage(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.opengl.QOpenGLDebugMessage) {
            return operator_equal((io.qt.opengl.QOpenGLDebugMessage) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QOpenGLDebugMessage clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QOpenGLDebugMessage clone_native(long __this_nativeId);
}
