package io.qt.opengl;


/**
 * <p>Wraps an OpenGL Vertex Array Object</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html">QOpenGLVertexArrayObject</a></p>
 */
public class QOpenGLVertexArrayObject extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLVertexArrayObject.class);
    
    /**
     * <p>QOpenGLVertexArrayObject::Binder class is a convenience class to help with the binding and releasing of OpenGL Vertex Array Objects</p>
     * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qopenglvertexarrayobject-binder.html">QOpenGLVertexArrayObject::Binder</a></p>
     */
    public static class Binder extends io.qt.QtObject
        implements AutoCloseable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject-binder.html#Binder">QOpenGLVertexArrayObject::Binder::Binder(QOpenGLVertexArrayObject*)</a></p>
         */
        public Binder(io.qt.opengl.QOpenGLVertexArrayObject v){
            super((QPrivateConstructor)null);
            initialize_native(this, v);
        }
        
        private native static void initialize_native(Binder instance, io.qt.opengl.QOpenGLVertexArrayObject v);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject-binder.html#rebind">QOpenGLVertexArrayObject::Binder::rebind()</a></p>
         */
        @io.qt.QtUninvokable
        public final void rebind(){
            rebind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native void rebind_native(long __this__nativeId);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject-binder.html#release">QOpenGLVertexArrayObject::Binder::release()</a></p>
         */
        @io.qt.QtUninvokable
        public final void release(){
            release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native void release_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Binder(QPrivateConstructor p) { super(p); } 
        
        @Override
        @io.qt.QtUninvokable
        public final void close(){
        	dispose();
        }
    }

    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLVertexArrayObject(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLVertexArrayObject() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#QOpenGLVertexArrayObject">QOpenGLVertexArrayObject::QOpenGLVertexArrayObject(QObject*)</a></p>
     */
    public QOpenGLVertexArrayObject(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOpenGLVertexArrayObject instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#bind">QOpenGLVertexArrayObject::bind()</a></p>
     */
    @io.qt.QtUninvokable
    public final void bind(){
        bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void bind_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#create">QOpenGLVertexArrayObject::create()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#destroy">QOpenGLVertexArrayObject::destroy()</a></p>
     */
    @io.qt.QtUninvokable
    public final void destroy(){
        destroy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void destroy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#isCreated">QOpenGLVertexArrayObject::isCreated()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCreated(){
        return isCreated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCreated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#objectId">QOpenGLVertexArrayObject::objectId()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int objectId(){
        return objectId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int objectId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglvertexarrayobject.html#release">QOpenGLVertexArrayObject::release()</a></p>
     */
    @io.qt.QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLVertexArrayObject(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QOpenGLVertexArrayObject(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QOpenGLVertexArrayObject instance, QDeclarativeConstructor constructor);
    
}
