package io.qt.opengl;


/**
 * <p>Allows OpenGL shader programs to be linked and used</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qopenglshaderprogram.html">QOpenGLShaderProgram</a></p>
 */
public class QOpenGLShaderProgram extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcSharers;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLShaderProgram.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLShaderProgram(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLShaderProgram() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#QOpenGLShaderProgram">QOpenGLShaderProgram::QOpenGLShaderProgram(QObject*)</a></p>
     */
    public QOpenGLShaderProgram(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOpenGLShaderProgram instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addCacheableShaderFromSourceCode-1">QOpenGLShaderProgram::addCacheableShaderFromSourceCode(QOpenGLShader::ShaderType,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean addCacheableShaderFromSourceCode(io.qt.opengl.QOpenGLShader.ShaderType type, io.qt.core.QByteArray source){
        return addCacheableShaderFromSourceCode_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @io.qt.QtUninvokable
    private native boolean addCacheableShaderFromSourceCode_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QByteArray(long __this__nativeId, int type, long source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addCacheableShaderFromSourceCode-2">QOpenGLShaderProgram::addCacheableShaderFromSourceCode(QOpenGLShader::ShaderType,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean addCacheableShaderFromSourceCode(io.qt.opengl.QOpenGLShader.ShaderType type, java.lang.String source){
        return addCacheableShaderFromSourceCode_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), source);
    }
    
    @io.qt.QtUninvokable
    private native boolean addCacheableShaderFromSourceCode_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(long __this__nativeId, int type, java.lang.String source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addCacheableShaderFromSourceFile">QOpenGLShaderProgram::addCacheableShaderFromSourceFile(QOpenGLShader::ShaderType,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean addCacheableShaderFromSourceFile(io.qt.opengl.QOpenGLShader.ShaderType type, java.lang.String fileName){
        return addCacheableShaderFromSourceFile_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), fileName);
    }
    
    @io.qt.QtUninvokable
    private native boolean addCacheableShaderFromSourceFile_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(long __this__nativeId, int type, java.lang.String fileName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addShader">QOpenGLShaderProgram::addShader(QOpenGLShader*)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean addShader(io.qt.opengl.QOpenGLShader shader){
        boolean __qt_return_value = addShader_native_QOpenGLShader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(shader));
        if (shader != null) {
            if(__rcSharers==null)
                __rcSharers = QtJambi_LibraryUtilities.internal.newRCList();
            __rcSharers.add(shader);
        }
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native boolean addShader_native_QOpenGLShader_ptr(long __this__nativeId, long shader);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addShaderFromSourceCode-1">QOpenGLShaderProgram::addShaderFromSourceCode(QOpenGLShader::ShaderType,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean addShaderFromSourceCode(io.qt.opengl.QOpenGLShader.ShaderType type, io.qt.core.QByteArray source){
        return addShaderFromSourceCode_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @io.qt.QtUninvokable
    private native boolean addShaderFromSourceCode_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QByteArray(long __this__nativeId, int type, long source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addShaderFromSourceCode-2">QOpenGLShaderProgram::addShaderFromSourceCode(QOpenGLShader::ShaderType,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean addShaderFromSourceCode(io.qt.opengl.QOpenGLShader.ShaderType type, java.lang.String source){
        return addShaderFromSourceCode_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), source);
    }
    
    @io.qt.QtUninvokable
    private native boolean addShaderFromSourceCode_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(long __this__nativeId, int type, java.lang.String source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#addShaderFromSourceFile">QOpenGLShaderProgram::addShaderFromSourceFile(QOpenGLShader::ShaderType,QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean addShaderFromSourceFile(io.qt.opengl.QOpenGLShader.ShaderType type, java.lang.String fileName){
        return addShaderFromSourceFile_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), fileName);
    }
    
    @io.qt.QtUninvokable
    private native boolean addShaderFromSourceFile_native_QFlags_QOpenGLShader_ShaderTypeBit__cref_QString(long __this__nativeId, int type, java.lang.String fileName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#attributeLocation-1">QOpenGLShaderProgram::attributeLocation(QByteArray)const</a></p>
     */
    @io.qt.QtUninvokable
    public final int attributeLocation(io.qt.core.QByteArray name){
        return attributeLocation_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @io.qt.QtUninvokable
    private native int attributeLocation_native_cref_QByteArray_constfct(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#attributeLocation-2">QOpenGLShaderProgram::attributeLocation(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final int attributeLocation(java.lang.String name){
        return attributeLocation_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native int attributeLocation_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#bind">QOpenGLShaderProgram::bind()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean bind(){
        return bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean bind_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#bindAttributeLocation-1">QOpenGLShaderProgram::bindAttributeLocation(QByteArray,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindAttributeLocation(io.qt.core.QByteArray name, int location){
        bindAttributeLocation_native_cref_QByteArray_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), location);
    }
    
    @io.qt.QtUninvokable
    private native void bindAttributeLocation_native_cref_QByteArray_int(long __this__nativeId, long name, int location);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#bindAttributeLocation-2">QOpenGLShaderProgram::bindAttributeLocation(QString,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bindAttributeLocation(java.lang.String name, int location){
        bindAttributeLocation_native_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, location);
    }
    
    @io.qt.QtUninvokable
    private native void bindAttributeLocation_native_cref_QString_int(long __this__nativeId, java.lang.String name, int location);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#create">QOpenGLShaderProgram::create()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#defaultInnerTessellationLevels">QOpenGLShaderProgram::defaultInnerTessellationLevels()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Float> defaultInnerTessellationLevels(){
        return defaultInnerTessellationLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Float> defaultInnerTessellationLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#defaultOuterTessellationLevels">QOpenGLShaderProgram::defaultOuterTessellationLevels()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Float> defaultOuterTessellationLevels(){
        return defaultOuterTessellationLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Float> defaultOuterTessellationLevels_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void disableAttributeArray(java.lang.String name){
        disableAttributeArray_native_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void disableAttributeArray_native_const_char_ptr(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#disableAttributeArray">QOpenGLShaderProgram::disableAttributeArray(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void disableAttributeArray(int location){
        disableAttributeArray_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), location);
    }
    
    @io.qt.QtUninvokable
    private native void disableAttributeArray_native_int(long __this__nativeId, int location);
    
    @io.qt.QtUninvokable
    public final void enableAttributeArray(java.lang.String name){
        enableAttributeArray_native_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void enableAttributeArray_native_const_char_ptr(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#enableAttributeArray">QOpenGLShaderProgram::enableAttributeArray(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void enableAttributeArray(int location){
        enableAttributeArray_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), location);
    }
    
    @io.qt.QtUninvokable
    private native void enableAttributeArray_native_int(long __this__nativeId, int location);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#isLinked">QOpenGLShaderProgram::isLinked()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isLinked(){
        return isLinked_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isLinked_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#log">QOpenGLShaderProgram::log()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String log(){
        return log_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String log_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#maxGeometryOutputVertices">QOpenGLShaderProgram::maxGeometryOutputVertices()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int maxGeometryOutputVertices(){
        return maxGeometryOutputVertices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxGeometryOutputVertices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#patchVertexCount">QOpenGLShaderProgram::patchVertexCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int patchVertexCount(){
        return patchVertexCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int patchVertexCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#programId">QOpenGLShaderProgram::programId()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int programId(){
        return programId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int programId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#release">QOpenGLShaderProgram::release()</a></p>
     */
    @io.qt.QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#removeAllShaders">QOpenGLShaderProgram::removeAllShaders()</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAllShaders(){
        removeAllShaders_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void removeAllShaders_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#removeShader">QOpenGLShaderProgram::removeShader(QOpenGLShader*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeShader(io.qt.opengl.QOpenGLShader shader){
        removeShader_native_QOpenGLShader_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(shader));
        if (shader != null) {
            while (__rcSharers != null && __rcSharers.remove(shader)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeShader_native_QOpenGLShader_ptr(long __this__nativeId, long shader);
    
    /**
     * <p>Overloaded function for {@link #setAttributeArray(java.lang.String, int, java.nio.Buffer, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeArray(java.lang.String name, int type, java.nio.Buffer values, int tupleSize) {
        setAttributeArray(name, type, values, tupleSize, (int)0);
    }
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(java.lang.String name, int type, java.nio.Buffer values, int tupleSize, int stride){
        setAttributeArray_native_const_char_ptr_GLenum_const_void_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, type, values, tupleSize, stride);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_GLenum_const_void_ptr_int_int(long __this__nativeId, java.lang.String name, int type, java.nio.Buffer values, int tupleSize, int stride);
    
    /**
     * <p>Overloaded function for {@link #setAttributeArray(java.lang.String, java.nio.FloatBuffer, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeArray(java.lang.String name, java.nio.FloatBuffer values, int tupleSize) {
        setAttributeArray(name, values, tupleSize, (int)0);
    }
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(java.lang.String name, java.nio.FloatBuffer values, int tupleSize, int stride){
        setAttributeArray_native_const_char_ptr_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values, tupleSize, stride);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_const_GLfloat_ptr_int_int(long __this__nativeId, java.lang.String name, java.nio.FloatBuffer values, int tupleSize, int stride);
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(java.lang.String name, io.qt.gui.QVector2D[] values){
        setAttributeArray_native_const_char_ptr_const_QVector2D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_const_QVector2D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector2D[] values);
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(java.lang.String name, io.qt.gui.QVector3D[] values){
        setAttributeArray_native_const_char_ptr_const_QVector3D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_const_QVector3D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector3D[] values);
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(java.lang.String name, io.qt.gui.QVector4D[] values){
        setAttributeArray_native_const_char_ptr_const_QVector4D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_const_char_ptr_const_QVector4D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector4D[] values);
    
    /**
     * <p>Overloaded function for {@link #setAttributeArray(int, int, java.nio.Buffer, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeArray(int location, int type, java.nio.Buffer values, int tupleSize) {
        setAttributeArray(location, type, values, tupleSize, (int)0);
    }
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(int location, int type, java.nio.Buffer values, int tupleSize, int stride){
        setAttributeArray_native_int_GLenum_const_void_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, type, values, tupleSize, stride);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_int_GLenum_const_void_ptr_int_int(long __this__nativeId, int location, int type, java.nio.Buffer values, int tupleSize, int stride);
    
    /**
     * <p>Overloaded function for {@link #setAttributeArray(int, java.nio.FloatBuffer, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeArray(int location, java.nio.FloatBuffer values, int tupleSize) {
        setAttributeArray(location, values, tupleSize, (int)0);
    }
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(int location, java.nio.FloatBuffer values, int tupleSize, int stride){
        setAttributeArray_native_int_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values, tupleSize, stride);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_int_const_GLfloat_ptr_int_int(long __this__nativeId, int location, java.nio.FloatBuffer values, int tupleSize, int stride);
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(int location, io.qt.gui.QVector2D[] values){
        setAttributeArray_native_int_const_QVector2D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_int_const_QVector2D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector2D[] values);
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(int location, io.qt.gui.QVector3D[] values){
        setAttributeArray_native_int_const_QVector3D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_int_const_QVector3D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector3D[] values);
    
    @io.qt.QtUninvokable
    public final void setAttributeArray(int location, io.qt.gui.QVector4D[] values){
        setAttributeArray_native_int_const_QVector4D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeArray_native_int_const_QVector4D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector4D[] values);
    
    /**
     * <p>Overloaded function for {@link #setAttributeBuffer(java.lang.String, int, int, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeBuffer(java.lang.String name, int type, int offset, int tupleSize) {
        setAttributeBuffer(name, type, offset, tupleSize, (int)0);
    }
    
    @io.qt.QtUninvokable
    public final void setAttributeBuffer(java.lang.String name, int type, int offset, int tupleSize, int stride){
        setAttributeBuffer_native_const_char_ptr_GLenum_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, type, offset, tupleSize, stride);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeBuffer_native_const_char_ptr_GLenum_int_int_int(long __this__nativeId, java.lang.String name, int type, int offset, int tupleSize, int stride);
    
    /**
     * <p>Overloaded function for {@link #setAttributeBuffer(int, int, int, int, int)}
     *  with <code>stride = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeBuffer(int location, int type, int offset, int tupleSize) {
        setAttributeBuffer(location, type, offset, tupleSize, (int)0);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeBuffer">QOpenGLShaderProgram::setAttributeBuffer(int,GLenum,int,int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeBuffer(int location, int type, int offset, int tupleSize, int stride){
        setAttributeBuffer_native_int_GLenum_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, type, offset, tupleSize, stride);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeBuffer_native_int_GLenum_int_int_int(long __this__nativeId, int location, int type, int offset, int tupleSize, int stride);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, float value){
        setAttributeValue_native_const_char_ptr_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_GLfloat(long __this__nativeId, java.lang.String name, float value);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, float x, float y){
        setAttributeValue_native_const_char_ptr_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, float x, float y, float z){
        setAttributeValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, float x, float y, float z, float w){
        setAttributeValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, java.nio.FloatBuffer values, int columns, int rows){
        setAttributeValue_native_const_char_ptr_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values, columns, rows);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_const_GLfloat_ptr_int_int(long __this__nativeId, java.lang.String name, java.nio.FloatBuffer values, int columns, int rows);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, io.qt.gui.QColor value){
        setAttributeValue_native_const_char_ptr_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_cref_QColor(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, io.qt.gui.QVector2D value){
        setAttributeValue_native_const_char_ptr_cref_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_cref_QVector2D(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, io.qt.gui.QVector3D value){
        setAttributeValue_native_const_char_ptr_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_cref_QVector3D(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(java.lang.String name, io.qt.gui.QVector4D value){
        setAttributeValue_native_const_char_ptr_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_const_char_ptr_cref_QVector4D(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue">QOpenGLShaderProgram::setAttributeValue(int,GLfloat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, float value){
        setAttributeValue_native_int_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, value);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_GLfloat(long __this__nativeId, int location, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-1">QOpenGLShaderProgram::setAttributeValue(int,GLfloat,GLfloat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, float x, float y){
        setAttributeValue_native_int_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-2">QOpenGLShaderProgram::setAttributeValue(int,GLfloat,GLfloat,GLfloat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, float x, float y, float z){
        setAttributeValue_native_int_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-3">QOpenGLShaderProgram::setAttributeValue(int,GLfloat,GLfloat,GLfloat,GLfloat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, float x, float y, float z, float w){
        setAttributeValue_native_int_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, java.nio.FloatBuffer values, int columns, int rows){
        setAttributeValue_native_int_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values, columns, rows);
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_const_GLfloat_ptr_int_int(long __this__nativeId, int location, java.nio.FloatBuffer values, int columns, int rows);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-7">QOpenGLShaderProgram::setAttributeValue(int,QColor)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.QColor value){
        setAttributeValue_native_int_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_cref_QColor(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-4">QOpenGLShaderProgram::setAttributeValue(int,QVector2D)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.QVector2D value){
        setAttributeValue_native_int_cref_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_cref_QVector2D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-5">QOpenGLShaderProgram::setAttributeValue(int,QVector3D)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.QVector3D value){
        setAttributeValue_native_int_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_cref_QVector3D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setAttributeValue-6">QOpenGLShaderProgram::setAttributeValue(int,QVector4D)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAttributeValue(int location, io.qt.gui.QVector4D value){
        setAttributeValue_native_int_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setAttributeValue_native_int_cref_QVector4D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setDefaultInnerTessellationLevels">QOpenGLShaderProgram::setDefaultInnerTessellationLevels(QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDefaultInnerTessellationLevels(java.util.Collection<java.lang.Float> levels){
        setDefaultInnerTessellationLevels_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), levels);
    }
    
    @io.qt.QtUninvokable
    private native void setDefaultInnerTessellationLevels_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.Float> levels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setDefaultOuterTessellationLevels">QOpenGLShaderProgram::setDefaultOuterTessellationLevels(QList&lt;float&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDefaultOuterTessellationLevels(java.util.Collection<java.lang.Float> levels){
        setDefaultOuterTessellationLevels_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), levels);
    }
    
    @io.qt.QtUninvokable
    private native void setDefaultOuterTessellationLevels_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.Float> levels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setPatchVertexCount">QOpenGLShaderProgram::setPatchVertexCount(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPatchVertexCount(int count){
        setPatchVertexCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    @io.qt.QtUninvokable
    private native void setPatchVertexCount_native_int(long __this__nativeId, int count);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, float value){
        setUniformValue_native_const_char_ptr_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLfloat(long __this__nativeId, java.lang.String name, float value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, float x, float y){
        setUniformValue_native_const_char_ptr_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, float x, float y, float z){
        setUniformValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, float x, float y, float z, float w){
        setUniformValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), name, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, java.lang.String name, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, int value){
        setUniformValue_native_const_char_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), name, value);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_GLint(long __this__nativeId, java.lang.String name, int value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QColor color){
        setUniformValue_native_const_char_ptr_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QColor(long __this__nativeId, java.lang.String name, long color);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix2x2 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix2x2(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix2x2(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix2x3 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix2x3(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix2x3(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix2x4 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix2x4(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix2x4(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix3x2 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix3x2(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix3x2(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix3x3 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix3x3(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix3x3(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix3x4 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix3x4(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix3x4(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix4x2 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix4x2(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix4x2(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix4x3 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix4x3(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix4x3(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QMatrix4x4 value){
        setUniformValue_native_const_char_ptr_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QMatrix4x4(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.core.QPoint point){
        setUniformValue_native_const_char_ptr_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QPoint(long __this__nativeId, java.lang.String name, long point);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.core.QPointF point){
        setUniformValue_native_const_char_ptr_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QPointF(long __this__nativeId, java.lang.String name, long point);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.core.QSize size){
        setUniformValue_native_const_char_ptr_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QSize(long __this__nativeId, java.lang.String name, long size);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.core.QSizeF size){
        setUniformValue_native_const_char_ptr_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QSizeF(long __this__nativeId, java.lang.String name, long size);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QTransform value){
        setUniformValue_native_const_char_ptr_cref_QTransform(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QTransform(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QVector2D value){
        setUniformValue_native_const_char_ptr_cref_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QVector2D(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QVector3D value){
        setUniformValue_native_const_char_ptr_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QVector3D(long __this__nativeId, java.lang.String name, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValue(java.lang.String name, io.qt.gui.QVector4D value){
        setUniformValue_native_const_char_ptr_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), name, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_const_char_ptr_cref_QVector4D(long __this__nativeId, java.lang.String name, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue">QOpenGLShaderProgram::setUniformValue(int,GLfloat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, float value){
        setUniformValue_native_int_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, value);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_GLfloat(long __this__nativeId, int location, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-3">QOpenGLShaderProgram::setUniformValue(int,GLfloat,GLfloat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, float x, float y){
        setUniformValue_native_int_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-4">QOpenGLShaderProgram::setUniformValue(int,GLfloat,GLfloat,GLfloat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, float x, float y, float z){
        setUniformValue_native_int_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-5">QOpenGLShaderProgram::setUniformValue(int,GLfloat,GLfloat,GLfloat,GLfloat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, float x, float y, float z, float w){
        setUniformValue_native_int_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z, float w);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-1">QOpenGLShaderProgram::setUniformValue(int,GLint)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, int value){
        setUniformValue_native_int_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, value);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_GLint(long __this__nativeId, int location, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-9">QOpenGLShaderProgram::setUniformValue(int,QColor)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QColor color){
        setUniformValue_native_int_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QColor(long __this__nativeId, int location, long color);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-14">QOpenGLShaderProgram::setUniformValue(int,QMatrix2x2)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix2x2 value){
        setUniformValue_native_int_cref_QMatrix2x2(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix2x2(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-15">QOpenGLShaderProgram::setUniformValue(int,QMatrix2x3)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix2x3 value){
        setUniformValue_native_int_cref_QMatrix2x3(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix2x3(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-16">QOpenGLShaderProgram::setUniformValue(int,QMatrix2x4)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix2x4 value){
        setUniformValue_native_int_cref_QMatrix2x4(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix2x4(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-17">QOpenGLShaderProgram::setUniformValue(int,QMatrix3x2)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix3x2 value){
        setUniformValue_native_int_cref_QMatrix3x2(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix3x2(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-18">QOpenGLShaderProgram::setUniformValue(int,QMatrix3x3)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix3x3 value){
        setUniformValue_native_int_cref_QMatrix3x3(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix3x3(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-19">QOpenGLShaderProgram::setUniformValue(int,QMatrix3x4)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix3x4 value){
        setUniformValue_native_int_cref_QMatrix3x4(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix3x4(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-20">QOpenGLShaderProgram::setUniformValue(int,QMatrix4x2)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix4x2 value){
        setUniformValue_native_int_cref_QMatrix4x2(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix4x2(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-21">QOpenGLShaderProgram::setUniformValue(int,QMatrix4x3)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix4x3 value){
        setUniformValue_native_int_cref_QMatrix4x3(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix4x3(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-22">QOpenGLShaderProgram::setUniformValue(int,QMatrix4x4)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QMatrix4x4 value){
        setUniformValue_native_int_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QMatrix4x4(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-10">QOpenGLShaderProgram::setUniformValue(int,QPoint)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.core.QPoint point){
        setUniformValue_native_int_cref_QPoint(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QPoint(long __this__nativeId, int location, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-11">QOpenGLShaderProgram::setUniformValue(int,QPointF)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.core.QPointF point){
        setUniformValue_native_int_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QPointF(long __this__nativeId, int location, long point);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-12">QOpenGLShaderProgram::setUniformValue(int,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.core.QSize size){
        setUniformValue_native_int_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QSize(long __this__nativeId, int location, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-13">QOpenGLShaderProgram::setUniformValue(int,QSizeF)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.core.QSizeF size){
        setUniformValue_native_int_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QSizeF(long __this__nativeId, int location, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-26">QOpenGLShaderProgram::setUniformValue(int,QTransform)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QTransform value){
        setUniformValue_native_int_cref_QTransform(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QTransform(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-6">QOpenGLShaderProgram::setUniformValue(int,QVector2D)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QVector2D value){
        setUniformValue_native_int_cref_QVector2D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QVector2D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-7">QOpenGLShaderProgram::setUniformValue(int,QVector3D)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QVector3D value){
        setUniformValue_native_int_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QVector3D(long __this__nativeId, int location, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#setUniformValue-8">QOpenGLShaderProgram::setUniformValue(int,QVector4D)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUniformValue(int location, io.qt.gui.QVector4D value){
        setUniformValue_native_int_cref_QVector4D(QtJambi_LibraryUtilities.internal.nativeId(this), location, QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValue_native_int_cref_QVector4D(long __this__nativeId, int location, long value);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, java.nio.FloatBuffer values, int count, int tupleSize){
        setUniformValueArray_native_const_char_ptr_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values, count, tupleSize);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_GLfloat_ptr_int_int(long __this__nativeId, java.lang.String name, java.nio.FloatBuffer values, int count, int tupleSize);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, java.nio.IntBuffer values, int count){
        setUniformValueArray_native_const_char_ptr_const_GLint_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values, count);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_GLint_ptr_int(long __this__nativeId, java.lang.String name, java.nio.IntBuffer values, int count);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix2x2[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix2x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix2x2_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix2x2[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix2x3[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix2x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix2x3_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix2x3[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix2x4[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix2x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix2x4_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix2x4[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix3x2[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix3x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix3x2_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix3x2[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix3x3[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix3x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix3x3_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix3x3[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix3x4[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix3x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix3x4_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix3x4[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix4x2[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix4x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix4x2_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix4x2[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix4x3[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix4x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix4x3_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix4x3[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QMatrix4x4[] values){
        setUniformValueArray_native_const_char_ptr_const_QMatrix4x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QMatrix4x4_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QMatrix4x4[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QVector2D[] values){
        setUniformValueArray_native_const_char_ptr_const_QVector2D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QVector2D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector2D[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QVector3D[] values){
        setUniformValueArray_native_const_char_ptr_const_QVector3D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QVector3D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector3D[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(java.lang.String name, io.qt.gui.QVector4D[] values){
        setUniformValueArray_native_const_char_ptr_const_QVector4D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), name, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_const_char_ptr_const_QVector4D_ptr_int(long __this__nativeId, java.lang.String name, io.qt.gui.QVector4D[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, java.nio.FloatBuffer values, int count, int tupleSize){
        setUniformValueArray_native_int_const_GLfloat_ptr_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values, count, tupleSize);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_GLfloat_ptr_int_int(long __this__nativeId, int location, java.nio.FloatBuffer values, int count, int tupleSize);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, java.nio.IntBuffer values, int count){
        setUniformValueArray_native_int_const_GLint_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values, count);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_GLint_ptr_int(long __this__nativeId, int location, java.nio.IntBuffer values, int count);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix2x2[] values){
        setUniformValueArray_native_int_const_QMatrix2x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix2x2_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix2x2[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix2x3[] values){
        setUniformValueArray_native_int_const_QMatrix2x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix2x3_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix2x3[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix2x4[] values){
        setUniformValueArray_native_int_const_QMatrix2x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix2x4_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix2x4[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix3x2[] values){
        setUniformValueArray_native_int_const_QMatrix3x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix3x2_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix3x2[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix3x3[] values){
        setUniformValueArray_native_int_const_QMatrix3x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix3x3_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix3x3[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix3x4[] values){
        setUniformValueArray_native_int_const_QMatrix3x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix3x4_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix3x4[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix4x2[] values){
        setUniformValueArray_native_int_const_QMatrix4x2_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix4x2_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix4x2[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix4x3[] values){
        setUniformValueArray_native_int_const_QMatrix4x3_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix4x3_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix4x3[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QMatrix4x4[] values){
        setUniformValueArray_native_int_const_QMatrix4x4_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QMatrix4x4_ptr_int(long __this__nativeId, int location, io.qt.gui.QMatrix4x4[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QVector2D[] values){
        setUniformValueArray_native_int_const_QVector2D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QVector2D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector2D[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QVector3D[] values){
        setUniformValueArray_native_int_const_QVector3D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QVector3D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector3D[] values);
    
    @io.qt.QtUninvokable
    public final void setUniformValueArray(int location, io.qt.gui.QVector4D[] values){
        setUniformValueArray_native_int_const_QVector4D_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), location, values);
    }
    
    @io.qt.QtUninvokable
    private native void setUniformValueArray_native_int_const_QVector4D_ptr_int(long __this__nativeId, int location, io.qt.gui.QVector4D[] values);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#shaders">QOpenGLShaderProgram::shaders()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.opengl.QOpenGLShader> shaders(){
        return shaders_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.opengl.QOpenGLShader> shaders_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#uniformLocation-1">QOpenGLShaderProgram::uniformLocation(QByteArray)const</a></p>
     */
    @io.qt.QtUninvokable
    public final int uniformLocation(io.qt.core.QByteArray name){
        return uniformLocation_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    @io.qt.QtUninvokable
    private native int uniformLocation_native_cref_QByteArray_constfct(long __this__nativeId, long name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#uniformLocation-2">QOpenGLShaderProgram::uniformLocation(QString)const</a></p>
     */
    @io.qt.QtUninvokable
    public final int uniformLocation(java.lang.String name){
        return uniformLocation_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native int uniformLocation_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#link">QOpenGLShaderProgram::link()</a></p>
     */
    @io.qt.QtUninvokable
    public boolean link(){
        return link_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean link_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #hasOpenGLShaderPrograms(io.qt.gui.QOpenGLContext)}
     *  with <code>context = null</code>.</p>
     */
    public static boolean hasOpenGLShaderPrograms() {
        return hasOpenGLShaderPrograms((io.qt.gui.QOpenGLContext)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshaderprogram.html#hasOpenGLShaderPrograms">QOpenGLShaderProgram::hasOpenGLShaderPrograms(QOpenGLContext*)</a></p>
     */
    public static boolean hasOpenGLShaderPrograms(io.qt.gui.QOpenGLContext context){
        return hasOpenGLShaderPrograms_native_QOpenGLContext_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    private native static boolean hasOpenGLShaderPrograms_native_QOpenGLContext_ptr(long context);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLShaderProgram(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QOpenGLShaderProgram(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QOpenGLShaderProgram instance, QDeclarativeConstructor constructor);
    
}
