package io.qt.opengl;


/**
 * <p>All functions for OpenGL 4.4 core profile</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qopenglfunctions-4-4-core.html">QOpenGLFunctions_4_4_Core</a></p>
 */
public final class QOpenGLFunctions_4_4_Core extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    public QOpenGLFunctions_4_4_Core(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_4_4_Core instance);
    
    @io.qt.QtUninvokable
    public final void glActiveShaderProgram(int pipeline, int program){
        glActiveShaderProgram_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, program);
    }
    
    @io.qt.QtUninvokable
    private native void glActiveShaderProgram_native_GLuint_GLuint(long __this__nativeId, int pipeline, int program);
    
    @io.qt.QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @io.qt.QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    @io.qt.QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @io.qt.QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    @io.qt.QtUninvokable
    public final void glBeginConditionalRender(int id, int mode){
        glBeginConditionalRender_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glBeginConditionalRender_native_GLuint_GLenum(long __this__nativeId, int id, int mode);
    
    @io.qt.QtUninvokable
    public final void glBeginQuery(int target, int id){
        glBeginQuery_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @io.qt.QtUninvokable
    private native void glBeginQuery_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    @io.qt.QtUninvokable
    public final void glBeginQueryIndexed(int target, int index, int id){
        glBeginQueryIndexed_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, id);
    }
    
    @io.qt.QtUninvokable
    private native void glBeginQueryIndexed_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int id);
    
    @io.qt.QtUninvokable
    public final void glBeginTransformFeedback(int primitiveMode){
        glBeginTransformFeedback_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveMode);
    }
    
    @io.qt.QtUninvokable
    private native void glBeginTransformFeedback_native_GLenum(long __this__nativeId, int primitiveMode);
    
    @io.qt.QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @io.qt.QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @io.qt.QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    @io.qt.QtUninvokable
    public final void glBindBufferBase(int target, int index, int buffer){
        glBindBufferBase_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer);
    }
    
    @io.qt.QtUninvokable
    private native void glBindBufferBase_native_GLenum_GLuint_GLuint(long __this__nativeId, int target, int index, int buffer);
    
    @io.qt.QtUninvokable
    public final void glBindBufferRange(int target, int index, int buffer, long offset, long size){
        glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, buffer, offset, size);
    }
    
    @io.qt.QtUninvokable
    private native void glBindBufferRange_native_GLenum_GLuint_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int index, int buffer, long offset, long size);
    
    @io.qt.QtUninvokable
    public final void glBindBuffersBase(int target, int first, int count, java.nio.IntBuffer buffers){
        java.util.Objects.requireNonNull(buffers, "Argument 'buffers': null not expected.");
        glBindBuffersBase_native_GLenum_GLuint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, first, count, buffers);
    }
    
    @io.qt.QtUninvokable
    private native void glBindBuffersBase_native_GLenum_GLuint_GLsizei_const_GLuint_ptr(long __this__nativeId, int target, int first, int count, java.nio.IntBuffer buffers);
    
    @io.qt.QtUninvokable
    public final void glBindBuffersRange(int target, int first, int count, java.nio.IntBuffer buffers, java.nio.LongBuffer offsets, java.nio.LongBuffer sizes){
        java.util.Objects.requireNonNull(buffers, "Argument 'buffers': null not expected.");
        java.util.Objects.requireNonNull(offsets, "Argument 'offsets': null not expected.");
        java.util.Objects.requireNonNull(sizes, "Argument 'sizes': null not expected.");
        glBindBuffersRange_native_GLenum_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizeiptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, first, count, buffers, offsets, sizes);
    }
    
    @io.qt.QtUninvokable
    private native void glBindBuffersRange_native_GLenum_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizeiptr_ptr(long __this__nativeId, int target, int first, int count, java.nio.IntBuffer buffers, java.nio.LongBuffer offsets, java.nio.LongBuffer sizes);
    
    @io.qt.QtUninvokable
    public final void glBindFragDataLocation(int program, int color, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, color, name);
    }
    
    @io.qt.QtUninvokable
    private native void glBindFragDataLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int color, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glBindFragDataLocationIndexed(int program, int colorNumber, int index, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glBindFragDataLocationIndexed_native_GLuint_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, colorNumber, index, name);
    }
    
    @io.qt.QtUninvokable
    private native void glBindFragDataLocationIndexed_native_GLuint_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int colorNumber, int index, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glBindFramebuffer(int target, int framebuffer){
        glBindFramebuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, framebuffer);
    }
    
    @io.qt.QtUninvokable
    private native void glBindFramebuffer_native_GLenum_GLuint(long __this__nativeId, int target, int framebuffer);
    
    @io.qt.QtUninvokable
    public final void glBindImageTexture(int unit, int texture, int level, boolean layered, int layer, int access, int format){
        glBindImageTexture_native_GLuint_GLuint_GLint_GLboolean_GLint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), unit, texture, level, layered, layer, access, format);
    }
    
    @io.qt.QtUninvokable
    private native void glBindImageTexture_native_GLuint_GLuint_GLint_GLboolean_GLint_GLenum_GLenum(long __this__nativeId, int unit, int texture, int level, boolean layered, int layer, int access, int format);
    
    @io.qt.QtUninvokable
    public final void glBindImageTextures(int first, int count, java.nio.IntBuffer textures){
        java.util.Objects.requireNonNull(textures, "Argument 'textures': null not expected.");
        glBindImageTextures_native_GLuint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, textures);
    }
    
    @io.qt.QtUninvokable
    private native void glBindImageTextures_native_GLuint_GLsizei_const_GLuint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer textures);
    
    @io.qt.QtUninvokable
    public final void glBindProgramPipeline(int pipeline){
        glBindProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @io.qt.QtUninvokable
    private native void glBindProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    @io.qt.QtUninvokable
    public final void glBindRenderbuffer(int target, int renderbuffer){
        glBindRenderbuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, renderbuffer);
    }
    
    @io.qt.QtUninvokable
    private native void glBindRenderbuffer_native_GLenum_GLuint(long __this__nativeId, int target, int renderbuffer);
    
    @io.qt.QtUninvokable
    public final void glBindSampler(int unit, int sampler){
        glBindSampler_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), unit, sampler);
    }
    
    @io.qt.QtUninvokable
    private native void glBindSampler_native_GLuint_GLuint(long __this__nativeId, int unit, int sampler);
    
    @io.qt.QtUninvokable
    public final void glBindSamplers(int first, int count, java.nio.IntBuffer samplers){
        java.util.Objects.requireNonNull(samplers, "Argument 'samplers': null not expected.");
        glBindSamplers_native_GLuint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, samplers);
    }
    
    @io.qt.QtUninvokable
    private native void glBindSamplers_native_GLuint_GLsizei_const_GLuint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer samplers);
    
    @io.qt.QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @io.qt.QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    @io.qt.QtUninvokable
    public final void glBindTextures(int first, int count, java.nio.IntBuffer textures){
        java.util.Objects.requireNonNull(textures, "Argument 'textures': null not expected.");
        glBindTextures_native_GLuint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, textures);
    }
    
    @io.qt.QtUninvokable
    private native void glBindTextures_native_GLuint_GLsizei_const_GLuint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer textures);
    
    @io.qt.QtUninvokable
    public final void glBindTransformFeedback(int target, int id){
        glBindTransformFeedback_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @io.qt.QtUninvokable
    private native void glBindTransformFeedback_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    @io.qt.QtUninvokable
    public final void glBindVertexArray(int array){
        glBindVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @io.qt.QtUninvokable
    private native void glBindVertexArray_native_GLuint(long __this__nativeId, int array);
    
    @io.qt.QtUninvokable
    public final void glBindVertexBuffer(int bindingindex, int buffer, long offset, int stride){
        glBindVertexBuffer_native_GLuint_GLuint_GLintptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), bindingindex, buffer, offset, stride);
    }
    
    @io.qt.QtUninvokable
    private native void glBindVertexBuffer_native_GLuint_GLuint_GLintptr_GLsizei(long __this__nativeId, int bindingindex, int buffer, long offset, int stride);
    
    @io.qt.QtUninvokable
    public final void glBindVertexBuffers(int first, int count, java.nio.IntBuffer buffers, java.nio.LongBuffer offsets, java.nio.IntBuffer strides){
        java.util.Objects.requireNonNull(buffers, "Argument 'buffers': null not expected.");
        java.util.Objects.requireNonNull(offsets, "Argument 'offsets': null not expected.");
        java.util.Objects.requireNonNull(strides, "Argument 'strides': null not expected.");
        glBindVertexBuffers_native_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizei_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, buffers, offsets, strides);
    }
    
    @io.qt.QtUninvokable
    private native void glBindVertexBuffers_native_GLuint_GLsizei_const_GLuint_ptr_const_GLintptr_ptr_const_GLsizei_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer buffers, java.nio.LongBuffer offsets, java.nio.IntBuffer strides);
    
    @io.qt.QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @io.qt.QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    @io.qt.QtUninvokable
    public final void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha){
        glBlendEquationSeparatei_native_GLuint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, modeRGB, modeAlpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendEquationSeparatei_native_GLuint_GLenum_GLenum(long __this__nativeId, int buf, int modeRGB, int modeAlpha);
    
    @io.qt.QtUninvokable
    public final void glBlendEquationi(int buf, int mode){
        glBlendEquationi_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendEquationi_native_GLuint_GLenum(long __this__nativeId, int buf, int mode);
    
    @io.qt.QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    @io.qt.QtUninvokable
    public final void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);
    
    @io.qt.QtUninvokable
    public final void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha){
        glBlendFuncSeparatei_native_GLuint_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendFuncSeparatei_native_GLuint_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);
    
    @io.qt.QtUninvokable
    public final void glBlendFunci(int buf, int src, int dst){
        glBlendFunci_native_GLuint_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf, src, dst);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendFunci_native_GLuint_GLenum_GLenum(long __this__nativeId, int buf, int src, int dst);
    
    @io.qt.QtUninvokable
    public final void glBlitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter){
        glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    }
    
    @io.qt.QtUninvokable
    private native void glBlitFramebuffer_native_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLint_GLbitfield_GLenum(long __this__nativeId, int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter);
    
    @io.qt.QtUninvokable
    public final void glBufferData(int target, long size, java.nio.Buffer data, int usage){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glBufferData_native_GLenum_GLsizeiptr_const_void_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @io.qt.QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_void_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    @io.qt.QtUninvokable
    public final void glBufferStorage(int target, long size, java.nio.Buffer data, int flags){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glBufferStorage_native_GLenum_GLsizeiptr_const_void_ptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, flags);
    }
    
    @io.qt.QtUninvokable
    private native void glBufferStorage_native_GLenum_GLsizeiptr_const_void_ptr_GLbitfield(long __this__nativeId, int target, long size, java.nio.Buffer data, int flags);
    
    @io.qt.QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @io.qt.QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_void_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final int glCheckFramebufferStatus(int target){
        return glCheckFramebufferStatus_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native int glCheckFramebufferStatus_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glClampColor(int target, int clamp){
        glClampColor_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, clamp);
    }
    
    @io.qt.QtUninvokable
    private native void glClampColor_native_GLenum_GLenum(long __this__nativeId, int target, int clamp);
    
    @io.qt.QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glClearBufferData(int target, int internalformat, int format, int type, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glClearBufferData_native_GLenum_GLenum_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, format, type, data);
    }
    
    @io.qt.QtUninvokable
    private native void glClearBufferData_native_GLenum_GLenum_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, int format, int type, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glClearBufferSubData_native_GLenum_GLenum_GLintptr_GLsizeiptr_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, offset, size, format, type, data);
    }
    
    @io.qt.QtUninvokable
    private native void glClearBufferSubData_native_GLenum_GLenum_GLintptr_GLsizeiptr_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int internalformat, long offset, long size, int format, int type, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glClearBufferfi(int buffer, int drawbuffer, float depth, int stencil){
        glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, depth, stencil);
    }
    
    @io.qt.QtUninvokable
    private native void glClearBufferfi_native_GLenum_GLint_GLfloat_GLint(long __this__nativeId, int buffer, int drawbuffer, float depth, int stencil);
    
    @io.qt.QtUninvokable
    public final void glClearBufferfv(int buffer, int drawbuffer, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @io.qt.QtUninvokable
    private native void glClearBufferfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glClearBufferiv(int buffer, int drawbuffer, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @io.qt.QtUninvokable
    private native void glClearBufferiv_native_GLenum_GLint_const_GLint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glClearBufferuiv(int buffer, int drawbuffer, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, drawbuffer, value);
    }
    
    @io.qt.QtUninvokable
    private native void glClearBufferuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int buffer, int drawbuffer, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @io.qt.QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @io.qt.QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    @io.qt.QtUninvokable
    public final void glClearDepthf(float dd){
        glClearDepthf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), dd);
    }
    
    @io.qt.QtUninvokable
    private native void glClearDepthf_native_GLfloat(long __this__nativeId, float dd);
    
    @io.qt.QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @io.qt.QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    @io.qt.QtUninvokable
    public final void glClearTexImage(int texture, int level, int format, int type, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glClearTexImage_native_GLuint_GLint_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, format, type, data);
    }
    
    @io.qt.QtUninvokable
    private native void glClearTexImage_native_GLuint_GLint_GLenum_GLenum_const_void_ptr(long __this__nativeId, int texture, int level, int format, int type, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glClearTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }
    
    @io.qt.QtUninvokable
    private native void glClearTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final int glClientWaitSync(io.qt.gui.gl.GLsync sync, int flags, long timeout){
        return glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @io.qt.QtUninvokable
    private native int glClientWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    @io.qt.QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    @io.qt.QtUninvokable
    public final void glColorMaski(int index, boolean r, boolean g, boolean b, boolean a){
        glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), index, r, g, b, a);
    }
    
    @io.qt.QtUninvokable
    private native void glColorMaski_native_GLuint_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, int index, boolean r, boolean g, boolean b, boolean a);
    
    @io.qt.QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCopyBufferSubData(int readTarget, int writeTarget, long readOffset, long writeOffset, long size){
        glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), readTarget, writeTarget, readOffset, writeOffset, size);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyBufferSubData_native_GLenum_GLenum_GLintptr_GLintptr_GLsizeiptr(long __this__nativeId, int readTarget, int writeTarget, long readOffset, long writeOffset, long size);
    
    @io.qt.QtUninvokable
    public final void glCopyImageSubData(int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth){
        glCopyImageSubData_native_GLuint_GLenum_GLint_GLint_GLint_GLint_GLuint_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyImageSubData_native_GLuint_GLenum_GLint_GLint_GLint_GLint_GLuint_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(long __this__nativeId, int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth);
    
    @io.qt.QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    @io.qt.QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    @io.qt.QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    @io.qt.QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @io.qt.QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    @io.qt.QtUninvokable
    public final int glCreateShaderProgramv(int type, java.lang.String[] strings){
        return glCreateShaderProgramv_native_GLenum_GLsizei_const_GLchar_cptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, strings);
    }
    
    @io.qt.QtUninvokable
    private native int glCreateShaderProgramv_native_GLenum_GLsizei_const_GLchar_cptr_ptr(long __this__nativeId, int type, java.lang.String[] strings);
    
    @io.qt.QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glDebugMessageCallback(io.qt.gui.gl.GLDEBUGPROC callback){
        glDebugMessageCallback_native_GLDEBUGPROC_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), callback);
    }
    
    @io.qt.QtUninvokable
    private native void glDebugMessageCallback_native_GLDEBUGPROC_const_void_ptr(long __this__nativeId, io.qt.gui.gl.GLDEBUGPROC callback);
    
    @io.qt.QtUninvokable
    public final void glDebugMessageControl(int source, int type, int severity, int count, java.nio.IntBuffer ids, boolean enabled){
        java.util.Objects.requireNonNull(ids, "Argument 'ids': null not expected.");
        glDebugMessageControl_native_GLenum_GLenum_GLenum_GLsizei_const_GLuint_ptr_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), source, type, severity, count, ids, enabled);
    }
    
    @io.qt.QtUninvokable
    private native void glDebugMessageControl_native_GLenum_GLenum_GLenum_GLsizei_const_GLuint_ptr_GLboolean(long __this__nativeId, int source, int type, int severity, int count, java.nio.IntBuffer ids, boolean enabled);
    
    @io.qt.QtUninvokable
    public final void glDebugMessageInsert(int source, int type, int id, int severity, int length, java.nio.CharBuffer buf){
        java.util.Objects.requireNonNull(buf, "Argument 'buf': null not expected.");
        glDebugMessageInsert_native_GLenum_GLenum_GLuint_GLenum_GLsizei_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), source, type, id, severity, length, buf);
    }
    
    @io.qt.QtUninvokable
    private native void glDebugMessageInsert_native_GLenum_GLenum_GLuint_GLenum_GLsizei_const_GLchar_ptr(long __this__nativeId, int source, int type, int id, int severity, int length, java.nio.CharBuffer buf);
    
    @io.qt.QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.IntBuffer buffers){
        java.util.Objects.requireNonNull(buffers, "Argument 'buffers': null not expected.");
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    @io.qt.QtUninvokable
    public final void glDeleteFramebuffers(int n, java.nio.IntBuffer framebuffers){
        java.util.Objects.requireNonNull(framebuffers, "Argument 'framebuffers': null not expected.");
        glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    @io.qt.QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glDeleteProgramPipelines(int n, java.nio.IntBuffer pipelines){
        java.util.Objects.requireNonNull(pipelines, "Argument 'pipelines': null not expected.");
        glDeleteProgramPipelines_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, pipelines);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteProgramPipelines_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer pipelines);
    
    @io.qt.QtUninvokable
    public final void glDeleteQueries(int n, java.nio.IntBuffer ids){
        java.util.Objects.requireNonNull(ids, "Argument 'ids': null not expected.");
        glDeleteQueries_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteQueries_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @io.qt.QtUninvokable
    public final void glDeleteRenderbuffers(int n, java.nio.IntBuffer renderbuffers){
        java.util.Objects.requireNonNull(renderbuffers, "Argument 'renderbuffers': null not expected.");
        glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    @io.qt.QtUninvokable
    public final void glDeleteSamplers(int count, java.nio.IntBuffer samplers){
        java.util.Objects.requireNonNull(samplers, "Argument 'samplers': null not expected.");
        glDeleteSamplers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), count, samplers);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteSamplers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int count, java.nio.IntBuffer samplers);
    
    @io.qt.QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final void glDeleteSync(io.qt.gui.gl.GLsync sync){
        glDeleteSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    @io.qt.QtUninvokable
    public final void glDeleteTextures(int n, java.nio.IntBuffer textures){
        java.util.Objects.requireNonNull(textures, "Argument 'textures': null not expected.");
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    @io.qt.QtUninvokable
    public final void glDeleteTransformFeedbacks(int n, java.nio.IntBuffer ids){
        java.util.Objects.requireNonNull(ids, "Argument 'ids': null not expected.");
        glDeleteTransformFeedbacks_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteTransformFeedbacks_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @io.qt.QtUninvokable
    public final void glDeleteVertexArrays(int n, java.nio.IntBuffer arrays){
        java.util.Objects.requireNonNull(arrays, "Argument 'arrays': null not expected.");
        glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteVertexArrays_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    @io.qt.QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    @io.qt.QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    @io.qt.QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    @io.qt.QtUninvokable
    public final void glDepthRangeArrayv(int first, int count, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glDepthRangeArrayv_native_GLuint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthRangeArrayv_native_GLuint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int first, int count, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glDepthRangeIndexed(int index, double n, double f){
        glDepthRangeIndexed_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, n, f);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthRangeIndexed_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double n, double f);
    
    @io.qt.QtUninvokable
    public final void glDepthRangef(float n, float f){
        glDepthRangef_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), n, f);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthRangef_native_GLfloat_GLfloat(long __this__nativeId, float n, float f);
    
    @io.qt.QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @io.qt.QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    @io.qt.QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void glDisablei(int target, int index){
        glDisablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @io.qt.QtUninvokable
    private native void glDisablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    @io.qt.QtUninvokable
    public final void glDispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z){
        glDispatchCompute_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), num_groups_x, num_groups_y, num_groups_z);
    }
    
    @io.qt.QtUninvokable
    private native void glDispatchCompute_native_GLuint_GLuint_GLuint(long __this__nativeId, int num_groups_x, int num_groups_y, int num_groups_z);
    
    @io.qt.QtUninvokable
    public final void glDispatchComputeIndirect(long indirect){
        glDispatchComputeIndirect_native_GLintptr(QtJambi_LibraryUtilities.internal.nativeId(this), indirect);
    }
    
    @io.qt.QtUninvokable
    private native void glDispatchComputeIndirect_native_GLintptr(long __this__nativeId, long indirect);
    
    @io.qt.QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    @io.qt.QtUninvokable
    public final void glDrawArraysIndirect(int mode, java.nio.Buffer indirect){
        java.util.Objects.requireNonNull(indirect, "Argument 'indirect': null not expected.");
        glDrawArraysIndirect_native_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, indirect);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawArraysIndirect_native_GLenum_const_void_ptr(long __this__nativeId, int mode, java.nio.Buffer indirect);
    
    @io.qt.QtUninvokable
    public final void glDrawArraysInstanced(int mode, int first, int count, int instancecount){
        glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawArraysInstanced_native_GLenum_GLint_GLsizei_GLsizei(long __this__nativeId, int mode, int first, int count, int instancecount);
    
    @io.qt.QtUninvokable
    public final void glDrawArraysInstancedBaseInstance(int mode, int first, int count, int instancecount, int baseinstance){
        glDrawArraysInstancedBaseInstance_native_GLenum_GLint_GLsizei_GLsizei_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, instancecount, baseinstance);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawArraysInstancedBaseInstance_native_GLenum_GLint_GLsizei_GLsizei_GLuint(long __this__nativeId, int mode, int first, int count, int instancecount, int baseinstance);
    
    @io.qt.QtUninvokable
    public final void glDrawBuffer(int buf){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), buf);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int buf);
    
    @io.qt.QtUninvokable
    public final void glDrawBuffers(int n, java.nio.IntBuffer bufs){
        java.util.Objects.requireNonNull(bufs, "Argument 'bufs': null not expected.");
        glDrawBuffers_native_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, bufs);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawBuffers_native_GLsizei_const_GLenum_ptr(long __this__nativeId, int n, java.nio.IntBuffer bufs);
    
    @io.qt.QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.Buffer indices){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawElements_native_GLenum_GLsizei_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_void_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    @io.qt.QtUninvokable
    public final void glDrawElementsBaseVertex(int mode, int count, int type, java.nio.Buffer indices, int basevertex){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_void_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, basevertex);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElementsBaseVertex_native_GLenum_GLsizei_GLenum_const_void_ptr_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int basevertex);
    
    @io.qt.QtUninvokable
    public final void glDrawElementsIndirect(int mode, int type, java.nio.Buffer indirect){
        java.util.Objects.requireNonNull(indirect, "Argument 'indirect': null not expected.");
        glDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, type, indirect);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr(long __this__nativeId, int mode, int type, java.nio.Buffer indirect);
    
    @io.qt.QtUninvokable
    public final void glDrawElementsInstanced(int mode, int count, int type, java.nio.Buffer indices, int instancecount){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElementsInstanced_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount);
    
    @io.qt.QtUninvokable
    public final void glDrawElementsInstancedBaseInstance(int mode, int count, int type, java.nio.Buffer indices, int instancecount, int baseinstance){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawElementsInstancedBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, baseinstance);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElementsInstancedBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLuint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int baseinstance);
    
    @io.qt.QtUninvokable
    public final void glDrawElementsInstancedBaseVertex(int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, basevertex);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElementsInstancedBaseVertex_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex);
    
    @io.qt.QtUninvokable
    public final void glDrawElementsInstancedBaseVertexBaseInstance(int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex, int baseinstance){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawElementsInstancedBaseVertexBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, instancecount, basevertex, baseinstance);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElementsInstancedBaseVertexBaseInstance_native_GLenum_GLsizei_GLenum_const_void_ptr_GLsizei_GLint_GLuint(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices, int instancecount, int basevertex, int baseinstance);
    
    @io.qt.QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.Buffer indices){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_void_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    @io.qt.QtUninvokable
    public final void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, java.nio.Buffer indices, int basevertex){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_void_ptr_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices, basevertex);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawRangeElementsBaseVertex_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_void_ptr_GLint(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices, int basevertex);
    
    @io.qt.QtUninvokable
    public final void glDrawTransformFeedback(int mode, int id){
        glDrawTransformFeedback_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawTransformFeedback_native_GLenum_GLuint(long __this__nativeId, int mode, int id);
    
    @io.qt.QtUninvokable
    public final void glDrawTransformFeedbackInstanced(int mode, int id, int instancecount){
        glDrawTransformFeedbackInstanced_native_GLenum_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, instancecount);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawTransformFeedbackInstanced_native_GLenum_GLuint_GLsizei(long __this__nativeId, int mode, int id, int instancecount);
    
    @io.qt.QtUninvokable
    public final void glDrawTransformFeedbackStream(int mode, int id, int stream){
        glDrawTransformFeedbackStream_native_GLenum_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, stream);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawTransformFeedbackStream_native_GLenum_GLuint_GLuint(long __this__nativeId, int mode, int id, int stream);
    
    @io.qt.QtUninvokable
    public final void glDrawTransformFeedbackStreamInstanced(int mode, int id, int stream, int instancecount){
        glDrawTransformFeedbackStreamInstanced_native_GLenum_GLuint_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, id, stream, instancecount);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawTransformFeedbackStreamInstanced_native_GLenum_GLuint_GLuint_GLsizei(long __this__nativeId, int mode, int id, int stream, int instancecount);
    
    @io.qt.QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void glEnablei(int target, int index){
        glEnablei_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @io.qt.QtUninvokable
    private native void glEnablei_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    @io.qt.QtUninvokable
    public final void glEndConditionalRender(){
        glEndConditionalRender_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glEndConditionalRender_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glEndQuery(int target){
        glEndQuery_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native void glEndQuery_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glEndQueryIndexed(int target, int index){
        glEndQueryIndexed_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @io.qt.QtUninvokable
    private native void glEndQueryIndexed_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    @io.qt.QtUninvokable
    public final void glEndTransformFeedback(){
        glEndTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glEndTransformFeedback_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.gui.gl.GLsync glFenceSync(int condition, int flags){
        return glFenceSync_native_GLenum_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), condition, flags);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.gl.GLsync glFenceSync_native_GLenum_GLbitfield(long __this__nativeId, int condition, int flags);
    
    @io.qt.QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glFlushMappedBufferRange(int target, long offset, long length){
        glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, length);
    }
    
    @io.qt.QtUninvokable
    private native void glFlushMappedBufferRange_native_GLenum_GLintptr_GLsizeiptr(long __this__nativeId, int target, long offset, long length);
    
    @io.qt.QtUninvokable
    public final void glFramebufferParameteri(int target, int pname, int param){
        glFramebufferParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer){
        glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, renderbuffertarget, renderbuffer);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(long __this__nativeId, int target, int attachment, int renderbuffertarget, int renderbuffer);
    
    @io.qt.QtUninvokable
    public final void glFramebufferTexture(int target, int attachment, int texture, int level){
        glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferTexture_native_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int texture, int level);
    
    @io.qt.QtUninvokable
    public final void glFramebufferTexture1D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferTexture1D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    @io.qt.QtUninvokable
    public final void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    @io.qt.QtUninvokable
    public final void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset){
        glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level, zoffset);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferTexture3D_native_GLenum_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level, int zoffset);
    
    @io.qt.QtUninvokable
    public final void glFramebufferTextureLayer(int target, int attachment, int texture, int level, int layer){
        glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, texture, level, layer);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferTextureLayer_native_GLenum_GLenum_GLuint_GLint_GLint(long __this__nativeId, int target, int attachment, int texture, int level, int layer);
    
    @io.qt.QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glGenBuffers(int n, java.nio.IntBuffer buffers){
        java.util.Objects.requireNonNull(buffers, "Argument 'buffers': null not expected.");
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @io.qt.QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    @io.qt.QtUninvokable
    public final void glGenFramebuffers(int n, java.nio.IntBuffer framebuffers){
        java.util.Objects.requireNonNull(framebuffers, "Argument 'framebuffers': null not expected.");
        glGenFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @io.qt.QtUninvokable
    private native void glGenFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    @io.qt.QtUninvokable
    public final void glGenProgramPipelines(int n, java.nio.IntBuffer pipelines){
        java.util.Objects.requireNonNull(pipelines, "Argument 'pipelines': null not expected.");
        glGenProgramPipelines_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, pipelines);
    }
    
    @io.qt.QtUninvokable
    private native void glGenProgramPipelines_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer pipelines);
    
    @io.qt.QtUninvokable
    public final void glGenQueries(int n, java.nio.IntBuffer ids){
        java.util.Objects.requireNonNull(ids, "Argument 'ids': null not expected.");
        glGenQueries_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @io.qt.QtUninvokable
    private native void glGenQueries_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @io.qt.QtUninvokable
    public final void glGenRenderbuffers(int n, java.nio.IntBuffer renderbuffers){
        java.util.Objects.requireNonNull(renderbuffers, "Argument 'renderbuffers': null not expected.");
        glGenRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @io.qt.QtUninvokable
    private native void glGenRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    @io.qt.QtUninvokable
    public final void glGenSamplers(int count, java.nio.IntBuffer samplers){
        java.util.Objects.requireNonNull(samplers, "Argument 'samplers': null not expected.");
        glGenSamplers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), count, samplers);
    }
    
    @io.qt.QtUninvokable
    private native void glGenSamplers_native_GLsizei_GLuint_ptr(long __this__nativeId, int count, java.nio.IntBuffer samplers);
    
    @io.qt.QtUninvokable
    public final void glGenTextures(int n, java.nio.IntBuffer textures){
        java.util.Objects.requireNonNull(textures, "Argument 'textures': null not expected.");
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @io.qt.QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    @io.qt.QtUninvokable
    public final void glGenTransformFeedbacks(int n, java.nio.IntBuffer ids){
        java.util.Objects.requireNonNull(ids, "Argument 'ids': null not expected.");
        glGenTransformFeedbacks_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @io.qt.QtUninvokable
    private native void glGenTransformFeedbacks_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @io.qt.QtUninvokable
    public final void glGenVertexArrays(int n, java.nio.IntBuffer arrays){
        java.util.Objects.requireNonNull(arrays, "Argument 'arrays': null not expected.");
        glGenVertexArrays_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, arrays);
    }
    
    @io.qt.QtUninvokable
    private native void glGenVertexArrays_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer arrays);
    
    @io.qt.QtUninvokable
    public final void glGenerateMipmap(int target){
        glGenerateMipmap_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native void glGenerateMipmap_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glGetActiveAtomicCounterBufferiv(int program, int bufferIndex, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetActiveAtomicCounterBufferiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufferIndex, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveAtomicCounterBufferiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int bufferIndex, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(size, "Argument 'size': null not expected.");
        java.util.Objects.requireNonNull(type, "Argument 'type': null not expected.");
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glGetActiveSubroutineName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, bufsize, length, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveSubroutineName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glGetActiveSubroutineUniformName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, bufsize, length, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveSubroutineUniformName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int shadertype, int index, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, java.nio.IntBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glGetActiveSubroutineUniformiv_native_GLuint_GLenum_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, index, pname, values);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveSubroutineUniformiv_native_GLuint_GLenum_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int shadertype, int index, int pname, java.nio.IntBuffer values);
    
    @io.qt.QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(size, "Argument 'size': null not expected.");
        java.util.Objects.requireNonNull(type, "Argument 'type': null not expected.");
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetActiveUniformBlockName(int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(uniformBlockName, "Argument 'uniformBlockName': null not expected.");
        glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, bufSize, length, uniformBlockName);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveUniformBlockName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformBlockIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformBlockName);
    
    @io.qt.QtUninvokable
    public final void glGetActiveUniformBlockiv(int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveUniformBlockiv_native_GLuint_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformBlockIndex, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetActiveUniformName(int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(uniformName, "Argument 'uniformName': null not expected.");
        glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformIndex, bufSize, length, uniformName);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveUniformName_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int uniformIndex, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer uniformName);
    
    @io.qt.QtUninvokable
    public final void glGetActiveUniformsiv(int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(uniformIndices, "Argument 'uniformIndices': null not expected.");
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformCount, uniformIndices, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveUniformsiv_native_GLuint_GLsizei_const_GLuint_ptr_GLenum_GLint_ptr(long __this__nativeId, int program, int uniformCount, java.nio.IntBuffer uniformIndices, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetAttachedShaders(int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer shaders){
        java.util.Objects.requireNonNull(count, "Argument 'count': null not expected.");
        java.util.Objects.requireNonNull(shaders, "Argument 'shaders': null not expected.");
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxCount, count, shaders);
    }
    
    @io.qt.QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer shaders);
    
    @io.qt.QtUninvokable
    public final int glGetAttribLocation(int program, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetBooleani_v(int target, int index, java.nio.IntBuffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBooleani_v_native_GLenum_GLuint_GLboolean_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    @io.qt.QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        if(data.length < 1)
            throw new IllegalArgumentException("Argument 'data': Wrong number of elements in array. Found: " + data.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] data);
    
    @io.qt.QtUninvokable
    public final void glGetBufferParameteri64v(int target, int pname, java.nio.LongBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBufferParameteri64v_native_GLenum_GLenum_GLint64_ptr(long __this__nativeId, int target, int pname, java.nio.LongBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetBufferPointerv(int target, int pname, java.nio.Buffer[] params){
        glGetBufferPointerv_native_GLenum_GLenum_void_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBufferPointerv_native_GLenum_GLenum_void_ptr_ptr(long __this__nativeId, int target, int pname, java.nio.Buffer[] params);
    
    @io.qt.QtUninvokable
    public final void glGetBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_void_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.Buffer img){
        java.util.Objects.requireNonNull(img, "Argument 'img': null not expected.");
        glGetCompressedTexImage_native_GLenum_GLint_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @io.qt.QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_void_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    @io.qt.QtUninvokable
    public final int glGetDebugMessageLog(int[] sources, int[] types, int[] ids, int[] severities, java.lang.String[] messageLog){
        java.util.Objects.requireNonNull(sources, "Argument 'sources': null not expected.");
        if(sources.length < 1)
            throw new IllegalArgumentException("Argument 'sources': Wrong number of elements in array. Found: " + sources.length + ", expected: 1");
        java.util.Objects.requireNonNull(types, "Argument 'types': null not expected.");
        if(types.length < 1)
            throw new IllegalArgumentException("Argument 'types': Wrong number of elements in array. Found: " + types.length + ", expected: 1");
        java.util.Objects.requireNonNull(ids, "Argument 'ids': null not expected.");
        if(ids.length < 1)
            throw new IllegalArgumentException("Argument 'ids': Wrong number of elements in array. Found: " + ids.length + ", expected: 1");
        java.util.Objects.requireNonNull(severities, "Argument 'severities': null not expected.");
        if(severities.length < 1)
            throw new IllegalArgumentException("Argument 'severities': Wrong number of elements in array. Found: " + severities.length + ", expected: 1");
        return glGetDebugMessageLog_native_GLuint_GLsizei_GLenum_ptr_GLenum_ptr_GLuint_ptr_GLenum_ptr_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sources, types, ids, severities, messageLog);
    }
    
    @io.qt.QtUninvokable
    private native int glGetDebugMessageLog_native_GLuint_GLsizei_GLenum_ptr_GLenum_ptr_GLuint_ptr_GLenum_ptr_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int[] sources, int[] types, int[] ids, int[] severities, java.lang.String[] messageLog);
    
    @io.qt.QtUninvokable
    public final void glGetDoublei_v(int target, int index, java.nio.DoubleBuffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glGetDoublei_v_native_GLenum_GLuint_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetDoublei_v_native_GLenum_GLuint_GLdouble_ptr(long __this__nativeId, int target, int index, java.nio.DoubleBuffer data);
    
    @io.qt.QtUninvokable
    public final void glGetDoublev(int pname, double[] data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        if(data.length < 1)
            throw new IllegalArgumentException("Argument 'data': Wrong number of elements in array. Found: " + data.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] data);
    
    @io.qt.QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glGetFloati_v(int target, int index, java.nio.FloatBuffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glGetFloati_v_native_GLenum_GLuint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetFloati_v_native_GLenum_GLuint_GLfloat_ptr(long __this__nativeId, int target, int index, java.nio.FloatBuffer data);
    
    @io.qt.QtUninvokable
    public final void glGetFloatv(int pname, float[] data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        if(data.length < 1)
            throw new IllegalArgumentException("Argument 'data': Wrong number of elements in array. Found: " + data.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] data);
    
    @io.qt.QtUninvokable
    public final int glGetFragDataIndex(int program, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetFragDataIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetFragDataIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final int glGetFragDataLocation(int program, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetFragDataLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetFragDataLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int attachment, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetFramebufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetFramebufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetFramebufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetInteger64i_v(int target, int index, java.nio.LongBuffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetInteger64i_v_native_GLenum_GLuint_GLint64_ptr(long __this__nativeId, int target, int index, java.nio.LongBuffer data);
    
    @io.qt.QtUninvokable
    public final void glGetInteger64v(int pname, java.nio.LongBuffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glGetInteger64v_native_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetInteger64v_native_GLenum_GLint64_ptr(long __this__nativeId, int pname, java.nio.LongBuffer data);
    
    @io.qt.QtUninvokable
    public final void glGetIntegeri_v(int target, int index, java.nio.IntBuffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetIntegeri_v_native_GLenum_GLuint_GLint_ptr(long __this__nativeId, int target, int index, java.nio.IntBuffer data);
    
    @io.qt.QtUninvokable
    public final void glGetIntegerv(int pname, int[] data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        if(data.length < 1)
            throw new IllegalArgumentException("Argument 'data': Wrong number of elements in array. Found: " + data.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] data);
    
    @io.qt.QtUninvokable
    public final void glGetInternalformati64v(int target, int internalformat, int pname, int bufSize, java.nio.LongBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetInternalformati64v_native_GLenum_GLenum_GLenum_GLsizei_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, pname, bufSize, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetInternalformati64v_native_GLenum_GLenum_GLenum_GLsizei_GLint64_ptr(long __this__nativeId, int target, int internalformat, int pname, int bufSize, java.nio.LongBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetInternalformativ(int target, int internalformat, int pname, int bufSize, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetInternalformativ_native_GLenum_GLenum_GLenum_GLsizei_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, pname, bufSize, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetInternalformativ_native_GLenum_GLenum_GLenum_GLsizei_GLint_ptr(long __this__nativeId, int target, int internalformat, int pname, int bufSize, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetMultisamplefv(int pname, int index, java.nio.FloatBuffer val){
        java.util.Objects.requireNonNull(val, "Argument 'val': null not expected.");
        glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, index, val);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMultisamplefv_native_GLenum_GLuint_GLfloat_ptr(long __this__nativeId, int pname, int index, java.nio.FloatBuffer val);
    
    @io.qt.QtUninvokable
    public final void glGetObjectLabel(int identifier, int name, java.lang.String[] label){
        if (label.length < 1)
            throw new IllegalArgumentException("Argument 'label': Wrong number of elements in array. Found: 0, expected: 1");
        glGetObjectLabel_native_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, name, label);
    }
    
    @io.qt.QtUninvokable
    private native void glGetObjectLabel_native_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int identifier, int name, java.lang.String[] label);
    
    @io.qt.QtUninvokable
    public final void glGetObjectPtrLabel(io.qt.gui.gl.GLsync ptr, java.lang.String[] label){
        if (label.length < 1)
            throw new IllegalArgumentException("Argument 'label': Wrong number of elements in array. Found: 0, expected: 1");
        java.util.Objects.requireNonNull(ptr, "Argument 'ptr': null not expected.");
        glGetObjectPtrLabel_native_const_void_ptr_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), ptr, label);
    }
    
    @io.qt.QtUninvokable
    private native void glGetObjectPtrLabel_native_const_void_ptr_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, io.qt.gui.gl.GLsync ptr, java.lang.String[] label);
    
    @io.qt.QtUninvokable
    public final void glGetProgramBinary(int program, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer binaryFormat, java.nio.Buffer binary){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(binaryFormat, "Argument 'binaryFormat': null not expected.");
        java.util.Objects.requireNonNull(binary, "Argument 'binary': null not expected.");
        glGetProgramBinary_native_GLuint_GLsizei_GLsizei_ptr_GLenum_ptr_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, binaryFormat, binary);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramBinary_native_GLuint_GLsizei_GLsizei_ptr_GLenum_ptr_void_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer binaryFormat, java.nio.Buffer binary);
    
    @io.qt.QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(infoLog, "Argument 'infoLog': null not expected.");
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, infoLog);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    @io.qt.QtUninvokable
    public final void glGetProgramInterfaceiv(int program, int programInterface, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetProgramInterfaceiv_native_GLuint_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramInterfaceiv_native_GLuint_GLenum_GLenum_GLint_ptr(long __this__nativeId, int program, int programInterface, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetProgramPipelineInfoLog(int pipeline, java.lang.String[] infoLog){
        if (infoLog.length < 1)
            throw new IllegalArgumentException("Argument 'infoLog': Wrong number of elements in array. Found: 0, expected: 1");
        glGetProgramPipelineInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, infoLog);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramPipelineInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int pipeline, java.lang.String[] infoLog);
    
    @io.qt.QtUninvokable
    public final void glGetProgramPipelineiv(int pipeline, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetProgramPipelineiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramPipelineiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int pipeline, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final int glGetProgramResourceIndex(int program, int programInterface, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetProgramResourceIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetProgramResourceIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final int glGetProgramResourceLocation(int program, int programInterface, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetProgramResourceLocation_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetProgramResourceLocation_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final int glGetProgramResourceLocationIndex(int program, int programInterface, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetProgramResourceLocationIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetProgramResourceLocationIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int programInterface, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetProgramResourceName(int program, int programInterface, int index, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        glGetProgramResourceName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, index, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramResourceName_native_GLuint_GLenum_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int programInterface, int index, java.lang.String[] name);
    
    @io.qt.QtUninvokable
    public final void glGetProgramResourceiv(int program, int programInterface, int index, int propCount, java.nio.IntBuffer props, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(props, "Argument 'props': null not expected.");
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetProgramResourceiv_native_GLuint_GLenum_GLuint_GLsizei_const_GLenum_ptr_GLsizei_GLsizei_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, programInterface, index, propCount, props, bufSize, length, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramResourceiv_native_GLuint_GLenum_GLuint_GLsizei_const_GLenum_ptr_GLsizei_GLsizei_ptr_GLint_ptr(long __this__nativeId, int program, int programInterface, int index, int propCount, java.nio.IntBuffer props, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetProgramStageiv(int program, int shadertype, int pname, java.nio.IntBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glGetProgramStageiv_native_GLuint_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, pname, values);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramStageiv_native_GLuint_GLenum_GLenum_GLint_ptr(long __this__nativeId, int program, int shadertype, int pname, java.nio.IntBuffer values);
    
    @io.qt.QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryIndexediv(int target, int index, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryIndexediv_native_GLenum_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryIndexediv_native_GLenum_GLuint_GLenum_GLint_ptr(long __this__nativeId, int target, int index, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryObjecti64v(int id, int pname, java.nio.LongBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryObjecti64v_native_GLuint_GLenum_GLint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryObjecti64v_native_GLuint_GLenum_GLint64_ptr(long __this__nativeId, int id, int pname, java.nio.LongBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryObjectiv(int id, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryObjectui64v(int id, int pname, java.nio.LongBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryObjectui64v_native_GLuint_GLenum_GLuint64_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryObjectui64v_native_GLuint_GLenum_GLuint64_ptr(long __this__nativeId, int id, int pname, java.nio.LongBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryObjectuiv(int id, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryiv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetRenderbufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetSamplerParameterIiv(int sampler, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetSamplerParameterIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetSamplerParameterIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetSamplerParameterIuiv(int sampler, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetSamplerParameterIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetSamplerParameterIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetSamplerParameterfv(int sampler, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetSamplerParameterfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetSamplerParameterfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int sampler, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetSamplerParameteriv(int sampler, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetSamplerParameteriv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetSamplerParameteriv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(infoLog, "Argument 'infoLog': null not expected.");
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, infoLog);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    @io.qt.QtUninvokable
    public final void glGetShaderPrecisionFormat(int shadertype, int precisiontype, java.nio.IntBuffer range, java.nio.IntBuffer precision){
        java.util.Objects.requireNonNull(range, "Argument 'range': null not expected.");
        java.util.Objects.requireNonNull(precision, "Argument 'precision': null not expected.");
        glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, precisiontype, range, precision);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(long __this__nativeId, int shadertype, int precisiontype, java.nio.IntBuffer range, java.nio.IntBuffer precision);
    
    @io.qt.QtUninvokable
    public final void glGetShaderSource(int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(source, "Argument 'source': null not expected.");
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, source);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    @io.qt.QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final java.lang.String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String glGetString_native_GLenum(long __this__nativeId, int name);
    
    @io.qt.QtUninvokable
    public final java.lang.String glGetStringi(int name, int index){
        return glGetStringi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name, index);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String glGetStringi_native_GLenum_GLuint(long __this__nativeId, int name, int index);
    
    @io.qt.QtUninvokable
    public final int glGetSubroutineIndex(int program, int shadertype, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetSubroutineIndex_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetSubroutineIndex_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int shadertype, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final int glGetSubroutineUniformLocation(int program, int shadertype, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetSubroutineUniformLocation_native_GLuint_GLenum_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, shadertype, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetSubroutineUniformLocation_native_GLuint_GLenum_const_GLchar_ptr(long __this__nativeId, int program, int shadertype, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetSynciv(io.qt.gui.gl.GLsync sync, int pname, int[] length, java.nio.IntBuffer values){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        if(length.length < 1)
            throw new IllegalArgumentException("Argument 'length': Wrong number of elements in array. Found: " + length.length + ", expected: 1");
        glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), pname, length, values);
    }
    
    @io.qt.QtUninvokable
    private native void glGetSynciv_native___GLsync_ptr_GLenum_GLsizei_GLsizei_ptr_GLint_ptr(long __this__nativeId, long sync, int pname, int[] length, java.nio.IntBuffer values);
    
    @io.qt.QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_void_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexParameterIiv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexParameterIiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexParameterIuiv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexParameterIuiv_native_GLenum_GLenum_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTransformFeedbackVarying(int program, int index, int[] size, int[] type, java.lang.String[] name){
        if (name.length < 1)
            throw new IllegalArgumentException("Argument 'name': Wrong number of elements in array. Found: 0, expected: 1");
        java.util.Objects.requireNonNull(size, "Argument 'size': null not expected.");
        if(size.length < 1)
            throw new IllegalArgumentException("Argument 'size': Wrong number of elements in array. Found: " + size.length + ", expected: 1");
        java.util.Objects.requireNonNull(type, "Argument 'type': null not expected.");
        if(type.length < 1)
            throw new IllegalArgumentException("Argument 'type': Wrong number of elements in array. Found: " + type.length + ", expected: 1");
        glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, size, type, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTransformFeedbackVarying_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLsizei_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int[] size, int[] type, java.lang.String[] name);
    
    @io.qt.QtUninvokable
    public final int glGetUniformBlockIndex(int program, java.nio.CharBuffer uniformBlockName){
        java.util.Objects.requireNonNull(uniformBlockName, "Argument 'uniformBlockName': null not expected.");
        return glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockName);
    }
    
    @io.qt.QtUninvokable
    private native int glGetUniformBlockIndex_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer uniformBlockName);
    
    @io.qt.QtUninvokable
    public final void glGetUniformIndices(int program, java.lang.String[] uniformNames, int[] uniformIndices){
        java.util.Objects.requireNonNull(uniformIndices, "Argument 'uniformIndices': null not expected.");
        glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformNames, uniformIndices);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformIndices_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLuint_ptr(long __this__nativeId, int program, java.lang.String[] uniformNames, int[] uniformIndices);
    
    @io.qt.QtUninvokable
    public final int glGetUniformLocation(int program, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetUniformSubroutineuiv(int shadertype, int location, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetUniformSubroutineuiv_native_GLenum_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformSubroutineuiv_native_GLenum_GLint_GLuint_ptr(long __this__nativeId, int shadertype, int location, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetUniformdv(int program, int location, java.nio.DoubleBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetUniformdv_native_GLuint_GLint_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformdv_native_GLuint_GLint_GLdouble_ptr(long __this__nativeId, int program, int location, java.nio.DoubleBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetUniformuiv(int program, int location, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformuiv_native_GLuint_GLint_GLuint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribIiv(int index, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribIiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribIuiv(int index, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribIuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribLdv(int index, int pname, java.nio.DoubleBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribLdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribLdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_void_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_void_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribdv(int index, int pname, java.nio.DoubleBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    @io.qt.QtUninvokable
    public final void glInvalidateBufferData(int buffer){
        glInvalidateBufferData_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @io.qt.QtUninvokable
    private native void glInvalidateBufferData_native_GLuint(long __this__nativeId, int buffer);
    
    @io.qt.QtUninvokable
    public final void glInvalidateBufferSubData(int buffer, long offset, long length){
        glInvalidateBufferSubData_native_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer, offset, length);
    }
    
    @io.qt.QtUninvokable
    private native void glInvalidateBufferSubData_native_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int buffer, long offset, long length);
    
    @io.qt.QtUninvokable
    public final void glInvalidateFramebuffer(int target, int numAttachments, java.nio.IntBuffer attachments){
        java.util.Objects.requireNonNull(attachments, "Argument 'attachments': null not expected.");
        glInvalidateFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, numAttachments, attachments);
    }
    
    @io.qt.QtUninvokable
    private native void glInvalidateFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr(long __this__nativeId, int target, int numAttachments, java.nio.IntBuffer attachments);
    
    @io.qt.QtUninvokable
    public final void glInvalidateSubFramebuffer(int target, int numAttachments, java.nio.IntBuffer attachments, int x, int y, int width, int height){
        java.util.Objects.requireNonNull(attachments, "Argument 'attachments': null not expected.");
        glInvalidateSubFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, numAttachments, attachments, x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glInvalidateSubFramebuffer_native_GLenum_GLsizei_const_GLenum_ptr_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int numAttachments, java.nio.IntBuffer attachments, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glInvalidateTexImage(int texture, int level){
        glInvalidateTexImage_native_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level);
    }
    
    @io.qt.QtUninvokable
    private native void glInvalidateTexImage_native_GLuint_GLint(long __this__nativeId, int texture, int level);
    
    @io.qt.QtUninvokable
    public final void glInvalidateTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth){
        glInvalidateTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), texture, level, xoffset, yoffset, zoffset, width, height, depth);
    }
    
    @io.qt.QtUninvokable
    private native void glInvalidateTexSubImage_native_GLuint_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei(long __this__nativeId, int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth);
    
    @io.qt.QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    @io.qt.QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final boolean glIsEnabledi(int target, int index){
        return glIsEnabledi_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, index);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsEnabledi_native_GLenum_GLuint(long __this__nativeId, int target, int index);
    
    @io.qt.QtUninvokable
    public final boolean glIsFramebuffer(int framebuffer){
        return glIsFramebuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsFramebuffer_native_GLuint(long __this__nativeId, int framebuffer);
    
    @io.qt.QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final boolean glIsProgramPipeline(int pipeline){
        return glIsProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    @io.qt.QtUninvokable
    public final boolean glIsQuery(int id){
        return glIsQuery_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsQuery_native_GLuint(long __this__nativeId, int id);
    
    @io.qt.QtUninvokable
    public final boolean glIsRenderbuffer(int renderbuffer){
        return glIsRenderbuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsRenderbuffer_native_GLuint(long __this__nativeId, int renderbuffer);
    
    @io.qt.QtUninvokable
    public final boolean glIsSampler(int sampler){
        return glIsSampler_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), sampler);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsSampler_native_GLuint(long __this__nativeId, int sampler);
    
    @io.qt.QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final boolean glIsSync(io.qt.gui.gl.GLsync sync){
        return glIsSync_native___GLsync_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync));
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsSync_native___GLsync_ptr(long __this__nativeId, long sync);
    
    @io.qt.QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    @io.qt.QtUninvokable
    public final boolean glIsTransformFeedback(int id){
        return glIsTransformFeedback_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsTransformFeedback_native_GLuint(long __this__nativeId, int id);
    
    @io.qt.QtUninvokable
    public final boolean glIsVertexArray(int array){
        return glIsVertexArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsVertexArray_native_GLuint(long __this__nativeId, int array);
    
    @io.qt.QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @io.qt.QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    @io.qt.QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @io.qt.QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    @io.qt.QtUninvokable
    public final java.nio.Buffer glMapBuffer(int target, int access){
        return glMapBuffer_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, access);
    }
    
    @io.qt.QtUninvokable
    private native java.nio.Buffer glMapBuffer_native_GLenum_GLenum(long __this__nativeId, int target, int access);
    
    @io.qt.QtUninvokable
    public final java.nio.Buffer glMapBufferRange(int target, long offset, int access){
        return glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, access);
    }
    
    @io.qt.QtUninvokable
    private native java.nio.Buffer glMapBufferRange_native_GLenum_GLintptr_GLsizeiptr_GLbitfield(long __this__nativeId, int target, long offset, int access);
    
    @io.qt.QtUninvokable
    public final void glMemoryBarrier(int barriers){
        glMemoryBarrier_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), barriers);
    }
    
    @io.qt.QtUninvokable
    private native void glMemoryBarrier_native_GLbitfield(long __this__nativeId, int barriers);
    
    @io.qt.QtUninvokable
    public final void glMinSampleShading(float value){
        glMinSampleShading_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    @io.qt.QtUninvokable
    private native void glMinSampleShading_native_GLfloat(long __this__nativeId, float value);
    
    @io.qt.QtUninvokable
    public final void glMultiDrawArrays(int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount){
        java.util.Objects.requireNonNull(first, "Argument 'first': null not expected.");
        java.util.Objects.requireNonNull(count, "Argument 'count': null not expected.");
        glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, drawcount);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount);
    
    @io.qt.QtUninvokable
    public final void glMultiDrawArraysIndirect(int mode, java.nio.Buffer indirect, int drawcount, int stride){
        java.util.Objects.requireNonNull(indirect, "Argument 'indirect': null not expected.");
        glMultiDrawArraysIndirect_native_GLenum_const_void_ptr_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, indirect, drawcount, stride);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiDrawArraysIndirect_native_GLenum_const_void_ptr_GLsizei_GLsizei(long __this__nativeId, int mode, java.nio.Buffer indirect, int drawcount, int stride);
    
    @io.qt.QtUninvokable
    public final void glMultiDrawElements(int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount){
        java.util.Objects.requireNonNull(count, "Argument 'count': null not expected.");
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_void_cptr_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_void_cptr_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount);
    
    @io.qt.QtUninvokable
    public final void glMultiDrawElementsBaseVertex(int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount, java.nio.IntBuffer basevertex){
        java.util.Objects.requireNonNull(count, "Argument 'count': null not expected.");
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        java.util.Objects.requireNonNull(basevertex, "Argument 'basevertex': null not expected.");
        glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_void_cptr_ptr_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount, basevertex);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiDrawElementsBaseVertex_native_GLenum_const_GLsizei_ptr_GLenum_const_void_cptr_ptr_GLsizei_const_GLint_ptr(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount, java.nio.IntBuffer basevertex);
    
    @io.qt.QtUninvokable
    public final void glMultiDrawElementsIndirect(int mode, int type, java.nio.Buffer indirect, int drawcount, int stride){
        java.util.Objects.requireNonNull(indirect, "Argument 'indirect': null not expected.");
        glMultiDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, type, indirect, drawcount, stride);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiDrawElementsIndirect_native_GLenum_GLenum_const_void_ptr_GLsizei_GLsizei(long __this__nativeId, int mode, int type, java.nio.Buffer indirect, int drawcount, int stride);
    
    @io.qt.QtUninvokable
    public final void glObjectLabel(int identifier, int name, int length, java.nio.CharBuffer label){
        java.util.Objects.requireNonNull(label, "Argument 'label': null not expected.");
        glObjectLabel_native_GLenum_GLuint_GLsizei_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), identifier, name, length, label);
    }
    
    @io.qt.QtUninvokable
    private native void glObjectLabel_native_GLenum_GLuint_GLsizei_const_GLchar_ptr(long __this__nativeId, int identifier, int name, int length, java.nio.CharBuffer label);
    
    @io.qt.QtUninvokable
    public final void glObjectPtrLabel(io.qt.gui.gl.GLsync ptr, java.lang.String label){
        java.util.Objects.requireNonNull(ptr, "Argument 'ptr': null not expected.");
        glObjectPtrLabel_native_const_void_ptr_GLsizei_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), ptr, label);
    }
    
    @io.qt.QtUninvokable
    private native void glObjectPtrLabel_native_const_void_ptr_GLsizei_const_GLchar_ptr(long __this__nativeId, io.qt.gui.gl.GLsync ptr, java.lang.String label);
    
    @io.qt.QtUninvokable
    public final void glPatchParameterfv(int pname, java.nio.FloatBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glPatchParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, values);
    }
    
    @io.qt.QtUninvokable
    private native void glPatchParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer values);
    
    @io.qt.QtUninvokable
    public final void glPatchParameteri(int pname, int value){
        glPatchParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, value);
    }
    
    @io.qt.QtUninvokable
    private native void glPatchParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int value);
    
    @io.qt.QtUninvokable
    public final void glPauseTransformFeedback(){
        glPauseTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glPauseTransformFeedback_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glPointParameterf(int pname, float param){
        glPointParameterf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPointParameterf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glPointParameterfv(int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glPointParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glPointParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glPointParameteri(int pname, int param){
        glPointParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPointParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glPointParameteriv(int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glPointParameteriv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glPointParameteriv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @io.qt.QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    @io.qt.QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    @io.qt.QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @io.qt.QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    @io.qt.QtUninvokable
    public final void glPopDebugGroup(){
        glPopDebugGroup_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glPopDebugGroup_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glPrimitiveRestartIndex(int index){
        glPrimitiveRestartIndex_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void glPrimitiveRestartIndex_native_GLuint(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void glProgramBinary(int program, int binaryFormat, java.nio.Buffer binary, int length){
        java.util.Objects.requireNonNull(binary, "Argument 'binary': null not expected.");
        glProgramBinary_native_GLuint_GLenum_const_void_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), program, binaryFormat, binary, length);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramBinary_native_GLuint_GLenum_const_void_ptr_GLsizei(long __this__nativeId, int program, int binaryFormat, java.nio.Buffer binary, int length);
    
    @io.qt.QtUninvokable
    public final void glProgramParameteri(int program, int pname, int value){
        glProgramParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int program, int pname, int value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform1d(int program, int location, double v0){
        glProgramUniform1d_native_GLuint_GLint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform1d_native_GLuint_GLint_GLdouble(long __this__nativeId, int program, int location, double v0);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform1dv(int program, int location, int count, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform1dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform1dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform1f(int program, int location, float v0){
        glProgramUniform1f_native_GLuint_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform1f_native_GLuint_GLint_GLfloat(long __this__nativeId, int program, int location, float v0);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform1fv(int program, int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform1fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform1fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform1i(int program, int location, int v0){
        glProgramUniform1i_native_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform1i_native_GLuint_GLint_GLint(long __this__nativeId, int program, int location, int v0);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform1iv(int program, int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform1iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform1iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform1ui(int program, int location, int v0){
        glProgramUniform1ui_native_GLuint_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform1ui_native_GLuint_GLint_GLuint(long __this__nativeId, int program, int location, int v0);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform1uiv(int program, int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform1uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform1uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform2d(int program, int location, double v0, double v1){
        glProgramUniform2d_native_GLuint_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform2d_native_GLuint_GLint_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform2dv(int program, int location, int count, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform2dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform2dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform2f(int program, int location, float v0, float v1){
        glProgramUniform2f_native_GLuint_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform2f_native_GLuint_GLint_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform2fv(int program, int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform2fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform2fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform2i(int program, int location, int v0, int v1){
        glProgramUniform2i_native_GLuint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform2i_native_GLuint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform2iv(int program, int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform2iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform2iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform2ui(int program, int location, int v0, int v1){
        glProgramUniform2ui_native_GLuint_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform2ui_native_GLuint_GLint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform2uiv(int program, int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform2uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform2uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform3d(int program, int location, double v0, double v1, double v2){
        glProgramUniform3d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform3d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1, double v2);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform3dv(int program, int location, int count, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform3dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform3dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform3f(int program, int location, float v0, float v1, float v2){
        glProgramUniform3f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform3f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1, float v2);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform3fv(int program, int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform3fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform3fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform3i(int program, int location, int v0, int v1, int v2){
        glProgramUniform3i_native_GLuint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform3i_native_GLuint_GLint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1, int v2);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform3iv(int program, int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform3iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform3iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform3ui(int program, int location, int v0, int v1, int v2){
        glProgramUniform3ui_native_GLuint_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform3ui_native_GLuint_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1, int v2);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform3uiv(int program, int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform3uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform3uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform4d(int program, int location, double v0, double v1, double v2, double v3){
        glProgramUniform4d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform4d_native_GLuint_GLint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int program, int location, double v0, double v1, double v2, double v3);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform4dv(int program, int location, int count, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform4dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform4dv_native_GLuint_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform4f(int program, int location, float v0, float v1, float v2, float v3){
        glProgramUniform4f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform4f_native_GLuint_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int program, int location, float v0, float v1, float v2, float v3);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform4fv(int program, int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform4fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform4fv_native_GLuint_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform4i(int program, int location, int v0, int v1, int v2, int v3){
        glProgramUniform4i_native_GLuint_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform4i_native_GLuint_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int program, int location, int v0, int v1, int v2, int v3);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform4iv(int program, int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform4iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform4iv_native_GLuint_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform4ui(int program, int location, int v0, int v1, int v2, int v3){
        glProgramUniform4ui_native_GLuint_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform4ui_native_GLuint_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int program, int location, int v0, int v1, int v2, int v3);
    
    @io.qt.QtUninvokable
    public final void glProgramUniform4uiv(int program, int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniform4uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniform4uiv_native_GLuint_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int program, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix2x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix2x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix2x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix2x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix2x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix2x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix2x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix2x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix3x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix3x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix3x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix3x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix3x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix3x4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix3x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix3x4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix4dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix4fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix4x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix4x2dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix4x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix4x2fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix4x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix4x3dv_native_GLuint_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glProgramUniformMatrix4x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glProgramUniformMatrix4x3fv_native_GLuint_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int program, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glProvokingVertex(int mode){
        glProvokingVertex_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glProvokingVertex_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glPushDebugGroup(int source, int id, int length, java.nio.CharBuffer message){
        java.util.Objects.requireNonNull(message, "Argument 'message': null not expected.");
        glPushDebugGroup_native_GLenum_GLuint_GLsizei_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), source, id, length, message);
    }
    
    @io.qt.QtUninvokable
    private native void glPushDebugGroup_native_GLenum_GLuint_GLsizei_const_GLchar_ptr(long __this__nativeId, int source, int id, int length, java.nio.CharBuffer message);
    
    @io.qt.QtUninvokable
    public final void glQueryCounter(int id, int target){
        glQueryCounter_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), id, target);
    }
    
    @io.qt.QtUninvokable
    private native void glQueryCounter_native_GLuint_GLenum(long __this__nativeId, int id, int target);
    
    @io.qt.QtUninvokable
    public final void glReadBuffer(int src){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), src);
    }
    
    @io.qt.QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int src);
    
    @io.qt.QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_void_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glReleaseShaderCompiler(){
        glReleaseShaderCompiler_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glReleaseShaderCompiler_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glRenderbufferStorage(int target, int internalformat, int width, int height){
        glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glRenderbufferStorageMultisample(int target, int samples, int internalformat, int width, int height){
        glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glRenderbufferStorageMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int samples, int internalformat, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glResumeTransformFeedback(){
        glResumeTransformFeedback_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glResumeTransformFeedback_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @io.qt.QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    @io.qt.QtUninvokable
    public final void glSampleMaski(int maskNumber, int mask){
        glSampleMaski_native_GLuint_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), maskNumber, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glSampleMaski_native_GLuint_GLbitfield(long __this__nativeId, int maskNumber, int mask);
    
    @io.qt.QtUninvokable
    public final void glSamplerParameterIiv(int sampler, int pname, java.nio.IntBuffer param){
        java.util.Objects.requireNonNull(param, "Argument 'param': null not expected.");
        glSamplerParameterIiv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glSamplerParameterIiv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    @io.qt.QtUninvokable
    public final void glSamplerParameterIuiv(int sampler, int pname, java.nio.IntBuffer param){
        java.util.Objects.requireNonNull(param, "Argument 'param': null not expected.");
        glSamplerParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glSamplerParameterIuiv_native_GLuint_GLenum_const_GLuint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    @io.qt.QtUninvokable
    public final void glSamplerParameterf(int sampler, int pname, float param){
        glSamplerParameterf_native_GLuint_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glSamplerParameterf_native_GLuint_GLenum_GLfloat(long __this__nativeId, int sampler, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glSamplerParameterfv(int sampler, int pname, java.nio.FloatBuffer param){
        java.util.Objects.requireNonNull(param, "Argument 'param': null not expected.");
        glSamplerParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glSamplerParameterfv_native_GLuint_GLenum_const_GLfloat_ptr(long __this__nativeId, int sampler, int pname, java.nio.FloatBuffer param);
    
    @io.qt.QtUninvokable
    public final void glSamplerParameteri(int sampler, int pname, int param){
        glSamplerParameteri_native_GLuint_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glSamplerParameteri_native_GLuint_GLenum_GLint(long __this__nativeId, int sampler, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glSamplerParameteriv(int sampler, int pname, java.nio.IntBuffer param){
        java.util.Objects.requireNonNull(param, "Argument 'param': null not expected.");
        glSamplerParameteriv_native_GLuint_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), sampler, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glSamplerParameteriv_native_GLuint_GLenum_const_GLint_ptr(long __this__nativeId, int sampler, int pname, java.nio.IntBuffer param);
    
    @io.qt.QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glScissorArrayv(int first, int count, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glScissorArrayv_native_GLuint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glScissorArrayv_native_GLuint_GLsizei_const_GLint_ptr(long __this__nativeId, int first, int count, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glScissorIndexed(int index, int left, int bottom, int width, int height){
        glScissorIndexed_native_GLuint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), index, left, bottom, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glScissorIndexed_native_GLuint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int index, int left, int bottom, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glScissorIndexedv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glScissorIndexedv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glScissorIndexedv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glShaderBinary(int count, java.nio.IntBuffer shaders, int binaryformat, java.nio.Buffer binary, int length){
        java.util.Objects.requireNonNull(shaders, "Argument 'shaders': null not expected.");
        java.util.Objects.requireNonNull(binary, "Argument 'binary': null not expected.");
        glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_void_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), count, shaders, binaryformat, binary, length);
    }
    
    @io.qt.QtUninvokable
    private native void glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_void_ptr_GLsizei(long __this__nativeId, int count, java.nio.IntBuffer shaders, int binaryformat, java.nio.Buffer binary, int length);
    
    @io.qt.QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string, java.nio.IntBuffer length){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string, length);
    }
    
    @io.qt.QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string, java.nio.IntBuffer length);
    
    @io.qt.QtUninvokable
    public final void glShaderStorageBlockBinding(int program, int storageBlockIndex, int storageBlockBinding){
        glShaderStorageBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, storageBlockIndex, storageBlockBinding);
    }
    
    @io.qt.QtUninvokable
    private native void glShaderStorageBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int storageBlockIndex, int storageBlockBinding);
    
    @io.qt.QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    @io.qt.QtUninvokable
    public final void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, sfail, dpfail, dppass);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int sfail, int dpfail, int dppass);
    
    @io.qt.QtUninvokable
    public final void glTexBuffer(int target, int internalformat, int buffer){
        glTexBuffer_native_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer);
    }
    
    @io.qt.QtUninvokable
    private native void glTexBuffer_native_GLenum_GLenum_GLuint(long __this__nativeId, int target, int internalformat, int buffer);
    
    @io.qt.QtUninvokable
    public final void glTexBufferRange(int target, int internalformat, int buffer, long offset, long size){
        glTexBufferRange_native_GLenum_GLenum_GLuint_GLintptr_GLsizeiptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, buffer, offset, size);
    }
    
    @io.qt.QtUninvokable
    private native void glTexBufferRange_native_GLenum_GLenum_GLuint_GLintptr_GLsizeiptr(long __this__nativeId, int target, int internalformat, int buffer, long offset, long size);
    
    @io.qt.QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTexImage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    @io.qt.QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTexImage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    @io.qt.QtUninvokable
    public final void glTexParameterIiv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameterIiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glTexParameterIuiv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameterIuiv_native_GLenum_GLenum_const_GLuint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glTexStorage1D(int target, int levels, int internalformat, int width){
        glTexStorage1D_native_GLenum_GLsizei_GLenum_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width);
    }
    
    @io.qt.QtUninvokable
    private native void glTexStorage1D_native_GLenum_GLsizei_GLenum_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width);
    
    @io.qt.QtUninvokable
    public final void glTexStorage2D(int target, int levels, int internalformat, int width, int height){
        glTexStorage2D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glTexStorage2D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glTexStorage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations){
        glTexStorage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, fixedsamplelocations);
    }
    
    @io.qt.QtUninvokable
    private native void glTexStorage2DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations);
    
    @io.qt.QtUninvokable
    public final void glTexStorage3D(int target, int levels, int internalformat, int width, int height, int depth){
        glTexStorage3D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, levels, internalformat, width, height, depth);
    }
    
    @io.qt.QtUninvokable
    private native void glTexStorage3D_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei(long __this__nativeId, int target, int levels, int internalformat, int width, int height, int depth);
    
    @io.qt.QtUninvokable
    public final void glTexStorage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations){
        glTexStorage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
    
    @io.qt.QtUninvokable
    private native void glTexStorage3DMultisample_native_GLenum_GLsizei_GLenum_GLsizei_GLsizei_GLsizei_GLboolean(long __this__nativeId, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations);
    
    @io.qt.QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_void_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTextureView(int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers){
        glTextureView_native_GLuint_GLenum_GLuint_GLenum_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
    }
    
    @io.qt.QtUninvokable
    private native void glTextureView_native_GLuint_GLenum_GLuint_GLenum_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers);
    
    @io.qt.QtUninvokable
    public final void glTransformFeedbackVaryings(int program, java.lang.String[] varyings, int bufferMode){
        glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), program, varyings, bufferMode);
    }
    
    @io.qt.QtUninvokable
    private native void glTransformFeedbackVaryings_native_GLuint_GLsizei_const_GLchar_cptr_ptr_GLenum(long __this__nativeId, int program, java.lang.String[] varyings, int bufferMode);
    
    @io.qt.QtUninvokable
    public final void glUniform1d(int location, double x){
        glUniform1d_native_GLint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1d_native_GLint_GLdouble(long __this__nativeId, int location, double x);
    
    @io.qt.QtUninvokable
    public final void glUniform1dv(int location, int count, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform1dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform1f(int location, float v0){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float v0);
    
    @io.qt.QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform1i(int location, int v0){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int v0);
    
    @io.qt.QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform1ui(int location, int v0){
        glUniform1ui_native_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1ui_native_GLint_GLuint(long __this__nativeId, int location, int v0);
    
    @io.qt.QtUninvokable
    public final void glUniform1uiv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform2d(int location, double x, double y){
        glUniform2d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y);
    
    @io.qt.QtUninvokable
    public final void glUniform2dv(int location, int count, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform2dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform2f(int location, float v0, float v1){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1);
    
    @io.qt.QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform2i(int location, int v0, int v1){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1);
    
    @io.qt.QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform2ui(int location, int v0, int v1){
        glUniform2ui_native_GLint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2ui_native_GLint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1);
    
    @io.qt.QtUninvokable
    public final void glUniform2uiv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform3d(int location, double x, double y, double z){
        glUniform3d_native_GLint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3d_native_GLint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glUniform3dv(int location, int count, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform3dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform3f(int location, float v0, float v1, float v2){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2);
    
    @io.qt.QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform3i(int location, int v0, int v1, int v2){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    @io.qt.QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform3ui(int location, int v0, int v1, int v2){
        glUniform3ui_native_GLint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3ui_native_GLint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    @io.qt.QtUninvokable
    public final void glUniform3uiv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform4d(int location, double x, double y, double z, double w){
        glUniform4d_native_GLint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4d_native_GLint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int location, double x, double y, double z, double w);
    
    @io.qt.QtUninvokable
    public final void glUniform4dv(int location, int count, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform4dv_native_GLint_GLsizei_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4dv_native_GLint_GLsizei_const_GLdouble_ptr(long __this__nativeId, int location, int count, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform4f(int location, float v0, float v1, float v2, float v3){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2, float v3);
    
    @io.qt.QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform4i(int location, int v0, int v1, int v2, int v3){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    @io.qt.QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform4ui(int location, int v0, int v1, int v2, int v3){
        glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4ui_native_GLint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    @io.qt.QtUninvokable
    public final void glUniform4uiv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4uiv_native_GLint_GLsizei_const_GLuint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformBlockBinding(int program, int uniformBlockIndex, int uniformBlockBinding){
        glUniformBlockBinding_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, uniformBlockIndex, uniformBlockBinding);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformBlockBinding_native_GLuint_GLuint_GLuint(long __this__nativeId, int program, int uniformBlockIndex, int uniformBlockBinding);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix2dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix2x3dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix2x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix2x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix2x3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix2x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix2x4dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix2x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix2x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix2x4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix2x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix3dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix3x2dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix3x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix3x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix3x2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix3x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix3x4dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix3x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix3x4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix3x4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix3x4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix4dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix4dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix4x2dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix4x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix4x2dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix4x2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix4x2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix4x3dv(int location, int count, boolean transpose, java.nio.DoubleBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix4x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix4x3dv_native_GLint_GLsizei_GLboolean_const_GLdouble_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.DoubleBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix4x3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix4x3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformSubroutinesuiv(int shadertype, int count, java.nio.IntBuffer indices){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glUniformSubroutinesuiv_native_GLenum_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, count, indices);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformSubroutinesuiv_native_GLenum_GLsizei_const_GLuint_ptr(long __this__nativeId, int shadertype, int count, java.nio.IntBuffer indices);
    
    @io.qt.QtUninvokable
    public final boolean glUnmapBuffer(int target){
        return glUnmapBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native boolean glUnmapBuffer_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glUseProgramStages(int pipeline, int stages, int program){
        glUseProgramStages_native_GLuint_GLbitfield_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline, stages, program);
    }
    
    @io.qt.QtUninvokable
    private native void glUseProgramStages_native_GLuint_GLbitfield_GLuint(long __this__nativeId, int pipeline, int stages, int program);
    
    @io.qt.QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glValidateProgramPipeline(int pipeline){
        glValidateProgramPipeline_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), pipeline);
    }
    
    @io.qt.QtUninvokable
    private native void glValidateProgramPipeline_native_GLuint(long __this__nativeId, int pipeline);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1d(int index, double x){
        glVertexAttrib1d_native_GLuint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1d_native_GLuint_GLdouble(long __this__nativeId, int index, double x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1f(int index, float x){
        glVertexAttrib1f_native_GLuint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1f_native_GLuint_GLfloat(long __this__nativeId, int index, float x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1fv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1s(int index, short x){
        glVertexAttrib1s_native_GLuint_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1s_native_GLuint_GLshort(long __this__nativeId, int index, short x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2d(int index, double x, double y){
        glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2f(int index, float x, float y){
        glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2fv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2s(int index, short x, short y){
        glVertexAttrib2s_native_GLuint_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2s_native_GLuint_GLshort_GLshort(long __this__nativeId, int index, short x, short y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3d(int index, double x, double y, double z){
        glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3f(int index, float x, float y, float z){
        glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3fv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3s(int index, short x, short y, short z){
        glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nbv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Niv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nsv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w){
        glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(long __this__nativeId, int index, byte x, byte y, byte z, byte w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nubv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nuiv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nusv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4bv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4d(int index, double x, double y, double z, double w){
        glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z, double w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4f(int index, float x, float y, float z, float w){
        glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4fv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4iv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4s(int index, short x, short y, short z, short w){
        glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z, short w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4ubv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4uiv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4usv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribBinding(int attribindex, int bindingindex){
        glVertexAttribBinding_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, bindingindex);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribBinding_native_GLuint_GLuint(long __this__nativeId, int attribindex, int bindingindex);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribDivisor(int index, int divisor){
        glVertexAttribDivisor_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, divisor);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribDivisor_native_GLuint_GLuint(long __this__nativeId, int index, int divisor);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribFormat(int attribindex, int size, int type, boolean normalized, int relativeoffset){
        glVertexAttribFormat_native_GLuint_GLint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, normalized, relativeoffset);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribFormat_native_GLuint_GLint_GLenum_GLboolean_GLuint(long __this__nativeId, int attribindex, int size, int type, boolean normalized, int relativeoffset);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI1i(int index, int x){
        glVertexAttribI1i_native_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI1i_native_GLuint_GLint(long __this__nativeId, int index, int x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI1iv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI1iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI1iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI1ui(int index, int x){
        glVertexAttribI1ui_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI1ui_native_GLuint_GLuint(long __this__nativeId, int index, int x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI1uiv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI1uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI1uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI2i(int index, int x, int y){
        glVertexAttribI2i_native_GLuint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI2i_native_GLuint_GLint_GLint(long __this__nativeId, int index, int x, int y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI2iv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI2iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI2iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI2ui(int index, int x, int y){
        glVertexAttribI2ui_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI2ui_native_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI2uiv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI2uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI2uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI3i(int index, int x, int y, int z){
        glVertexAttribI3i_native_GLuint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI3i_native_GLuint_GLint_GLint_GLint(long __this__nativeId, int index, int x, int y, int z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI3iv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI3iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI3iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI3ui(int index, int x, int y, int z){
        glVertexAttribI3ui_native_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI3ui_native_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y, int z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI3uiv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI3uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI3uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI4bv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI4bv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI4bv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI4i(int index, int x, int y, int z, int w){
        glVertexAttribI4i_native_GLuint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI4i_native_GLuint_GLint_GLint_GLint_GLint(long __this__nativeId, int index, int x, int y, int z, int w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI4iv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI4iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI4iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI4sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI4sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI4sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI4ubv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI4ubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI4ubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI4ui(int index, int x, int y, int z, int w){
        glVertexAttribI4ui_native_GLuint_GLuint_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI4ui_native_GLuint_GLuint_GLuint_GLuint_GLuint(long __this__nativeId, int index, int x, int y, int z, int w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI4uiv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI4uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI4uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribI4usv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribI4usv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribI4usv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribIFormat(int attribindex, int size, int type, int relativeoffset){
        glVertexAttribIFormat_native_GLuint_GLint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, relativeoffset);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribIFormat_native_GLuint_GLint_GLenum_GLuint(long __this__nativeId, int attribindex, int size, int type, int relativeoffset);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribIPointer(int index, int size, int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribIPointer_native_GLuint_GLint_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribL1d(int index, double x){
        glVertexAttribL1d_native_GLuint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribL1d_native_GLuint_GLdouble(long __this__nativeId, int index, double x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribL1dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribL1dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribL1dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribL2d(int index, double x, double y){
        glVertexAttribL2d_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribL2d_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribL2dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribL2dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribL2dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribL3d(int index, double x, double y, double z){
        glVertexAttribL3d_native_GLuint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribL3d_native_GLuint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribL3dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribL3dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribL3dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribL4d(int index, double x, double y, double z, double w){
        glVertexAttribL4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribL4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z, double w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribL4dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttribL4dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribL4dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribLFormat(int attribindex, int size, int type, int relativeoffset){
        glVertexAttribLFormat_native_GLuint_GLint_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), attribindex, size, type, relativeoffset);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribLFormat_native_GLuint_GLint_GLenum_GLuint(long __this__nativeId, int attribindex, int size, int type, int relativeoffset);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribLPointer(int index, int size, int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glVertexAttribLPointer_native_GLuint_GLint_GLenum_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribLPointer_native_GLuint_GLint_GLenum_GLsizei_const_void_ptr(long __this__nativeId, int index, int size, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribP1ui(int index, int type, boolean normalized, int value){
        glVertexAttribP1ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribP1ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribP1uiv(int index, int type, boolean normalized, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glVertexAttribP1uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribP1uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribP2ui(int index, int type, boolean normalized, int value){
        glVertexAttribP2ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribP2ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribP2uiv(int index, int type, boolean normalized, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glVertexAttribP2uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribP2uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribP3ui(int index, int type, boolean normalized, int value){
        glVertexAttribP3ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribP3ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribP3uiv(int index, int type, boolean normalized, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glVertexAttribP3uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribP3uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribP4ui(int index, int type, boolean normalized, int value){
        glVertexAttribP4ui_native_GLuint_GLenum_GLboolean_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribP4ui_native_GLuint_GLenum_GLboolean_GLuint(long __this__nativeId, int index, int type, boolean normalized, int value);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribP4uiv(int index, int type, boolean normalized, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glVertexAttribP4uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, type, normalized, value);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribP4uiv_native_GLuint_GLenum_GLboolean_const_GLuint_ptr(long __this__nativeId, int index, int type, boolean normalized, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_void_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, normalized, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_void_ptr(long __this__nativeId, int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glVertexBindingDivisor(int bindingindex, int divisor){
        glVertexBindingDivisor_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), bindingindex, divisor);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexBindingDivisor_native_GLuint_GLuint(long __this__nativeId, int bindingindex, int divisor);
    
    @io.qt.QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glViewportArrayv(int first, int count, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glViewportArrayv_native_GLuint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), first, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glViewportArrayv_native_GLuint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int first, int count, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glViewportIndexedf(int index, float x, float y, float w, float h){
        glViewportIndexedf_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, w, h);
    }
    
    @io.qt.QtUninvokable
    private native void glViewportIndexedf_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float w, float h);
    
    @io.qt.QtUninvokable
    public final void glViewportIndexedfv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glViewportIndexedfv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glViewportIndexedfv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glWaitSync(io.qt.gui.gl.GLsync sync, int flags, long timeout){
        glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sync), flags, timeout);
    }
    
    @io.qt.QtUninvokable
    private native void glWaitSync_native___GLsync_ptr_GLbitfield_GLuint64(long __this__nativeId, long sync, int flags, long timeout);
    
    @io.qt.QtUninvokable
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLFunctions_4_4_Core(QPrivateConstructor p) { super(p); } 
    
}
