package io.qt.opengl;


/**
 * <p>All functions for OpenGL 2.0 specification</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qopenglfunctions-2-0.html">QOpenGLFunctions_2_0</a></p>
 */
public final class QOpenGLFunctions_2_0 extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    public QOpenGLFunctions_2_0(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_2_0 instance);
    
    @io.qt.QtUninvokable
    public final void glAccum(int op, float value){
        glAccum_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), op, value);
    }
    
    @io.qt.QtUninvokable
    private native void glAccum_native_GLenum_GLfloat(long __this__nativeId, int op, float value);
    
    @io.qt.QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @io.qt.QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    @io.qt.QtUninvokable
    public final void glAlphaFunc(int func, float ref){
        glAlphaFunc_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref);
    }
    
    @io.qt.QtUninvokable
    private native void glAlphaFunc_native_GLenum_GLfloat(long __this__nativeId, int func, float ref);
    
    @io.qt.QtUninvokable
    public final boolean glAreTexturesResident(java.nio.IntBuffer textures, boolean[] residences){
        java.util.Objects.requireNonNull(textures, "Argument 'textures': null not expected.");
        java.util.Objects.requireNonNull(residences, "Argument 'residences': null not expected.");
        return glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), textures, residences);
    }
    
    @io.qt.QtUninvokable
    private native boolean glAreTexturesResident_native_GLsizei_const_GLuint_ptr_GLboolean_ptr(long __this__nativeId, java.nio.IntBuffer textures, boolean[] residences);
    
    @io.qt.QtUninvokable
    public final void glArrayElement(int i){
        glArrayElement_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @io.qt.QtUninvokable
    private native void glArrayElement_native_GLint(long __this__nativeId, int i);
    
    @io.qt.QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @io.qt.QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    @io.qt.QtUninvokable
    public final void glBegin(int mode){
        glBegin_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glBegin_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glBeginQuery(int target, int id){
        glBeginQuery_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, id);
    }
    
    @io.qt.QtUninvokable
    private native void glBeginQuery_native_GLenum_GLuint(long __this__nativeId, int target, int id);
    
    @io.qt.QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @io.qt.QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @io.qt.QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    @io.qt.QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @io.qt.QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    @io.qt.QtUninvokable
    public final void glBitmap(int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.ByteBuffer bitmap){
        java.util.Objects.requireNonNull(bitmap, "Argument 'bitmap': null not expected.");
        glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, xorig, yorig, xmove, ymove, bitmap);
    }
    
    @io.qt.QtUninvokable
    private native void glBitmap_native_GLsizei_GLsizei_GLfloat_GLfloat_GLfloat_GLfloat_const_GLubyte_ptr(long __this__nativeId, int width, int height, float xorig, float yorig, float xmove, float ymove, java.nio.ByteBuffer bitmap);
    
    @io.qt.QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @io.qt.QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    @io.qt.QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    @io.qt.QtUninvokable
    public final void glBlendFuncSeparate(int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int sfactorRGB, int dfactorRGB, int sfactorAlpha, int dfactorAlpha);
    
    @io.qt.QtUninvokable
    public final void glBufferData(int target, long size, java.nio.Buffer data, int usage){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @io.qt.QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    @io.qt.QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @io.qt.QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCallList(int list){
        glCallList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @io.qt.QtUninvokable
    private native void glCallList_native_GLuint(long __this__nativeId, int list);
    
    @io.qt.QtUninvokable
    public final void glCallLists(int n, int type, java.nio.Buffer lists){
        java.util.Objects.requireNonNull(lists, "Argument 'lists': null not expected.");
        glCallLists_native_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, type, lists);
    }
    
    @io.qt.QtUninvokable
    private native void glCallLists_native_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int n, int type, java.nio.Buffer lists);
    
    @io.qt.QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glClearAccum(float red, float green, float blue, float alpha){
        glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glClearAccum_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @io.qt.QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glClearColor_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @io.qt.QtUninvokable
    public final void glClearDepth(double depth){
        glClearDepth_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @io.qt.QtUninvokable
    private native void glClearDepth_native_GLdouble(long __this__nativeId, double depth);
    
    @io.qt.QtUninvokable
    public final void glClearIndex(float c){
        glClearIndex_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glClearIndex_native_GLfloat(long __this__nativeId, float c);
    
    @io.qt.QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @io.qt.QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    @io.qt.QtUninvokable
    public final void glClientActiveTexture(int texture){
        glClientActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @io.qt.QtUninvokable
    private native void glClientActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    @io.qt.QtUninvokable
    public final void glClipPlane(int plane, double[] equation){
        java.util.Objects.requireNonNull(equation, "Argument 'equation': null not expected.");
        if(equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glClipPlane_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @io.qt.QtUninvokable
    private native void glClipPlane_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    @io.qt.QtUninvokable
    public final void glColor3b(byte red, byte green, byte blue){
        glColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    @io.qt.QtUninvokable
    public final void glColor3bv(byte[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    @io.qt.QtUninvokable
    public final void glColor3d(double red, double green, double blue){
        glColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    @io.qt.QtUninvokable
    public final void glColor3dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glColor3f(float red, float green, float blue){
        glColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    @io.qt.QtUninvokable
    public final void glColor3fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glColor3i(int red, int green, int blue){
        glColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    @io.qt.QtUninvokable
    public final void glColor3iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glColor3s(short red, short green, short blue){
        glColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    @io.qt.QtUninvokable
    public final void glColor3sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glColor4b(byte red, byte green, byte blue, byte alpha){
        glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4b_native_GLbyte_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue, byte alpha);
    
    @io.qt.QtUninvokable
    public final void glColor4bv(byte[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    @io.qt.QtUninvokable
    public final void glColor4d(double red, double green, double blue, double alpha){
        glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue, double alpha);
    
    @io.qt.QtUninvokable
    public final void glColor4dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glColor4f(float red, float green, float blue, float alpha){
        glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @io.qt.QtUninvokable
    public final void glColor4fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glColor4i(int red, int green, int blue, int alpha){
        glColor4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue, int alpha);
    
    @io.qt.QtUninvokable
    public final void glColor4iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glColor4s(short red, short green, short blue, short alpha){
        glColor4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue, short alpha);
    
    @io.qt.QtUninvokable
    public final void glColor4sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glColor4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glColor4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    @io.qt.QtUninvokable
    public final void glColorMaterial(int face, int mode){
        glColorMaterial_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glColorMaterial_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    @io.qt.QtUninvokable
    public final void glColorPointer(int size, int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glColorSubTable(int target, int start, int count, int format, int type, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, count, format, type, data);
    }
    
    @io.qt.QtUninvokable
    private native void glColorSubTable_native_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int start, int count, int format, int type, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glColorTable(int target, int internalformat, int width, int format, int type, java.nio.Buffer table){
        java.util.Objects.requireNonNull(table, "Argument 'table': null not expected.");
        glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, table);
    }
    
    @io.qt.QtUninvokable
    private native void glColorTable_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer table);
    
    @io.qt.QtUninvokable
    public final void glColorTableParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glColorTableParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glColorTableParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glColorTableParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexImage1D_native_GLenum_GLint_GLenum_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexImage3D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, java.nio.Buffer image){
        java.util.Objects.requireNonNull(image, "Argument 'image': null not expected.");
        glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, format, type, image);
    }
    
    @io.qt.QtUninvokable
    private native void glConvolutionFilter1D_native_GLenum_GLenum_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int format, int type, java.nio.Buffer image);
    
    @io.qt.QtUninvokable
    public final void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer image){
        java.util.Objects.requireNonNull(image, "Argument 'image': null not expected.");
        glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, image);
    }
    
    @io.qt.QtUninvokable
    private native void glConvolutionFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer image);
    
    @io.qt.QtUninvokable
    public final void glConvolutionParameterf(int target, int pname, float params){
        glConvolutionParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glConvolutionParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float params);
    
    @io.qt.QtUninvokable
    public final void glConvolutionParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glConvolutionParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glConvolutionParameteri(int target, int pname, int params){
        glConvolutionParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glConvolutionParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int params);
    
    @io.qt.QtUninvokable
    public final void glConvolutionParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glConvolutionParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glCopyColorSubTable(int target, int start, int x, int y, int width){
        glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, start, x, y, width);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyColorSubTable_native_GLenum_GLsizei_GLint_GLint_GLsizei(long __this__nativeId, int target, int start, int x, int y, int width);
    
    @io.qt.QtUninvokable
    public final void glCopyColorTable(int target, int internalformat, int x, int y, int width){
        glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyColorTable_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    @io.qt.QtUninvokable
    public final void glCopyConvolutionFilter1D(int target, int internalformat, int x, int y, int width){
        glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyConvolutionFilter1D_native_GLenum_GLenum_GLint_GLint_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width);
    
    @io.qt.QtUninvokable
    public final void glCopyConvolutionFilter2D(int target, int internalformat, int x, int y, int width, int height){
        glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyConvolutionFilter2D_native_GLenum_GLenum_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glCopyPixels(int x, int y, int width, int height, int type){
        glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, type);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum(long __this__nativeId, int x, int y, int width, int height, int type);
    
    @io.qt.QtUninvokable
    public final void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border){
        glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, border);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexImage1D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int border);
    
    @io.qt.QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    @io.qt.QtUninvokable
    public final void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width){
        glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, x, y, width);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexSubImage1D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei(long __this__nativeId, int target, int level, int xoffset, int x, int y, int width);
    
    @io.qt.QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height){
        glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @io.qt.QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    @io.qt.QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.IntBuffer buffers){
        java.util.Objects.requireNonNull(buffers, "Argument 'buffers': null not expected.");
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    @io.qt.QtUninvokable
    public final void glDeleteLists(int list, int range){
        glDeleteLists_native_GLuint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), list, range);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteLists_native_GLuint_GLsizei(long __this__nativeId, int list, int range);
    
    @io.qt.QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glDeleteQueries(int n, java.nio.IntBuffer ids){
        java.util.Objects.requireNonNull(ids, "Argument 'ids': null not expected.");
        glDeleteQueries_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteQueries_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @io.qt.QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final void glDeleteTextures(int n, java.nio.IntBuffer textures){
        java.util.Objects.requireNonNull(textures, "Argument 'textures': null not expected.");
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    @io.qt.QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    @io.qt.QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    @io.qt.QtUninvokable
    public final void glDepthRange(double nearVal, double farVal){
        glDepthRange_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nearVal, farVal);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthRange_native_GLdouble_GLdouble(long __this__nativeId, double nearVal, double farVal);
    
    @io.qt.QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @io.qt.QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    @io.qt.QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final void glDisableClientState(int array){
        glDisableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @io.qt.QtUninvokable
    private native void glDisableClientState_native_GLenum(long __this__nativeId, int array);
    
    @io.qt.QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    @io.qt.QtUninvokable
    public final void glDrawBuffer(int mode){
        glDrawBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawBuffer_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glDrawBuffers(int n, java.nio.IntBuffer bufs){
        java.util.Objects.requireNonNull(bufs, "Argument 'bufs': null not expected.");
        glDrawBuffers_native_GLsizei_const_GLenum_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, bufs);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawBuffers_native_GLsizei_const_GLenum_ptr(long __this__nativeId, int n, java.nio.IntBuffer bufs);
    
    @io.qt.QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.Buffer indices){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    @io.qt.QtUninvokable
    public final void glDrawPixels(int width, int height, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawPixels_native_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glDrawRangeElements(int mode, int start, int end, int count, int type, java.nio.Buffer indices){
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, start, end, count, type, indices);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawRangeElements_native_GLenum_GLuint_GLuint_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int start, int end, int count, int type, java.nio.Buffer indices);
    
    @io.qt.QtUninvokable
    public final void glEdgeFlag(boolean flag){
        glEdgeFlag_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @io.qt.QtUninvokable
    private native void glEdgeFlag_native_GLboolean(long __this__nativeId, boolean flag);
    
    @io.qt.QtUninvokable
    public final void glEdgeFlagPointer(int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glEdgeFlagPointer_native_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glEdgeFlagPointer_native_GLsizei_const_GLvoid_ptr(long __this__nativeId, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final void glEnableClientState(int array){
        glEnableClientState_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), array);
    }
    
    @io.qt.QtUninvokable
    private native void glEnableClientState_native_GLenum(long __this__nativeId, int array);
    
    @io.qt.QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void glEnd(){
        glEnd_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glEnd_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glEndList(){
        glEndList_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glEndList_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glEndQuery(int target){
        glEndQuery_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native void glEndQuery_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glEvalCoord1d(double u){
        glEvalCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalCoord1d_native_GLdouble(long __this__nativeId, double u);
    
    @io.qt.QtUninvokable
    public final void glEvalCoord1dv(double[] u){
        java.util.Objects.requireNonNull(u, "Argument 'u': null not expected.");
        if(u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    @io.qt.QtUninvokable
    public final void glEvalCoord1f(float u){
        glEvalCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalCoord1f_native_GLfloat(long __this__nativeId, float u);
    
    @io.qt.QtUninvokable
    public final void glEvalCoord1fv(float[] u){
        java.util.Objects.requireNonNull(u, "Argument 'u': null not expected.");
        if(u.length < 1)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 1");
        glEvalCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    @io.qt.QtUninvokable
    public final void glEvalCoord2d(double u, double v){
        glEvalCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double u, double v);
    
    @io.qt.QtUninvokable
    public final void glEvalCoord2dv(double[] u){
        java.util.Objects.requireNonNull(u, "Argument 'u': null not expected.");
        if(u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] u);
    
    @io.qt.QtUninvokable
    public final void glEvalCoord2f(float u, float v){
        glEvalCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), u, v);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float u, float v);
    
    @io.qt.QtUninvokable
    public final void glEvalCoord2fv(float[] u){
        java.util.Objects.requireNonNull(u, "Argument 'u': null not expected.");
        if(u.length < 2)
            throw new IllegalArgumentException("Argument 'u': Wrong number of elements in array. Found: " + u.length + ", expected: 2");
        glEvalCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), u);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] u);
    
    @io.qt.QtUninvokable
    public final void glEvalMesh1(int mode, int i1, int i2){
        glEvalMesh1_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalMesh1_native_GLenum_GLint_GLint(long __this__nativeId, int mode, int i1, int i2);
    
    @io.qt.QtUninvokable
    public final void glEvalMesh2(int mode, int i1, int i2, int j1, int j2){
        glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), mode, i1, i2, j1, j2);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalMesh2_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int mode, int i1, int i2, int j1, int j2);
    
    @io.qt.QtUninvokable
    public final void glEvalPoint1(int i){
        glEvalPoint1_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalPoint1_native_GLint(long __this__nativeId, int i);
    
    @io.qt.QtUninvokable
    public final void glEvalPoint2(int i, int j){
        glEvalPoint2_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), i, j);
    }
    
    @io.qt.QtUninvokable
    private native void glEvalPoint2_native_GLint_GLint(long __this__nativeId, int i, int j);
    
    @io.qt.QtUninvokable
    public final void glFeedbackBuffer(int type, java.nio.FloatBuffer buffer){
        java.util.Objects.requireNonNull(buffer, "Argument 'buffer': null not expected.");
        glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, buffer);
    }
    
    @io.qt.QtUninvokable
    private native void glFeedbackBuffer_native_GLsizei_GLenum_GLfloat_ptr(long __this__nativeId, int type, java.nio.FloatBuffer buffer);
    
    @io.qt.QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glFogCoordPointer(int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glFogCoordPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glFogCoordPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glFogCoordd(double coord){
        glFogCoordd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @io.qt.QtUninvokable
    private native void glFogCoordd_native_GLdouble(long __this__nativeId, double coord);
    
    @io.qt.QtUninvokable
    public final void glFogCoorddv(java.nio.DoubleBuffer coord){
        java.util.Objects.requireNonNull(coord, "Argument 'coord': null not expected.");
        glFogCoorddv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @io.qt.QtUninvokable
    private native void glFogCoorddv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer coord);
    
    @io.qt.QtUninvokable
    public final void glFogCoordf(float coord){
        glFogCoordf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @io.qt.QtUninvokable
    private native void glFogCoordf_native_GLfloat(long __this__nativeId, float coord);
    
    @io.qt.QtUninvokable
    public final void glFogCoordfv(java.nio.FloatBuffer coord){
        java.util.Objects.requireNonNull(coord, "Argument 'coord': null not expected.");
        glFogCoordfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord);
    }
    
    @io.qt.QtUninvokable
    private native void glFogCoordfv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer coord);
    
    @io.qt.QtUninvokable
    public final void glFogf(int pname, float param){
        glFogf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glFogf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glFogfv(int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glFogfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glFogi(int pname, int param){
        glFogi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glFogi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glFogiv(int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glFogiv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glFogiv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glFrustum(double left, double right, double bottom, double top, double zNear, double zFar){
        glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @io.qt.QtUninvokable
    private native void glFrustum_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    @io.qt.QtUninvokable
    public final void glGenBuffers(int n, java.nio.IntBuffer buffers){
        java.util.Objects.requireNonNull(buffers, "Argument 'buffers': null not expected.");
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @io.qt.QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    @io.qt.QtUninvokable
    public final int glGenLists(int range){
        return glGenLists_native_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), range);
    }
    
    @io.qt.QtUninvokable
    private native int glGenLists_native_GLsizei(long __this__nativeId, int range);
    
    @io.qt.QtUninvokable
    public final void glGenQueries(int n, java.nio.IntBuffer ids){
        java.util.Objects.requireNonNull(ids, "Argument 'ids': null not expected.");
        glGenQueries_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, ids);
    }
    
    @io.qt.QtUninvokable
    private native void glGenQueries_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer ids);
    
    @io.qt.QtUninvokable
    public final void glGenTextures(int n, java.nio.IntBuffer textures){
        java.util.Objects.requireNonNull(textures, "Argument 'textures': null not expected.");
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @io.qt.QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    @io.qt.QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(size, "Argument 'size': null not expected.");
        java.util.Objects.requireNonNull(type, "Argument 'type': null not expected.");
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(size, "Argument 'size': null not expected.");
        java.util.Objects.requireNonNull(type, "Argument 'type': null not expected.");
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufSize, length, size, type, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufSize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetAttachedShaders(int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj){
        java.util.Objects.requireNonNull(count, "Argument 'count': null not expected.");
        java.util.Objects.requireNonNull(obj, "Argument 'obj': null not expected.");
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxCount, count, obj);
    }
    
    @io.qt.QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxCount, java.nio.IntBuffer count, java.nio.IntBuffer obj);
    
    @io.qt.QtUninvokable
    public final int glGetAttribLocation(int program, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetBooleanv(int pname, boolean[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, boolean[] params);
    
    @io.qt.QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetBufferPointerv(int target, int pname, java.nio.Buffer[] params){
        glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBufferPointerv_native_GLenum_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int target, int pname, java.nio.Buffer[] params);
    
    @io.qt.QtUninvokable
    public final void glGetBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBufferSubData_native_GLenum_GLintptr_GLsizeiptr_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glGetClipPlane(int plane, double[] equation){
        java.util.Objects.requireNonNull(equation, "Argument 'equation': null not expected.");
        if(equation.length < 4)
            throw new IllegalArgumentException("Argument 'equation': Wrong number of elements in array. Found: " + equation.length + ", expected: 4");
        glGetClipPlane_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), plane, equation);
    }
    
    @io.qt.QtUninvokable
    private native void glGetClipPlane_native_GLenum_GLdouble_ptr(long __this__nativeId, int plane, double[] equation);
    
    @io.qt.QtUninvokable
    public final void glGetColorTable(int target, int format, int type, java.nio.Buffer table){
        java.util.Objects.requireNonNull(table, "Argument 'table': null not expected.");
        glGetColorTable_native_GLenum_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, table);
    }
    
    @io.qt.QtUninvokable
    private native void glGetColorTable_native_GLenum_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer table);
    
    @io.qt.QtUninvokable
    public final void glGetColorTableParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetColorTableParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetColorTableParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetColorTableParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetCompressedTexImage(int target, int level, java.nio.Buffer img){
        java.util.Objects.requireNonNull(img, "Argument 'img': null not expected.");
        glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, img);
    }
    
    @io.qt.QtUninvokable
    private native void glGetCompressedTexImage_native_GLenum_GLint_GLvoid_ptr(long __this__nativeId, int target, int level, java.nio.Buffer img);
    
    @io.qt.QtUninvokable
    public final void glGetConvolutionFilter(int target, int format, int type, java.nio.Buffer image){
        java.util.Objects.requireNonNull(image, "Argument 'image': null not expected.");
        glGetConvolutionFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, image);
    }
    
    @io.qt.QtUninvokable
    private native void glGetConvolutionFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer image);
    
    @io.qt.QtUninvokable
    public final void glGetConvolutionParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetConvolutionParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetConvolutionParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetConvolutionParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetDoublev(int pname, double[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetDoublev_native_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetDoublev_native_GLenum_GLdouble_ptr(long __this__nativeId, int pname, double[] params);
    
    @io.qt.QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glGetFloatv(int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glGetHistogram(int target, boolean reset, int format, int type, java.nio.Buffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @io.qt.QtUninvokable
    private native void glGetHistogram_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    @io.qt.QtUninvokable
    public final void glGetHistogramParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetHistogramParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetHistogramParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetHistogramParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetIntegerv(int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glGetLightfv(int light, int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetLightfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glGetLightiv(int light, int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetLightiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetLightiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glGetMapdv(int target, int query, double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMapdv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int target, int query, double[] v);
    
    @io.qt.QtUninvokable
    public final void glGetMapfv(int target, int query, float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMapfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int query, float[] v);
    
    @io.qt.QtUninvokable
    public final void glGetMapiv(int target, int query, int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glGetMapiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, query, v);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMapiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int query, int[] v);
    
    @io.qt.QtUninvokable
    public final void glGetMaterialfv(int face, int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMaterialfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glGetMaterialiv(int face, int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMaterialiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glGetMinmax(int target, boolean reset, int format, int type, java.nio.Buffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, reset, format, type, values);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMinmax_native_GLenum_GLboolean_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, boolean reset, int format, int type, java.nio.Buffer values);
    
    @io.qt.QtUninvokable
    public final void glGetMinmaxParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMinmaxParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetMinmaxParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetMinmaxParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetPixelMapfv(int map, java.nio.FloatBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glGetPixelMapfv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @io.qt.QtUninvokable
    private native void glGetPixelMapfv_native_GLenum_GLfloat_ptr(long __this__nativeId, int map, java.nio.FloatBuffer values);
    
    @io.qt.QtUninvokable
    public final void glGetPixelMapuiv(int map, java.nio.IntBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glGetPixelMapuiv_native_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @io.qt.QtUninvokable
    private native void glGetPixelMapuiv_native_GLenum_GLuint_ptr(long __this__nativeId, int map, java.nio.IntBuffer values);
    
    @io.qt.QtUninvokable
    public final void glGetPixelMapusv(int map, java.nio.ShortBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glGetPixelMapusv_native_GLenum_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, values);
    }
    
    @io.qt.QtUninvokable
    private native void glGetPixelMapusv_native_GLenum_GLushort_ptr(long __this__nativeId, int map, java.nio.ShortBuffer values);
    
    @io.qt.QtUninvokable
    public final void glGetPointerv(int pname, java.nio.Buffer[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetPointerv_native_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetPointerv_native_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int pname, java.nio.Buffer[] params);
    
    @io.qt.QtUninvokable
    public final void glGetPolygonStipple(java.nio.ByteBuffer mask){
        java.util.Objects.requireNonNull(mask, "Argument 'mask': null not expected.");
        glGetPolygonStipple_native_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glGetPolygonStipple_native_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    @io.qt.QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(infoLog, "Argument 'infoLog': null not expected.");
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufSize, length, infoLog);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    @io.qt.QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryObjectiv(int id, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryObjectiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryObjectuiv(int id, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), id, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryObjectuiv_native_GLuint_GLenum_GLuint_ptr(long __this__nativeId, int id, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetQueryiv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetQueryiv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetQueryiv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetSeparableFilter(int target, int format, int type, java.nio.Buffer row, java.nio.Buffer column, java.nio.Buffer span){
        java.util.Objects.requireNonNull(row, "Argument 'row': null not expected.");
        java.util.Objects.requireNonNull(column, "Argument 'column': null not expected.");
        java.util.Objects.requireNonNull(span, "Argument 'span': null not expected.");
        glGetSeparableFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr_GLvoid_ptr_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, format, type, row, column, span);
    }
    
    @io.qt.QtUninvokable
    private native void glGetSeparableFilter_native_GLenum_GLenum_GLenum_GLvoid_ptr_GLvoid_ptr_GLvoid_ptr(long __this__nativeId, int target, int format, int type, java.nio.Buffer row, java.nio.Buffer column, java.nio.Buffer span);
    
    @io.qt.QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(infoLog, "Argument 'infoLog': null not expected.");
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, infoLog);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer infoLog);
    
    @io.qt.QtUninvokable
    public final void glGetShaderSource(int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        java.util.Objects.requireNonNull(source, "Argument 'source': null not expected.");
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufSize, length, source);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufSize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    @io.qt.QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final java.lang.String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String glGetString_native_GLenum(long __this__nativeId, int name);
    
    @io.qt.QtUninvokable
    public final void glGetTexEnvfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexEnvfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexEnviv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexEnviv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexGendv(int coord, int pname, java.nio.DoubleBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexGendv_native_GLenum_GLenum_GLdouble_ptr(long __this__nativeId, int coord, int pname, java.nio.DoubleBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexGenfv(int coord, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexGenfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int coord, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexGeniv(int coord, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexGeniv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int coord, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexImage(int target, int level, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexImage_native_GLenum_GLint_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int target, int level, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glGetTexLevelParameterfv(int target, int level, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexLevelParameterfv_native_GLenum_GLint_GLenum_GLfloat_ptr(long __this__nativeId, int target, int level, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexLevelParameteriv(int target, int level, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexLevelParameteriv_native_GLenum_GLint_GLenum_GLint_ptr(long __this__nativeId, int target, int level, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final int glGetUniformLocation(int program, java.nio.CharBuffer name){
        java.util.Objects.requireNonNull(name, "Argument 'name': null not expected.");
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribdv(int index, int pname, java.nio.DoubleBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribdv_native_GLuint_GLenum_GLdouble_ptr(long __this__nativeId, int index, int pname, java.nio.DoubleBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    @io.qt.QtUninvokable
    public final void glHistogram(int target, int width, int internalformat, boolean sink){
        glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, width, internalformat, sink);
    }
    
    @io.qt.QtUninvokable
    private native void glHistogram_native_GLenum_GLsizei_GLenum_GLboolean(long __this__nativeId, int target, int width, int internalformat, boolean sink);
    
    @io.qt.QtUninvokable
    public final void glIndexMask(int mask){
        glIndexMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexMask_native_GLuint(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glIndexPointer(int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glIndexPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glIndexd(double c){
        glIndexd_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexd_native_GLdouble(long __this__nativeId, double c);
    
    @io.qt.QtUninvokable
    public final void glIndexdv(double[] c){
        java.util.Objects.requireNonNull(c, "Argument 'c': null not expected.");
        if(c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexdv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexdv_native_const_GLdouble_ptr(long __this__nativeId, double[] c);
    
    @io.qt.QtUninvokable
    public final void glIndexf(float c){
        glIndexf_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexf_native_GLfloat(long __this__nativeId, float c);
    
    @io.qt.QtUninvokable
    public final void glIndexfv(float[] c){
        java.util.Objects.requireNonNull(c, "Argument 'c': null not expected.");
        if(c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexfv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexfv_native_const_GLfloat_ptr(long __this__nativeId, float[] c);
    
    @io.qt.QtUninvokable
    public final void glIndexi(int c){
        glIndexi_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexi_native_GLint(long __this__nativeId, int c);
    
    @io.qt.QtUninvokable
    public final void glIndexiv(int[] c){
        java.util.Objects.requireNonNull(c, "Argument 'c': null not expected.");
        if(c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexiv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexiv_native_const_GLint_ptr(long __this__nativeId, int[] c);
    
    @io.qt.QtUninvokable
    public final void glIndexs(short c){
        glIndexs_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexs_native_GLshort(long __this__nativeId, short c);
    
    @io.qt.QtUninvokable
    public final void glIndexsv(short[] c){
        java.util.Objects.requireNonNull(c, "Argument 'c': null not expected.");
        if(c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexsv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexsv_native_const_GLshort_ptr(long __this__nativeId, short[] c);
    
    @io.qt.QtUninvokable
    public final void glIndexub(byte c){
        glIndexub_native_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexub_native_GLubyte(long __this__nativeId, byte c);
    
    @io.qt.QtUninvokable
    public final void glIndexubv(byte[] c){
        java.util.Objects.requireNonNull(c, "Argument 'c': null not expected.");
        if(c.length < 1)
            throw new IllegalArgumentException("Argument 'c': Wrong number of elements in array. Found: " + c.length + ", expected: 1");
        glIndexubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), c);
    }
    
    @io.qt.QtUninvokable
    private native void glIndexubv_native_const_GLubyte_ptr(long __this__nativeId, byte[] c);
    
    @io.qt.QtUninvokable
    public final void glInitNames(){
        glInitNames_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glInitNames_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glInterleavedArrays(int format, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glInterleavedArrays_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), format, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glInterleavedArrays_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int format, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    @io.qt.QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final boolean glIsList(int list){
        return glIsList_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsList_native_GLuint(long __this__nativeId, int list);
    
    @io.qt.QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final boolean glIsQuery(int id){
        return glIsQuery_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsQuery_native_GLuint(long __this__nativeId, int id);
    
    @io.qt.QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    @io.qt.QtUninvokable
    public final void glLightModelf(int pname, float param){
        glLightModelf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glLightModelf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glLightModelfv(int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModelfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glLightModelfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glLightModeli(int pname, int param){
        glLightModeli_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glLightModeli_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glLightModeliv(int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightModeliv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glLightModeliv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glLightf(int light, int pname, float param){
        glLightf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glLightf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int light, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glLightfv(int light, int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glLightfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int light, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glLighti(int light, int pname, int param){
        glLighti_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glLighti_native_GLenum_GLenum_GLint(long __this__nativeId, int light, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glLightiv(int light, int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glLightiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), light, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glLightiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int light, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glLineStipple(int factor, short pattern){
        glLineStipple_native_GLint_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), factor, pattern);
    }
    
    @io.qt.QtUninvokable
    private native void glLineStipple_native_GLint_GLushort(long __this__nativeId, int factor, short pattern);
    
    @io.qt.QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @io.qt.QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    @io.qt.QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glListBase(int base){
        glListBase_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), base);
    }
    
    @io.qt.QtUninvokable
    private native void glListBase_native_GLuint(long __this__nativeId, int base);
    
    @io.qt.QtUninvokable
    public final void glLoadIdentity(){
        glLoadIdentity_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glLoadIdentity_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glLoadMatrixd(double[] m){
        java.util.Objects.requireNonNull(m, "Argument 'm': null not expected.");
        if(m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @io.qt.QtUninvokable
    private native void glLoadMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    @io.qt.QtUninvokable
    public final void glLoadMatrixf(float[] m){
        java.util.Objects.requireNonNull(m, "Argument 'm': null not expected.");
        if(m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glLoadMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @io.qt.QtUninvokable
    private native void glLoadMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    @io.qt.QtUninvokable
    public final void glLoadName(int name){
        glLoadName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void glLoadName_native_GLuint(long __this__nativeId, int name);
    
    @io.qt.QtUninvokable
    public final void glLoadTransposeMatrixd(java.nio.DoubleBuffer m){
        java.util.Objects.requireNonNull(m, "Argument 'm': null not expected.");
        glLoadTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @io.qt.QtUninvokable
    private native void glLoadTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    @io.qt.QtUninvokable
    public final void glLoadTransposeMatrixf(java.nio.FloatBuffer m){
        java.util.Objects.requireNonNull(m, "Argument 'm': null not expected.");
        glLoadTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @io.qt.QtUninvokable
    private native void glLoadTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    @io.qt.QtUninvokable
    public final void glLogicOp(int opcode){
        glLogicOp_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), opcode);
    }
    
    @io.qt.QtUninvokable
    private native void glLogicOp_native_GLenum(long __this__nativeId, int opcode);
    
    @io.qt.QtUninvokable
    public final void glMap1d(int target, double u1, double u2, int stride, int order, java.nio.DoubleBuffer points){
        java.util.Objects.requireNonNull(points, "Argument 'points': null not expected.");
        glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @io.qt.QtUninvokable
    private native void glMap1d_native_GLenum_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int stride, int order, java.nio.DoubleBuffer points);
    
    @io.qt.QtUninvokable
    public final void glMap1f(int target, float u1, float u2, int stride, int order, java.nio.FloatBuffer points){
        java.util.Objects.requireNonNull(points, "Argument 'points': null not expected.");
        glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, stride, order, points);
    }
    
    @io.qt.QtUninvokable
    private native void glMap1f_native_GLenum_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int stride, int order, java.nio.FloatBuffer points);
    
    @io.qt.QtUninvokable
    public final void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.DoubleBuffer points){
        java.util.Objects.requireNonNull(points, "Argument 'points': null not expected.");
        glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @io.qt.QtUninvokable
    private native void glMap2d_native_GLenum_GLdouble_GLdouble_GLint_GLint_GLdouble_GLdouble_GLint_GLint_const_GLdouble_ptr(long __this__nativeId, int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, java.nio.DoubleBuffer points);
    
    @io.qt.QtUninvokable
    public final void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.FloatBuffer points){
        java.util.Objects.requireNonNull(points, "Argument 'points': null not expected.");
        glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    }
    
    @io.qt.QtUninvokable
    private native void glMap2f_native_GLenum_GLfloat_GLfloat_GLint_GLint_GLfloat_GLfloat_GLint_GLint_const_GLfloat_ptr(long __this__nativeId, int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, java.nio.FloatBuffer points);
    
    @io.qt.QtUninvokable
    public final java.nio.Buffer glMapBuffer(int target, int access){
        return glMapBuffer_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, access);
    }
    
    @io.qt.QtUninvokable
    private native java.nio.Buffer glMapBuffer_native_GLenum_GLenum(long __this__nativeId, int target, int access);
    
    @io.qt.QtUninvokable
    public final void glMapGrid1d(int un, double u1, double u2){
        glMapGrid1d_native_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @io.qt.QtUninvokable
    private native void glMapGrid1d_native_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2);
    
    @io.qt.QtUninvokable
    public final void glMapGrid1f(int un, float u1, float u2){
        glMapGrid1f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2);
    }
    
    @io.qt.QtUninvokable
    private native void glMapGrid1f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2);
    
    @io.qt.QtUninvokable
    public final void glMapGrid2d(int un, double u1, double u2, int vn, double v1, double v2){
        glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glMapGrid2d_native_GLint_GLdouble_GLdouble_GLint_GLdouble_GLdouble(long __this__nativeId, int un, double u1, double u2, int vn, double v1, double v2);
    
    @io.qt.QtUninvokable
    public final void glMapGrid2f(int un, float u1, float u2, int vn, float v1, float v2){
        glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), un, u1, u2, vn, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glMapGrid2f_native_GLint_GLfloat_GLfloat_GLint_GLfloat_GLfloat(long __this__nativeId, int un, float u1, float u2, int vn, float v1, float v2);
    
    @io.qt.QtUninvokable
    public final void glMaterialf(int face, int pname, float param){
        glMaterialf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glMaterialf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int face, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glMaterialfv(int face, int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glMaterialfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int face, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glMateriali(int face, int pname, int param){
        glMateriali_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glMateriali_native_GLenum_GLenum_GLint(long __this__nativeId, int face, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glMaterialiv(int face, int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), face, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glMaterialiv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int face, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glMatrixMode(int mode){
        glMatrixMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glMatrixMode_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glMinmax(int target, int internalformat, boolean sink){
        glMinmax_native_GLenum_GLenum_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, sink);
    }
    
    @io.qt.QtUninvokable
    private native void glMinmax_native_GLenum_GLenum_GLboolean(long __this__nativeId, int target, int internalformat, boolean sink);
    
    @io.qt.QtUninvokable
    public final void glMultMatrixd(double[] m){
        java.util.Objects.requireNonNull(m, "Argument 'm': null not expected.");
        if(m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @io.qt.QtUninvokable
    private native void glMultMatrixd_native_const_GLdouble_ptr(long __this__nativeId, double[] m);
    
    @io.qt.QtUninvokable
    public final void glMultMatrixf(float[] m){
        java.util.Objects.requireNonNull(m, "Argument 'm': null not expected.");
        if(m.length < 16)
            throw new IllegalArgumentException("Argument 'm': Wrong number of elements in array. Found: " + m.length + ", expected: 16");
        glMultMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @io.qt.QtUninvokable
    private native void glMultMatrixf_native_const_GLfloat_ptr(long __this__nativeId, float[] m);
    
    @io.qt.QtUninvokable
    public final void glMultTransposeMatrixd(java.nio.DoubleBuffer m){
        java.util.Objects.requireNonNull(m, "Argument 'm': null not expected.");
        glMultTransposeMatrixd_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @io.qt.QtUninvokable
    private native void glMultTransposeMatrixd_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer m);
    
    @io.qt.QtUninvokable
    public final void glMultTransposeMatrixf(java.nio.FloatBuffer m){
        java.util.Objects.requireNonNull(m, "Argument 'm': null not expected.");
        glMultTransposeMatrixf_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
    }
    
    @io.qt.QtUninvokable
    private native void glMultTransposeMatrixf_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer m);
    
    @io.qt.QtUninvokable
    public final void glMultiDrawArrays(int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount){
        java.util.Objects.requireNonNull(first, "Argument 'first': null not expected.");
        java.util.Objects.requireNonNull(count, "Argument 'count': null not expected.");
        glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count, drawcount);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiDrawArrays_native_GLenum_const_GLint_ptr_const_GLsizei_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer first, java.nio.IntBuffer count, int drawcount);
    
    @io.qt.QtUninvokable
    public final void glMultiDrawElements(int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount){
        java.util.Objects.requireNonNull(count, "Argument 'count': null not expected.");
        java.util.Objects.requireNonNull(indices, "Argument 'indices': null not expected.");
        glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices, drawcount);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiDrawElements_native_GLenum_const_GLsizei_ptr_GLenum_const_GLvoid_cptr_ptr_GLsizei(long __this__nativeId, int mode, java.nio.IntBuffer count, int type, java.nio.Buffer[] indices, int drawcount);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord1d(int target, double s){
        glMultiTexCoord1d_native_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord1d_native_GLenum_GLdouble(long __this__nativeId, int target, double s);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord1dv(int target, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord1dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord1f(int target, float s){
        glMultiTexCoord1f_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord1f_native_GLenum_GLfloat(long __this__nativeId, int target, float s);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord1fv(int target, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord1fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord1i(int target, int s){
        glMultiTexCoord1i_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord1i_native_GLenum_GLint(long __this__nativeId, int target, int s);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord1iv(int target, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord1iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord1s(int target, short s){
        glMultiTexCoord1s_native_GLenum_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord1s_native_GLenum_GLshort(long __this__nativeId, int target, short s);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord1sv(int target, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord1sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord2d(int target, double s, double t){
        glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord2d_native_GLenum_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord2dv(int target, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord2dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord2f(int target, float s, float t){
        glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord2f_native_GLenum_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord2fv(int target, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord2fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord2i(int target, int s, int t){
        glMultiTexCoord2i_native_GLenum_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord2i_native_GLenum_GLint_GLint(long __this__nativeId, int target, int s, int t);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord2iv(int target, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord2iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord2s(int target, short s, short t){
        glMultiTexCoord2s_native_GLenum_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord2s_native_GLenum_GLshort_GLshort(long __this__nativeId, int target, short s, short t);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord2sv(int target, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord2sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord3d(int target, double s, double t, double r){
        glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord3d_native_GLenum_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord3dv(int target, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord3dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord3f(int target, float s, float t, float r){
        glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord3f_native_GLenum_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord3fv(int target, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord3fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord3i(int target, int s, int t, int r){
        glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord3i_native_GLenum_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord3iv(int target, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord3iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord3s(int target, short s, short t, short r){
        glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord3s_native_GLenum_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord3sv(int target, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord3sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord4d(int target, double s, double t, double r, double q){
        glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord4d_native_GLenum_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int target, double s, double t, double r, double q);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord4dv(int target, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord4dv_native_GLenum_const_GLdouble_ptr(long __this__nativeId, int target, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord4f(int target, float s, float t, float r, float q){
        glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord4f_native_GLenum_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int target, float s, float t, float r, float q);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord4fv(int target, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord4fv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord4i(int target, int s, int t, int r, int q){
        glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord4i_native_GLenum_GLint_GLint_GLint_GLint(long __this__nativeId, int target, int s, int t, int r, int q);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord4iv(int target, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord4iv_native_GLenum_const_GLint_ptr(long __this__nativeId, int target, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord4s(int target, short s, short t, short r, short q){
        glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), target, s, t, r, q);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord4s_native_GLenum_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int target, short s, short t, short r, short q);
    
    @io.qt.QtUninvokable
    public final void glMultiTexCoord4sv(int target, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, v);
    }
    
    @io.qt.QtUninvokable
    private native void glMultiTexCoord4sv_native_GLenum_const_GLshort_ptr(long __this__nativeId, int target, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glNewList(int list, int mode){
        glNewList_native_GLuint_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), list, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glNewList_native_GLuint_GLenum(long __this__nativeId, int list, int mode);
    
    @io.qt.QtUninvokable
    public final void glNormal3b(byte nx, byte ny, byte nz){
        glNormal3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte nx, byte ny, byte nz);
    
    @io.qt.QtUninvokable
    public final void glNormal3bv(byte[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3bv_native_const_GLbyte_ptr(long __this__nativeId, byte[] v);
    
    @io.qt.QtUninvokable
    public final void glNormal3d(double nx, double ny, double nz){
        glNormal3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double nx, double ny, double nz);
    
    @io.qt.QtUninvokable
    public final void glNormal3dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glNormal3f(float nx, float ny, float nz){
        glNormal3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float nx, float ny, float nz);
    
    @io.qt.QtUninvokable
    public final void glNormal3fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glNormal3i(int nx, int ny, int nz){
        glNormal3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3i_native_GLint_GLint_GLint(long __this__nativeId, int nx, int ny, int nz);
    
    @io.qt.QtUninvokable
    public final void glNormal3iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glNormal3s(short nx, short ny, short nz){
        glNormal3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nz);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short nx, short ny, short nz);
    
    @io.qt.QtUninvokable
    public final void glNormal3sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glNormal3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glNormal3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glNormalPointer(int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glNormalPointer_native_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glNormalPointer_native_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glOrtho(double left, double right, double bottom, double top, double zNear, double zFar){
        glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), left, right, bottom, top, zNear, zFar);
    }
    
    @io.qt.QtUninvokable
    private native void glOrtho_native_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double left, double right, double bottom, double top, double zNear, double zFar);
    
    @io.qt.QtUninvokable
    public final void glPassThrough(float token){
        glPassThrough_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), token);
    }
    
    @io.qt.QtUninvokable
    private native void glPassThrough_native_GLfloat(long __this__nativeId, float token);
    
    @io.qt.QtUninvokable
    public final void glPixelMapfv(int map, int mapsize, java.nio.FloatBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glPixelMapfv_native_GLenum_GLint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelMapfv_native_GLenum_GLint_const_GLfloat_ptr(long __this__nativeId, int map, int mapsize, java.nio.FloatBuffer values);
    
    @io.qt.QtUninvokable
    public final void glPixelMapuiv(int map, int mapsize, java.nio.IntBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glPixelMapuiv_native_GLenum_GLint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelMapuiv_native_GLenum_GLint_const_GLuint_ptr(long __this__nativeId, int map, int mapsize, java.nio.IntBuffer values);
    
    @io.qt.QtUninvokable
    public final void glPixelMapusv(int map, int mapsize, java.nio.ShortBuffer values){
        java.util.Objects.requireNonNull(values, "Argument 'values': null not expected.");
        glPixelMapusv_native_GLenum_GLint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), map, mapsize, values);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelMapusv_native_GLenum_GLint_const_GLushort_ptr(long __this__nativeId, int map, int mapsize, java.nio.ShortBuffer values);
    
    @io.qt.QtUninvokable
    public final void glPixelStoref(int pname, float param){
        glPixelStoref_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelStoref_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glPixelTransferf(int pname, float param){
        glPixelTransferf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelTransferf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glPixelTransferi(int pname, int param){
        glPixelTransferi_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelTransferi_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glPixelZoom(float xfactor, float yfactor){
        glPixelZoom_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), xfactor, yfactor);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelZoom_native_GLfloat_GLfloat(long __this__nativeId, float xfactor, float yfactor);
    
    @io.qt.QtUninvokable
    public final void glPointParameterf(int pname, float param){
        glPointParameterf_native_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPointParameterf_native_GLenum_GLfloat(long __this__nativeId, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glPointParameterfv(int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glPointParameterfv_native_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glPointParameterfv_native_GLenum_const_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glPointParameteri(int pname, int param){
        glPointParameteri_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPointParameteri_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glPointParameteriv(int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glPointParameteriv_native_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glPointParameteriv_native_GLenum_const_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glPointSize(float size){
        glPointSize_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @io.qt.QtUninvokable
    private native void glPointSize_native_GLfloat(long __this__nativeId, float size);
    
    @io.qt.QtUninvokable
    public final void glPolygonMode(int face, int mode){
        glPolygonMode_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glPolygonMode_native_GLenum_GLenum(long __this__nativeId, int face, int mode);
    
    @io.qt.QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @io.qt.QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    @io.qt.QtUninvokable
    public final void glPolygonStipple(java.nio.ByteBuffer mask){
        java.util.Objects.requireNonNull(mask, "Argument 'mask': null not expected.");
        glPolygonStipple_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glPolygonStipple_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer mask);
    
    @io.qt.QtUninvokable
    public final void glPopAttrib(){
        glPopAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glPopAttrib_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glPopClientAttrib(){
        glPopClientAttrib_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glPopClientAttrib_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glPopMatrix(){
        glPopMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glPopMatrix_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glPopName(){
        glPopName_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glPopName_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glPrioritizeTextures(int n, java.nio.IntBuffer textures, java.nio.FloatBuffer priorities){
        java.util.Objects.requireNonNull(textures, "Argument 'textures': null not expected.");
        java.util.Objects.requireNonNull(priorities, "Argument 'priorities': null not expected.");
        glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures, priorities);
    }
    
    @io.qt.QtUninvokable
    private native void glPrioritizeTextures_native_GLsizei_const_GLuint_ptr_const_GLfloat_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures, java.nio.FloatBuffer priorities);
    
    @io.qt.QtUninvokable
    public final void glPushAttrib(int mask){
        glPushAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glPushAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glPushClientAttrib(int mask){
        glPushClientAttrib_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glPushClientAttrib_native_GLbitfield(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glPushMatrix(){
        glPushMatrix_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glPushMatrix_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glPushName(int name){
        glPushName_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void glPushName_native_GLuint(long __this__nativeId, int name);
    
    @io.qt.QtUninvokable
    public final void glRasterPos2d(double x, double y){
        glRasterPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    @io.qt.QtUninvokable
    public final void glRasterPos2dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos2f(float x, float y){
        glRasterPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    @io.qt.QtUninvokable
    public final void glRasterPos2fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos2i(int x, int y){
        glRasterPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    @io.qt.QtUninvokable
    public final void glRasterPos2iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos2s(short x, short y){
        glRasterPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    @io.qt.QtUninvokable
    public final void glRasterPos2sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glRasterPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos3d(double x, double y, double z){
        glRasterPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glRasterPos3dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos3f(float x, float y, float z){
        glRasterPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glRasterPos3fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos3i(int x, int y, int z){
        glRasterPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    @io.qt.QtUninvokable
    public final void glRasterPos3iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos3s(short x, short y, short z){
        glRasterPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    @io.qt.QtUninvokable
    public final void glRasterPos3sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glRasterPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos4d(double x, double y, double z, double w){
        glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    @io.qt.QtUninvokable
    public final void glRasterPos4dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos4f(float x, float y, float z, float w){
        glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void glRasterPos4fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos4i(int x, int y, int z, int w){
        glRasterPos4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    @io.qt.QtUninvokable
    public final void glRasterPos4iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glRasterPos4s(short x, short y, short z, short w){
        glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    @io.qt.QtUninvokable
    public final void glRasterPos4sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glRasterPos4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glRasterPos4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glReadBuffer(int mode){
        glReadBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glReadBuffer_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glRectd(double x1, double y1, double x2, double y2){
        glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @io.qt.QtUninvokable
    private native void glRectd_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x1, double y1, double x2, double y2);
    
    @io.qt.QtUninvokable
    public final void glRectdv(double[] v1, double[] v2){
        java.util.Objects.requireNonNull(v1, "Argument 'v1': null not expected.");
        if(v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        java.util.Objects.requireNonNull(v2, "Argument 'v2': null not expected.");
        if(v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glRectdv_native_const_GLdouble_ptr_const_GLdouble_ptr(long __this__nativeId, double[] v1, double[] v2);
    
    @io.qt.QtUninvokable
    public final void glRectf(float x1, float y1, float x2, float y2){
        glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @io.qt.QtUninvokable
    private native void glRectf_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x1, float y1, float x2, float y2);
    
    @io.qt.QtUninvokable
    public final void glRectfv(float[] v1, float[] v2){
        java.util.Objects.requireNonNull(v1, "Argument 'v1': null not expected.");
        if(v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        java.util.Objects.requireNonNull(v2, "Argument 'v2': null not expected.");
        if(v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glRectfv_native_const_GLfloat_ptr_const_GLfloat_ptr(long __this__nativeId, float[] v1, float[] v2);
    
    @io.qt.QtUninvokable
    public final void glRecti(int x1, int y1, int x2, int y2){
        glRecti_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @io.qt.QtUninvokable
    private native void glRecti_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x1, int y1, int x2, int y2);
    
    @io.qt.QtUninvokable
    public final void glRectiv(int[] v1, int[] v2){
        java.util.Objects.requireNonNull(v1, "Argument 'v1': null not expected.");
        if(v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        java.util.Objects.requireNonNull(v2, "Argument 'v2': null not expected.");
        if(v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectiv_native_const_GLint_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glRectiv_native_const_GLint_ptr_const_GLint_ptr(long __this__nativeId, int[] v1, int[] v2);
    
    @io.qt.QtUninvokable
    public final void glRects(short x1, short y1, short x2, short y2){
        glRects_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x1, y1, x2, y2);
    }
    
    @io.qt.QtUninvokable
    private native void glRects_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x1, short y1, short x2, short y2);
    
    @io.qt.QtUninvokable
    public final void glRectsv(short[] v1, short[] v2){
        java.util.Objects.requireNonNull(v1, "Argument 'v1': null not expected.");
        if(v1.length < 2)
            throw new IllegalArgumentException("Argument 'v1': Wrong number of elements in array. Found: " + v1.length + ", expected: 2");
        java.util.Objects.requireNonNull(v2, "Argument 'v2': null not expected.");
        if(v2.length < 2)
            throw new IllegalArgumentException("Argument 'v2': Wrong number of elements in array. Found: " + v2.length + ", expected: 2");
        glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glRectsv_native_const_GLshort_ptr_const_GLshort_ptr(long __this__nativeId, short[] v1, short[] v2);
    
    @io.qt.QtUninvokable
    public final int glRenderMode(int mode){
        return glRenderMode_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native int glRenderMode_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glResetHistogram(int target){
        glResetHistogram_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native void glResetHistogram_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glResetMinmax(int target){
        glResetMinmax_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native void glResetMinmax_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glRotated(double angle, double x, double y, double z){
        glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glRotated_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double angle, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glRotatef(float angle, float x, float y, float z){
        glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), angle, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glRotatef_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float angle, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLfloat_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @io.qt.QtUninvokable
    private native void glSampleCoverage_native_GLfloat_GLboolean(long __this__nativeId, float value, boolean invert);
    
    @io.qt.QtUninvokable
    public final void glScaled(double x, double y, double z){
        glScaled_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glScaled_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glScalef(float x, float y, float z){
        glScalef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glScalef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3b(byte red, byte green, byte blue){
        glSecondaryColor3b_native_GLbyte_GLbyte_GLbyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3b_native_GLbyte_GLbyte_GLbyte(long __this__nativeId, byte red, byte green, byte blue);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3bv(java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glSecondaryColor3bv_native_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3bv_native_const_GLbyte_ptr(long __this__nativeId, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3d(double red, double green, double blue){
        glSecondaryColor3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double red, double green, double blue);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3dv(java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glSecondaryColor3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3f(float red, float green, float blue){
        glSecondaryColor3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float red, float green, float blue);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3fv(java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glSecondaryColor3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3i(int red, int green, int blue){
        glSecondaryColor3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3i_native_GLint_GLint_GLint(long __this__nativeId, int red, int green, int blue);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3iv(java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glSecondaryColor3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3s(short red, short green, short blue){
        glSecondaryColor3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short red, short green, short blue);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3sv(java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glSecondaryColor3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3ub(byte red, byte green, byte blue){
        glSecondaryColor3ub_native_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3ub_native_GLubyte_GLubyte_GLubyte(long __this__nativeId, byte red, byte green, byte blue);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3ubv(java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glSecondaryColor3ubv_native_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3ubv_native_const_GLubyte_ptr(long __this__nativeId, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3ui(int red, int green, int blue){
        glSecondaryColor3ui_native_GLuint_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3ui_native_GLuint_GLuint_GLuint(long __this__nativeId, int red, int green, int blue);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3uiv(java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glSecondaryColor3uiv_native_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3uiv_native_const_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3us(short red, short green, short blue){
        glSecondaryColor3us_native_GLushort_GLushort_GLushort(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3us_native_GLushort_GLushort_GLushort(long __this__nativeId, short red, short green, short blue);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColor3usv(java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glSecondaryColor3usv_native_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColor3usv_native_const_GLushort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glSecondaryColorPointer(int size, int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glSecondaryColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glSecondaryColorPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glSelectBuffer(java.nio.IntBuffer buffer){
        java.util.Objects.requireNonNull(buffer, "Argument 'buffer': null not expected.");
        glSelectBuffer_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @io.qt.QtUninvokable
    private native void glSelectBuffer_native_GLsizei_GLuint_ptr(long __this__nativeId, java.nio.IntBuffer buffer);
    
    @io.qt.QtUninvokable
    public final void glSeparableFilter2D(int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer row, java.nio.Buffer column){
        java.util.Objects.requireNonNull(row, "Argument 'row': null not expected.");
        java.util.Objects.requireNonNull(column, "Argument 'column': null not expected.");
        glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height, format, type, row, column);
    }
    
    @io.qt.QtUninvokable
    private native void glSeparableFilter2D_native_GLenum_GLenum_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr_const_GLvoid_ptr(long __this__nativeId, int target, int internalformat, int width, int height, int format, int type, java.nio.Buffer row, java.nio.Buffer column);
    
    @io.qt.QtUninvokable
    public final void glShadeModel(int mode){
        glShadeModel_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glShadeModel_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string, java.nio.IntBuffer length){
        java.util.Objects.requireNonNull(length, "Argument 'length': null not expected.");
        glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string, length);
    }
    
    @io.qt.QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_cptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string, java.nio.IntBuffer length);
    
    @io.qt.QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    @io.qt.QtUninvokable
    public final void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, sfail, dpfail, dppass);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int sfail, int dpfail, int dppass);
    
    @io.qt.QtUninvokable
    public final void glTexCoord1d(double s){
        glTexCoord1d_native_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord1d_native_GLdouble(long __this__nativeId, double s);
    
    @io.qt.QtUninvokable
    public final void glTexCoord1dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord1dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord1f(float s){
        glTexCoord1f_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord1f_native_GLfloat(long __this__nativeId, float s);
    
    @io.qt.QtUninvokable
    public final void glTexCoord1fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord1fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord1i(int s){
        glTexCoord1i_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord1i_native_GLint(long __this__nativeId, int s);
    
    @io.qt.QtUninvokable
    public final void glTexCoord1iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord1iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord1s(short s){
        glTexCoord1s_native_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord1s_native_GLshort(long __this__nativeId, short s);
    
    @io.qt.QtUninvokable
    public final void glTexCoord1sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 1)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 1");
        glTexCoord1sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord1sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord2d(double s, double t){
        glTexCoord2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord2d_native_GLdouble_GLdouble(long __this__nativeId, double s, double t);
    
    @io.qt.QtUninvokable
    public final void glTexCoord2dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord2f(float s, float t){
        glTexCoord2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord2f_native_GLfloat_GLfloat(long __this__nativeId, float s, float t);
    
    @io.qt.QtUninvokable
    public final void glTexCoord2fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord2i(int s, int t){
        glTexCoord2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord2i_native_GLint_GLint(long __this__nativeId, int s, int t);
    
    @io.qt.QtUninvokable
    public final void glTexCoord2iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord2s(short s, short t){
        glTexCoord2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord2s_native_GLshort_GLshort(long __this__nativeId, short s, short t);
    
    @io.qt.QtUninvokable
    public final void glTexCoord2sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glTexCoord2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord3d(double s, double t, double r){
        glTexCoord3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r);
    
    @io.qt.QtUninvokable
    public final void glTexCoord3dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord3f(float s, float t, float r){
        glTexCoord3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r);
    
    @io.qt.QtUninvokable
    public final void glTexCoord3fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord3i(int s, int t, int r){
        glTexCoord3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord3i_native_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r);
    
    @io.qt.QtUninvokable
    public final void glTexCoord3iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord3s(short s, short t, short r){
        glTexCoord3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r);
    
    @io.qt.QtUninvokable
    public final void glTexCoord3sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glTexCoord3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord4d(double s, double t, double r, double q){
        glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double s, double t, double r, double q);
    
    @io.qt.QtUninvokable
    public final void glTexCoord4dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord4f(float s, float t, float r, float q){
        glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float s, float t, float r, float q);
    
    @io.qt.QtUninvokable
    public final void glTexCoord4fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord4i(int s, int t, int r, int q){
        glTexCoord4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int s, int t, int r, int q);
    
    @io.qt.QtUninvokable
    public final void glTexCoord4iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoord4s(short s, short t, short r, short q){
        glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), s, t, r, q);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short s, short t, short r, short q);
    
    @io.qt.QtUninvokable
    public final void glTexCoord4sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glTexCoord4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoord4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glTexCoordPointer(int size, int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glTexCoordPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glTexCoordPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glTexEnvf(int target, int pname, float param){
        glTexEnvf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexEnvf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glTexEnvfv(int target, int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexEnvfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glTexEnvi(int target, int pname, int param){
        glTexEnvi_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexEnvi_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glTexEnviv(int target, int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexEnviv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glTexGend(int coord, int pname, double param){
        glTexGend_native_GLenum_GLenum_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexGend_native_GLenum_GLenum_GLdouble(long __this__nativeId, int coord, int pname, double param);
    
    @io.qt.QtUninvokable
    public final void glTexGendv(int coord, int pname, double[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexGendv_native_GLenum_GLenum_const_GLdouble_ptr(long __this__nativeId, int coord, int pname, double[] params);
    
    @io.qt.QtUninvokable
    public final void glTexGenf(int coord, int pname, float param){
        glTexGenf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexGenf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int coord, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glTexGenfv(int coord, int pname, float[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexGenfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int coord, int pname, float[] params);
    
    @io.qt.QtUninvokable
    public final void glTexGeni(int coord, int pname, int param){
        glTexGeni_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexGeni_native_GLenum_GLenum_GLint(long __this__nativeId, int coord, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glTexGeniv(int coord, int pname, int[] params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        if(params.length < 1)
            throw new IllegalArgumentException("Argument 'params': Wrong number of elements in array. Found: " + params.length + ", expected: 1");
        glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), coord, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexGeniv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int coord, int pname, int[] params);
    
    @io.qt.QtUninvokable
    public final void glTexImage1D(int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, border, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage1D_native_GLenum_GLint_GLint_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int border, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, depth, border, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage3D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        java.util.Objects.requireNonNull(params, "Argument 'params': null not expected.");
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, width, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexSubImage1D_native_GLenum_GLint_GLint_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int width, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels){
        java.util.Objects.requireNonNull(pixels, "Argument 'pixels': null not expected.");
        glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexSubImage3D_native_GLenum_GLint_GLint_GLint_GLint_GLsizei_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTranslated(double x, double y, double z){
        glTranslated_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glTranslated_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glTranslatef(float x, float y, float z){
        glTranslatef_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glTranslatef_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glUniform1f(int location, float v0){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float v0);
    
    @io.qt.QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform1i(int location, int v0){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int v0);
    
    @io.qt.QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform2f(int location, float v0, float v1){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1);
    
    @io.qt.QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform2i(int location, int v0, int v1){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1);
    
    @io.qt.QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform3f(int location, float v0, float v1, float v2){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2);
    
    @io.qt.QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform3i(int location, int v0, int v1, int v2){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2);
    
    @io.qt.QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform4f(int location, float v0, float v1, float v2, float v3){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float v0, float v1, float v2, float v3);
    
    @io.qt.QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniform4i(int location, int v0, int v1, int v2, int v3){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, v0, v1, v2, v3);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int v0, int v1, int v2, int v3);
    
    @io.qt.QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.IntBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        java.util.Objects.requireNonNull(value, "Argument 'value': null not expected.");
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final boolean glUnmapBuffer(int target){
        return glUnmapBuffer_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native boolean glUnmapBuffer_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glVertex2d(double x, double y){
        glVertex2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    @io.qt.QtUninvokable
    public final void glVertex2dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex2dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex2f(float x, float y){
        glVertex2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    @io.qt.QtUninvokable
    public final void glVertex2fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex2fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex2i(int x, int y){
        glVertex2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    @io.qt.QtUninvokable
    public final void glVertex2iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex2iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex2s(short x, short y){
        glVertex2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    @io.qt.QtUninvokable
    public final void glVertex2sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 2)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 2");
        glVertex2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex2sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex3d(double x, double y, double z){
        glVertex3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glVertex3dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex3dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex3f(float x, float y, float z){
        glVertex3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glVertex3fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex3fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex3i(int x, int y, int z){
        glVertex3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    @io.qt.QtUninvokable
    public final void glVertex3iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex3iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex3s(short x, short y, short z){
        glVertex3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    @io.qt.QtUninvokable
    public final void glVertex3sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 3)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 3");
        glVertex3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex3sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex4d(double x, double y, double z, double w){
        glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex4d_native_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z, double w);
    
    @io.qt.QtUninvokable
    public final void glVertex4dv(double[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex4dv_native_const_GLdouble_ptr(long __this__nativeId, double[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex4f(float x, float y, float z, float w){
        glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex4f_native_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void glVertex4fv(float[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex4fv_native_const_GLfloat_ptr(long __this__nativeId, float[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex4i(int x, int y, int z, int w){
        glVertex4i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex4i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z, int w);
    
    @io.qt.QtUninvokable
    public final void glVertex4iv(int[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex4iv_native_const_GLint_ptr(long __this__nativeId, int[] v);
    
    @io.qt.QtUninvokable
    public final void glVertex4s(short x, short y, short z, short w){
        glVertex4s_native_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex4s_native_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z, short w);
    
    @io.qt.QtUninvokable
    public final void glVertex4sv(short[] v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        if(v.length < 4)
            throw new IllegalArgumentException("Argument 'v': Wrong number of elements in array. Found: " + v.length + ", expected: 4");
        glVertex4sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertex4sv_native_const_GLshort_ptr(long __this__nativeId, short[] v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1d(int index, double x){
        glVertexAttrib1d_native_GLuint_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1d_native_GLuint_GLdouble(long __this__nativeId, int index, double x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1f(int index, float x){
        glVertexAttrib1f_native_GLuint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1f_native_GLuint_GLfloat(long __this__nativeId, int index, float x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1fv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1s(int index, short x){
        glVertexAttrib1s_native_GLuint_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1s_native_GLuint_GLshort(long __this__nativeId, int index, short x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2d(int index, double x, double y){
        glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2d_native_GLuint_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2f(int index, float x, float y){
        glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2fv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2s(int index, short x, short y){
        glVertexAttrib2s_native_GLuint_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2s_native_GLuint_GLshort_GLshort(long __this__nativeId, int index, short x, short y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3d(int index, double x, double y, double z){
        glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3d_native_GLuint_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3f(int index, float x, float y, float z){
        glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3fv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3s(int index, short x, short y, short z){
        glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3s_native_GLuint_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nbv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nbv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Niv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Niv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nsv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nsv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w){
        glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nub_native_GLuint_GLubyte_GLubyte_GLubyte_GLubyte(long __this__nativeId, int index, byte x, byte y, byte z, byte w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nubv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nuiv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nuiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4Nusv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4Nusv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4bv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4bv_native_GLuint_const_GLbyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4d(int index, double x, double y, double z, double w){
        glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4d_native_GLuint_GLdouble_GLdouble_GLdouble_GLdouble(long __this__nativeId, int index, double x, double y, double z, double w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4dv(int index, java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4dv_native_GLuint_const_GLdouble_ptr(long __this__nativeId, int index, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4f(int index, float x, float y, float z, float w){
        glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int index, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4fv(int index, java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int index, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4iv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4iv_native_GLuint_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4iv_native_GLuint_const_GLint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4s(int index, short x, short y, short z, short w){
        glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), index, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4s_native_GLuint_GLshort_GLshort_GLshort_GLshort(long __this__nativeId, int index, short x, short y, short z, short w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4sv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4sv_native_GLuint_const_GLshort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4ubv(int index, java.nio.ByteBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4ubv_native_GLuint_const_GLubyte_ptr(long __this__nativeId, int index, java.nio.ByteBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4uiv(int index, java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4uiv_native_GLuint_const_GLuint_ptr(long __this__nativeId, int index, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4usv(int index, java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, v);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4usv_native_GLuint_const_GLushort_ptr(long __this__nativeId, int index, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, size, type, normalized, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(long __this__nativeId, int index, int size, int type, boolean normalized, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glVertexPointer(int size, int type, int stride, java.nio.Buffer pointer){
        java.util.Objects.requireNonNull(pointer, "Argument 'pointer': null not expected.");
        glVertexPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), size, type, stride, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexPointer_native_GLint_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int size, int type, int stride, java.nio.Buffer pointer);
    
    @io.qt.QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glWindowPos2d(double x, double y){
        glWindowPos2d_native_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos2d_native_GLdouble_GLdouble(long __this__nativeId, double x, double y);
    
    @io.qt.QtUninvokable
    public final void glWindowPos2dv(java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glWindowPos2dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos2dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glWindowPos2f(float x, float y){
        glWindowPos2f_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos2f_native_GLfloat_GLfloat(long __this__nativeId, float x, float y);
    
    @io.qt.QtUninvokable
    public final void glWindowPos2fv(java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glWindowPos2fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos2fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glWindowPos2i(int x, int y){
        glWindowPos2i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos2i_native_GLint_GLint(long __this__nativeId, int x, int y);
    
    @io.qt.QtUninvokable
    public final void glWindowPos2iv(java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glWindowPos2iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos2iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glWindowPos2s(short x, short y){
        glWindowPos2s_native_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos2s_native_GLshort_GLshort(long __this__nativeId, short x, short y);
    
    @io.qt.QtUninvokable
    public final void glWindowPos2sv(java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glWindowPos2sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos2sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public final void glWindowPos3d(double x, double y, double z){
        glWindowPos3d_native_GLdouble_GLdouble_GLdouble(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos3d_native_GLdouble_GLdouble_GLdouble(long __this__nativeId, double x, double y, double z);
    
    @io.qt.QtUninvokable
    public final void glWindowPos3dv(java.nio.DoubleBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glWindowPos3dv_native_const_GLdouble_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos3dv_native_const_GLdouble_ptr(long __this__nativeId, java.nio.DoubleBuffer v);
    
    @io.qt.QtUninvokable
    public final void glWindowPos3f(float x, float y, float z){
        glWindowPos3f_native_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos3f_native_GLfloat_GLfloat_GLfloat(long __this__nativeId, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glWindowPos3fv(java.nio.FloatBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glWindowPos3fv_native_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos3fv_native_const_GLfloat_ptr(long __this__nativeId, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glWindowPos3i(int x, int y, int z){
        glWindowPos3i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos3i_native_GLint_GLint_GLint(long __this__nativeId, int x, int y, int z);
    
    @io.qt.QtUninvokable
    public final void glWindowPos3iv(java.nio.IntBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glWindowPos3iv_native_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos3iv_native_const_GLint_ptr(long __this__nativeId, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glWindowPos3s(short x, short y, short z){
        glWindowPos3s_native_GLshort_GLshort_GLshort(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos3s_native_GLshort_GLshort_GLshort(long __this__nativeId, short x, short y, short z);
    
    @io.qt.QtUninvokable
    public final void glWindowPos3sv(java.nio.ShortBuffer v){
        java.util.Objects.requireNonNull(v, "Argument 'v': null not expected.");
        glWindowPos3sv_native_const_GLshort_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), v);
    }
    
    @io.qt.QtUninvokable
    private native void glWindowPos3sv_native_const_GLshort_ptr(long __this__nativeId, java.nio.ShortBuffer v);
    
    @io.qt.QtUninvokable
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLFunctions_2_0(QPrivateConstructor p) { super(p); } 
    
}
