package io.qt.opengl;


/**
 * <p>Functions for creating and managing OpenGL buffer objects</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qopenglbuffer.html">QOpenGLBuffer</a></p>
 */
public class QOpenGLBuffer extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopenglbuffer.html#Access-enum">QOpenGLBuffer::Access</a></p>
     */
    public enum Access implements io.qt.QtEnumerator {
        ReadOnly(35000),
        WriteOnly(35001),
        ReadWrite(35002);

        private Access(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Access resolve(int value) {
            switch (value) {
            case 35000: return ReadOnly;
            case 35001: return WriteOnly;
            case 35002: return ReadWrite;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopenglbuffer.html#RangeAccessFlag-enum">QOpenGLBuffer::RangeAccessFlag</a></p>
     * 
     * @see RangeAccessFlags
     */
    public enum RangeAccessFlag implements io.qt.QtFlagEnumerator {
        RangeRead(1),
        RangeWrite(2),
        RangeInvalidate(4),
        RangeInvalidateBuffer(8),
        RangeFlushExplicit(16),
        RangeUnsynchronized(32);

        private RangeAccessFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public RangeAccessFlags asFlags() {
            return new RangeAccessFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public RangeAccessFlags combined(RangeAccessFlag e) {
            return new RangeAccessFlags(this, e);
        }

        /**
         * Creates a new {@link RangeAccessFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static RangeAccessFlags flags(RangeAccessFlag ... values) {
            return new RangeAccessFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RangeAccessFlag resolve(int value) {
            switch (value) {
            case 1: return RangeRead;
            case 2: return RangeWrite;
            case 4: return RangeInvalidate;
            case 8: return RangeInvalidateBuffer;
            case 16: return RangeFlushExplicit;
            case 32: return RangeUnsynchronized;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link RangeAccessFlag}
     */
    public static final class RangeAccessFlags extends io.qt.QFlags<RangeAccessFlag> implements Comparable<RangeAccessFlags> {
        private static final long serialVersionUID = 0xc659f859e942b0e3L;

        /**
         * Creates a new RangeAccessFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public RangeAccessFlags(RangeAccessFlag ... args){
            super(args);
        }

        /**
         * Creates a new RangeAccessFlags with given <code>value</code>.
         * @param value
         */
        public RangeAccessFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new RangeAccessFlags
         */
        @Override
        public final RangeAccessFlags combined(RangeAccessFlag e){
            return new RangeAccessFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final RangeAccessFlags setFlag(RangeAccessFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final RangeAccessFlags setFlag(RangeAccessFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this RangeAccessFlags.
         * @return array of enum entries
         */
        @Override
        public final RangeAccessFlag[] flags(){
            return super.flags(RangeAccessFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final RangeAccessFlags clone(){
            return new RangeAccessFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(RangeAccessFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopenglbuffer.html#Type-enum">QOpenGLBuffer::Type</a></p>
     */
    public enum Type implements io.qt.QtEnumerator {
        VertexBuffer(34962),
        IndexBuffer(34963),
        PixelPackBuffer(35051),
        PixelUnpackBuffer(35052);

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case 34962: return VertexBuffer;
            case 34963: return IndexBuffer;
            case 35051: return PixelPackBuffer;
            case 35052: return PixelUnpackBuffer;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopenglbuffer.html#UsagePattern-enum">QOpenGLBuffer::UsagePattern</a></p>
     */
    public enum UsagePattern implements io.qt.QtEnumerator {
        StreamDraw(35040),
        StreamRead(35041),
        StreamCopy(35042),
        StaticDraw(35044),
        StaticRead(35045),
        StaticCopy(35046),
        DynamicDraw(35048),
        DynamicRead(35049),
        DynamicCopy(35050);

        private UsagePattern(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static UsagePattern resolve(int value) {
            switch (value) {
            case 35040: return StreamDraw;
            case 35041: return StreamRead;
            case 35042: return StreamCopy;
            case 35044: return StaticDraw;
            case 35045: return StaticRead;
            case 35046: return StaticCopy;
            case 35048: return DynamicDraw;
            case 35049: return DynamicRead;
            case 35050: return DynamicCopy;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#QOpenGLBuffer">QOpenGLBuffer::QOpenGLBuffer()</a></p>
     */
    public QOpenGLBuffer(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLBuffer instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#QOpenGLBuffer-1">QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer::Type)</a></p>
     */
    public QOpenGLBuffer(io.qt.opengl.QOpenGLBuffer.Type type){
        super((QPrivateConstructor)null);
        initialize_native(this, type);
    }
    
    private native static void initialize_native(QOpenGLBuffer instance, io.qt.opengl.QOpenGLBuffer.Type type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#QOpenGLBuffer-2">QOpenGLBuffer::QOpenGLBuffer(QOpenGLBuffer)</a></p>
     */
    public QOpenGLBuffer(io.qt.opengl.QOpenGLBuffer other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QOpenGLBuffer instance, io.qt.opengl.QOpenGLBuffer other);
    
    @io.qt.QtUninvokable
    public final void allocate(java.nio.Buffer data, int count){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        allocate_native_const_void_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), data, count);
    }
    
    @io.qt.QtUninvokable
    private native void allocate_native_const_void_ptr_int(long __this__nativeId, java.nio.Buffer data, int count);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#allocate-1">QOpenGLBuffer::allocate(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void allocate(int count){
        allocate_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), count);
    }
    
    @io.qt.QtUninvokable
    private native void allocate_native_int(long __this__nativeId, int count);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#bind">QOpenGLBuffer::bind()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean bind(){
        return bind_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean bind_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#bufferId">QOpenGLBuffer::bufferId()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int bufferId(){
        return bufferId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int bufferId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#create">QOpenGLBuffer::create()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#destroy">QOpenGLBuffer::destroy()</a></p>
     */
    @io.qt.QtUninvokable
    public final void destroy(){
        destroy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void destroy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#isCreated">QOpenGLBuffer::isCreated()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCreated(){
        return isCreated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCreated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#map">QOpenGLBuffer::map(QOpenGLBuffer::Access)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.nio.ByteBuffer map(io.qt.opengl.QOpenGLBuffer.Access access){
        return map_native_QOpenGLBuffer_Access(QtJambi_LibraryUtilities.internal.nativeId(this), access.value());
    }
    
    @io.qt.QtUninvokable
    private native java.nio.ByteBuffer map_native_QOpenGLBuffer_Access(long __this__nativeId, int access);
    
    /**
     * <p>Overloaded function for {@link #mapRange(int, int, io.qt.opengl.QOpenGLBuffer.RangeAccessFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final java.nio.ByteBuffer mapRange(int offset, int count, io.qt.opengl.QOpenGLBuffer.RangeAccessFlag ... access){
        return mapRange(offset, count, new io.qt.opengl.QOpenGLBuffer.RangeAccessFlags(access));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#mapRange">QOpenGLBuffer::mapRange(int,int,QOpenGLBuffer::RangeAccessFlags)</a></p>
     */
    @io.qt.QtUninvokable
    public final java.nio.ByteBuffer mapRange(int offset, int count, io.qt.opengl.QOpenGLBuffer.RangeAccessFlags access){
        return mapRange_native_int_int_QFlags_QOpenGLBuffer_RangeAccessFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), offset, count, access.value());
    }
    
    @io.qt.QtUninvokable
    private native java.nio.ByteBuffer mapRange_native_int_int_QFlags_QOpenGLBuffer_RangeAccessFlag_(long __this__nativeId, int offset, int count, int access);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#read">QOpenGLBuffer::read(int,void*,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean read(int offset, java.nio.Buffer data, int count){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        return read_native_int_void_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset, data, count);
    }
    
    @io.qt.QtUninvokable
    private native boolean read_native_int_void_ptr_int(long __this__nativeId, int offset, java.nio.Buffer data, int count);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#release">QOpenGLBuffer::release()</a></p>
     */
    @io.qt.QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#setUsagePattern">QOpenGLBuffer::setUsagePattern(QOpenGLBuffer::UsagePattern)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUsagePattern(io.qt.opengl.QOpenGLBuffer.UsagePattern value){
        setUsagePattern_native_QOpenGLBuffer_UsagePattern(QtJambi_LibraryUtilities.internal.nativeId(this), value.value());
    }
    
    @io.qt.QtUninvokable
    private native void setUsagePattern_native_QOpenGLBuffer_UsagePattern(long __this__nativeId, int value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#size">QOpenGLBuffer::size()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#type">QOpenGLBuffer::type()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.opengl.QOpenGLBuffer.Type type(){
        return io.qt.opengl.QOpenGLBuffer.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#unmap">QOpenGLBuffer::unmap()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean unmap(){
        return unmap_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean unmap_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#usagePattern">QOpenGLBuffer::usagePattern()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.opengl.QOpenGLBuffer.UsagePattern usagePattern(){
        return io.qt.opengl.QOpenGLBuffer.UsagePattern.resolve(usagePattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int usagePattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#write">QOpenGLBuffer::write(int,const void*,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void write(int offset, java.nio.Buffer data, int count){
        java.util.Objects.requireNonNull(data, "Argument 'data': null not expected.");
        write_native_int_const_void_ptr_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset, data, count);
    }
    
    @io.qt.QtUninvokable
    private native void write_native_int_const_void_ptr_int(long __this__nativeId, int offset, java.nio.Buffer data, int count);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglbuffer.html#release-1">QOpenGLBuffer::release(QOpenGLBuffer::Type)</a></p>
     */
    public static void release(io.qt.opengl.QOpenGLBuffer.Type type){
        release_native_QOpenGLBuffer_Type(type.value());
    }
    
    private native static void release_native_QOpenGLBuffer_Type(int type);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLBuffer(QPrivateConstructor p) { super(p); } 
    
    
    @Override
    public QOpenGLBuffer clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QOpenGLBuffer clone_native(long __this_nativeId);
}
