package io.qt.opengl;


/**
 * <p>Provides access to OpenGL functions for a specified version and profile</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qopenglversionfunctionsfactory.html">QOpenGLVersionFunctionsFactory</a></p>
 */
public class QOpenGLVersionFunctionsFactory extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    public QOpenGLVersionFunctionsFactory(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLVersionFunctionsFactory instance);
    
    /**
     * <p>Overloaded function for {@link #get(io.qt.opengl.QOpenGLVersionProfile, io.qt.gui.QOpenGLContext)}
     *  with <code>context = null</code>.</p>
     */
    public static io.qt.opengl.QAbstractOpenGLFunctions get(io.qt.opengl.QOpenGLVersionProfile versionProfile) {
        return get(versionProfile, (io.qt.gui.QOpenGLContext)null);
    }
    
    /**
     * <p>Overloaded function for {@link #get(io.qt.opengl.QOpenGLVersionProfile, io.qt.gui.QOpenGLContext)}</p>
     * <p>with: </p><ul>
     * <li><code>versionProfile = new io.qt.opengl.QOpenGLVersionProfile()</code></li>
     * <li><code>context = null</code></li>
     * </ul>
     */
    public static io.qt.opengl.QAbstractOpenGLFunctions get() {
        return get(new io.qt.opengl.QOpenGLVersionProfile(), (io.qt.gui.QOpenGLContext)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglversionfunctionsfactory.html#get">QOpenGLVersionFunctionsFactory::get(QOpenGLVersionProfile,QOpenGLContext*)</a></p>
     */
    public static io.qt.opengl.QAbstractOpenGLFunctions get(io.qt.opengl.QOpenGLVersionProfile versionProfile, io.qt.gui.QOpenGLContext context){
        return get_native_cref_QOpenGLVersionProfile_QOpenGLContext_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(versionProfile), QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    private native static io.qt.opengl.QAbstractOpenGLFunctions get_native_cref_QOpenGLVersionProfile_QOpenGLContext_ptr(long versionProfile, long context);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLVersionFunctionsFactory(QPrivateConstructor p) { super(p); } 
    
    @io.qt.QtUninvokable
    public static <T extends io.qt.opengl.QAbstractOpenGLFunctions> T get(Class<T> type){
        return get(type, null);
    }
    @io.qt.QtUninvokable
    public static native <T extends io.qt.opengl.QAbstractOpenGLFunctions> T get(Class<T> type, io.qt.gui.QOpenGLContext context);
}
