package io.qt.opengl;


/**
 * <p>Convenient way to draw textured quads via OpenGL</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopengltextureblitter.html">QOpenGLTextureBlitter</a></p>
 */
public class QOpenGLTextureBlitter extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengltextureblitter.html#Origin-enum">QOpenGLTextureBlitter::Origin</a></p>
     */
    public enum Origin implements io.qt.QtEnumerator {
        OriginBottomLeft(0),
        OriginTopLeft(1);

        private Origin(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Origin resolve(int value) {
            switch (value) {
            case 0: return OriginBottomLeft;
            case 1: return OriginTopLeft;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#QOpenGLTextureBlitter">QOpenGLTextureBlitter::QOpenGLTextureBlitter()</a></p>
     */
    public QOpenGLTextureBlitter(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLTextureBlitter instance);
    
    /**
     * <p>Overloaded function for {@link #bind(int)}
     *  with <code>target = 0x0DE1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void bind() {
        bind((int)0x0DE1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#bind">QOpenGLTextureBlitter::bind(GLenum)</a></p>
     */
    @io.qt.QtUninvokable
    public final void bind(int target){
        bind_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native void bind_native_GLenum(long __this__nativeId, int target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#blit">QOpenGLTextureBlitter::blit(GLuint,QMatrix4x4,QOpenGLTextureBlitter::Origin)</a></p>
     */
    @io.qt.QtUninvokable
    public final void blit(int texture, io.qt.gui.QMatrix4x4 targetTransform, io.qt.opengl.QOpenGLTextureBlitter.Origin sourceOrigin){
        blit_native_GLuint_cref_QMatrix4x4_QOpenGLTextureBlitter_Origin(QtJambi_LibraryUtilities.internal.nativeId(this), texture, QtJambi_LibraryUtilities.internal.checkedNativeId(targetTransform), sourceOrigin.value());
    }
    
    @io.qt.QtUninvokable
    private native void blit_native_GLuint_cref_QMatrix4x4_QOpenGLTextureBlitter_Origin(long __this__nativeId, int texture, long targetTransform, int sourceOrigin);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#blit-1">QOpenGLTextureBlitter::blit(GLuint,QMatrix4x4,QMatrix3x3)</a></p>
     */
    @io.qt.QtUninvokable
    public final void blit(int texture, io.qt.gui.QMatrix4x4 targetTransform, io.qt.gui.QMatrix3x3 sourceTransform){
        blit_native_GLuint_cref_QMatrix4x4_cref_QMatrix3x3(QtJambi_LibraryUtilities.internal.nativeId(this), texture, QtJambi_LibraryUtilities.internal.checkedNativeId(targetTransform), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceTransform));
    }
    
    @io.qt.QtUninvokable
    private native void blit_native_GLuint_cref_QMatrix4x4_cref_QMatrix3x3(long __this__nativeId, int texture, long targetTransform, long sourceTransform);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#create">QOpenGLTextureBlitter::create()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#destroy">QOpenGLTextureBlitter::destroy()</a></p>
     */
    @io.qt.QtUninvokable
    public final void destroy(){
        destroy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void destroy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#isCreated">QOpenGLTextureBlitter::isCreated()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCreated(){
        return isCreated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCreated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#release">QOpenGLTextureBlitter::release()</a></p>
     */
    @io.qt.QtUninvokable
    public final void release(){
        release_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void release_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#setOpacity">QOpenGLTextureBlitter::setOpacity(float)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOpacity(float opacity){
        setOpacity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), opacity);
    }
    
    @io.qt.QtUninvokable
    private native void setOpacity_native_float(long __this__nativeId, float opacity);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#setRedBlueSwizzle">QOpenGLTextureBlitter::setRedBlueSwizzle(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRedBlueSwizzle(boolean swizzle){
        setRedBlueSwizzle_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), swizzle);
    }
    
    @io.qt.QtUninvokable
    private native void setRedBlueSwizzle_native_bool(long __this__nativeId, boolean swizzle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#supportsExternalOESTarget">QOpenGLTextureBlitter::supportsExternalOESTarget()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean supportsExternalOESTarget(){
        return supportsExternalOESTarget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean supportsExternalOESTarget_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#sourceTransform">QOpenGLTextureBlitter::sourceTransform(QRectF,QSize,QOpenGLTextureBlitter::Origin)</a></p>
     */
    public static io.qt.gui.QMatrix3x3 sourceTransform(io.qt.core.QRectF subTexture, io.qt.core.QSize textureSize, io.qt.opengl.QOpenGLTextureBlitter.Origin origin){
        return sourceTransform_native_cref_QRectF_cref_QSize_QOpenGLTextureBlitter_Origin(QtJambi_LibraryUtilities.internal.checkedNativeId(subTexture), QtJambi_LibraryUtilities.internal.checkedNativeId(textureSize), origin.value());
    }
    
    private native static io.qt.gui.QMatrix3x3 sourceTransform_native_cref_QRectF_cref_QSize_QOpenGLTextureBlitter_Origin(long subTexture, long textureSize, int origin);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltextureblitter.html#targetTransform">QOpenGLTextureBlitter::targetTransform(QRectF,QRect)</a></p>
     */
    public static io.qt.gui.QMatrix4x4 targetTransform(io.qt.core.QRectF target, io.qt.core.QRect viewport){
        return targetTransform_native_cref_QRectF_cref_QRect(QtJambi_LibraryUtilities.internal.checkedNativeId(target), QtJambi_LibraryUtilities.internal.checkedNativeId(viewport));
    }
    
    private native static io.qt.gui.QMatrix4x4 targetTransform_native_cref_QRectF_cref_QRect(long target, long viewport);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLTextureBlitter(QPrivateConstructor p) { super(p); } 
    
}
