package io.qt.opengl;


/**
 * <p>Enables logging of OpenGL debugging messages</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopengldebuglogger.html">QOpenGLDebugLogger</a></p>
 */
public class QOpenGLDebugLogger extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLDebugLogger.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopengldebuglogger.html#LoggingMode-enum">QOpenGLDebugLogger::LoggingMode</a></p>
     */
    public enum LoggingMode implements io.qt.QtEnumerator {
        AsynchronousLogging(0),
        SynchronousLogging(1);

        private LoggingMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static LoggingMode resolve(int value) {
            switch (value) {
            case 0: return AsynchronousLogging;
            case 1: return SynchronousLogging;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#messageLogged">QOpenGLDebugLogger::messageLogged(QOpenGLDebugMessage)</a></p>
     */
    public final Signal1<io.qt.opengl.QOpenGLDebugMessage> messageLogged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLDebugLogger(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLDebugLogger() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#QOpenGLDebugLogger">QOpenGLDebugLogger::QOpenGLDebugLogger(QObject*)</a></p>
     */
    public QOpenGLDebugLogger(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOpenGLDebugLogger instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded function for {@link #disableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types, io.qt.opengl.QOpenGLDebugMessage.Severities)}.</p>
     */
    @io.qt.QtUninvokable
    public final void disableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Types types, io.qt.opengl.QOpenGLDebugMessage.Severity ... severities){
        disableMessages(sources, types, new io.qt.opengl.QOpenGLDebugMessage.Severities(severities));
    }
    
    /**
     * <p>Overloaded function for {@link #disableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types, io.qt.opengl.QOpenGLDebugMessage.Severities)}
     *  with <code>severities = new io.qt.opengl.QOpenGLDebugMessage.Severities(-1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void disableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Types types) {
        disableMessages(sources, types, new io.qt.opengl.QOpenGLDebugMessage.Severities(-1));
    }
    
    /**
     * <p>Overloaded function for {@link #disableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types, io.qt.opengl.QOpenGLDebugMessage.Severities)}</p>
     * <p>with: </p><ul>
     * <li><code>types = new io.qt.opengl.QOpenGLDebugMessage.Types(-1)</code></li>
     * <li><code>severities = new io.qt.opengl.QOpenGLDebugMessage.Severities(-1)</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void disableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources sources) {
        disableMessages(sources, new io.qt.opengl.QOpenGLDebugMessage.Types(-1), new io.qt.opengl.QOpenGLDebugMessage.Severities(-1));
    }
    
    /**
     * <p>Overloaded function for {@link #disableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types, io.qt.opengl.QOpenGLDebugMessage.Severities)}</p>
     * <p>with: </p><ul>
     * <li><code>sources = new io.qt.opengl.QOpenGLDebugMessage.Sources(-1)</code></li>
     * <li><code>types = new io.qt.opengl.QOpenGLDebugMessage.Types(-1)</code></li>
     * <li><code>severities = new io.qt.opengl.QOpenGLDebugMessage.Severities(-1)</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void disableMessages() {
        disableMessages(new io.qt.opengl.QOpenGLDebugMessage.Sources(-1), new io.qt.opengl.QOpenGLDebugMessage.Types(-1), new io.qt.opengl.QOpenGLDebugMessage.Severities(-1));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#disableMessages">QOpenGLDebugLogger::disableMessages(QOpenGLDebugMessage::Sources,QOpenGLDebugMessage::Types,QOpenGLDebugMessage::Severities)</a></p>
     */
    @io.qt.QtUninvokable
    public final void disableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Types types, io.qt.opengl.QOpenGLDebugMessage.Severities severities){
        disableMessages_native_QFlags_QOpenGLDebugMessage_Source__QFlags_QOpenGLDebugMessage_Type__QFlags_QOpenGLDebugMessage_Severity_(QtJambi_LibraryUtilities.internal.nativeId(this), sources.value(), types.value(), severities.value());
    }
    
    @io.qt.QtUninvokable
    private native void disableMessages_native_QFlags_QOpenGLDebugMessage_Source__QFlags_QOpenGLDebugMessage_Type__QFlags_QOpenGLDebugMessage_Severity_(long __this__nativeId, int sources, int types, int severities);
    
    /**
     * <p>Overloaded function for {@link #disableMessages(java.util.Collection, io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types)}.</p>
     */
    @io.qt.QtUninvokable
    public final void disableMessages(java.util.Collection<java.lang.Integer> ids, io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Type ... types){
        disableMessages(ids, sources, new io.qt.opengl.QOpenGLDebugMessage.Types(types));
    }
    
    /**
     * <p>Overloaded function for {@link #disableMessages(java.util.Collection, io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types)}
     *  with <code>types = new io.qt.opengl.QOpenGLDebugMessage.Types(-1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void disableMessages(java.util.Collection<java.lang.Integer> ids, io.qt.opengl.QOpenGLDebugMessage.Sources sources) {
        disableMessages(ids, sources, new io.qt.opengl.QOpenGLDebugMessage.Types(-1));
    }
    
    /**
     * <p>Overloaded function for {@link #disableMessages(java.util.Collection, io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types)}</p>
     * <p>with: </p><ul>
     * <li><code>sources = new io.qt.opengl.QOpenGLDebugMessage.Sources(-1)</code></li>
     * <li><code>types = new io.qt.opengl.QOpenGLDebugMessage.Types(-1)</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void disableMessages(java.util.Collection<java.lang.Integer> ids) {
        disableMessages(ids, new io.qt.opengl.QOpenGLDebugMessage.Sources(-1), new io.qt.opengl.QOpenGLDebugMessage.Types(-1));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#disableMessages-1">QOpenGLDebugLogger::disableMessages(QList&lt;GLuint&gt;,QOpenGLDebugMessage::Sources,QOpenGLDebugMessage::Types)</a></p>
     */
    @io.qt.QtUninvokable
    public final void disableMessages(java.util.Collection<java.lang.Integer> ids, io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Types types){
        disableMessages_native_cref_QList_QFlags_QOpenGLDebugMessage_Source__QFlags_QOpenGLDebugMessage_Type_(QtJambi_LibraryUtilities.internal.nativeId(this), ids, sources.value(), types.value());
    }
    
    @io.qt.QtUninvokable
    private native void disableMessages_native_cref_QList_QFlags_QOpenGLDebugMessage_Source__QFlags_QOpenGLDebugMessage_Type_(long __this__nativeId, java.util.Collection<java.lang.Integer> ids, int sources, int types);
    
    /**
     * <p>Overloaded function for {@link #enableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types, io.qt.opengl.QOpenGLDebugMessage.Severities)}.</p>
     */
    @io.qt.QtUninvokable
    public final void enableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Types types, io.qt.opengl.QOpenGLDebugMessage.Severity ... severities){
        enableMessages(sources, types, new io.qt.opengl.QOpenGLDebugMessage.Severities(severities));
    }
    
    /**
     * <p>Overloaded function for {@link #enableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types, io.qt.opengl.QOpenGLDebugMessage.Severities)}
     *  with <code>severities = new io.qt.opengl.QOpenGLDebugMessage.Severities(-1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void enableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Types types) {
        enableMessages(sources, types, new io.qt.opengl.QOpenGLDebugMessage.Severities(-1));
    }
    
    /**
     * <p>Overloaded function for {@link #enableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types, io.qt.opengl.QOpenGLDebugMessage.Severities)}</p>
     * <p>with: </p><ul>
     * <li><code>types = new io.qt.opengl.QOpenGLDebugMessage.Types(-1)</code></li>
     * <li><code>severities = new io.qt.opengl.QOpenGLDebugMessage.Severities(-1)</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void enableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources sources) {
        enableMessages(sources, new io.qt.opengl.QOpenGLDebugMessage.Types(-1), new io.qt.opengl.QOpenGLDebugMessage.Severities(-1));
    }
    
    /**
     * <p>Overloaded function for {@link #enableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types, io.qt.opengl.QOpenGLDebugMessage.Severities)}</p>
     * <p>with: </p><ul>
     * <li><code>sources = new io.qt.opengl.QOpenGLDebugMessage.Sources(-1)</code></li>
     * <li><code>types = new io.qt.opengl.QOpenGLDebugMessage.Types(-1)</code></li>
     * <li><code>severities = new io.qt.opengl.QOpenGLDebugMessage.Severities(-1)</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void enableMessages() {
        enableMessages(new io.qt.opengl.QOpenGLDebugMessage.Sources(-1), new io.qt.opengl.QOpenGLDebugMessage.Types(-1), new io.qt.opengl.QOpenGLDebugMessage.Severities(-1));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#enableMessages">QOpenGLDebugLogger::enableMessages(QOpenGLDebugMessage::Sources,QOpenGLDebugMessage::Types,QOpenGLDebugMessage::Severities)</a></p>
     */
    @io.qt.QtUninvokable
    public final void enableMessages(io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Types types, io.qt.opengl.QOpenGLDebugMessage.Severities severities){
        enableMessages_native_QFlags_QOpenGLDebugMessage_Source__QFlags_QOpenGLDebugMessage_Type__QFlags_QOpenGLDebugMessage_Severity_(QtJambi_LibraryUtilities.internal.nativeId(this), sources.value(), types.value(), severities.value());
    }
    
    @io.qt.QtUninvokable
    private native void enableMessages_native_QFlags_QOpenGLDebugMessage_Source__QFlags_QOpenGLDebugMessage_Type__QFlags_QOpenGLDebugMessage_Severity_(long __this__nativeId, int sources, int types, int severities);
    
    /**
     * <p>Overloaded function for {@link #enableMessages(java.util.Collection, io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types)}.</p>
     */
    @io.qt.QtUninvokable
    public final void enableMessages(java.util.Collection<java.lang.Integer> ids, io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Type ... types){
        enableMessages(ids, sources, new io.qt.opengl.QOpenGLDebugMessage.Types(types));
    }
    
    /**
     * <p>Overloaded function for {@link #enableMessages(java.util.Collection, io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types)}
     *  with <code>types = new io.qt.opengl.QOpenGLDebugMessage.Types(-1)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void enableMessages(java.util.Collection<java.lang.Integer> ids, io.qt.opengl.QOpenGLDebugMessage.Sources sources) {
        enableMessages(ids, sources, new io.qt.opengl.QOpenGLDebugMessage.Types(-1));
    }
    
    /**
     * <p>Overloaded function for {@link #enableMessages(java.util.Collection, io.qt.opengl.QOpenGLDebugMessage.Sources, io.qt.opengl.QOpenGLDebugMessage.Types)}</p>
     * <p>with: </p><ul>
     * <li><code>sources = new io.qt.opengl.QOpenGLDebugMessage.Sources(-1)</code></li>
     * <li><code>types = new io.qt.opengl.QOpenGLDebugMessage.Types(-1)</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void enableMessages(java.util.Collection<java.lang.Integer> ids) {
        enableMessages(ids, new io.qt.opengl.QOpenGLDebugMessage.Sources(-1), new io.qt.opengl.QOpenGLDebugMessage.Types(-1));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#enableMessages-1">QOpenGLDebugLogger::enableMessages(QList&lt;GLuint&gt;,QOpenGLDebugMessage::Sources,QOpenGLDebugMessage::Types)</a></p>
     */
    @io.qt.QtUninvokable
    public final void enableMessages(java.util.Collection<java.lang.Integer> ids, io.qt.opengl.QOpenGLDebugMessage.Sources sources, io.qt.opengl.QOpenGLDebugMessage.Types types){
        enableMessages_native_cref_QList_QFlags_QOpenGLDebugMessage_Source__QFlags_QOpenGLDebugMessage_Type_(QtJambi_LibraryUtilities.internal.nativeId(this), ids, sources.value(), types.value());
    }
    
    @io.qt.QtUninvokable
    private native void enableMessages_native_cref_QList_QFlags_QOpenGLDebugMessage_Source__QFlags_QOpenGLDebugMessage_Type_(long __this__nativeId, java.util.Collection<java.lang.Integer> ids, int sources, int types);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#initialize">QOpenGLDebugLogger::initialize()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean initialize(){
        return initialize_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean initialize_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#isLogging">QOpenGLDebugLogger::isLogging()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isLogging(){
        return isLogging_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isLogging_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#logMessage">QOpenGLDebugLogger::logMessage(QOpenGLDebugMessage)</a></p>
     */
    public final void logMessage(io.qt.opengl.QOpenGLDebugMessage debugMessage){
        logMessage_native_cref_QOpenGLDebugMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(debugMessage));
    }
    
    private native void logMessage_native_cref_QOpenGLDebugMessage(long __this__nativeId, long debugMessage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#loggedMessages">QOpenGLDebugLogger::loggedMessages()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.opengl.QOpenGLDebugMessage> loggedMessages(){
        return loggedMessages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.opengl.QOpenGLDebugMessage> loggedMessages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#loggingMode">QOpenGLDebugLogger::loggingMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="loggingMode")
    @io.qt.QtUninvokable
    public final io.qt.opengl.QOpenGLDebugLogger.LoggingMode loggingMode(){
        return io.qt.opengl.QOpenGLDebugLogger.LoggingMode.resolve(loggingMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int loggingMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#maximumMessageLength">QOpenGLDebugLogger::maximumMessageLength()const</a></p>
     */
    @io.qt.QtUninvokable
    public final long maximumMessageLength(){
        return maximumMessageLength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long maximumMessageLength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#popGroup">QOpenGLDebugLogger::popGroup()</a></p>
     */
    @io.qt.QtUninvokable
    public final void popGroup(){
        popGroup_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void popGroup_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #pushGroup(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Source)}
     *  with <code>source = io.qt.opengl.QOpenGLDebugMessage.Source.ApplicationSource</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void pushGroup(java.lang.String name, int id) {
        pushGroup(name, id, io.qt.opengl.QOpenGLDebugMessage.Source.ApplicationSource);
    }
    
    /**
     * <p>Overloaded function for {@link #pushGroup(java.lang.String, int, io.qt.opengl.QOpenGLDebugMessage.Source)}</p>
     * <p>with: </p><ul>
     * <li><code>id = 0</code></li>
     * <li><code>source = io.qt.opengl.QOpenGLDebugMessage.Source.ApplicationSource</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void pushGroup(java.lang.String name) {
        pushGroup(name, (int)0, io.qt.opengl.QOpenGLDebugMessage.Source.ApplicationSource);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#pushGroup">QOpenGLDebugLogger::pushGroup(QString,GLuint,QOpenGLDebugMessage::Source)</a></p>
     */
    @io.qt.QtUninvokable
    public final void pushGroup(java.lang.String name, int id, io.qt.opengl.QOpenGLDebugMessage.Source source){
        pushGroup_native_cref_QString_GLuint_QOpenGLDebugMessage_Source(QtJambi_LibraryUtilities.internal.nativeId(this), name, id, source.value());
    }
    
    @io.qt.QtUninvokable
    private native void pushGroup_native_cref_QString_GLuint_QOpenGLDebugMessage_Source(long __this__nativeId, java.lang.String name, int id, int source);
    
    /**
     * <p>Overloaded function for {@link #startLogging(io.qt.opengl.QOpenGLDebugLogger.LoggingMode)}
     *  with <code>loggingMode = io.qt.opengl.QOpenGLDebugLogger.LoggingMode.AsynchronousLogging</code>.</p>
     */
    public final void startLogging() {
        startLogging(io.qt.opengl.QOpenGLDebugLogger.LoggingMode.AsynchronousLogging);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#startLogging">QOpenGLDebugLogger::startLogging(QOpenGLDebugLogger::LoggingMode)</a></p>
     */
    public final void startLogging(io.qt.opengl.QOpenGLDebugLogger.LoggingMode loggingMode){
        startLogging_native_QOpenGLDebugLogger_LoggingMode(QtJambi_LibraryUtilities.internal.nativeId(this), loggingMode.value());
    }
    
    private native void startLogging_native_QOpenGLDebugLogger_LoggingMode(long __this__nativeId, int loggingMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengldebuglogger.html#stopLogging">QOpenGLDebugLogger::stopLogging()</a></p>
     */
    public final void stopLogging(){
        stopLogging_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stopLogging_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLDebugLogger(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QOpenGLDebugLogger(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QOpenGLDebugLogger instance, QDeclarativeConstructor constructor);
    
}
