package io.qt.opengl;


/**
 * <p>All functions for OpenGL ES 2</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qopenglfunctions-es2.html">QOpenGLFunctions_ES2</a></p>
 */
public final class QOpenGLFunctions_ES2 extends io.qt.opengl.QAbstractOpenGLFunctions
{
    
    public QOpenGLFunctions_ES2(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLFunctions_ES2 instance);
    
    @io.qt.QtUninvokable
    public final void glActiveTexture(int texture){
        glActiveTexture_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @io.qt.QtUninvokable
    private native void glActiveTexture_native_GLenum(long __this__nativeId, int texture);
    
    @io.qt.QtUninvokable
    public final void glAttachShader(int program, int shader){
        glAttachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @io.qt.QtUninvokable
    private native void glAttachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    @io.qt.QtUninvokable
    public final void glBindAttribLocation(int program, int index, java.lang.String name){
        glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, name);
    }
    
    @io.qt.QtUninvokable
    private native void glBindAttribLocation_native_GLuint_GLuint_const_GLchar_ptr(long __this__nativeId, int program, int index, java.lang.String name);
    
    @io.qt.QtUninvokable
    public final void glBindBuffer(int target, int buffer){
        glBindBuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, buffer);
    }
    
    @io.qt.QtUninvokable
    private native void glBindBuffer_native_GLenum_GLuint(long __this__nativeId, int target, int buffer);
    
    @io.qt.QtUninvokable
    public final void glBindFramebuffer(int target, int framebuffer){
        glBindFramebuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, framebuffer);
    }
    
    @io.qt.QtUninvokable
    private native void glBindFramebuffer_native_GLenum_GLuint(long __this__nativeId, int target, int framebuffer);
    
    @io.qt.QtUninvokable
    public final void glBindRenderbuffer(int target, int renderbuffer){
        glBindRenderbuffer_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, renderbuffer);
    }
    
    @io.qt.QtUninvokable
    private native void glBindRenderbuffer_native_GLenum_GLuint(long __this__nativeId, int target, int renderbuffer);
    
    @io.qt.QtUninvokable
    public final void glBindTexture(int target, int texture){
        glBindTexture_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, texture);
    }
    
    @io.qt.QtUninvokable
    private native void glBindTexture_native_GLenum_GLuint(long __this__nativeId, int target, int texture);
    
    @io.qt.QtUninvokable
    public final void glBlendColor(float red, float green, float blue, float alpha){
        glBlendColor_native_GLclampf_GLclampf_GLclampf_GLclampf(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendColor_native_GLclampf_GLclampf_GLclampf_GLclampf(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @io.qt.QtUninvokable
    public final void glBlendEquation(int mode){
        glBlendEquation_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendEquation_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glBlendEquationSeparate(int modeRGB, int modeAlpha){
        glBlendEquationSeparate_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), modeRGB, modeAlpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendEquationSeparate_native_GLenum_GLenum(long __this__nativeId, int modeRGB, int modeAlpha);
    
    @io.qt.QtUninvokable
    public final void glBlendFunc(int sfactor, int dfactor){
        glBlendFunc_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), sfactor, dfactor);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendFunc_native_GLenum_GLenum(long __this__nativeId, int sfactor, int dfactor);
    
    @io.qt.QtUninvokable
    public final void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha){
        glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), srcRGB, dstRGB, srcAlpha, dstAlpha);
    }
    
    @io.qt.QtUninvokable
    private native void glBlendFuncSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);
    
    @io.qt.QtUninvokable
    public final void glBufferData(int target, long size, java.nio.Buffer data, int usage){
        glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, size, data, usage);
    }
    
    @io.qt.QtUninvokable
    private native void glBufferData_native_GLenum_GLsizeiptr_const_GLvoid_ptr_GLenum(long __this__nativeId, int target, long size, java.nio.Buffer data, int usage);
    
    @io.qt.QtUninvokable
    public final void glBufferSubData(int target, long offset, long size, java.nio.Buffer data){
        glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, offset, size, data);
    }
    
    @io.qt.QtUninvokable
    private native void glBufferSubData_native_GLenum_GLintptr_GLsizeiptr_const_GLvoid_ptr(long __this__nativeId, int target, long offset, long size, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final int glCheckFramebufferStatus(int target){
        return glCheckFramebufferStatus_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native int glCheckFramebufferStatus_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glClear(int mask){
        glClear_native_GLbitfield(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glClear_native_GLbitfield(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glClearColor(float red, float green, float blue, float alpha){
        glClearColor_native_GLclampf_GLclampf_GLclampf_GLclampf(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glClearColor_native_GLclampf_GLclampf_GLclampf_GLclampf(long __this__nativeId, float red, float green, float blue, float alpha);
    
    @io.qt.QtUninvokable
    public final void glClearDepthf(float depth){
        glClearDepthf_native_GLclampf(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @io.qt.QtUninvokable
    private native void glClearDepthf_native_GLclampf(long __this__nativeId, float depth);
    
    @io.qt.QtUninvokable
    public final void glClearStencil(int s){
        glClearStencil_native_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), s);
    }
    
    @io.qt.QtUninvokable
    private native void glClearStencil_native_GLint(long __this__nativeId, int s);
    
    @io.qt.QtUninvokable
    public final void glColorMask(boolean red, boolean green, boolean blue, boolean alpha){
        glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), red, green, blue, alpha);
    }
    
    @io.qt.QtUninvokable
    private native void glColorMask_native_GLboolean_GLboolean_GLboolean_GLboolean(long __this__nativeId, boolean red, boolean green, boolean blue, boolean alpha);
    
    @io.qt.QtUninvokable
    public final void glCompileShader(int shader){
        glCompileShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native void glCompileShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data){
        glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexImage2D_native_GLenum_GLint_GLenum_GLsizei_GLsizei_GLint_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data){
        glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }
    
    @io.qt.QtUninvokable
    private native void glCompressedTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLsizei_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, java.nio.Buffer data);
    
    @io.qt.QtUninvokable
    public final void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border){
        glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, x, y, width, height, border);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexImage2D_native_GLenum_GLint_GLenum_GLint_GLint_GLsizei_GLsizei_GLint(long __this__nativeId, int target, int level, int internalformat, int x, int y, int width, int height, int border);
    
    @io.qt.QtUninvokable
    public final void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height){
        glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glCopyTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final int glCreateProgram(){
        return glCreateProgram_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int glCreateProgram_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final int glCreateShader(int type){
        return glCreateShader_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @io.qt.QtUninvokable
    private native int glCreateShader_native_GLenum(long __this__nativeId, int type);
    
    @io.qt.QtUninvokable
    public final void glCullFace(int mode){
        glCullFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glCullFace_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glDeleteBuffers(int n, java.nio.IntBuffer buffers){
        glDeleteBuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteBuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    @io.qt.QtUninvokable
    public final void glDeleteFramebuffers(int n, java.nio.IntBuffer framebuffers){
        glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteFramebuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    @io.qt.QtUninvokable
    public final void glDeleteProgram(int program){
        glDeleteProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glDeleteRenderbuffers(int n, java.nio.IntBuffer renderbuffers){
        glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteRenderbuffers_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    @io.qt.QtUninvokable
    public final void glDeleteShader(int shader){
        glDeleteShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final void glDeleteTextures(int n, java.nio.IntBuffer textures){
        glDeleteTextures_native_GLsizei_const_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @io.qt.QtUninvokable
    private native void glDeleteTextures_native_GLsizei_const_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    @io.qt.QtUninvokable
    public final void glDepthFunc(int func){
        glDepthFunc_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), func);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthFunc_native_GLenum(long __this__nativeId, int func);
    
    @io.qt.QtUninvokable
    public final void glDepthMask(boolean flag){
        glDepthMask_native_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), flag);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthMask_native_GLboolean(long __this__nativeId, boolean flag);
    
    @io.qt.QtUninvokable
    public final void glDepthRangef(float zNear, float zFar){
        glDepthRangef_native_GLclampf_GLclampf(QtJambi_LibraryUtilities.internal.nativeId(this), zNear, zFar);
    }
    
    @io.qt.QtUninvokable
    private native void glDepthRangef_native_GLclampf_GLclampf(long __this__nativeId, float zNear, float zFar);
    
    @io.qt.QtUninvokable
    public final void glDetachShader(int program, int shader){
        glDetachShader_native_GLuint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program, shader);
    }
    
    @io.qt.QtUninvokable
    private native void glDetachShader_native_GLuint_GLuint(long __this__nativeId, int program, int shader);
    
    @io.qt.QtUninvokable
    public final void glDisable(int cap){
        glDisable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native void glDisable_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final void glDisableVertexAttribArray(int index){
        glDisableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void glDisableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void glDrawArrays(int mode, int first, int count){
        glDrawArrays_native_GLenum_GLint_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), mode, first, count);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawArrays_native_GLenum_GLint_GLsizei(long __this__nativeId, int mode, int first, int count);
    
    @io.qt.QtUninvokable
    public final void glDrawElements(int mode, int count, int type, java.nio.Buffer indices){
        glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), mode, count, type, indices);
    }
    
    @io.qt.QtUninvokable
    private native void glDrawElements_native_GLenum_GLsizei_GLenum_const_GLvoid_ptr(long __this__nativeId, int mode, int count, int type, java.nio.Buffer indices);
    
    @io.qt.QtUninvokable
    public final void glEnable(int cap){
        glEnable_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native void glEnable_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final void glEnableVertexAttribArray(int index){
        glEnableVertexAttribArray_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @io.qt.QtUninvokable
    private native void glEnableVertexAttribArray_native_GLuint(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void glFinish(){
        glFinish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glFinish_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glFlush(){
        glFlush_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glFlush_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer){
        glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, renderbuffertarget, renderbuffer);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferRenderbuffer_native_GLenum_GLenum_GLenum_GLuint(long __this__nativeId, int target, int attachment, int renderbuffertarget, int renderbuffer);
    
    @io.qt.QtUninvokable
    public final void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level){
        glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, textarget, texture, level);
    }
    
    @io.qt.QtUninvokable
    private native void glFramebufferTexture2D_native_GLenum_GLenum_GLenum_GLuint_GLint(long __this__nativeId, int target, int attachment, int textarget, int texture, int level);
    
    @io.qt.QtUninvokable
    public final void glFrontFace(int mode){
        glFrontFace_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void glFrontFace_native_GLenum(long __this__nativeId, int mode);
    
    @io.qt.QtUninvokable
    public final void glGenBuffers(int n, java.nio.IntBuffer buffers){
        glGenBuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, buffers);
    }
    
    @io.qt.QtUninvokable
    private native void glGenBuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer buffers);
    
    @io.qt.QtUninvokable
    public final void glGenFramebuffers(int n, java.nio.IntBuffer framebuffers){
        glGenFramebuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, framebuffers);
    }
    
    @io.qt.QtUninvokable
    private native void glGenFramebuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer framebuffers);
    
    @io.qt.QtUninvokable
    public final void glGenRenderbuffers(int n, java.nio.IntBuffer renderbuffers){
        glGenRenderbuffers_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, renderbuffers);
    }
    
    @io.qt.QtUninvokable
    private native void glGenRenderbuffers_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer renderbuffers);
    
    @io.qt.QtUninvokable
    public final void glGenTextures(int n, java.nio.IntBuffer textures){
        glGenTextures_native_GLsizei_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), n, textures);
    }
    
    @io.qt.QtUninvokable
    private native void glGenTextures_native_GLsizei_GLuint_ptr(long __this__nativeId, int n, java.nio.IntBuffer textures);
    
    @io.qt.QtUninvokable
    public final void glGenerateMipmap(int target){
        glGenerateMipmap_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target);
    }
    
    @io.qt.QtUninvokable
    private native void glGenerateMipmap_native_GLenum(long __this__nativeId, int target);
    
    @io.qt.QtUninvokable
    public final void glGetActiveAttrib(int program, int index, int bufsize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufsize, length, size, type, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveAttrib_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufsize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetActiveUniform(int program, int index, int bufsize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name){
        glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, index, bufsize, length, size, type, name);
    }
    
    @io.qt.QtUninvokable
    private native void glGetActiveUniform_native_GLuint_GLuint_GLsizei_GLsizei_ptr_GLint_ptr_GLenum_ptr_GLchar_ptr(long __this__nativeId, int program, int index, int bufsize, java.nio.IntBuffer length, java.nio.IntBuffer size, java.nio.IntBuffer type, java.nio.CharBuffer name);
    
    @io.qt.QtUninvokable
    public final void glGetAttachedShaders(int program, int maxcount, java.nio.IntBuffer count, java.nio.IntBuffer shaders){
        glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, maxcount, count, shaders);
    }
    
    @io.qt.QtUninvokable
    private native void glGetAttachedShaders_native_GLuint_GLsizei_GLsizei_ptr_GLuint_ptr(long __this__nativeId, int program, int maxcount, java.nio.IntBuffer count, java.nio.IntBuffer shaders);
    
    @io.qt.QtUninvokable
    public final int glGetAttribLocation(int program, java.lang.String name){
        return glGetAttribLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetAttribLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.lang.String name);
    
    @io.qt.QtUninvokable
    public final void glGetBooleanv(int pname, java.nio.Buffer params){
        glGetBooleanv_native_GLenum_GLboolean_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBooleanv_native_GLenum_GLboolean_ptr(long __this__nativeId, int pname, java.nio.Buffer params);
    
    @io.qt.QtUninvokable
    public final void glGetBufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetBufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final int glGetError(){
        return glGetError_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int glGetError_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glGetFloatv(int pname, java.nio.FloatBuffer params){
        glGetFloatv_native_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetFloatv_native_GLenum_GLfloat_ptr(long __this__nativeId, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, java.nio.IntBuffer params){
        glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, attachment, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetFramebufferAttachmentParameteriv_native_GLenum_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int attachment, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetIntegerv(int pname, java.nio.IntBuffer params){
        glGetIntegerv_native_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetIntegerv_native_GLenum_GLint_ptr(long __this__nativeId, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetProgramInfoLog(int program, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer infolog){
        glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, bufsize, length, infolog);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int program, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer infolog);
    
    @io.qt.QtUninvokable
    public final void glGetProgramiv(int program, int pname, java.nio.IntBuffer params){
        glGetProgramiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetProgramiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int program, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetRenderbufferParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetRenderbufferParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetShaderInfoLog(int shader, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer infolog){
        glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufsize, length, infolog);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderInfoLog_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer infolog);
    
    @io.qt.QtUninvokable
    public final void glGetShaderPrecisionFormat(int shadertype, int precisiontype, java.nio.IntBuffer range, java.nio.IntBuffer precision){
        glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shadertype, precisiontype, range, precision);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderPrecisionFormat_native_GLenum_GLenum_GLint_ptr_GLint_ptr(long __this__nativeId, int shadertype, int precisiontype, java.nio.IntBuffer range, java.nio.IntBuffer precision);
    
    @io.qt.QtUninvokable
    public final void glGetShaderSource(int shader, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer source){
        glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, bufsize, length, source);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderSource_native_GLuint_GLsizei_GLsizei_ptr_GLchar_ptr(long __this__nativeId, int shader, int bufsize, java.nio.IntBuffer length, java.nio.CharBuffer source);
    
    @io.qt.QtUninvokable
    public final void glGetShaderiv(int shader, int pname, java.nio.IntBuffer params){
        glGetShaderiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetShaderiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int shader, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final java.lang.String glGetString(int name){
        return glGetString_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String glGetString_native_GLenum(long __this__nativeId, int name);
    
    @io.qt.QtUninvokable
    public final void glGetTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexParameterfv_native_GLenum_GLenum_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetTexParameteriv_native_GLenum_GLenum_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final int glGetUniformLocation(int program, java.lang.String name){
        return glGetUniformLocation_native_GLuint_const_GLchar_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, name);
    }
    
    @io.qt.QtUninvokable
    private native int glGetUniformLocation_native_GLuint_const_GLchar_ptr(long __this__nativeId, int program, java.lang.String name);
    
    @io.qt.QtUninvokable
    public final void glGetUniformfv(int program, int location, java.nio.FloatBuffer params){
        glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformfv_native_GLuint_GLint_GLfloat_ptr(long __this__nativeId, int program, int location, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetUniformiv(int program, int location, java.nio.IntBuffer params){
        glGetUniformiv_native_GLuint_GLint_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), program, location, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetUniformiv_native_GLuint_GLint_GLint_ptr(long __this__nativeId, int program, int location, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribPointerv(int index, int pname, java.nio.Buffer[] pointer){
        glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, pointer);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribPointerv_native_GLuint_GLenum_GLvoid_ptr_ptr(long __this__nativeId, int index, int pname, java.nio.Buffer[] pointer);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribfv(int index, int pname, java.nio.FloatBuffer params){
        glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribfv_native_GLuint_GLenum_GLfloat_ptr(long __this__nativeId, int index, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glGetVertexAttribiv(int index, int pname, java.nio.IntBuffer params){
        glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), index, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glGetVertexAttribiv_native_GLuint_GLenum_GLint_ptr(long __this__nativeId, int index, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glHint(int target, int mode){
        glHint_native_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), target, mode);
    }
    
    @io.qt.QtUninvokable
    private native void glHint_native_GLenum_GLenum(long __this__nativeId, int target, int mode);
    
    @io.qt.QtUninvokable
    public final boolean glIsBuffer(int buffer){
        return glIsBuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), buffer);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsBuffer_native_GLuint(long __this__nativeId, int buffer);
    
    @io.qt.QtUninvokable
    public final boolean glIsEnabled(int cap){
        return glIsEnabled_native_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), cap);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsEnabled_native_GLenum(long __this__nativeId, int cap);
    
    @io.qt.QtUninvokable
    public final boolean glIsFramebuffer(int framebuffer){
        return glIsFramebuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), framebuffer);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsFramebuffer_native_GLuint(long __this__nativeId, int framebuffer);
    
    @io.qt.QtUninvokable
    public final boolean glIsProgram(int program){
        return glIsProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final boolean glIsRenderbuffer(int renderbuffer){
        return glIsRenderbuffer_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), renderbuffer);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsRenderbuffer_native_GLuint(long __this__nativeId, int renderbuffer);
    
    @io.qt.QtUninvokable
    public final boolean glIsShader(int shader){
        return glIsShader_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), shader);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsShader_native_GLuint(long __this__nativeId, int shader);
    
    @io.qt.QtUninvokable
    public final boolean glIsTexture(int texture){
        return glIsTexture_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), texture);
    }
    
    @io.qt.QtUninvokable
    private native boolean glIsTexture_native_GLuint(long __this__nativeId, int texture);
    
    @io.qt.QtUninvokable
    public final void glLineWidth(float width){
        glLineWidth_native_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @io.qt.QtUninvokable
    private native void glLineWidth_native_GLfloat(long __this__nativeId, float width);
    
    @io.qt.QtUninvokable
    public final void glLinkProgram(int program){
        glLinkProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glLinkProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glPixelStorei(int pname, int param){
        glPixelStorei_native_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glPixelStorei_native_GLenum_GLint(long __this__nativeId, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glPolygonOffset(float factor, float units){
        glPolygonOffset_native_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), factor, units);
    }
    
    @io.qt.QtUninvokable
    private native void glPolygonOffset_native_GLfloat_GLfloat(long __this__nativeId, float factor, float units);
    
    @io.qt.QtUninvokable
    public final void glReadPixels(int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels){
        glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glReadPixels_native_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_GLvoid_ptr(long __this__nativeId, int x, int y, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glReleaseShaderCompiler(){
        glReleaseShaderCompiler_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void glReleaseShaderCompiler_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void glRenderbufferStorage(int target, int internalformat, int width, int height){
        glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), target, internalformat, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glRenderbufferStorage_native_GLenum_GLenum_GLsizei_GLsizei(long __this__nativeId, int target, int internalformat, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glSampleCoverage(float value, boolean invert){
        glSampleCoverage_native_GLclampf_GLboolean(QtJambi_LibraryUtilities.internal.nativeId(this), value, invert);
    }
    
    @io.qt.QtUninvokable
    private native void glSampleCoverage_native_GLclampf_GLboolean(long __this__nativeId, float value, boolean invert);
    
    @io.qt.QtUninvokable
    public final void glScissor(int x, int y, int width, int height){
        glScissor_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glScissor_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public final void glShaderBinary(int n, java.nio.IntBuffer shaders, int binaryformat, java.nio.Buffer binary, int length){
        glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_GLvoid_ptr_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), n, shaders, binaryformat, binary, length);
    }
    
    @io.qt.QtUninvokable
    private native void glShaderBinary_native_GLsizei_const_GLuint_ptr_GLenum_const_GLvoid_ptr_GLsizei(long __this__nativeId, int n, java.nio.IntBuffer shaders, int binaryformat, java.nio.Buffer binary, int length);
    
    @io.qt.QtUninvokable
    public final void glShaderSource(int shader, java.lang.String[] string){
        glShaderSource_native_GLuint_GLsizei_const_GLchar_ptr_ptr_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), shader, string);
    }
    
    @io.qt.QtUninvokable
    private native void glShaderSource_native_GLuint_GLsizei_const_GLchar_ptr_ptr_const_GLint_ptr(long __this__nativeId, int shader, java.lang.String[] string);
    
    @io.qt.QtUninvokable
    public final void glStencilFunc(int func, int ref, int mask){
        glStencilFunc_native_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), func, ref, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilFunc_native_GLenum_GLint_GLuint(long __this__nativeId, int func, int ref, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilFuncSeparate(int face, int func, int ref, int mask){
        glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, func, ref, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilFuncSeparate_native_GLenum_GLenum_GLint_GLuint(long __this__nativeId, int face, int func, int ref, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilMask(int mask){
        glStencilMask_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilMask_native_GLuint(long __this__nativeId, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilMaskSeparate(int face, int mask){
        glStencilMaskSeparate_native_GLenum_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), face, mask);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilMaskSeparate_native_GLenum_GLuint(long __this__nativeId, int face, int mask);
    
    @io.qt.QtUninvokable
    public final void glStencilOp(int fail, int zfail, int zpass){
        glStencilOp_native_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), fail, zfail, zpass);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilOp_native_GLenum_GLenum_GLenum(long __this__nativeId, int fail, int zfail, int zpass);
    
    @io.qt.QtUninvokable
    public final void glStencilOpSeparate(int face, int fail, int zfail, int zpass){
        glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(QtJambi_LibraryUtilities.internal.nativeId(this), face, fail, zfail, zpass);
    }
    
    @io.qt.QtUninvokable
    private native void glStencilOpSeparate_native_GLenum_GLenum_GLenum_GLenum(long __this__nativeId, int face, int fail, int zfail, int zpass);
    
    @io.qt.QtUninvokable
    public final void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels){
        glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, internalformat, width, height, border, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexImage2D_native_GLenum_GLint_GLint_GLsizei_GLsizei_GLint_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int internalformat, int width, int height, int border, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glTexParameterf(int target, int pname, float param){
        glTexParameterf_native_GLenum_GLenum_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameterf_native_GLenum_GLenum_GLfloat(long __this__nativeId, int target, int pname, float param);
    
    @io.qt.QtUninvokable
    public final void glTexParameterfv(int target, int pname, java.nio.FloatBuffer params){
        glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameterfv_native_GLenum_GLenum_const_GLfloat_ptr(long __this__nativeId, int target, int pname, java.nio.FloatBuffer params);
    
    @io.qt.QtUninvokable
    public final void glTexParameteri(int target, int pname, int param){
        glTexParameteri_native_GLenum_GLenum_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, param);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameteri_native_GLenum_GLenum_GLint(long __this__nativeId, int target, int pname, int param);
    
    @io.qt.QtUninvokable
    public final void glTexParameteriv(int target, int pname, java.nio.IntBuffer params){
        glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, pname, params);
    }
    
    @io.qt.QtUninvokable
    private native void glTexParameteriv_native_GLenum_GLenum_const_GLint_ptr(long __this__nativeId, int target, int pname, java.nio.IntBuffer params);
    
    @io.qt.QtUninvokable
    public final void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels){
        glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), target, level, xoffset, yoffset, width, height, format, type, pixels);
    }
    
    @io.qt.QtUninvokable
    private native void glTexSubImage2D_native_GLenum_GLint_GLint_GLint_GLsizei_GLsizei_GLenum_GLenum_const_GLvoid_ptr(long __this__nativeId, int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, java.nio.Buffer pixels);
    
    @io.qt.QtUninvokable
    public final void glUniform1f(int location, float x){
        glUniform1f_native_GLint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1f_native_GLint_GLfloat(long __this__nativeId, int location, float x);
    
    @io.qt.QtUninvokable
    public final void glUniform1fv(int location, int count, java.nio.FloatBuffer v){
        glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glUniform1i(int location, int x){
        glUniform1i_native_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, x);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1i_native_GLint_GLint(long __this__nativeId, int location, int x);
    
    @io.qt.QtUninvokable
    public final void glUniform1iv(int location, int count, java.nio.IntBuffer v){
        glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform1iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glUniform2f(int location, float x, float y){
        glUniform2f_native_GLint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2f_native_GLint_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y);
    
    @io.qt.QtUninvokable
    public final void glUniform2fv(int location, int count, java.nio.FloatBuffer v){
        glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glUniform2i(int location, int x, int y){
        glUniform2i_native_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2i_native_GLint_GLint_GLint(long __this__nativeId, int location, int x, int y);
    
    @io.qt.QtUninvokable
    public final void glUniform2iv(int location, int count, java.nio.IntBuffer v){
        glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform2iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glUniform3f(int location, float x, float y, float z){
        glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3f_native_GLint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glUniform3fv(int location, int count, java.nio.FloatBuffer v){
        glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glUniform3i(int location, int x, int y, int z){
        glUniform3i_native_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3i_native_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int x, int y, int z);
    
    @io.qt.QtUninvokable
    public final void glUniform3iv(int location, int count, java.nio.IntBuffer v){
        glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform3iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glUniform4f(int location, float x, float y, float z, float w){
        glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4f_native_GLint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int location, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void glUniform4fv(int location, int count, java.nio.FloatBuffer v){
        glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4fv_native_GLint_GLsizei_const_GLfloat_ptr(long __this__nativeId, int location, int count, java.nio.FloatBuffer v);
    
    @io.qt.QtUninvokable
    public final void glUniform4i(int location, int x, int y, int z, int w){
        glUniform4i_native_GLint_GLint_GLint_GLint_GLint(QtJambi_LibraryUtilities.internal.nativeId(this), location, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4i_native_GLint_GLint_GLint_GLint_GLint(long __this__nativeId, int location, int x, int y, int z, int w);
    
    @io.qt.QtUninvokable
    public final void glUniform4iv(int location, int count, java.nio.IntBuffer v){
        glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, v);
    }
    
    @io.qt.QtUninvokable
    private native void glUniform4iv_native_GLint_GLsizei_const_GLint_ptr(long __this__nativeId, int location, int count, java.nio.IntBuffer v);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix2fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix2fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix3fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix3fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUniformMatrix4fv(int location, int count, boolean transpose, java.nio.FloatBuffer value){
        glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), location, count, transpose, value);
    }
    
    @io.qt.QtUninvokable
    private native void glUniformMatrix4fv_native_GLint_GLsizei_GLboolean_const_GLfloat_ptr(long __this__nativeId, int location, int count, boolean transpose, java.nio.FloatBuffer value);
    
    @io.qt.QtUninvokable
    public final void glUseProgram(int program){
        glUseProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glUseProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glValidateProgram(int program){
        glValidateProgram_native_GLuint(QtJambi_LibraryUtilities.internal.nativeId(this), program);
    }
    
    @io.qt.QtUninvokable
    private native void glValidateProgram_native_GLuint(long __this__nativeId, int program);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1f(int indx, float x){
        glVertexAttrib1f_native_GLuint_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), indx, x);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1f_native_GLuint_GLfloat(long __this__nativeId, int indx, float x);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib1fv(int indx, java.nio.FloatBuffer values){
        glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, values);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib1fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int indx, java.nio.FloatBuffer values);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2f(int indx, float x, float y){
        glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), indx, x, y);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2f_native_GLuint_GLfloat_GLfloat(long __this__nativeId, int indx, float x, float y);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib2fv(int indx, java.nio.FloatBuffer values){
        glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, values);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib2fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int indx, java.nio.FloatBuffer values);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3f(int indx, float x, float y, float z){
        glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), indx, x, y, z);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3f_native_GLuint_GLfloat_GLfloat_GLfloat(long __this__nativeId, int indx, float x, float y, float z);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib3fv(int indx, java.nio.FloatBuffer values){
        glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, values);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib3fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int indx, java.nio.FloatBuffer values);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4f(int indx, float x, float y, float z, float w){
        glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(QtJambi_LibraryUtilities.internal.nativeId(this), indx, x, y, z, w);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4f_native_GLuint_GLfloat_GLfloat_GLfloat_GLfloat(long __this__nativeId, int indx, float x, float y, float z, float w);
    
    @io.qt.QtUninvokable
    public final void glVertexAttrib4fv(int indx, java.nio.FloatBuffer values){
        glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, values);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttrib4fv_native_GLuint_const_GLfloat_ptr(long __this__nativeId, int indx, java.nio.FloatBuffer values);
    
    @io.qt.QtUninvokable
    public final void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, java.nio.Buffer ptr){
        glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), indx, size, type, normalized, stride, ptr);
    }
    
    @io.qt.QtUninvokable
    private native void glVertexAttribPointer_native_GLuint_GLint_GLenum_GLboolean_GLsizei_const_GLvoid_ptr(long __this__nativeId, int indx, int size, int type, boolean normalized, int stride, java.nio.Buffer ptr);
    
    @io.qt.QtUninvokable
    public final void glViewport(int x, int y, int width, int height){
        glViewport_native_GLint_GLint_GLsizei_GLsizei(QtJambi_LibraryUtilities.internal.nativeId(this), x, y, width, height);
    }
    
    @io.qt.QtUninvokable
    private native void glViewport_native_GLint_GLint_GLsizei_GLsizei(long __this__nativeId, int x, int y, int width, int height);
    
    @io.qt.QtUninvokable
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLFunctions_ES2(QPrivateConstructor p) { super(p); } 
    
}
