package io.qt.opengl;

import io.qt.*;


/**
 * <p>Allows OpenGL shaders to be compiled</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglshader.html">QOpenGLShader</a></p>
 */
public class QOpenGLShader extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLShader.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qopenglshader.html#ShaderTypeBit-enum">QOpenGLShader::ShaderTypeBit</a></p>
     * 
     * @see ShaderType
     */
    public enum ShaderTypeBit implements QtFlagEnumerator {
        Vertex(1),
        Fragment(2),
        Geometry(4),
        TessellationControl(8),
        TessellationEvaluation(16),
        Compute(32);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShaderTypeBit(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ShaderType asFlags() {
            return new ShaderType(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ShaderType combined(ShaderTypeBit e) {
            return new ShaderType(this, e);
        }

        /**
         * Creates a new {@link ShaderType} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ShaderType flags(ShaderTypeBit ... values) {
            return new ShaderType(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ShaderTypeBit resolve(int value) {
            switch (value) {
            case 1: return Vertex;
            case 2: return Fragment;
            case 4: return Geometry;
            case 8: return TessellationControl;
            case 16: return TessellationEvaluation;
            case 32: return Compute;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ShaderTypeBit}
     */
    public static final class ShaderType extends QFlags<ShaderTypeBit> implements Comparable<ShaderType> {
        private static final long serialVersionUID = 0x537faec4bcf3a495L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ShaderType where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ShaderType(ShaderTypeBit ... args){
            super(args);
        }

        /**
         * Creates a new ShaderType with given <code>value</code>.
         * @param value
         */
        public ShaderType(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ShaderType
         */
        @Override
        public final ShaderType combined(ShaderTypeBit e){
            return new ShaderType(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ShaderType setFlag(ShaderTypeBit e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ShaderType setFlag(ShaderTypeBit e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ShaderType.
         * @return array of enum entries
         */
        @Override
        public final ShaderTypeBit[] flags(){
            return super.flags(ShaderTypeBit.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ShaderType clone(){
            return new ShaderType(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ShaderType other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.opengl.QOpenGLShader.ShaderType, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLShader(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type) {
        this(type, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#QOpenGLShader">QOpenGLShader::QOpenGLShader(QOpenGLShader::ShaderType,QObject*)</a></p>
     */
    public QOpenGLShader(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, type, parent);
    }
    
    private native static void initialize_native(QOpenGLShader instance, io.qt.opengl.QOpenGLShader.ShaderType type, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#compileSourceCode-1">QOpenGLShader::compileSourceCode(QByteArray)</a></p>
     */
    @QtUninvokable
    public final boolean compileSourceCode(io.qt.core.@NonNull QByteArray source){
        return compileSourceCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @QtUninvokable
    private native boolean compileSourceCode_native_cref_QByteArray(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#compileSourceCode-2">QOpenGLShader::compileSourceCode(QString)</a></p>
     */
    @QtUninvokable
    public final boolean compileSourceCode(java.lang.@NonNull String source){
        return compileSourceCode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), source);
    }
    
    @QtUninvokable
    private native boolean compileSourceCode_native_cref_QString(long __this__nativeId, java.lang.String source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#compileSourceFile">QOpenGLShader::compileSourceFile(QString)</a></p>
     */
    @QtUninvokable
    public final boolean compileSourceFile(java.lang.@NonNull String fileName){
        return compileSourceFile_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @QtUninvokable
    private native boolean compileSourceFile_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#isCompiled">QOpenGLShader::isCompiled()const</a></p>
     */
    @QtUninvokable
    public final boolean isCompiled(){
        return isCompiled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCompiled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#log">QOpenGLShader::log()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String log(){
        return log_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String log_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#shaderId">QOpenGLShader::shaderId()const</a></p>
     */
    @QtUninvokable
    public final int shaderId(){
        return shaderId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int shaderId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#shaderType">QOpenGLShader::shaderType()const</a></p>
     */
    @QtUninvokable
    public final io.qt.opengl.QOpenGLShader.@NonNull ShaderType shaderType(){
        return new io.qt.opengl.QOpenGLShader.ShaderType(shaderType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int shaderType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#sourceCode">QOpenGLShader::sourceCode()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray sourceCode(){
        return sourceCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray sourceCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #hasOpenGLShaders(io.qt.opengl.QOpenGLShader.ShaderType, io.qt.gui.QOpenGLContext)}
     *  with <code>context = null</code>.</p>
     */
    public static boolean hasOpenGLShaders(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type) {
        return hasOpenGLShaders(type, (io.qt.gui.QOpenGLContext)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglshader.html#hasOpenGLShaders">QOpenGLShader::hasOpenGLShaders(QOpenGLShader::ShaderType,QOpenGLContext*)</a></p>
     */
    public static boolean hasOpenGLShaders(io.qt.opengl.QOpenGLShader.@NonNull ShaderType type, io.qt.gui.@Nullable QOpenGLContext context){
        return hasOpenGLShaders_native_QOpenGLShader_ShaderType_QOpenGLContext_ptr(type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    private native static boolean hasOpenGLShaders_native_QOpenGLShader_ShaderType_QOpenGLContext_ptr(int type, long context);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QOpenGLShader(QPrivateConstructor p) { super(p); } 
    
}
