package io.qt.opengl;

import io.qt.*;


/**
 * <p>The base class of a family of classes that expose all functions for each OpenGL version and profile</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qabstractopenglfunctions.html">QAbstractOpenGLFunctions</a></p>
 */
public class QAbstractOpenGLFunctions extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    
    @QtUninvokable
    protected final boolean isInitialized(){
        return isInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isInitialized_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected final io.qt.gui.@Nullable QOpenGLContext owningContext(){
        return owningContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QOpenGLContext owningContext_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    protected final void setOwningContext(io.qt.gui.@Nullable QOpenGLContext context){
        setOwningContext_native_const_QOpenGLContext_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    @QtUninvokable
    private native void setOwningContext_native_const_QOpenGLContext_ptr(long __this__nativeId, long context);
    
    @QtUninvokable
    public boolean initializeOpenGLFunctions(){
        return initializeOpenGLFunctions_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean initializeOpenGLFunctions_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QAbstractOpenGLFunctions(QPrivateConstructor p) { super(p); } 
    
}
