package io.qt.opengl;


/**
 * <p>Enables painting to an OpenGL context using QPainter</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopenglpaintdevice.html">QOpenGLPaintDevice</a></p>
 */
public class QOpenGLPaintDevice extends io.qt.QtObject
    implements io.qt.gui.QPaintDevice
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#QOpenGLPaintDevice">QOpenGLPaintDevice::QOpenGLPaintDevice()</a></p>
     */
    public QOpenGLPaintDevice(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QOpenGLPaintDevice instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#QOpenGLPaintDevice-1">QOpenGLPaintDevice::QOpenGLPaintDevice(QSize)</a></p>
     */
    public QOpenGLPaintDevice(io.qt.core.QSize size){
        super((QPrivateConstructor)null);
        initialize_native(this, size);
    }
    
    private native static void initialize_native(QOpenGLPaintDevice instance, io.qt.core.QSize size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#QOpenGLPaintDevice-2">QOpenGLPaintDevice::QOpenGLPaintDevice(int,int)</a></p>
     */
    public QOpenGLPaintDevice(int width, int height){
        super((QPrivateConstructor)null);
        initialize_native(this, width, height);
    }
    
    private native static void initialize_native(QOpenGLPaintDevice instance, int width, int height);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#colorCount">QPaintDevice::colorCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int colorCount(){
        return colorCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int colorCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#context">QOpenGLPaintDevice::context()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLContext context(){
        return context_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QOpenGLContext context_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#depth">QPaintDevice::depth()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#devicePixelRatio">QPaintDevice::devicePixelRatio()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double devicePixelRatio(){
        return devicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#devicePixelRatioF">QPaintDevice::devicePixelRatioF()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double devicePixelRatioF(){
        return devicePixelRatioF_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static double devicePixelRatioF_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#dotsPerMeterX">QOpenGLPaintDevice::dotsPerMeterX()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double dotsPerMeterX(){
        return dotsPerMeterX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double dotsPerMeterX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#dotsPerMeterY">QOpenGLPaintDevice::dotsPerMeterY()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double dotsPerMeterY(){
        return dotsPerMeterY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double dotsPerMeterY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#height">QPaintDevice::height()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#heightMM">QPaintDevice::heightMM()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int heightMM(){
        return heightMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int heightMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#logicalDpiX">QPaintDevice::logicalDpiX()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int logicalDpiX(){
        return logicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#logicalDpiY">QPaintDevice::logicalDpiY()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int logicalDpiY(){
        return logicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int logicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#paintFlipped">QOpenGLPaintDevice::paintFlipped()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean paintFlipped(){
        return paintFlipped_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean paintFlipped_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#paintingActive">QPaintDevice::paintingActive()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean paintingActive(){
        return paintingActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static boolean paintingActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#physicalDpiX">QPaintDevice::physicalDpiX()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int physicalDpiX(){
        return physicalDpiX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#physicalDpiY">QPaintDevice::physicalDpiY()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int physicalDpiY(){
        return physicalDpiY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int physicalDpiY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setDevicePixelRatio">QOpenGLPaintDevice::setDevicePixelRatio(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDevicePixelRatio(double devicePixelRatio){
        setDevicePixelRatio_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), devicePixelRatio);
    }
    
    @io.qt.QtUninvokable
    private native void setDevicePixelRatio_native_qreal(long __this__nativeId, double devicePixelRatio);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setDotsPerMeterX">QOpenGLPaintDevice::setDotsPerMeterX(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDotsPerMeterX(double arg__1){
        setDotsPerMeterX_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setDotsPerMeterX_native_qreal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setDotsPerMeterY">QOpenGLPaintDevice::setDotsPerMeterY(qreal)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDotsPerMeterY(double arg__1){
        setDotsPerMeterY_native_qreal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setDotsPerMeterY_native_qreal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setPaintFlipped">QOpenGLPaintDevice::setPaintFlipped(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPaintFlipped(boolean flipped){
        setPaintFlipped_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), flipped);
    }
    
    @io.qt.QtUninvokable
    private native void setPaintFlipped_native_bool(long __this__nativeId, boolean flipped);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#setSize">QOpenGLPaintDevice::setSize(QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSize(io.qt.core.QSize size){
        setSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#size">QOpenGLPaintDevice::size()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#width">QPaintDevice::width()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#widthMM">QPaintDevice::widthMM()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int widthMM(){
        return widthMM_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static int widthMM_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopenglpaintdevice.html#ensureActiveTarget">QOpenGLPaintDevice::ensureActiveTarget()</a></p>
     */
    @io.qt.QtUninvokable
    public void ensureActiveTarget(){
        ensureActiveTarget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void ensureActiveTarget_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected void initPainter(io.qt.gui.QPainter painter){
        initPainter_native_QPainter_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
    }
    
    private native static void initPainter_native_QPainter_ptr_constfct(long __this__nativeId, long painter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#metric">QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const</a></p>
     */
    @io.qt.QtUninvokable
    protected int metric(io.qt.gui.QPaintDevice.PaintDeviceMetric metric){
        return metric_native_QPaintDevice_PaintDeviceMetric_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), metric.value());
    }
    
    private native static int metric_native_QPaintDevice_PaintDeviceMetric_constfct(long __this__nativeId, int metric);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qpaintdevice.html#paintEngine">QPaintDevice::paintEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QPaintEngine paintEngine(){
        return paintEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPaintEngine paintEngine_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected io.qt.gui.QPaintDevice redirected(io.qt.core.QPoint offset){
        return redirected_native_QPoint_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    private native static io.qt.gui.QPaintDevice redirected_native_QPoint_ptr_constfct(long __this__nativeId, io.qt.core.QPoint offset);
    
    @io.qt.QtUninvokable
    protected io.qt.gui.QPainter sharedPainter(){
        return sharedPainter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static io.qt.gui.QPainter sharedPainter_native_constfct(long __this__nativeId);
    
    public native static double devicePixelRatioFScale();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLPaintDevice(QPrivateConstructor p) { super(p); } 
    
}
