package io.qt.opengl;


/**
 * <p>Wraps a sequence of OpenGL timer query objects</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qopengltimemonitor.html">QOpenGLTimeMonitor</a></p>
 */
public class QOpenGLTimeMonitor extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOpenGLTimeMonitor.class);
    
    
    /**
     * <p>Overloaded constructor for {@link #QOpenGLTimeMonitor(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOpenGLTimeMonitor() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#QOpenGLTimeMonitor">QOpenGLTimeMonitor::QOpenGLTimeMonitor(QObject*)</a></p>
     */
    public QOpenGLTimeMonitor(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOpenGLTimeMonitor instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#create">QOpenGLTimeMonitor::create()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean create(){
        return create_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean create_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#destroy">QOpenGLTimeMonitor::destroy()</a></p>
     */
    @io.qt.QtUninvokable
    public final void destroy(){
        destroy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void destroy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#isCreated">QOpenGLTimeMonitor::isCreated()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCreated(){
        return isCreated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCreated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#isResultAvailable">QOpenGLTimeMonitor::isResultAvailable()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isResultAvailable(){
        return isResultAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isResultAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#objectIds">QOpenGLTimeMonitor::objectIds()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Integer> objectIds(){
        return objectIds_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Integer> objectIds_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#recordSample">QOpenGLTimeMonitor::recordSample()</a></p>
     */
    @io.qt.QtUninvokable
    public final int recordSample(){
        return recordSample_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int recordSample_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#reset">QOpenGLTimeMonitor::reset()</a></p>
     */
    @io.qt.QtUninvokable
    public final void reset(){
        reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void reset_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#sampleCount">QOpenGLTimeMonitor::sampleCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int sampleCount(){
        return sampleCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int sampleCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#setSampleCount">QOpenGLTimeMonitor::setSampleCount(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSampleCount(int sampleCount){
        setSampleCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), sampleCount);
    }
    
    @io.qt.QtUninvokable
    private native void setSampleCount_native_int(long __this__nativeId, int sampleCount);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#waitForIntervals">QOpenGLTimeMonitor::waitForIntervals()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Long> waitForIntervals(){
        return waitForIntervals_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Long> waitForIntervals_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qopengltimemonitor.html#waitForSamples">QOpenGLTimeMonitor::waitForSamples()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Long> waitForSamples(){
        return waitForSamples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Long> waitForSamples_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QOpenGLTimeMonitor(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QOpenGLTimeMonitor(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QOpenGLTimeMonitor instance, QDeclarativeConstructor constructor);
    
}
