#ifndef QOPENGLPAINTDEVICE_SHELL_H
#define QOPENGLPAINTDEVICE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtOpenGL/qopenglpaintdevice.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qpoint.h>
#include <QtCore/qsize.h>
#include <QtGui/qopenglcontext.h>
#include <QtGui/qpaintdevice.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpainter.h>
#include <QtJambi/RegistryAPI>


class QOpenGLPaintDevice_shell : public QOpenGLPaintDevice, public QtJambiShellInterface
{
public:
    QOpenGLPaintDevice_shell();
    QOpenGLPaintDevice_shell(const QSize& size0);
    QOpenGLPaintDevice_shell(int width0, int height1);
    ~QOpenGLPaintDevice_shell() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    friend class QOpenGLPaintDevice_oshell;
};


class QOpenGLPaintDevice_oshell : public QOpenGLPaintDevice_shell
{
public:
    using QOpenGLPaintDevice_shell::QOpenGLPaintDevice_shell;
    ~QOpenGLPaintDevice_oshell() override;
    void ensureActiveTarget() override;
    void initPainter(QPainter* painter0) const override;
    int metric(QPaintDevice::PaintDeviceMetric metric0) const override;
    QPaintEngine* paintEngine() const override;
    QPaintDevice* redirected(QPoint* offset0) const override;
    QPainter* sharedPainter() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QOpenGLPaintDevice_access : public QOpenGLPaintDevice
{
    void __qt_ensureActiveTarget(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_initPainter_QPainter_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID painter0) const;
    jint __qt_metric_QPaintDevice_PaintDeviceMetric_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint metric0) const;
    jobject __qt_paintEngine_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_redirected_QPoint_ptr_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID offset0) const;
    jobject __qt_sharedPainter_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QOPENGLPAINTDEVICE_SHELL_H
