package io.qt.nfc;

import io.qt.*;


/**
 * <p>Access to notifications for NFC events</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html">QNearFieldManager</a></code></p>
 */
public class QNearFieldManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNearFieldManager.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::AdapterState</a></code></p>
     */
    public enum AdapterState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::<wbr/>AdapterState::<wbr/>Offline</a></code></p>
         */
        Offline(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::<wbr/>AdapterState::<wbr/>TurningOn</a></code></p>
         */
        TurningOn(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::<wbr/>AdapterState::<wbr/>Online</a></code></p>
         */
        Online(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::<wbr/>AdapterState::<wbr/>TurningOff</a></code></p>
         */
        TurningOff(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AdapterState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AdapterState resolve(int value) {
            switch (value) {
            case 1: return Offline;
            case 2: return TurningOn;
            case 3: return Online;
            case 4: return TurningOff;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#adapterStateChanged">QNearFieldManager::<wbr/>adapterStateChanged(QNearFieldManager::AdapterState)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.QNearFieldManager.@NonNull AdapterState> adapterStateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#targetDetected">QNearFieldManager::<wbr/>targetDetected(QNearFieldTarget*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.@Nullable QNearFieldTarget> targetDetected = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#targetDetectionStopped">QNearFieldManager::<wbr/>targetDetectionStopped()</a></code></p>
     */
    public final @NonNull Signal0 targetDetectionStopped = new Signal0();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#targetLost">QNearFieldManager::<wbr/>targetLost(QNearFieldTarget*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.@Nullable QNearFieldTarget> targetLost = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#QNearFieldManager">QNearFieldManager::<wbr/>QNearFieldManager(QObject*)</a></code></p>
     */
    public QNearFieldManager(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNearFieldManager instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#isEnabled">QNearFieldManager::<wbr/>isEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#isSupported">QNearFieldManager::<wbr/>isSupported(QNearFieldTarget::AccessMethod)const</a></code></p>
     */
    @QtUninvokable
    public final boolean isSupported(io.qt.nfc.QNearFieldTarget.@NonNull AccessMethod accessMethod){
        return isSupported_native_QNearFieldTarget_AccessMethod_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), accessMethod.value());
    }
    
    @QtUninvokable
    private native boolean isSupported_native_QNearFieldTarget_AccessMethod_constfct(long __this__nativeId, int accessMethod);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#setUserInformation">QNearFieldManager::<wbr/>setUserInformation(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setUserInformation(java.lang.@NonNull String message){
        setUserInformation_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), message);
    }
    
    @QtUninvokable
    private native void setUserInformation_native_cref_QString(long __this__nativeId, java.lang.String message);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#startTargetDetection">QNearFieldManager::<wbr/>startTargetDetection(QNearFieldTarget::AccessMethod)</a></code></p>
     */
    @QtUninvokable
    public final boolean startTargetDetection(io.qt.nfc.QNearFieldTarget.@NonNull AccessMethod accessMethod){
        return startTargetDetection_native_QNearFieldTarget_AccessMethod(QtJambi_LibraryUtilities.internal.nativeId(this), accessMethod.value());
    }
    
    @QtUninvokable
    private native boolean startTargetDetection_native_QNearFieldTarget_AccessMethod(long __this__nativeId, int accessMethod);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qnearfieldmanager.html#stopTargetDetection">QNearFieldManager::<wbr/>stopTargetDetection(QString)</a></code></p>
     */
    @QtUninvokable
    public final void stopTargetDetection(java.lang.@NonNull String errorMessage){
        stopTargetDetection_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), errorMessage);
    }
    
    @QtUninvokable
    private native void stopTargetDetection_native_cref_QString(long __this__nativeId, java.lang.String errorMessage);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QNearFieldManager(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QNearFieldManager(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QNearFieldManager instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QNearFieldManager(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QNearFieldManager() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #isSupported(io.qt.nfc.QNearFieldTarget.AccessMethod)}
     *  with <code>accessMethod = io.qt.nfc.QNearFieldTarget.AccessMethod.AnyAccess</code>.</p>
     */
    @QtUninvokable
    public final boolean isSupported() {
        return isSupported(io.qt.nfc.QNearFieldTarget.AccessMethod.AnyAccess);
    }
    
    /**
     * <p>Overloaded function for {@link #stopTargetDetection(java.lang.String)}
     *  with <code>errorMessage = (String)null</code>.</p>
     */
    @QtUninvokable
    public final void stopTargetDetection() {
        stopTargetDetection((String)null);
    }
}
