package io.qt.nfc;

import io.qt.*;


/**
 * <p>Filter for matching NDEF messages</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qndeffilter.html">QNdefFilter</a></code></p>
 */
public class QNdefFilter extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>QNdefFilter::Record struct contains the information about a filter record</p>
     * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qndeffilter-record.html">QNdefFilter::Record</a></code></p>
     */
    public static class Record extends QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>Record()</code></p>
         */
        public Record(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(Record instance);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>Record(QNdefFilter::Record)</code></p>
         */
        public Record(io.qt.nfc.QNdefFilter.@NonNull Record other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(Record instance, io.qt.nfc.QNdefFilter.Record other);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>Record{QNdefRecord::TypeNameFormat,<wbr/>QByteArray,<wbr/>uint,<wbr/>uint}</code></p>
         */
        public Record(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type, int minimum, int maximum){
            super((QPrivateConstructor)null);
            initialize_native(this, typeNameFormat, type, minimum, maximum);
        }
        
        private native static void initialize_native(Record instance, io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type, int minimum, int maximum);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>maximum</code></p>
         */
        @QtUninvokable
        public final void setMaximum(int maximum){
            setMaximum_native_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), maximum);
        }
        
        @QtUninvokable
        private native void setMaximum_native_unsigned_int(long __this__nativeId, int maximum);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>maximum</code></p>
         */
        @QtUninvokable
        public final int maximum(){
            return maximum_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int maximum_native(long __this__nativeId);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>minimum</code></p>
         */
        @QtUninvokable
        public final void setMinimum(int minimum){
            setMinimum_native_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), minimum);
        }
        
        @QtUninvokable
        private native void setMinimum_native_unsigned_int(long __this__nativeId, int minimum);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>minimum</code></p>
         */
        @QtUninvokable
        public final int minimum(){
            return minimum_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int minimum_native(long __this__nativeId);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>type</code></p>
         */
        @QtUninvokable
        public final void setType(io.qt.core.@NonNull QByteArray type){
            setType_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(type));
        }
        
        @QtUninvokable
        private native void setType_native_cref_QByteArray(long __this__nativeId, long type);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>type</code></p>
         */
        @QtUninvokable
        public final io.qt.core.@NonNull QByteArray type(){
            return type_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native io.qt.core.QByteArray type_native(long __this__nativeId);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>typeNameFormat</code></p>
         */
        @QtUninvokable
        public final void setTypeNameFormat(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat){
            setTypeNameFormat_native_cref_QNdefRecord_TypeNameFormat(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value());
        }
        
        @QtUninvokable
        private native void setTypeNameFormat_native_cref_QNdefRecord_TypeNameFormat(long __this__nativeId, int typeNameFormat);
        
        /**
         * <p>See <code>QNdefFilter::Record::<wbr/>typeNameFormat</code></p>
         */
        @QtUninvokable
        public final io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat(){
            return io.qt.nfc.QNdefRecord.TypeNameFormat.resolve(typeNameFormat_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @QtUninvokable
        private native int typeNameFormat_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected Record(QPrivateConstructor p) { super(p); } 
        
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QNdefFilter::Record::<wbr/>Record(QNdefFilter::Record)</code></p>
         */
        @QtUninvokable
        @Override
        public Record clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native Record clone_native(long __this_nativeId);
        
        /**
         * <p>Overloaded constructor for {@link #Record(io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray, int, int)}.</p>
         */
        public Record(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, byte @NonNull[] type, int minimum, int maximum) {
            this(typeNameFormat, new io.qt.core.QByteArray(type), minimum, maximum);
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #maximum()} instead.</p>
         */
        @QtUninvokable
        public final int getMaximum() {
            return maximum();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #minimum()} instead.</p>
         */
        @QtUninvokable
        public final int getMinimum() {
            return minimum();
        }
        
        /**
         * <p>Overloaded function for {@link #setType(io.qt.core.QByteArray)}.</p>
         */
        @QtUninvokable
        public final void setType(byte @NonNull[] type) {
            setType(new io.qt.core.QByteArray(type));
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
         */
        @QtUninvokable
        public final io.qt.core.@NonNull QByteArray getType() {
            return type();
        }
        
        /**
         * @hidden
         * <p>Kotlin property getter. In Java use {@link #typeNameFormat()} instead.</p>
         */
        @QtUninvokable
        public final io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat getTypeNameFormat() {
            return typeNameFormat();
        }
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#QNdefFilter">QNdefFilter::<wbr/>QNdefFilter()</a></code></p>
     */
    public QNdefFilter(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QNdefFilter instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#QNdefFilter-1">QNdefFilter::<wbr/>QNdefFilter(QNdefFilter)</a></code></p>
     */
    public QNdefFilter(io.qt.nfc.@NonNull QNdefFilter other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QNdefFilter instance, io.qt.nfc.QNdefFilter other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#appendRecord-2">QNdefFilter::<wbr/>appendRecord(QNdefFilter::Record)</a></code></p>
     */
    @QtUninvokable
    public final boolean appendRecord(io.qt.nfc.QNdefFilter.@NonNull Record record){
        return appendRecord_native_cref_QNdefFilter_Record(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    @QtUninvokable
    private native boolean appendRecord_native_cref_QNdefFilter_Record(long __this__nativeId, long record);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#appendRecord-1">QNdefFilter::<wbr/>appendRecord(QNdefRecord::TypeNameFormat,<wbr/>QByteArray,<wbr/>uint,<wbr/>uint)</a></code></p>
     */
    @QtUninvokable
    public final boolean appendRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type, int min, int max){
        return appendRecord_native_QNdefRecord_TypeNameFormat_cref_QByteArray_unsigned_int_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(type), min, max);
    }
    
    @QtUninvokable
    private native boolean appendRecord_native_QNdefRecord_TypeNameFormat_cref_QByteArray_unsigned_int_unsigned_int(long __this__nativeId, int typeNameFormat, long type, int min, int max);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#clear">QNdefFilter::<wbr/>clear()</a></code></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#match">QNdefFilter::<wbr/>match(QNdefMessage)const</a></code></p>
     */
    @QtUninvokable
    public final boolean match(io.qt.nfc.@NonNull QNdefMessage message){
        return match_native_cref_QNdefMessage_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(message));
    }
    
    @QtUninvokable
    private native boolean match_native_cref_QNdefMessage_constfct(long __this__nativeId, long message);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#operator-eq">QNdefFilter::<wbr/>operator=(QNdefFilter)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.nfc.@NonNull QNdefFilter other){
        assign_native_cref_QNdefFilter(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QNdefFilter(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#orderMatch">QNdefFilter::<wbr/>orderMatch()const</a></code></p>
     */
    @QtUninvokable
    public final boolean orderMatch(){
        return orderMatch_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean orderMatch_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#recordAt">QNdefFilter::<wbr/>recordAt(qsizetype)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNdefFilter.@NonNull Record recordAt(long i){
        return recordAt_native_qsizetype_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNdefFilter.Record recordAt_native_qsizetype_constfct(long __this__nativeId, long i);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#recordCount">QNdefFilter::<wbr/>recordCount()const</a></code></p>
     */
    @QtUninvokable
    public final long recordCount(){
        return recordCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long recordCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#setOrderMatch">QNdefFilter::<wbr/>setOrderMatch(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setOrderMatch(boolean on){
        setOrderMatch_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), on);
    }
    
    @QtUninvokable
    private native void setOrderMatch_native_bool(long __this__nativeId, boolean on);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QNdefFilter(QPrivateConstructor p) { super(p); } 
    
    @QtUninvokable
    public final void appendRecord(Class<? extends QNdefRecord> type) {
        appendRecord(type, 1, 1);
    }
    
    @QtUninvokable
    public final void appendRecord(Class<? extends QNdefRecord> type, int min) {
        appendRecord(type, min, 1);
    }
    
    @QtUninvokable
    public final void appendRecord(Class<? extends QNdefRecord> type, int min, int max) {
        if(type==QNdefRecord.class) {
            QNdefRecord record = new QNdefRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else if(type==QNdefNfcSmartPosterRecord.class) {
            QNdefNfcSmartPosterRecord record = new QNdefNfcSmartPosterRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else if(type==QNdefNfcTextRecord.class) {
            QNdefNfcTextRecord record = new QNdefNfcTextRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else if(type==QNdefNfcUriRecord.class) {
            QNdefNfcUriRecord record = new QNdefNfcUriRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else if(type==QNdefNfcIconRecord.class) {
            QNdefNfcIconRecord record = new QNdefNfcIconRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else {
            try {
                QNdefRecord record = type.getConstructor().newInstance();
                appendRecord(record.typeNameFormat(), record.type(), min, max);
            } catch (RuntimeException | Error e) {
                throw e;
            } catch (InstantiationException | IllegalAccessException
                                            | java.lang.reflect.InvocationTargetException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="https://doc.qt.io/qt/qndeffilter.html#QNdefFilter-1">QNdefFilter::<wbr/>QNdefFilter(QNdefFilter)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QNdefFilter clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QNdefFilter clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded function for {@link #appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray, int, int)}
     *  with <code>max = 1</code>.</p>
     */
    @QtUninvokable
    public final boolean appendRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type, int min) {
        return appendRecord(typeNameFormat, type, min, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>min = 1</code></li>
     * <li><code>max = 1</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean appendRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type) {
        return appendRecord(typeNameFormat, type, (int)1, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat, byte[], int, int)}
     *  with <code>max = 1</code>.</p>
     */
    @QtUninvokable
    public final boolean appendRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, byte @NonNull[] type, int min) {
        return appendRecord(typeNameFormat, type, min, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat, byte[], int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>min = 1</code></li>
     * <li><code>max = 1</code></li>
     * </ul>
     */
    @QtUninvokable
    public final boolean appendRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, byte @NonNull[] type) {
        return appendRecord(typeNameFormat, type, (int)1, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray, int, int)}.</p>
     */
    @QtUninvokable
    public final boolean appendRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, byte @NonNull[] type, int min, int max) {
        return appendRecord(typeNameFormat, new io.qt.core.QByteArray(type), min, max);
    }
}
