package io.qt.nfc;

import io.qt.*;


/**
 * <p>NFC NDEF record</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qndefrecord.html">QNdefRecord</a></p>
 */
public class QNdefRecord extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::TypeNameFormat</a></p>
     */
    public enum TypeNameFormat implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::Empty</a></p>
         */
        Empty(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::NfcRtd</a></p>
         */
        NfcRtd(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::Mime</a></p>
         */
        Mime(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::Uri</a></p>
         */
        Uri(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::ExternalRtd</a></p>
         */
        ExternalRtd(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::Unknown</a></p>
         */
        Unknown(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TypeNameFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TypeNameFormat resolve(int value) {
            switch (value) {
            case 0: return Empty;
            case 1: return NfcRtd;
            case 2: return Mime;
            case 3: return Uri;
            case 4: return ExternalRtd;
            case 5: return Unknown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#QNdefRecord">QNdefRecord::QNdefRecord()</a></p>
     */
    public QNdefRecord(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QNdefRecord instance);
    
    protected QNdefRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type){
        super((QPrivateConstructor)null);
        initialize_native(this, typeNameFormat, type);
    }
    
    private native static void initialize_native(QNdefRecord instance, io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#QNdefRecord-1">QNdefRecord::QNdefRecord(QNdefRecord)</a></p>
     */
    public QNdefRecord(io.qt.nfc.@NonNull QNdefRecord other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QNdefRecord instance, io.qt.nfc.QNdefRecord other);
    
    protected QNdefRecord(io.qt.nfc.@NonNull QNdefRecord other, io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat){
        super((QPrivateConstructor)null);
        initialize_native(this, other, typeNameFormat);
    }
    
    private native static void initialize_native(QNdefRecord instance, io.qt.nfc.QNdefRecord other, io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat);
    
    protected QNdefRecord(io.qt.nfc.@NonNull QNdefRecord other, io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type){
        super((QPrivateConstructor)null);
        initialize_native(this, other, typeNameFormat, type);
    }
    
    private native static void initialize_native(QNdefRecord instance, io.qt.nfc.QNdefRecord other, io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#clear">QNdefRecord::clear()</a></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#id">QNdefRecord::id()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#isEmpty">QNdefRecord::isEmpty()const</a></p>
     */
    @QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#operator-eq">QNdefRecord::operator=(QNdefRecord)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.nfc.@NonNull QNdefRecord other){
        assign_native_cref_QNdefRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QNdefRecord(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#operator-eq-eq">QNdefRecord::operator==(QNdefRecord)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.nfc.@NonNull QNdefRecord other){
        return operator_equal_native_cref_QNdefRecord_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QNdefRecord_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#payload">QNdefRecord::payload()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray payload(){
        return payload_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray payload_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#setId">QNdefRecord::setId(QByteArray)</a></p>
     */
    @QtUninvokable
    public final void setId(io.qt.core.@NonNull QByteArray id){
        setId_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
    }
    
    @QtUninvokable
    private native void setId_native_cref_QByteArray(long __this__nativeId, long id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#setPayload">QNdefRecord::setPayload(QByteArray)</a></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public void setPayload(io.qt.core.@NonNull QByteArray payload){
        setPayload_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(payload));
    }
    
    @QtUninvokable
    private native void setPayload_native_cref_QByteArray(long __this__nativeId, long payload);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#setType">QNdefRecord::setType(QByteArray)</a></p>
     */
    @QtUninvokable
    public final void setType(io.qt.core.@NonNull QByteArray type){
        setType_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    @QtUninvokable
    private native void setType_native_cref_QByteArray(long __this__nativeId, long type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#setTypeNameFormat">QNdefRecord::setTypeNameFormat(QNdefRecord::TypeNameFormat)</a></p>
     */
    @QtUninvokable
    public final void setTypeNameFormat(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat){
        setTypeNameFormat_native_QNdefRecord_TypeNameFormat(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value());
    }
    
    @QtUninvokable
    private native void setTypeNameFormat_native_QNdefRecord_TypeNameFormat(long __this__nativeId, int typeNameFormat);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#type">QNdefRecord::type()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#typeNameFormat">QNdefRecord::typeNameFormat()const</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat(){
        return io.qt.nfc.QNdefRecord.TypeNameFormat.resolve(typeNameFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int typeNameFormat_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QNdefRecord(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.nfc.QNdefRecord) {
            return operator_equal((io.qt.nfc.QNdefRecord) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QNdefRecord clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QNdefRecord clone_native(long __this_nativeId);
}
