package io.qt.nfc;

import io.qt.*;


/**
 * <p>NFC RTD-SmartPoster</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html">QNdefNfcSmartPosterRecord</a></p>
 */
public class QNdefNfcSmartPosterRecord extends io.qt.nfc.QNdefRecord
    implements java.lang.Cloneable
{
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#Action-enum">QNdefNfcSmartPosterRecord::Action</a></p>
     */
    public enum Action implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#Action-enum">QNdefNfcSmartPosterRecord::UnspecifiedAction</a></p>
         */
        UnspecifiedAction(-1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#Action-enum">QNdefNfcSmartPosterRecord::DoAction</a></p>
         */
        DoAction(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#Action-enum">QNdefNfcSmartPosterRecord::SaveAction</a></p>
         */
        SaveAction(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#Action-enum">QNdefNfcSmartPosterRecord::EditAction</a></p>
         */
        EditAction(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Action(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Action resolve(int value) {
            switch (value) {
            case -1: return UnspecifiedAction;
            case 0: return DoAction;
            case 1: return SaveAction;
            case 2: return EditAction;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#QNdefNfcSmartPosterRecord">QNdefNfcSmartPosterRecord::QNdefNfcSmartPosterRecord()</a></p>
     */
    public QNdefNfcSmartPosterRecord(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QNdefNfcSmartPosterRecord instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#QNdefNfcSmartPosterRecord-2">QNdefNfcSmartPosterRecord::QNdefNfcSmartPosterRecord(QNdefNfcSmartPosterRecord)</a></p>
     */
    public QNdefNfcSmartPosterRecord(io.qt.nfc.@NonNull QNdefNfcSmartPosterRecord other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QNdefNfcSmartPosterRecord instance, io.qt.nfc.QNdefNfcSmartPosterRecord other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#QNdefNfcSmartPosterRecord-1">QNdefNfcSmartPosterRecord::QNdefNfcSmartPosterRecord(QNdefRecord)</a></p>
     */
    public QNdefNfcSmartPosterRecord(io.qt.nfc.@NonNull QNdefRecord other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QNdefNfcSmartPosterRecord instance, io.qt.nfc.QNdefRecord other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#action">QNdefNfcSmartPosterRecord::action()const</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNdefNfcSmartPosterRecord.@NonNull Action action(){
        return io.qt.nfc.QNdefNfcSmartPosterRecord.Action.resolve(action_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int action_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#addIcon-1">QNdefNfcSmartPosterRecord::addIcon(QByteArray,QByteArray)</a></p>
     */
    @QtUninvokable
    public final void addIcon(io.qt.core.@NonNull QByteArray type, io.qt.core.@NonNull QByteArray data){
        addIcon_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(type), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    @QtUninvokable
    private native void addIcon_native_cref_QByteArray_cref_QByteArray(long __this__nativeId, long type, long data);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#addIcon">QNdefNfcSmartPosterRecord::addIcon(QNdefNfcIconRecord)</a></p>
     */
    @QtUninvokable
    public final void addIcon(io.qt.nfc.@NonNull QNdefNfcIconRecord icon){
        addIcon_native_cref_QNdefNfcIconRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(icon));
    }
    
    @QtUninvokable
    private native void addIcon_native_cref_QNdefNfcIconRecord(long __this__nativeId, long icon);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#addTitle">QNdefNfcSmartPosterRecord::addTitle(QNdefNfcTextRecord)</a></p>
     */
    @QtUninvokable
    public final boolean addTitle(io.qt.nfc.@NonNull QNdefNfcTextRecord text){
        return addTitle_native_cref_QNdefNfcTextRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(text));
    }
    
    @QtUninvokable
    private native boolean addTitle_native_cref_QNdefNfcTextRecord(long __this__nativeId, long text);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#addTitle-1">QNdefNfcSmartPosterRecord::addTitle(QString,QString,QNdefNfcTextRecord::Encoding)</a></p>
     */
    @QtUninvokable
    public final boolean addTitle(java.lang.@NonNull String text, java.lang.@NonNull String locale, io.qt.nfc.QNdefNfcTextRecord.@NonNull Encoding encoding){
        return addTitle_native_cref_QString_cref_QString_QNdefNfcTextRecord_Encoding(QtJambi_LibraryUtilities.internal.nativeId(this), text, locale, encoding.value());
    }
    
    @QtUninvokable
    private native boolean addTitle_native_cref_QString_cref_QString_QNdefNfcTextRecord_Encoding(long __this__nativeId, java.lang.String text, java.lang.String locale, int encoding);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#hasAction">QNdefNfcSmartPosterRecord::hasAction()const</a></p>
     */
    @QtUninvokable
    public final boolean hasAction(){
        return hasAction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasAction_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #hasIcon(io.qt.core.QByteArray)}
     *  with <code>mimetype = new io.qt.core.QByteArray()</code>.</p>
     */
    @QtUninvokable
    public final boolean hasIcon() {
        return hasIcon(new io.qt.core.QByteArray());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#hasIcon">QNdefNfcSmartPosterRecord::hasIcon(QByteArray)const</a></p>
     */
    @QtUninvokable
    public final boolean hasIcon(io.qt.core.@NonNull QByteArray mimetype){
        return hasIcon_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(mimetype));
    }
    
    @QtUninvokable
    private native boolean hasIcon_native_cref_QByteArray_constfct(long __this__nativeId, long mimetype);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#hasSize">QNdefNfcSmartPosterRecord::hasSize()const</a></p>
     */
    @QtUninvokable
    public final boolean hasSize(){
        return hasSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #hasTitle(java.lang.String)}
     *  with <code>locale = (String)null</code>.</p>
     */
    @QtUninvokable
    public final boolean hasTitle() {
        return hasTitle((String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#hasTitle">QNdefNfcSmartPosterRecord::hasTitle(QString)const</a></p>
     */
    @QtUninvokable
    public final boolean hasTitle(java.lang.@NonNull String locale){
        return hasTitle_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), locale);
    }
    
    @QtUninvokable
    private native boolean hasTitle_native_cref_QString_constfct(long __this__nativeId, java.lang.String locale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#hasTypeInfo">QNdefNfcSmartPosterRecord::hasTypeInfo()const</a></p>
     */
    @QtUninvokable
    public final boolean hasTypeInfo(){
        return hasTypeInfo_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasTypeInfo_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #icon(io.qt.core.QByteArray)}
     *  with <code>mimetype = new io.qt.core.QByteArray()</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray icon() {
        return icon(new io.qt.core.QByteArray());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#icon">QNdefNfcSmartPosterRecord::icon(QByteArray)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray icon(io.qt.core.@NonNull QByteArray mimetype){
        return icon_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(mimetype));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray icon_native_cref_QByteArray_constfct(long __this__nativeId, long mimetype);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#iconCount">QNdefNfcSmartPosterRecord::iconCount()const</a></p>
     */
    @QtUninvokable
    public final long iconCount(){
        return iconCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long iconCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#iconRecord">QNdefNfcSmartPosterRecord::iconRecord(qsizetype)const</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.@NonNull QNdefNfcIconRecord iconRecord(long index){
        return iconRecord_native_qsizetype_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNdefNfcIconRecord iconRecord_native_qsizetype_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#iconRecords">QNdefNfcSmartPosterRecord::iconRecords()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.nfc.@NonNull QNdefNfcIconRecord> iconRecords(){
        return iconRecords_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.nfc.QNdefNfcIconRecord> iconRecords_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#operator-eq">QNdefNfcSmartPosterRecord::operator=(QNdefNfcSmartPosterRecord)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.nfc.@NonNull QNdefNfcSmartPosterRecord other){
        assign_native_cref_QNdefNfcSmartPosterRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QNdefNfcSmartPosterRecord(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#removeIcon-1">QNdefNfcSmartPosterRecord::removeIcon(QByteArray)</a></p>
     */
    @QtUninvokable
    public final boolean removeIcon(io.qt.core.@NonNull QByteArray type){
        return removeIcon_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    @QtUninvokable
    private native boolean removeIcon_native_cref_QByteArray(long __this__nativeId, long type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#removeIcon">QNdefNfcSmartPosterRecord::removeIcon(QNdefNfcIconRecord)</a></p>
     */
    @QtUninvokable
    public final boolean removeIcon(io.qt.nfc.@NonNull QNdefNfcIconRecord icon){
        return removeIcon_native_cref_QNdefNfcIconRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(icon));
    }
    
    @QtUninvokable
    private native boolean removeIcon_native_cref_QNdefNfcIconRecord(long __this__nativeId, long icon);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#removeTitle">QNdefNfcSmartPosterRecord::removeTitle(QNdefNfcTextRecord)</a></p>
     */
    @QtUninvokable
    public final boolean removeTitle(io.qt.nfc.@NonNull QNdefNfcTextRecord text){
        return removeTitle_native_cref_QNdefNfcTextRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(text));
    }
    
    @QtUninvokable
    private native boolean removeTitle_native_cref_QNdefNfcTextRecord(long __this__nativeId, long text);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#removeTitle-1">QNdefNfcSmartPosterRecord::removeTitle(QString)</a></p>
     */
    @QtUninvokable
    public final boolean removeTitle(java.lang.@NonNull String locale){
        return removeTitle_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), locale);
    }
    
    @QtUninvokable
    private native boolean removeTitle_native_cref_QString(long __this__nativeId, java.lang.String locale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#setAction">QNdefNfcSmartPosterRecord::setAction(QNdefNfcSmartPosterRecord::Action)</a></p>
     */
    @QtUninvokable
    public final void setAction(io.qt.nfc.QNdefNfcSmartPosterRecord.@NonNull Action act){
        setAction_native_QNdefNfcSmartPosterRecord_Action(QtJambi_LibraryUtilities.internal.nativeId(this), act.value());
    }
    
    @QtUninvokable
    private native void setAction_native_QNdefNfcSmartPosterRecord_Action(long __this__nativeId, int act);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#setIcons">QNdefNfcSmartPosterRecord::setIcons(QList&lt;QNdefNfcIconRecord&gt;)</a></p>
     */
    @QtUninvokable
    public final void setIcons(java.util.@NonNull Collection<? extends io.qt.nfc.@NonNull QNdefNfcIconRecord> icons){
        setIcons_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), icons);
    }
    
    @QtUninvokable
    private native void setIcons_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.nfc.QNdefNfcIconRecord> icons);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefrecord.html#setPayload">QNdefRecord::setPayload(QByteArray)</a></p>
     */
    @QtUninvokable
    public final void setPayload(io.qt.core.@NonNull QByteArray payload){
        setPayload_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(payload));
    }
    
    @QtUninvokable
    private native void setPayload_native_cref_QByteArray(long __this__nativeId, long payload);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#setSize">QNdefNfcSmartPosterRecord::setSize(quint32)</a></p>
     */
    @QtUninvokable
    public final void setSize(int size){
        setSize_native_quint32(QtJambi_LibraryUtilities.internal.nativeId(this), size);
    }
    
    @QtUninvokable
    private native void setSize_native_quint32(long __this__nativeId, int size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#setTitles">QNdefNfcSmartPosterRecord::setTitles(QList&lt;QNdefNfcTextRecord&gt;)</a></p>
     */
    @QtUninvokable
    public final void setTitles(java.util.@NonNull Collection<? extends io.qt.nfc.@NonNull QNdefNfcTextRecord> titles){
        setTitles_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), titles);
    }
    
    @QtUninvokable
    private native void setTitles_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.nfc.QNdefNfcTextRecord> titles);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#setTypeInfo">QNdefNfcSmartPosterRecord::setTypeInfo(QString)</a></p>
     */
    @QtUninvokable
    public final void setTypeInfo(java.lang.@NonNull String type){
        setTypeInfo_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), type);
    }
    
    @QtUninvokable
    private native void setTypeInfo_native_cref_QString(long __this__nativeId, java.lang.String type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#setUri">QNdefNfcSmartPosterRecord::setUri(QNdefNfcUriRecord)</a></p>
     */
    @QtUninvokable
    public final void setUri(io.qt.nfc.@NonNull QNdefNfcUriRecord url){
        setUri_native_cref_QNdefNfcUriRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setUri_native_cref_QNdefNfcUriRecord(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#setUri-1">QNdefNfcSmartPosterRecord::setUri(QUrl)</a></p>
     */
    @QtUninvokable
    public final void setUri(io.qt.core.@NonNull QUrl url){
        setUri_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setUri_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#size">QNdefNfcSmartPosterRecord::size()const</a></p>
     */
    @QtUninvokable
    public final int size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int size_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #title(java.lang.String)}
     *  with <code>locale = (String)null</code>.</p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String title() {
        return title((String)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#title">QNdefNfcSmartPosterRecord::title(QString)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String title(java.lang.@NonNull String locale){
        return title_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), locale);
    }
    
    @QtUninvokable
    private native java.lang.String title_native_cref_QString_constfct(long __this__nativeId, java.lang.String locale);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#titleCount">QNdefNfcSmartPosterRecord::titleCount()const</a></p>
     */
    @QtUninvokable
    public final long titleCount(){
        return titleCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long titleCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#titleRecord">QNdefNfcSmartPosterRecord::titleRecord(qsizetype)const</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.@NonNull QNdefNfcTextRecord titleRecord(long index){
        return titleRecord_native_qsizetype_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNdefNfcTextRecord titleRecord_native_qsizetype_constfct(long __this__nativeId, long index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#titleRecords">QNdefNfcSmartPosterRecord::titleRecords()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.nfc.@NonNull QNdefNfcTextRecord> titleRecords(){
        return titleRecords_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.nfc.QNdefNfcTextRecord> titleRecords_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#typeInfo">QNdefNfcSmartPosterRecord::typeInfo()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String typeInfo(){
        return typeInfo_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String typeInfo_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#uri">QNdefNfcSmartPosterRecord::uri()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl uri(){
        return uri_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl uri_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefnfcsmartposterrecord.html#uriRecord">QNdefNfcSmartPosterRecord::uriRecord()const</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.@NonNull QNdefNfcUriRecord uriRecord(){
        return uriRecord_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNdefNfcUriRecord uriRecord_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QNdefNfcSmartPosterRecord(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QNdefNfcSmartPosterRecord clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QNdefNfcSmartPosterRecord clone_native(long __this_nativeId);
}
