package io.qt.nfc;

import io.qt.*;


/**
 * <p>NFC NDEF message</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qndefmessage.html">QNdefMessage</a></p>
 */
public class QNdefMessage extends io.qt.core.QList<io.qt.nfc.@NonNull QNdefRecord>
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefmessage.html#QNdefMessage">QNdefMessage::QNdefMessage()</a></p>
     */
    public QNdefMessage(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QNdefMessage instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefmessage.html#QNdefMessage-3">QNdefMessage::QNdefMessage(QList&lt;QNdefRecord&gt;)</a></p>
     */
    public QNdefMessage(java.util.@NonNull Collection<? extends io.qt.nfc.@NonNull QNdefRecord> records){
        super((QPrivateConstructor)null);
        initialize_native(this, records);
    }
    
    private native static void initialize_native(QNdefMessage instance, java.util.Collection<? extends io.qt.nfc.QNdefRecord> records);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefmessage.html#QNdefMessage-2">QNdefMessage::QNdefMessage(QNdefMessage)</a></p>
     */
    public QNdefMessage(io.qt.nfc.@NonNull QNdefMessage message){
        super((QPrivateConstructor)null);
        initialize_native(this, message);
    }
    
    private native static void initialize_native(QNdefMessage instance, io.qt.nfc.QNdefMessage message);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefmessage.html#QNdefMessage-1">QNdefMessage::QNdefMessage(QNdefRecord)</a></p>
     */
    public QNdefMessage(io.qt.nfc.@NonNull QNdefRecord record){
        super((QPrivateConstructor)null);
        initialize_native(this, record);
    }
    
    private native static void initialize_native(QNdefMessage instance, io.qt.nfc.QNdefRecord record);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefmessage.html#operator-eq">QNdefMessage::operator=(QNdefMessage)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.nfc.@NonNull QNdefMessage other){
        assign_native_cref_QNdefMessage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QNdefMessage(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefmessage.html#operator-eq-eq">QNdefMessage::operator==(QNdefMessage)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.nfc.@NonNull QNdefMessage other){
        return operator_equal_native_cref_QNdefMessage_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QNdefMessage_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefmessage.html#toByteArray">QNdefMessage::toByteArray()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray toByteArray(){
        return toByteArray_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray toByteArray_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qndefmessage.html#fromByteArray">QNdefMessage::fromByteArray(QByteArray)</a></p>
     */
    public static io.qt.nfc.@NonNull QNdefMessage fromByteArray(io.qt.core.@NonNull QByteArray message){
        return fromByteArray_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(message));
    }
    
    private native static io.qt.nfc.QNdefMessage fromByteArray_native_cref_QByteArray(long message);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QNdefMessage(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.nfc.QNdefMessage) {
            return operator_equal((io.qt.nfc.QNdefMessage) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QNdefMessage clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QNdefMessage clone_native(long __this_nativeId);
}
