package io.qt.nfc;

import io.qt.*;


/**
 * <p>Interface for communicating with a target device</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qnearfieldtarget.html">QNearFieldTarget</a></p>
 */
public class QNearFieldTarget extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNearFieldTarget.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qnearfieldtarget.html#AccessMethod-enum">QNearFieldTarget::AccessMethod</a></p>
     * 
     * @see AccessMethods
     */
    public enum AccessMethod implements QtFlagEnumerator {
        UnknownAccess(0),
        NdefAccess(1),
        TagTypeSpecificAccess(2),
        AnyAccess(255);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AccessMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public AccessMethods asFlags() {
            return new AccessMethods(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public AccessMethods combined(AccessMethod e) {
            return new AccessMethods(this, e);
        }

        /**
         * Creates a new {@link AccessMethods} from the entries.
         * @param values entries
         * @return new flag
         */
        public static AccessMethods flags(AccessMethod ... values) {
            return new AccessMethods(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AccessMethod resolve(int value) {
            switch (value) {
            case 0: return UnknownAccess;
            case 1: return NdefAccess;
            case 2: return TagTypeSpecificAccess;
            case 255: return AnyAccess;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link AccessMethod}
     */
    public static final class AccessMethods extends QFlags<AccessMethod> implements Comparable<AccessMethods> {
        private static final long serialVersionUID = 0x34d242f1c8a6d910L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new AccessMethods where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public AccessMethods(AccessMethod ... args){
            super(args);
        }

        /**
         * Creates a new AccessMethods with given <code>value</code>.
         * @param value
         */
        public AccessMethods(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new AccessMethods
         */
        @Override
        public final AccessMethods combined(AccessMethod e){
            return new AccessMethods(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final AccessMethods setFlag(AccessMethod e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final AccessMethods setFlag(AccessMethod e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this AccessMethods.
         * @return array of enum entries
         */
        @Override
        public final AccessMethod[] flags(){
            return super.flags(AccessMethod.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final AccessMethods clone(){
            return new AccessMethods(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(AccessMethods other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qnearfieldtarget.html#Error-enum">QNearFieldTarget::Error</a></p>
     */
    public enum Error implements QtEnumerator {
        NoError(0),
        UnknownError(1),
        UnsupportedError(2),
        TargetOutOfRangeError(3),
        NoResponseError(4),
        ChecksumMismatchError(5),
        InvalidParametersError(6),
        ConnectionError(7),
        NdefReadError(8),
        NdefWriteError(9),
        CommandError(10),
        TimeoutError(11);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return UnknownError;
            case 2: return UnsupportedError;
            case 3: return TargetOutOfRangeError;
            case 4: return NoResponseError;
            case 5: return ChecksumMismatchError;
            case 6: return InvalidParametersError;
            case 7: return ConnectionError;
            case 8: return NdefReadError;
            case 9: return NdefWriteError;
            case 10: return CommandError;
            case 11: return TimeoutError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qnearfieldtarget.html#Type-enum">QNearFieldTarget::Type</a></p>
     */
    public enum Type implements QtEnumerator {
        ProprietaryTag(0),
        NfcTagType1(1),
        NfcTagType2(2),
        NfcTagType3(3),
        NfcTagType4(4),
        NfcTagType4A(5),
        NfcTagType4B(6),
        MifareTag(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case 0: return ProprietaryTag;
            case 1: return NfcTagType1;
            case 2: return NfcTagType2;
            case 3: return NfcTagType3;
            case 4: return NfcTagType4;
            case 5: return NfcTagType4A;
            case 6: return NfcTagType4B;
            case 7: return MifareTag;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>A request id handle</p>
     * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qnearfieldtarget-requestid.html">QNearFieldTarget::RequestId</a></p>
     */
    public static class RequestId extends QtObject
        implements java.lang.Comparable<io.qt.nfc.QNearFieldTarget.RequestId>,
                java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget-requestid.html#RequestId">QNearFieldTarget::RequestId::RequestId()</a></p>
         */
        public RequestId(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(RequestId instance);
        
        public RequestId(io.qt.nfc.QNearFieldTarget.@NonNull RequestId other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(RequestId instance, io.qt.nfc.QNearFieldTarget.RequestId other);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget-requestid.html#isValid">QNearFieldTarget::RequestId::isValid()const</a></p>
         */
        @QtUninvokable
        public final boolean isValid(){
            return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native boolean isValid_native_constfct(long __this__nativeId);
        
        @QtUninvokable
        private final boolean operator_less(io.qt.nfc.QNearFieldTarget.@NonNull RequestId other){
            return operator_less_native_cref_QNearFieldTarget_RequestId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        @QtUninvokable
        private native boolean operator_less_native_cref_QNearFieldTarget_RequestId_constfct(long __this__nativeId, long other);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget-requestid.html#operator-eq">QNearFieldTarget::RequestId::operator=(QNearFieldTarget::RequestId)</a></p>
         */
        @QtUninvokable
        public final void assign(io.qt.nfc.QNearFieldTarget.@NonNull RequestId other){
            assign_native_cref_QNearFieldTarget_RequestId(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        @QtUninvokable
        private native void assign_native_cref_QNearFieldTarget_RequestId(long __this__nativeId, long other);
        
        @QtUninvokable
        private final boolean operator_equal(io.qt.nfc.QNearFieldTarget.@NonNull RequestId other){
            return operator_equal_native_cref_QNearFieldTarget_RequestId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        @QtUninvokable
        private native boolean operator_equal_native_cref_QNearFieldTarget_RequestId_constfct(long __this__nativeId, long other);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget-requestid.html#refCount">QNearFieldTarget::RequestId::refCount()const</a></p>
         */
        @QtUninvokable
        public final int refCount(){
            return refCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int refCount_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @NativeAccess
        protected RequestId(QPrivateConstructor p) { super(p); } 
        

        @Override
        @QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.nfc.QNearFieldTarget.RequestId) {
                return operator_equal((io.qt.nfc.QNearFieldTarget.RequestId) other);
            }

            return false;
        }

        @QtUninvokable
        public int compareTo(io.qt.nfc.QNearFieldTarget.RequestId other) {
            if (equals(other)) return 0;
            else if (operator_less(other)) return -1;
            else return 1;
        }


        @QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        @QtUninvokable
        @Override
        public RequestId clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native RequestId clone_native(long __this_nativeId);
    }


    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#disconnected">QNearFieldTarget::disconnected()</a></p>
     */
    public final @NonNull Signal0 disconnected = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#error">QNearFieldTarget::error(QNearFieldTarget::Error,QNearFieldTarget::RequestId)</a></p>
     */
    public final @NonNull Signal2<io.qt.nfc.QNearFieldTarget.@NonNull Error, io.qt.nfc.QNearFieldTarget.@NonNull RequestId> error = new Signal2<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#ndefMessageRead">QNearFieldTarget::ndefMessageRead(QNdefMessage)</a></p>
     */
    public final @NonNull Signal1<io.qt.nfc.@NonNull QNdefMessage> ndefMessageRead = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#requestCompleted">QNearFieldTarget::requestCompleted(QNearFieldTarget::RequestId)</a></p>
     */
    public final @NonNull Signal1<io.qt.nfc.QNearFieldTarget.@NonNull RequestId> requestCompleted = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QNearFieldTarget() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#QNearFieldTarget">QNearFieldTarget::QNearFieldTarget(QObject*)</a></p>
     */
    public QNearFieldTarget(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNearFieldTarget instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#accessMethods">QNearFieldTarget::accessMethods()const</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldTarget.@NonNull AccessMethods accessMethods(){
        return new io.qt.nfc.QNearFieldTarget.AccessMethods(accessMethods_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int accessMethods_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#disconnect">QNearFieldTarget::disconnect()</a></p>
     */
    @QtUninvokable
    public final boolean disconnectFromTarget(){
        return disconnectFromTarget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean disconnectFromTarget_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#hasNdefMessage">QNearFieldTarget::hasNdefMessage()</a></p>
     */
    @QtUninvokable
    public final boolean hasNdefMessage(){
        return hasNdefMessage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasNdefMessage_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#maxCommandLength">QNearFieldTarget::maxCommandLength()const</a></p>
     */
    @QtUninvokable
    public final int maxCommandLength(){
        return maxCommandLength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxCommandLength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#readNdefMessages">QNearFieldTarget::readNdefMessages()</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldTarget.@NonNull RequestId readNdefMessages(){
        return readNdefMessages_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNearFieldTarget.RequestId readNdefMessages_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#requestResponse">QNearFieldTarget::requestResponse(QNearFieldTarget::RequestId)const</a></p>
     */
    @QtUninvokable
    public final java.lang.Object requestResponse(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id){
        return requestResponse_native_cref_QNearFieldTarget_RequestId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
    }
    
    @QtUninvokable
    private native java.lang.Object requestResponse_native_cref_QNearFieldTarget_RequestId_constfct(long __this__nativeId, long id);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#sendCommand">QNearFieldTarget::sendCommand(QByteArray)</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldTarget.@NonNull RequestId sendCommand(io.qt.core.@NonNull QByteArray command){
        return sendCommand_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(command));
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNearFieldTarget.RequestId sendCommand_native_cref_QByteArray(long __this__nativeId, long command);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#type">QNearFieldTarget::type()const</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldTarget.@NonNull Type type(){
        return io.qt.nfc.QNearFieldTarget.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#uid">QNearFieldTarget::uid()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray uid(){
        return uid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray uid_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #waitForRequestCompleted(io.qt.nfc.QNearFieldTarget.RequestId, int)}
     *  with <code>msecs = 5000</code>.</p>
     */
    @QtUninvokable
    public final boolean waitForRequestCompleted(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id) {
        return waitForRequestCompleted(id, (int)5000);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#waitForRequestCompleted">QNearFieldTarget::waitForRequestCompleted(QNearFieldTarget::RequestId,int)</a></p>
     */
    @QtUninvokable
    public final boolean waitForRequestCompleted(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id, int msecs){
        return waitForRequestCompleted_native_cref_QNearFieldTarget_RequestId_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id), msecs);
    }
    
    @QtUninvokable
    private native boolean waitForRequestCompleted_native_cref_QNearFieldTarget_RequestId_int(long __this__nativeId, long id, int msecs);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qnearfieldtarget.html#writeNdefMessages">QNearFieldTarget::writeNdefMessages(QList&lt;QNdefMessage&gt;)</a></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldTarget.@NonNull RequestId writeNdefMessages(java.util.@NonNull Collection<? extends io.qt.nfc.@NonNull QNdefMessage> messages){
        return writeNdefMessages_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), messages);
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNearFieldTarget.RequestId writeNdefMessages_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.nfc.QNdefMessage> messages);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QNearFieldTarget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QNearFieldTarget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QNearFieldTarget instance, QDeclarativeConstructor constructor);
    
}
