package io.qt.nfc;


/**
 * <p>Access to notifications for NFC events</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html">QNearFieldManager</a></p>
 */
public class QNearFieldManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNearFieldManager.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::AdapterState</a></p>
     */
    public enum AdapterState implements io.qt.QtEnumerator {
        Offline(1),
        TurningOn(2),
        Online(3),
        TurningOff(4);

        private AdapterState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AdapterState resolve(int value) {
            switch (value) {
            case 1: return Offline;
            case 2: return TurningOn;
            case 3: return Online;
            case 4: return TurningOff;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#TargetAccessMode-enum">QNearFieldManager::TargetAccessMode</a></p>
     * 
     * @see TargetAccessModes
     */
    public enum TargetAccessMode implements io.qt.QtFlagEnumerator {
        NoTargetAccess(0),
        NdefReadTargetAccess(1),
        NdefWriteTargetAccess(2),
        TagTypeSpecificTargetAccess(4);

        private TargetAccessMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public TargetAccessModes asFlags() {
            return new TargetAccessModes(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public TargetAccessModes combined(TargetAccessMode e) {
            return new TargetAccessModes(this, e);
        }

        /**
         * Creates a new {@link TargetAccessModes} from the entries.
         * @param values entries
         * @return new flag
         */
        public static TargetAccessModes flags(TargetAccessMode ... values) {
            return new TargetAccessModes(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TargetAccessMode resolve(int value) {
            switch (value) {
            case 0: return NoTargetAccess;
            case 1: return NdefReadTargetAccess;
            case 2: return NdefWriteTargetAccess;
            case 4: return TagTypeSpecificTargetAccess;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link TargetAccessMode}
     */
    public static final class TargetAccessModes extends io.qt.QFlags<TargetAccessMode> implements Comparable<TargetAccessModes> {
        private static final long serialVersionUID = 0x7e8bf1a9b72a6441L;

        /**
         * Creates a new TargetAccessModes where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public TargetAccessModes(TargetAccessMode ... args){
            super(args);
        }

        /**
         * Creates a new TargetAccessModes with given <code>value</code>.
         * @param value
         */
        public TargetAccessModes(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new TargetAccessModes
         */
        @Override
        public final TargetAccessModes combined(TargetAccessMode e){
            return new TargetAccessModes(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final TargetAccessModes setFlag(TargetAccessMode e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final TargetAccessModes setFlag(TargetAccessMode e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this TargetAccessModes.
         * @return array of enum entries
         */
        @Override
        public final TargetAccessMode[] flags(){
            return super.flags(TargetAccessMode.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final TargetAccessModes clone(){
            return new TargetAccessModes(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(TargetAccessModes other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#adapterStateChanged">QNearFieldManager::adapterStateChanged(QNearFieldManager::AdapterState)</a></p>
     */
    public final Signal1<io.qt.nfc.QNearFieldManager.AdapterState> adapterStateChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#targetDetected">QNearFieldManager::targetDetected(QNearFieldTarget*)</a></p>
     */
    public final Signal1<io.qt.nfc.QNearFieldTarget> targetDetected = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#targetLost">QNearFieldManager::targetLost(QNearFieldTarget*)</a></p>
     */
    public final Signal1<io.qt.nfc.QNearFieldTarget> targetLost = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QNearFieldManager(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QNearFieldManager() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#QNearFieldManager">QNearFieldManager::QNearFieldManager(QObject*)</a></p>
     */
    public QNearFieldManager(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNearFieldManager instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#isAvailable">QNearFieldManager::isAvailable()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isAvailable(){
        return isAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#isSupported">QNearFieldManager::isSupported()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isSupported(){
        return isSupported_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSupported_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler-1">QNearFieldManager::registerNdefMessageHandler(QNdefRecord::TypeNameFormat,QByteArray,QObject*,const char*)</a></p>
     */
    @io.qt.QtUninvokable
    public final int registerNdefMessageHandler(io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type, io.qt.core.QObject object, java.lang.String method){
        return registerNdefMessageHandler_native_QNdefRecord_TypeNameFormat_cref_QByteArray_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(type), QtJambi_LibraryUtilities.internal.checkedNativeId(object), method);
    }
    
    @io.qt.QtUninvokable
    private native int registerNdefMessageHandler_native_QNdefRecord_TypeNameFormat_cref_QByteArray_QObject_ptr_const_char_ptr(long __this__nativeId, int typeNameFormat, long type, long object, java.lang.String method);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler">QNearFieldManager::registerNdefMessageHandler(QObject*,const char*)</a></p>
     */
    @io.qt.QtUninvokable
    public final int registerNdefMessageHandler(io.qt.core.QObject object, java.lang.String method){
        return registerNdefMessageHandler_native_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), method);
    }
    
    @io.qt.QtUninvokable
    private native int registerNdefMessageHandler_native_QObject_ptr_const_char_ptr(long __this__nativeId, long object, java.lang.String method);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler-2">QNearFieldManager::registerNdefMessageHandler(QNdefFilter,QObject*,const char*)</a></p>
     */
    @io.qt.QtUninvokable
    public final int registerNdefMessageHandler(io.qt.nfc.QNdefFilter filter, io.qt.core.QObject object, java.lang.String method){
        return registerNdefMessageHandler_native_cref_QNdefFilter_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filter), QtJambi_LibraryUtilities.internal.checkedNativeId(object), method);
    }
    
    @io.qt.QtUninvokable
    private native int registerNdefMessageHandler_native_cref_QNdefFilter_QObject_ptr_const_char_ptr(long __this__nativeId, long filter, long object, java.lang.String method);
    
    /**
     * <p>Overloaded function for {@link #setTargetAccessModes(io.qt.nfc.QNearFieldManager.TargetAccessModes)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setTargetAccessModes(io.qt.nfc.QNearFieldManager.TargetAccessMode ... accessModes){
        setTargetAccessModes(new io.qt.nfc.QNearFieldManager.TargetAccessModes(accessModes));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#setTargetAccessModes">QNearFieldManager::setTargetAccessModes(TargetAccessModes)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTargetAccessModes(io.qt.nfc.QNearFieldManager.TargetAccessModes accessModes){
        setTargetAccessModes_native_QFlags_QNearFieldManager_TargetAccessMode_(QtJambi_LibraryUtilities.internal.nativeId(this), accessModes.value());
    }
    
    @io.qt.QtUninvokable
    private native void setTargetAccessModes_native_QFlags_QNearFieldManager_TargetAccessMode_(long __this__nativeId, int accessModes);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#startTargetDetection">QNearFieldManager::startTargetDetection()</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean startTargetDetection(){
        return startTargetDetection_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean startTargetDetection_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#stopTargetDetection">QNearFieldManager::stopTargetDetection()</a></p>
     */
    @io.qt.QtUninvokable
    public final void stopTargetDetection(){
        stopTargetDetection_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void stopTargetDetection_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#targetAccessModes">QNearFieldManager::targetAccessModes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.nfc.QNearFieldManager.TargetAccessModes targetAccessModes(){
        return new io.qt.nfc.QNearFieldManager.TargetAccessModes(targetAccessModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int targetAccessModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#unregisterNdefMessageHandler">QNearFieldManager::unregisterNdefMessageHandler(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean unregisterNdefMessageHandler(int handlerId){
        return unregisterNdefMessageHandler_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), handlerId);
    }
    
    @io.qt.QtUninvokable
    private native boolean unregisterNdefMessageHandler_native_int(long __this__nativeId, int handlerId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QNearFieldManager(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QNearFieldManager(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QNearFieldManager instance, QDeclarativeConstructor constructor);
    
}
