package io.qt.nfc;


/**
 * <p>Manages all interactions related to sharing files and data over NFC</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html">QNearFieldShareManager</a></p>
 */
public class QNearFieldShareManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNearFieldShareManager.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::ShareError</a></p>
     */
    public enum ShareError implements io.qt.QtEnumerator {
        NoError(0),
        UnknownError(1),
        InvalidShareContentError(2),
        ShareCanceledError(3),
        ShareInterruptedError(4),
        ShareRejectedError(5),
        UnsupportedShareModeError(6),
        ShareAlreadyInProgressError(7),
        SharePermissionDeniedError(8);

        private ShareError(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ShareError resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return UnknownError;
            case 2: return InvalidShareContentError;
            case 3: return ShareCanceledError;
            case 4: return ShareInterruptedError;
            case 5: return ShareRejectedError;
            case 6: return UnsupportedShareModeError;
            case 7: return ShareAlreadyInProgressError;
            case 8: return SharePermissionDeniedError;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareMode-enum">QNearFieldShareManager::ShareMode</a></p>
     * 
     * @see ShareModes
     */
    public enum ShareMode implements io.qt.QtFlagEnumerator {
        NoShare(0),
        NdefShare(1),
        FileShare(2);

        private ShareMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ShareModes asFlags() {
            return new ShareModes(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ShareModes combined(ShareMode e) {
            return new ShareModes(this, e);
        }

        /**
         * Creates a new {@link ShareModes} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ShareModes flags(ShareMode ... values) {
            return new ShareModes(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ShareMode resolve(int value) {
            switch (value) {
            case 0: return NoShare;
            case 1: return NdefShare;
            case 2: return FileShare;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ShareMode}
     */
    public static final class ShareModes extends io.qt.QFlags<ShareMode> implements Comparable<ShareModes> {
        private static final long serialVersionUID = 0xcda0e2a455e788aeL;

        /**
         * Creates a new ShareModes where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ShareModes(ShareMode ... args){
            super(args);
        }

        /**
         * Creates a new ShareModes with given <code>value</code>.
         * @param value
         */
        public ShareModes(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ShareModes
         */
        @Override
        public final ShareModes combined(ShareMode e){
            return new ShareModes(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ShareModes setFlag(ShareMode e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ShareModes setFlag(ShareMode e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ShareModes.
         * @return array of enum entries
         */
        @Override
        public final ShareMode[] flags(){
            return super.flags(ShareMode.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ShareModes clone(){
            return new ShareModes(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ShareModes other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#error">QNearFieldShareManager::error(QNearFieldShareManager::ShareError)</a></p>
     */
    public final Signal1<io.qt.nfc.QNearFieldShareManager.ShareError> error = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareModesChanged">QNearFieldShareManager::shareModesChanged(QNearFieldShareManager::ShareModes)</a></p>
     */
    public final Signal1<io.qt.nfc.QNearFieldShareManager.ShareModes> shareModesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#targetDetected">QNearFieldShareManager::targetDetected(QNearFieldShareTarget*)</a></p>
     */
    public final Signal1<io.qt.nfc.QNearFieldShareTarget> targetDetected = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QNearFieldShareManager(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QNearFieldShareManager() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#QNearFieldShareManager">QNearFieldShareManager::QNearFieldShareManager(QObject*)</a></p>
     */
    public QNearFieldShareManager(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNearFieldShareManager instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded function for {@link #setShareModes(io.qt.nfc.QNearFieldShareManager.ShareModes)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setShareModes(io.qt.nfc.QNearFieldShareManager.ShareMode ... modes){
        setShareModes(new io.qt.nfc.QNearFieldShareManager.ShareModes(modes));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#setShareModes">QNearFieldShareManager::setShareModes(ShareModes)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setShareModes(io.qt.nfc.QNearFieldShareManager.ShareModes modes){
        setShareModes_native_QFlags_QNearFieldShareManager_ShareMode_(QtJambi_LibraryUtilities.internal.nativeId(this), modes.value());
    }
    
    @io.qt.QtUninvokable
    private native void setShareModes_native_QFlags_QNearFieldShareManager_ShareMode_(long __this__nativeId, int modes);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareError">QNearFieldShareManager::shareError()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.nfc.QNearFieldShareManager.ShareError shareError(){
        return io.qt.nfc.QNearFieldShareManager.ShareError.resolve(shareError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int shareError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareModes">QNearFieldShareManager::shareModes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.nfc.QNearFieldShareManager.ShareModes shareModes(){
        return new io.qt.nfc.QNearFieldShareManager.ShareModes(shareModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int shareModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#supportedShareModes">QNearFieldShareManager::supportedShareModes()</a></p>
     */
    public static io.qt.nfc.QNearFieldShareManager.ShareModes supportedShareModes(){
        return new io.qt.nfc.QNearFieldShareManager.ShareModes(supportedShareModes_native());
    }
    
    private native static int supportedShareModes_native();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QNearFieldShareManager(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QNearFieldShareManager(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QNearFieldShareManager instance, QDeclarativeConstructor constructor);
    
}
