package io.qt.nfc;

import io.qt.*;


/**
 * <p>Implements the NdefRecord type in QML</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html">QQmlNdefRecord</a></code></p>
 */
public class QQmlNdefRecord extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlNdefRecord.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#TypeNameFormat-enum">QQmlNdefRecord::TypeNameFormat</a></code></p>
     */
    public enum TypeNameFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#TypeNameFormat-enum">QQmlNdefRecord::<wbr/>Empty</a></code></p>
         */
        Empty(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#TypeNameFormat-enum">QQmlNdefRecord::<wbr/>NfcRtd</a></code></p>
         */
        NfcRtd(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#TypeNameFormat-enum">QQmlNdefRecord::<wbr/>Mime</a></code></p>
         */
        Mime(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#TypeNameFormat-enum">QQmlNdefRecord::<wbr/>Uri</a></code></p>
         */
        Uri(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#TypeNameFormat-enum">QQmlNdefRecord::<wbr/>ExternalRtd</a></code></p>
         */
        ExternalRtd(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#TypeNameFormat-enum">QQmlNdefRecord::<wbr/>Unknown</a></code></p>
         */
        Unknown(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TypeNameFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TypeNameFormat resolve(int value) {
            switch (value) {
            case 0: return Empty;
            case 1: return NfcRtd;
            case 2: return Mime;
            case 3: return Uri;
            case 4: return ExternalRtd;
            case 5: return Unknown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#record-prop">QQmlNdefRecord::<wbr/>recordChanged()</a></code></p>
     */
    @QtPropertyNotify(name="record")
    public final @NonNull Signal0 recordChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#typeChanged">QQmlNdefRecord::<wbr/>typeChanged()</a></code></p>
     */
    @QtPropertyNotify(name="type")
    public final @NonNull Signal0 typeChanged = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#typeNameFormat-prop">QQmlNdefRecord::<wbr/>typeNameFormatChanged()</a></code></p>
     */
    @QtPropertyNotify(name="typeNameFormat")
    public final @NonNull Signal0 typeNameFormatChanged = new Signal0();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#QQmlNdefRecord-1">QQmlNdefRecord::<wbr/>QQmlNdefRecord(QNdefRecord,<wbr/>QObject*)</a></code></p>
     */
    public QQmlNdefRecord(io.qt.nfc.@NonNull QNdefRecord record, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, record, parent);
    }
    
    private native static void initialize_native(QQmlNdefRecord instance, io.qt.nfc.QNdefRecord record, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#QQmlNdefRecord">QQmlNdefRecord::<wbr/>QQmlNdefRecord(QObject*)</a></code></p>
     */
    public QQmlNdefRecord(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQmlNdefRecord instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#record">QQmlNdefRecord::<wbr/>record()const</a></code></p>
     */
    @QtPropertyReader(name="record")
    @QtUninvokable
    public final io.qt.nfc.@NonNull QNdefRecord record(){
        return record_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNdefRecord record_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#setRecord">QQmlNdefRecord::<wbr/>setRecord(QNdefRecord)</a></code></p>
     */
    @QtPropertyWriter(name="record")
    @QtUninvokable
    public final void setRecord(io.qt.nfc.@NonNull QNdefRecord record){
        setRecord_native_cref_QNdefRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    @QtUninvokable
    private native void setRecord_native_cref_QNdefRecord(long __this__nativeId, long record);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#setType">QQmlNdefRecord::<wbr/>setType(QString)</a></code></p>
     */
    @QtPropertyWriter(name="type")
    @QtUninvokable
    public final void setType(java.lang.@NonNull String t){
        setType_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), t);
    }
    
    @QtUninvokable
    private native void setType_native_cref_QString(long __this__nativeId, java.lang.String t);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#setTypeNameFormat">QQmlNdefRecord::<wbr/>setTypeNameFormat(QQmlNdefRecord::TypeNameFormat)</a></code></p>
     */
    @QtPropertyWriter(name="typeNameFormat")
    @QtUninvokable
    public final void setTypeNameFormat(io.qt.nfc.QQmlNdefRecord.@NonNull TypeNameFormat typeNameFormat){
        setTypeNameFormat_native_QQmlNdefRecord_TypeNameFormat(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value());
    }
    
    @QtUninvokable
    private native void setTypeNameFormat_native_QQmlNdefRecord_TypeNameFormat(long __this__nativeId, int typeNameFormat);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#type">QQmlNdefRecord::<wbr/>type()const</a></code></p>
     */
    @QtPropertyReader(name="type")
    @QtUninvokable
    public final java.lang.@NonNull String type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#typeNameFormat">QQmlNdefRecord::<wbr/>typeNameFormat()const</a></code></p>
     */
    @QtPropertyReader(name="typeNameFormat")
    @QtUninvokable
    public final io.qt.nfc.QQmlNdefRecord.@NonNull TypeNameFormat typeNameFormat(){
        return io.qt.nfc.QQmlNdefRecord.TypeNameFormat.resolve(typeNameFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int typeNameFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>qNewDeclarativeNdefRecordForNdefRecord(QNdefRecord)</code></p>
     */
    public static io.qt.nfc.@Nullable QQmlNdefRecord qNewDeclarativeNdefRecordForNdefRecord(io.qt.nfc.@NonNull QNdefRecord record){
        return qNewDeclarativeNdefRecordForNdefRecord_native_cref_QNdefRecord(QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    private native static io.qt.nfc.QQmlNdefRecord qNewDeclarativeNdefRecordForNdefRecord_native_cref_QNdefRecord(long record);
    
    /**
     * <p>See <code>qRegisterNdefRecordTypeHelper(const QMetaObject*,<wbr/>QNdefRecord::TypeNameFormat,<wbr/>QByteArray)</code></p>
     */
    public static void qRegisterNdefRecordTypeHelper(io.qt.core.@Nullable QMetaObject metaObject, io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type){
        qRegisterNdefRecordTypeHelper_native_const_QMetaObject_ptr_QNdefRecord_TypeNameFormat_cref_QByteArray(metaObject, typeNameFormat.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    private native static void qRegisterNdefRecordTypeHelper_native_const_QMetaObject_ptr_QNdefRecord_TypeNameFormat_cref_QByteArray(io.qt.core.QMetaObject metaObject, int typeNameFormat, long type);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QQmlNdefRecord(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QQmlNdefRecord(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QQmlNdefRecord instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QQmlNdefRecord(io.qt.nfc.QNdefRecord, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlNdefRecord(io.qt.nfc.@NonNull QNdefRecord record) {
        this(record, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QQmlNdefRecord(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlNdefRecord() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #record()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.nfc.@NonNull QNdefRecord getRecord() {
        return record();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getType() {
        return type();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #typeNameFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.nfc.QQmlNdefRecord.@NonNull TypeNameFormat getTypeNameFormat() {
        return typeNameFormat();
    }
    
    /**
     * <p>Overloaded function for {@link #qRegisterNdefRecordTypeHelper(io.qt.core.QMetaObject, io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray)}.</p>
     */
    public static void qRegisterNdefRecordTypeHelper(io.qt.core.@Nullable QMetaObject metaObject, io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, byte @NonNull[] type) {
        qRegisterNdefRecordTypeHelper(metaObject, typeNameFormat, new io.qt.core.QByteArray(type));
    }
}
