package io.qt.nfc;

import io.qt.*;


/**
 * <p>Manages all interactions related to sharing files and data over NFC</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html">QNearFieldShareManager</a></code></p>
 */
public class QNearFieldShareManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNearFieldShareManager.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::ShareError</a></code></p>
     */
    public enum ShareError implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>UnknownError</a></code></p>
         */
        UnknownError(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>InvalidShareContentError</a></code></p>
         */
        InvalidShareContentError(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>ShareCanceledError</a></code></p>
         */
        ShareCanceledError(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>ShareInterruptedError</a></code></p>
         */
        ShareInterruptedError(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>ShareRejectedError</a></code></p>
         */
        ShareRejectedError(5),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>UnsupportedShareModeError</a></code></p>
         */
        UnsupportedShareModeError(6),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>ShareAlreadyInProgressError</a></code></p>
         */
        ShareAlreadyInProgressError(7),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareError-enum">QNearFieldShareManager::<wbr/>SharePermissionDeniedError</a></code></p>
         */
        SharePermissionDeniedError(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShareError(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ShareError resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return UnknownError;
            case 2: return InvalidShareContentError;
            case 3: return ShareCanceledError;
            case 4: return ShareInterruptedError;
            case 5: return ShareRejectedError;
            case 6: return UnsupportedShareModeError;
            case 7: return ShareAlreadyInProgressError;
            case 8: return SharePermissionDeniedError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareMode-enum">QNearFieldShareManager::ShareMode</a></code></p>
     * 
     * @see ShareModes
     */
    public enum ShareMode implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareMode-enum">QNearFieldShareManager::<wbr/>NoShare</a></code></p>
         */
        NoShare(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareMode-enum">QNearFieldShareManager::<wbr/>NdefShare</a></code></p>
         */
        NdefShare(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#ShareMode-enum">QNearFieldShareManager::<wbr/>FileShare</a></code></p>
         */
        FileShare(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ShareMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull ShareModes asFlags() {
            return new ShareModes(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ShareModes combined(@NonNull ShareMode e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull ShareModes cleared(@NonNull ShareMode e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link ShareModes} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull ShareModes flags(@Nullable ShareMode @NonNull... values) {
            return new ShareModes(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ShareMode resolve(int value) {
            switch (value) {
            case 0: return NoShare;
            case 1: return NdefShare;
            case 2: return FileShare;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link ShareMode}
     */
    public static final class ShareModes extends QFlags<ShareMode> implements Comparable<ShareModes> {
        private static final long serialVersionUID = 0xcda0e2a455e788aeL;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new ShareModes where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ShareModes(@Nullable ShareMode @NonNull... args){
            super(args);
        }

        /**
         * Creates a new ShareModes with given <code>value</code>.
         * @param value
         */
        public ShareModes(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ShareModes
         */
        @Override
        public final @NonNull ShareModes combined(@StrictNonNull ShareMode e){
            return new ShareModes(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull ShareModes setFlag(@Nullable ShareMode e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull ShareModes setFlag(@Nullable ShareMode e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ShareModes.
         * @return array of enum entries
         */
        @Override
        public final @NonNull ShareMode @NonNull[] flags(){
            return super.flags(ShareMode.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull ShareModes clone(){
            return new ShareModes(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull ShareModes other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#error">QNearFieldShareManager::<wbr/>error(QNearFieldShareManager::ShareError)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.QNearFieldShareManager.@NonNull ShareError> error = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareModesChanged">QNearFieldShareManager::<wbr/>shareModesChanged(QNearFieldShareManager::ShareModes)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.QNearFieldShareManager.@NonNull ShareModes> shareModesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#targetDetected">QNearFieldShareManager::<wbr/>targetDetected(QNearFieldShareTarget*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.@Nullable QNearFieldShareTarget> targetDetected = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#QNearFieldShareManager">QNearFieldShareManager::<wbr/>QNearFieldShareManager(QObject*)</a></code></p>
     */
    public QNearFieldShareManager(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNearFieldShareManager instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#setShareModes">QNearFieldShareManager::<wbr/>setShareModes(QNearFieldShareManager::ShareModes)</a></code></p>
     */
    @QtUninvokable
    public final void setShareModes(io.qt.nfc.QNearFieldShareManager.@NonNull ShareModes modes){
        setShareModes_native_QNearFieldShareManager_ShareModes(QtJambi_LibraryUtilities.internal.nativeId(this), modes.value());
    }
    
    @QtUninvokable
    private native void setShareModes_native_QNearFieldShareManager_ShareModes(long __this__nativeId, int modes);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareError">QNearFieldShareManager::<wbr/>shareError()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldShareManager.@NonNull ShareError shareError(){
        return io.qt.nfc.QNearFieldShareManager.ShareError.resolve(shareError_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int shareError_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#shareModes">QNearFieldShareManager::<wbr/>shareModes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldShareManager.@NonNull ShareModes shareModes(){
        return new io.qt.nfc.QNearFieldShareManager.ShareModes(shareModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int shareModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldsharemanager.html#supportedShareModes">QNearFieldShareManager::<wbr/>supportedShareModes()</a></code></p>
     */
    public static io.qt.nfc.QNearFieldShareManager.@NonNull ShareModes supportedShareModes(){
        return new io.qt.nfc.QNearFieldShareManager.ShareModes(supportedShareModes_native());
    }
    
    private native static int supportedShareModes_native();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QNearFieldShareManager(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QNearFieldShareManager(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QNearFieldShareManager instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QNearFieldShareManager(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QNearFieldShareManager() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #setShareModes(io.qt.nfc.QNearFieldShareManager.ShareModes)}.</p>
     */
    @QtUninvokable
    public final void setShareModes(io.qt.nfc.QNearFieldShareManager.@NonNull ShareMode @NonNull... modes) {
        setShareModes(new io.qt.nfc.QNearFieldShareManager.ShareModes(modes));
    }
}
