package io.qt.nfc;

import io.qt.*;


/**
 * <p>NFC NDEF record</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qndefrecord.html">QNdefRecord</a></code></p>
 */
public class QNdefRecord extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::TypeNameFormat</a></code></p>
     */
    public enum TypeNameFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::<wbr/>Empty</a></code></p>
         */
        Empty(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::<wbr/>NfcRtd</a></code></p>
         */
        NfcRtd(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::<wbr/>Mime</a></code></p>
         */
        Mime(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::<wbr/>Uri</a></code></p>
         */
        Uri(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::<wbr/>ExternalRtd</a></code></p>
         */
        ExternalRtd(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#TypeNameFormat-enum">QNdefRecord::<wbr/>Unknown</a></code></p>
         */
        Unknown(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TypeNameFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TypeNameFormat resolve(int value) {
            switch (value) {
            case 0: return Empty;
            case 1: return NfcRtd;
            case 2: return Mime;
            case 3: return Uri;
            case 4: return ExternalRtd;
            case 5: return Unknown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#QNdefRecord">QNdefRecord::<wbr/>QNdefRecord()</a></code></p>
     */
    public QNdefRecord(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QNdefRecord instance);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#QNdefRecord-1">QNdefRecord::<wbr/>QNdefRecord(QNdefRecord)</a></code></p>
     */
    public QNdefRecord(io.qt.nfc.@NonNull QNdefRecord other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QNdefRecord instance, io.qt.nfc.QNdefRecord other);
    
    /**
     * <p>See <code>QNdefRecord::<wbr/>QNdefRecord(QNdefRecord,<wbr/>QNdefRecord::TypeNameFormat)</code></p>
     */
    protected QNdefRecord(io.qt.nfc.@NonNull QNdefRecord other, io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat){
        super((QPrivateConstructor)null);
        initialize_native(this, other, typeNameFormat);
    }
    
    private native static void initialize_native(QNdefRecord instance, io.qt.nfc.QNdefRecord other, io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat);
    
    /**
     * <p>See <code>QNdefRecord::<wbr/>QNdefRecord(QNdefRecord,<wbr/>QNdefRecord::TypeNameFormat,<wbr/>QByteArray)</code></p>
     */
    protected QNdefRecord(io.qt.nfc.@NonNull QNdefRecord other, io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type){
        super((QPrivateConstructor)null);
        initialize_native(this, other, typeNameFormat, type);
    }
    
    private native static void initialize_native(QNdefRecord instance, io.qt.nfc.QNdefRecord other, io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type);
    
    /**
     * <p>See <code>QNdefRecord::<wbr/>QNdefRecord(QNdefRecord::TypeNameFormat,<wbr/>QByteArray)</code></p>
     */
    protected QNdefRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type){
        super((QPrivateConstructor)null);
        initialize_native(this, typeNameFormat, type);
    }
    
    private native static void initialize_native(QNdefRecord instance, io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#id">QNdefRecord::<wbr/>id()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#isEmpty">QNdefRecord::<wbr/>isEmpty()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#operator-eq">QNdefRecord::<wbr/>operator=(QNdefRecord)</a></code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.nfc.@NonNull QNdefRecord other){
        assign_native_cref_QNdefRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QNdefRecord(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#operator-eq-eq">QNdefRecord::<wbr/>operator==(QNdefRecord)const</a></code></p>
     */
    @QtUninvokable
    public final boolean equals(io.qt.nfc.@NonNull QNdefRecord other){
        return equals_native_cref_QNdefRecord_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean equals_native_cref_QNdefRecord_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#payload">QNdefRecord::<wbr/>payload()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray payload(){
        return payload_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray payload_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#setId">QNdefRecord::<wbr/>setId(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void setId(io.qt.core.@NonNull QByteArray id){
        setId_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
    }
    
    @QtUninvokable
    private native void setId_native_cref_QByteArray(long __this__nativeId, long id);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#setPayload">QNdefRecord::<wbr/>setPayload(QByteArray)</a></code></p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public void setPayload(io.qt.core.@NonNull QByteArray payload){
        setPayload_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(payload));
    }
    
    @QtUninvokable
    private native void setPayload_native_cref_QByteArray(long __this__nativeId, long payload);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#setType">QNdefRecord::<wbr/>setType(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public final void setType(io.qt.core.@NonNull QByteArray type){
        setType_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(type));
    }
    
    @QtUninvokable
    private native void setType_native_cref_QByteArray(long __this__nativeId, long type);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#setTypeNameFormat">QNdefRecord::<wbr/>setTypeNameFormat(QNdefRecord::TypeNameFormat)</a></code></p>
     */
    @QtUninvokable
    public final void setTypeNameFormat(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat){
        setTypeNameFormat_native_QNdefRecord_TypeNameFormat(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value());
    }
    
    @QtUninvokable
    private native void setTypeNameFormat_native_QNdefRecord_TypeNameFormat(long __this__nativeId, int typeNameFormat);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#type">QNdefRecord::<wbr/>type()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#typeNameFormat">QNdefRecord::<wbr/>typeNameFormat()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat(){
        return io.qt.nfc.QNdefRecord.TypeNameFormat.resolve(typeNameFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int typeNameFormat_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QNdefRecord(QPrivateConstructor p) { super(p); } 
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#operator-eq-eq">QNdefRecord::<wbr/>operator==(QNdefRecord)const</a></code></p>
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.nfc.QNdefRecord) {
            return equals((io.qt.nfc.QNdefRecord) other);
        }

        return false;
    }


    /**
     * Returns the objects's hash code computed by <code>qHash(QNdefRecord)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
    <p>See <code><a href="http://doc.qt.io/qt-5/qndefrecord.html#QNdefRecord-1">QNdefRecord::<wbr/>QNdefRecord(QNdefRecord)</a></code></p>
     */
    @QtUninvokable
    @Override
    public QNdefRecord clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QNdefRecord clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded constructor for {@link #QNdefRecord(io.qt.nfc.QNdefRecord, io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray)}.</p>
     */
    protected QNdefRecord(io.qt.nfc.@NonNull QNdefRecord other, io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, byte @NonNull[] type) {
        this(other, typeNameFormat, new io.qt.core.QByteArray(type));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QNdefRecord(io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray)}.</p>
     */
    protected QNdefRecord(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, byte @NonNull[] type) {
        this(typeNameFormat, new io.qt.core.QByteArray(type));
    }
    
    /**
     * <p>Overloaded function for {@link #setId(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void setId(byte @NonNull[] id) {
        setId(new io.qt.core.QByteArray(id));
    }
    
    /**
     * <p>Overloaded function for {@link #setPayload(io.qt.core.QByteArray)}.</p>
     */
    @QtDeclaredFinal
    @QtUninvokable
    public final void setPayload(byte @NonNull[] payload) {
        setPayload(new io.qt.core.QByteArray(payload));
    }
    
    /**
     * <p>Overloaded function for {@link #setType(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final void setType(byte @NonNull[] type) {
        setType(new io.qt.core.QByteArray(type));
    }
}
