package io.qt.nfc;

import io.qt.*;


/**
 * <p>Interface for communicating with a target device</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html">QNearFieldTarget</a></code></p>
 */
public abstract class QNearFieldTarget extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNearFieldTarget.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QNearFieldTarget {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public io.qt.nfc.QNearFieldTarget.@NonNull AccessMethods accessMethods(){
            return new io.qt.nfc.QNearFieldTarget.AccessMethods(accessMethods_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @QtUninvokable
        private native int accessMethods_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public io.qt.nfc.QNearFieldTarget.@NonNull Type type(){
            return io.qt.nfc.QNearFieldTarget.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @QtUninvokable
        private native int type_native_constfct(long __this__nativeId);
        
        
        @Override
        @QtUninvokable
        public io.qt.core.@NonNull QByteArray uid(){
            return uid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native io.qt.core.QByteArray uid_native_constfct(long __this__nativeId);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#AccessMethod-enum">QNearFieldTarget::AccessMethod</a></code></p>
     * 
     * @see AccessMethods
     */
    public enum AccessMethod implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#AccessMethod-enum">QNearFieldTarget::<wbr/>UnknownAccess</a></code></p>
         */
        UnknownAccess(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#AccessMethod-enum">QNearFieldTarget::<wbr/>NdefAccess</a></code></p>
         */
        NdefAccess(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#AccessMethod-enum">QNearFieldTarget::<wbr/>TagTypeSpecificAccess</a></code></p>
         */
        TagTypeSpecificAccess(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#AccessMethod-enum">QNearFieldTarget::<wbr/>LlcpAccess</a></code></p>
         */
        LlcpAccess(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AccessMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull AccessMethods asFlags() {
            return new AccessMethods(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull AccessMethods combined(@NonNull AccessMethod e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull AccessMethods cleared(@NonNull AccessMethod e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link AccessMethods} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull AccessMethods flags(@Nullable AccessMethod @NonNull... values) {
            return new AccessMethods(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AccessMethod resolve(int value) {
            switch (value) {
            case 0: return UnknownAccess;
            case 1: return NdefAccess;
            case 2: return TagTypeSpecificAccess;
            case 4: return LlcpAccess;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link AccessMethod}
     */
    public static final class AccessMethods extends QFlags<AccessMethod> implements Comparable<AccessMethods> {
        private static final long serialVersionUID = 0x34d242f1c8a6d910L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new AccessMethods where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public AccessMethods(@Nullable AccessMethod @NonNull... args){
            super(args);
        }

        /**
         * Creates a new AccessMethods with given <code>value</code>.
         * @param value
         */
        public AccessMethods(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new AccessMethods
         */
        @Override
        public final @NonNull AccessMethods combined(@StrictNonNull AccessMethod e){
            return new AccessMethods(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull AccessMethods setFlag(@Nullable AccessMethod e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull AccessMethods setFlag(@Nullable AccessMethod e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this AccessMethods.
         * @return array of enum entries
         */
        @Override
        public final @NonNull AccessMethod @NonNull[] flags(){
            return super.flags(AccessMethod.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull AccessMethods clone(){
            return new AccessMethods(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull AccessMethods other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::Error</a></code></p>
     */
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>UnknownError</a></code></p>
         */
        UnknownError(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>UnsupportedError</a></code></p>
         */
        UnsupportedError(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>TargetOutOfRangeError</a></code></p>
         */
        TargetOutOfRangeError(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>NoResponseError</a></code></p>
         */
        NoResponseError(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>ChecksumMismatchError</a></code></p>
         */
        ChecksumMismatchError(5),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>InvalidParametersError</a></code></p>
         */
        InvalidParametersError(6),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>NdefReadError</a></code></p>
         */
        NdefReadError(7),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>NdefWriteError</a></code></p>
         */
        NdefWriteError(8),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Error-enum">QNearFieldTarget::<wbr/>CommandError</a></code></p>
         */
        CommandError(9);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return UnknownError;
            case 2: return UnsupportedError;
            case 3: return TargetOutOfRangeError;
            case 4: return NoResponseError;
            case 5: return ChecksumMismatchError;
            case 6: return InvalidParametersError;
            case 7: return NdefReadError;
            case 8: return NdefWriteError;
            case 9: return CommandError;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Type-enum">QNearFieldTarget::Type</a></code></p>
     */
    public enum Type implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Type-enum">QNearFieldTarget::<wbr/>ProprietaryTag</a></code></p>
         */
        ProprietaryTag(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Type-enum">QNearFieldTarget::<wbr/>NfcTagType1</a></code></p>
         */
        NfcTagType1(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Type-enum">QNearFieldTarget::<wbr/>NfcTagType2</a></code></p>
         */
        NfcTagType2(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Type-enum">QNearFieldTarget::<wbr/>NfcTagType3</a></code></p>
         */
        NfcTagType3(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Type-enum">QNearFieldTarget::<wbr/>NfcTagType4</a></code></p>
         */
        NfcTagType4(4),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#Type-enum">QNearFieldTarget::<wbr/>MifareTag</a></code></p>
         */
        MifareTag(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Type resolve(int value) {
            switch (value) {
            case 0: return ProprietaryTag;
            case 1: return NfcTagType1;
            case 2: return NfcTagType2;
            case 3: return NfcTagType3;
            case 4: return NfcTagType4;
            case 5: return MifareTag;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>A request id handle</p>
     * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget-requestid.html">QNearFieldTarget::RequestId</a></code></p>
     */
    public static class RequestId extends QtObject
        implements java.lang.Comparable<io.qt.nfc.QNearFieldTarget.@StrictNonNull RequestId>,
                java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget-requestid.html#RequestId">QNearFieldTarget::RequestId::<wbr/>RequestId()</a></code></p>
         */
        public RequestId(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(RequestId instance);
        
        /**
         * <p>See <code>QNearFieldTarget::RequestId::<wbr/>RequestId(QNearFieldTarget::RequestId)</code></p>
         */
        public RequestId(io.qt.nfc.QNearFieldTarget.@NonNull RequestId other){
            super((QPrivateConstructor)null);
            initialize_native(this, other);
        }
        
        private native static void initialize_native(RequestId instance, io.qt.nfc.QNearFieldTarget.RequestId other);
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget-requestid.html#isValid">QNearFieldTarget::RequestId::<wbr/>isValid()const</a></code></p>
         */
        @QtUninvokable
        public final boolean isValid(){
            return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native boolean isValid_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <code>QNearFieldTarget::RequestId::<wbr/>operator&lt;(QNearFieldTarget::RequestId)const</code></p>
         */
        @QtUninvokable
        private final boolean operator_less(io.qt.nfc.QNearFieldTarget.@NonNull RequestId other){
            return operator_less_native_cref_QNearFieldTarget_RequestId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        @QtUninvokable
        private native boolean operator_less_native_cref_QNearFieldTarget_RequestId_constfct(long __this__nativeId, long other);
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget-requestid.html#operator-eq">QNearFieldTarget::RequestId::<wbr/>operator=(QNearFieldTarget::RequestId)</a></code></p>
         */
        @QtUninvokable
        public final void assign(io.qt.nfc.QNearFieldTarget.@NonNull RequestId other){
            assign_native_cref_QNearFieldTarget_RequestId(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        @QtUninvokable
        private native void assign_native_cref_QNearFieldTarget_RequestId(long __this__nativeId, long other);
        
        /**
         * <p>See <code>QNearFieldTarget::RequestId::<wbr/>operator==(QNearFieldTarget::RequestId)const</code></p>
         */
        @QtUninvokable
        public final boolean equals(io.qt.nfc.QNearFieldTarget.@NonNull RequestId other){
            return equals_native_cref_QNearFieldTarget_RequestId_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
        }
        
        @QtUninvokable
        private native boolean equals_native_cref_QNearFieldTarget_RequestId_constfct(long __this__nativeId, long other);
        
        /**
         * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget-requestid.html#refCount">QNearFieldTarget::RequestId::<wbr/>refCount()const</a></code></p>
         */
        @QtUninvokable
        public final int refCount(){
            return refCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @QtUninvokable
        private native int refCount_native_constfct(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         * @hidden
         */
        @NativeAccess
        protected RequestId(QPrivateConstructor p) { super(p); } 
        

        /**
         * <p>See <code>QNearFieldTarget::RequestId::<wbr/>operator==(QNearFieldTarget::RequestId)const</code></p>
         */
        @Override
        @QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.nfc.QNearFieldTarget.RequestId) {
                return equals((io.qt.nfc.QNearFieldTarget.RequestId) other);
            }

            return false;
        }

        /**
         * <p>See <code>QNearFieldTarget::RequestId::<wbr/>operator&lt;(QNearFieldTarget::RequestId)const</code></p>
         */
        /**
         * {@inheritDoc}
         */
        @QtUninvokable
        public int compareTo(io.qt.nfc.QNearFieldTarget.@StrictNonNull RequestId other) {
            if (equals(other)) return 0;
            else if (operator_less(other)) return -1;
            else return 1;
        }


        /**
         * Returns the objects's hash code computed by <code>qHash(QNearFieldTarget::RequestId)</code>.
         */
        @QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        /**
         * <p>Creates and returns a copy of this object.</p>
        <p>See <code>QNearFieldTarget::RequestId::<wbr/>RequestId(QNearFieldTarget::RequestId)</code></p>
         */
        @QtUninvokable
        @Override
        public RequestId clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private static native RequestId clone_native(long __this_nativeId);
    }


    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#disconnected">QNearFieldTarget::<wbr/>disconnected()</a></code></p>
     */
    public final @NonNull Signal0 disconnected = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#error">QNearFieldTarget::<wbr/>error(QNearFieldTarget::Error,<wbr/>QNearFieldTarget::RequestId)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.nfc.QNearFieldTarget.@NonNull Error, io.qt.nfc.QNearFieldTarget.@NonNull RequestId> error = new Signal2<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#ndefMessageRead">QNearFieldTarget::<wbr/>ndefMessageRead(QNdefMessage)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.@NonNull QNdefMessage> ndefMessageRead = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#ndefMessagesWritten">QNearFieldTarget::<wbr/>ndefMessagesWritten()</a></code></p>
     */
    public final @NonNull Signal0 ndefMessagesWritten = new Signal0();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#requestCompleted">QNearFieldTarget::<wbr/>requestCompleted(QNearFieldTarget::RequestId)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.QNearFieldTarget.@NonNull RequestId> requestCompleted = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#QNearFieldTarget">QNearFieldTarget::<wbr/>QNearFieldTarget(QObject*)</a></code></p>
     */
    public QNearFieldTarget(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNearFieldTarget instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#disconnect">QNearFieldTarget::<wbr/>disconnect()</a></code></p>
     */
    @QtUninvokable
    public final boolean disconnectFromTarget(){
        return disconnectFromTarget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean disconnectFromTarget_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#isProcessingCommand">QNearFieldTarget::<wbr/>isProcessingCommand()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isProcessingCommand(){
        return isProcessingCommand_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isProcessingCommand_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#keepConnection">QNearFieldTarget::<wbr/>keepConnection()const</a></code></p>
     */
    @QtUninvokable
    public final boolean keepConnection(){
        return keepConnection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean keepConnection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#maxCommandLength">QNearFieldTarget::<wbr/>maxCommandLength()const</a></code></p>
     */
    @QtUninvokable
    public final int maxCommandLength(){
        return maxCommandLength_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxCommandLength_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#reportError">QNearFieldTarget::<wbr/>reportError(QNearFieldTarget::Error,<wbr/>QNearFieldTarget::RequestId)</a></code></p>
     */
    @QtUninvokable
    protected final void reportError(io.qt.nfc.QNearFieldTarget.@NonNull Error error, io.qt.nfc.QNearFieldTarget.@NonNull RequestId id){
        reportError_native_QNearFieldTarget_Error_cref_QNearFieldTarget_RequestId(QtJambi_LibraryUtilities.internal.nativeId(this), error.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
    }
    
    @QtUninvokable
    private native void reportError_native_QNearFieldTarget_Error_cref_QNearFieldTarget_RequestId(long __this__nativeId, int error, long id);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#requestResponse">QNearFieldTarget::<wbr/>requestResponse(QNearFieldTarget::RequestId)</a></code></p>
     */
    @QtUninvokable
    public final java.lang.Object requestResponse(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id){
        return requestResponse_native_cref_QNearFieldTarget_RequestId(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id));
    }
    
    @QtUninvokable
    private native java.lang.Object requestResponse_native_cref_QNearFieldTarget_RequestId(long __this__nativeId, long id);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#setKeepConnection">QNearFieldTarget::<wbr/>setKeepConnection(bool)</a></code></p>
     */
    @QtUninvokable
    public final boolean setKeepConnection(boolean isPersistent){
        return setKeepConnection_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isPersistent);
    }
    
    @QtUninvokable
    private native boolean setKeepConnection_native_bool(long __this__nativeId, boolean isPersistent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#setResponseForRequest">QNearFieldTarget::<wbr/>setResponseForRequest(QNearFieldTarget::RequestId,<wbr/>QVariant,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final void setResponseForRequest(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id, java.lang.Object response, boolean emitRequestCompleted){
        setResponseForRequest_native_cref_QNearFieldTarget_RequestId_cref_QVariant_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id), response, emitRequestCompleted);
    }
    
    @QtUninvokable
    private native void setResponseForRequest_native_cref_QNearFieldTarget_RequestId_cref_QVariant_bool(long __this__nativeId, long id, java.lang.Object response, boolean emitRequestCompleted);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#accessMethods">QNearFieldTarget::<wbr/>accessMethods()const</a></code></p>
     */
    @QtUninvokable
    public abstract io.qt.nfc.QNearFieldTarget.@NonNull AccessMethods accessMethods();
    
    @QtUninvokable
    private native int accessMethods_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#handleResponse">QNearFieldTarget::<wbr/>handleResponse(QNearFieldTarget::RequestId,<wbr/>QByteArray)</a></code></p>
     */
    protected boolean handleResponse(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id, io.qt.core.@NonNull QByteArray response){
        return handleResponse_native_cref_QNearFieldTarget_RequestId_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id), QtJambi_LibraryUtilities.internal.checkedNativeId(response));
    }
    
    private native boolean handleResponse_native_cref_QNearFieldTarget_RequestId_cref_QByteArray(long __this__nativeId, long id, long response);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#hasNdefMessage">QNearFieldTarget::<wbr/>hasNdefMessage()</a></code></p>
     */
    @QtUninvokable
    public boolean hasNdefMessage(){
        return hasNdefMessage_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasNdefMessage_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#readNdefMessages">QNearFieldTarget::<wbr/>readNdefMessages()</a></code></p>
     */
    @QtUninvokable
    public io.qt.nfc.QNearFieldTarget.@NonNull RequestId readNdefMessages(){
        return readNdefMessages_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNearFieldTarget.RequestId readNdefMessages_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#sendCommand">QNearFieldTarget::<wbr/>sendCommand(QByteArray)</a></code></p>
     */
    @QtUninvokable
    public io.qt.nfc.QNearFieldTarget.@NonNull RequestId sendCommand(io.qt.core.@NonNull QByteArray command){
        return sendCommand_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(command));
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNearFieldTarget.RequestId sendCommand_native_cref_QByteArray(long __this__nativeId, long command);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#sendCommands">QNearFieldTarget::<wbr/>sendCommands(QList&lt;QByteArray&gt;)</a></code></p>
     */
    @QtUninvokable
    public io.qt.nfc.QNearFieldTarget.@NonNull RequestId sendCommands(java.util.@NonNull Collection<? extends io.qt.core.@NonNull QByteArray> commands){
        return sendCommands_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), commands);
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNearFieldTarget.RequestId sendCommands_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.core.QByteArray> commands);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#type">QNearFieldTarget::<wbr/>type()const</a></code></p>
     */
    @QtUninvokable
    public abstract io.qt.nfc.QNearFieldTarget.@NonNull Type type();
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#uid">QNearFieldTarget::<wbr/>uid()const</a></code></p>
     */
    @QtUninvokable
    public abstract io.qt.core.@NonNull QByteArray uid();
    
    @QtUninvokable
    private native io.qt.core.QByteArray uid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#url">QNearFieldTarget::<wbr/>url()const</a></code></p>
     */
    @QtUninvokable
    public io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#waitForRequestCompleted">QNearFieldTarget::<wbr/>waitForRequestCompleted(QNearFieldTarget::RequestId,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public boolean waitForRequestCompleted(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id, int msecs){
        return waitForRequestCompleted_native_cref_QNearFieldTarget_RequestId_int(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(id), msecs);
    }
    
    @QtUninvokable
    private native boolean waitForRequestCompleted_native_cref_QNearFieldTarget_RequestId_int(long __this__nativeId, long id, int msecs);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldtarget.html#writeNdefMessages">QNearFieldTarget::<wbr/>writeNdefMessages(QList&lt;QNdefMessage&gt;)</a></code></p>
     */
    @QtUninvokable
    public io.qt.nfc.QNearFieldTarget.@NonNull RequestId writeNdefMessages(java.util.@NonNull Collection<? extends io.qt.nfc.@NonNull QNdefMessage> messages){
        return writeNdefMessages_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), messages);
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNearFieldTarget.RequestId writeNdefMessages_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.nfc.QNdefMessage> messages);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QNearFieldTarget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QNearFieldTarget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QNearFieldTarget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QNearFieldTarget(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QNearFieldTarget() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #setResponseForRequest(io.qt.nfc.QNearFieldTarget.RequestId, java.lang.Object, boolean)}
     *  with <code>emitRequestCompleted = true</code>.</p>
     */
    @QtUninvokable
    public final void setResponseForRequest(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id, java.lang.Object response) {
        setResponseForRequest(id, response, (boolean)true);
    }
    
    /**
     * <p>Overloaded function for {@link #handleResponse(io.qt.nfc.QNearFieldTarget.RequestId, io.qt.core.QByteArray)}.</p>
     */
    protected final boolean handleResponse(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id, byte @NonNull[] response) {
        return handleResponse(id, new io.qt.core.QByteArray(response));
    }
    
    /**
     * <p>Overloaded function for {@link #sendCommand(io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldTarget.@NonNull RequestId sendCommand(byte @NonNull[] command) {
        return sendCommand(new io.qt.core.QByteArray(command));
    }
    
    /**
     * <p>Overloaded function for {@link #waitForRequestCompleted(io.qt.nfc.QNearFieldTarget.RequestId, int)}
     *  with <code>msecs = 5000</code>.</p>
     */
    @QtUninvokable
    public final boolean waitForRequestCompleted(io.qt.nfc.QNearFieldTarget.@NonNull RequestId id) {
        return waitForRequestCompleted(id, (int)5000);
    }
}
