package io.qt.nfc;

import io.qt.*;


/**
 * <p>Access to notifications for NFC events</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html">QNearFieldManager</a></code></p>
 */
public class QNearFieldManager extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QNearFieldManager.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::AdapterState</a></code></p>
     */
    public enum AdapterState implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::<wbr/>AdapterState::<wbr/>Offline</a></code></p>
         */
        Offline(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::<wbr/>AdapterState::<wbr/>TurningOn</a></code></p>
         */
        TurningOn(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::<wbr/>AdapterState::<wbr/>Online</a></code></p>
         */
        Online(3),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#AdapterState-enum">QNearFieldManager::<wbr/>AdapterState::<wbr/>TurningOff</a></code></p>
         */
        TurningOff(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AdapterState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AdapterState resolve(int value) {
            switch (value) {
            case 1: return Offline;
            case 2: return TurningOn;
            case 3: return Online;
            case 4: return TurningOff;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#TargetAccessMode-enum">QNearFieldManager::TargetAccessMode</a></code></p>
     * 
     * @see TargetAccessModes
     */
    public enum TargetAccessMode implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#TargetAccessMode-enum">QNearFieldManager::<wbr/>NoTargetAccess</a></code></p>
         */
        NoTargetAccess(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#TargetAccessMode-enum">QNearFieldManager::<wbr/>NdefReadTargetAccess</a></code></p>
         */
        NdefReadTargetAccess(1),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#TargetAccessMode-enum">QNearFieldManager::<wbr/>NdefWriteTargetAccess</a></code></p>
         */
        NdefWriteTargetAccess(2),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#TargetAccessMode-enum">QNearFieldManager::<wbr/>TagTypeSpecificTargetAccess</a></code></p>
         */
        TagTypeSpecificTargetAccess(4);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TargetAccessMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull TargetAccessModes asFlags() {
            return new TargetAccessModes(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull TargetAccessModes combined(@NonNull TargetAccessMode e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull TargetAccessModes cleared(@NonNull TargetAccessMode e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link TargetAccessModes} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull TargetAccessModes flags(@Nullable TargetAccessMode @NonNull... values) {
            return new TargetAccessModes(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TargetAccessMode resolve(int value) {
            switch (value) {
            case 0: return NoTargetAccess;
            case 1: return NdefReadTargetAccess;
            case 2: return NdefWriteTargetAccess;
            case 4: return TagTypeSpecificTargetAccess;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link TargetAccessMode}
     */
    public static final class TargetAccessModes extends QFlags<TargetAccessMode> implements Comparable<TargetAccessModes> {
        private static final long serialVersionUID = 0x7e8bf1a9b72a6441L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new TargetAccessModes where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public TargetAccessModes(@Nullable TargetAccessMode @NonNull... args){
            super(args);
        }

        /**
         * Creates a new TargetAccessModes with given <code>value</code>.
         * @param value
         */
        public TargetAccessModes(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new TargetAccessModes
         */
        @Override
        public final @NonNull TargetAccessModes combined(@StrictNonNull TargetAccessMode e){
            return new TargetAccessModes(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull TargetAccessModes setFlag(@Nullable TargetAccessMode e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull TargetAccessModes setFlag(@Nullable TargetAccessMode e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this TargetAccessModes.
         * @return array of enum entries
         */
        @Override
        public final @NonNull TargetAccessMode @NonNull[] flags(){
            return super.flags(TargetAccessMode.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull TargetAccessModes clone(){
            return new TargetAccessModes(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull TargetAccessModes other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#adapterStateChanged">QNearFieldManager::<wbr/>adapterStateChanged(QNearFieldManager::AdapterState)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.QNearFieldManager.@NonNull AdapterState> adapterStateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#targetDetected">QNearFieldManager::<wbr/>targetDetected(QNearFieldTarget*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.@Nullable QNearFieldTarget> targetDetected = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#targetLost">QNearFieldManager::<wbr/>targetLost(QNearFieldTarget*)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.nfc.@Nullable QNearFieldTarget> targetLost = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#QNearFieldManager">QNearFieldManager::<wbr/>QNearFieldManager(QObject*)</a></code></p>
     */
    public QNearFieldManager(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QNearFieldManager instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#isAvailable">QNearFieldManager::<wbr/>isAvailable()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAvailable(){
        return isAvailable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAvailable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#isSupported">QNearFieldManager::<wbr/>isSupported()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isSupported(){
        return isSupported_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSupported_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler-2">QNearFieldManager::<wbr/>registerNdefMessageHandler(QNdefFilter,<wbr/>QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final int registerNdefMessageHandler(io.qt.nfc.@NonNull QNdefFilter filter, io.qt.core.@Nullable QObject object, java.lang.@Nullable String method){
        return registerNdefMessageHandler_native_cref_QNdefFilter_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filter), QtJambi_LibraryUtilities.internal.checkedNativeId(object), method);
    }
    
    @QtUninvokable
    private native int registerNdefMessageHandler_native_cref_QNdefFilter_QObject_ptr_const_char_ptr(long __this__nativeId, long filter, long object, java.lang.String method);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler-1">QNearFieldManager::<wbr/>registerNdefMessageHandler(QNdefRecord::TypeNameFormat,<wbr/>QByteArray,<wbr/>QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final int registerNdefMessageHandler(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, io.qt.core.@NonNull QByteArray type, io.qt.core.@Nullable QObject object, java.lang.@Nullable String method){
        return registerNdefMessageHandler_native_QNdefRecord_TypeNameFormat_cref_QByteArray_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(type), QtJambi_LibraryUtilities.internal.checkedNativeId(object), method);
    }
    
    @QtUninvokable
    private native int registerNdefMessageHandler_native_QNdefRecord_TypeNameFormat_cref_QByteArray_QObject_ptr_const_char_ptr(long __this__nativeId, int typeNameFormat, long type, long object, java.lang.String method);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#registerNdefMessageHandler">QNearFieldManager::<wbr/>registerNdefMessageHandler(QObject*,<wbr/>const char*)</a></code></p>
     */
    @QtUninvokable
    public final int registerNdefMessageHandler(io.qt.core.@Nullable QObject object, java.lang.@Nullable String method){
        return registerNdefMessageHandler_native_QObject_ptr_const_char_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(object), method);
    }
    
    @QtUninvokable
    private native int registerNdefMessageHandler_native_QObject_ptr_const_char_ptr(long __this__nativeId, long object, java.lang.String method);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#setTargetAccessModes">QNearFieldManager::<wbr/>setTargetAccessModes(QNearFieldManager::TargetAccessModes)</a></code></p>
     */
    @QtUninvokable
    public final void setTargetAccessModes(io.qt.nfc.QNearFieldManager.@NonNull TargetAccessModes accessModes){
        setTargetAccessModes_native_QNearFieldManager_TargetAccessModes(QtJambi_LibraryUtilities.internal.nativeId(this), accessModes.value());
    }
    
    @QtUninvokable
    private native void setTargetAccessModes_native_QNearFieldManager_TargetAccessModes(long __this__nativeId, int accessModes);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#startTargetDetection">QNearFieldManager::<wbr/>startTargetDetection()</a></code></p>
     */
    @QtUninvokable
    public final boolean startTargetDetection(){
        return startTargetDetection_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean startTargetDetection_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#stopTargetDetection">QNearFieldManager::<wbr/>stopTargetDetection()</a></code></p>
     */
    @QtUninvokable
    public final void stopTargetDetection(){
        stopTargetDetection_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void stopTargetDetection_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#targetAccessModes">QNearFieldManager::<wbr/>targetAccessModes()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.nfc.QNearFieldManager.@NonNull TargetAccessModes targetAccessModes(){
        return new io.qt.nfc.QNearFieldManager.TargetAccessModes(targetAccessModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int targetAccessModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qnearfieldmanager.html#unregisterNdefMessageHandler">QNearFieldManager::<wbr/>unregisterNdefMessageHandler(int)</a></code></p>
     */
    @QtUninvokable
    public final boolean unregisterNdefMessageHandler(int handlerId){
        return unregisterNdefMessageHandler_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), handlerId);
    }
    
    @QtUninvokable
    private native boolean unregisterNdefMessageHandler_native_int(long __this__nativeId, int handlerId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QNearFieldManager(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QNearFieldManager(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QNearFieldManager instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QNearFieldManager(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QNearFieldManager() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #registerNdefMessageHandler(io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray, io.qt.core.QObject, java.lang.String)}.</p>
     */
    @QtUninvokable
    public final int registerNdefMessageHandler(io.qt.nfc.QNdefRecord.@NonNull TypeNameFormat typeNameFormat, byte @NonNull[] type, io.qt.core.@Nullable QObject object, java.lang.@Nullable String method) {
        return registerNdefMessageHandler(typeNameFormat, new io.qt.core.QByteArray(type), object, method);
    }
    
    /**
     * <p>Overloaded function for {@link #setTargetAccessModes(io.qt.nfc.QNearFieldManager.TargetAccessModes)}.</p>
     */
    @QtUninvokable
    public final void setTargetAccessModes(io.qt.nfc.QNearFieldManager.@NonNull TargetAccessMode @NonNull... accessModes) {
        setTargetAccessModes(new io.qt.nfc.QNearFieldManager.TargetAccessModes(accessModes));
    }
}
