package io.qt.nfc;

import io.qt.*;


/**
 * <p>Implements the NdefRecord type in QML</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html">QQmlNdefRecord</a></p>
 */
public class QQmlNdefRecord extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQmlNdefRecord.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#TypeNameFormat-enum">QQmlNdefRecord::TypeNameFormat</a></p>
     */
    public enum TypeNameFormat implements QtEnumerator {
        Empty(0),
        NfcRtd(1),
        Mime(2),
        Uri(3),
        ExternalRtd(4),
        Unknown(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TypeNameFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TypeNameFormat resolve(int value) {
            switch (value) {
            case 0: return Empty;
            case 1: return NfcRtd;
            case 2: return Mime;
            case 3: return Uri;
            case 4: return ExternalRtd;
            case 5: return Unknown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#record-prop">QQmlNdefRecord::recordChanged()</a></p>
     */
    @QtPropertyNotify(name="record")
    public final @NonNull Signal0 recordChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#typeChanged">QQmlNdefRecord::typeChanged()</a></p>
     */
    @QtPropertyNotify(name="type")
    public final @NonNull Signal0 typeChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#typeNameFormat-prop">QQmlNdefRecord::typeNameFormatChanged()</a></p>
     */
    @QtPropertyNotify(name="typeNameFormat")
    public final @NonNull Signal0 typeNameFormatChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlNdefRecord() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#QQmlNdefRecord">QQmlNdefRecord::QQmlNdefRecord(QObject*)</a></p>
     */
    public QQmlNdefRecord(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQmlNdefRecord instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #(io.qt.nfc.QNdefRecord, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQmlNdefRecord(io.qt.nfc.@NonNull QNdefRecord record) {
        this(record, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#QQmlNdefRecord-1">QQmlNdefRecord::QQmlNdefRecord(QNdefRecord,QObject*)</a></p>
     */
    public QQmlNdefRecord(io.qt.nfc.@NonNull QNdefRecord record, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, record, parent);
    }
    
    private native static void initialize_native(QQmlNdefRecord instance, io.qt.nfc.QNdefRecord record, io.qt.core.QObject parent);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #record()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.nfc.@NonNull QNdefRecord getRecord() {
        return record();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#record">QQmlNdefRecord::record()const</a></p>
     */
    @QtPropertyReader(name="record")
    @QtUninvokable
    public final io.qt.nfc.@NonNull QNdefRecord record(){
        return record_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.nfc.QNdefRecord record_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#setRecord">QQmlNdefRecord::setRecord(QNdefRecord)</a></p>
     */
    @QtPropertyWriter(name="record")
    @QtUninvokable
    public final void setRecord(io.qt.nfc.@NonNull QNdefRecord record){
        setRecord_native_cref_QNdefRecord(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    @QtUninvokable
    private native void setRecord_native_cref_QNdefRecord(long __this__nativeId, long record);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#setType">QQmlNdefRecord::setType(QString)</a></p>
     */
    @QtPropertyWriter(name="type")
    @QtUninvokable
    public final void setType(java.lang.@NonNull String t){
        setType_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), t);
    }
    
    @QtUninvokable
    private native void setType_native_cref_QString(long __this__nativeId, java.lang.String t);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#setTypeNameFormat">QQmlNdefRecord::setTypeNameFormat(QQmlNdefRecord::TypeNameFormat)</a></p>
     */
    @QtPropertyWriter(name="typeNameFormat")
    @QtUninvokable
    public final void setTypeNameFormat(io.qt.nfc.QQmlNdefRecord.@NonNull TypeNameFormat typeNameFormat){
        setTypeNameFormat_native_QQmlNdefRecord_TypeNameFormat(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value());
    }
    
    @QtUninvokable
    private native void setTypeNameFormat_native_QQmlNdefRecord_TypeNameFormat(long __this__nativeId, int typeNameFormat);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getType() {
        return type();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#type">QQmlNdefRecord::type()const</a></p>
     */
    @QtPropertyReader(name="type")
    @QtUninvokable
    public final java.lang.@NonNull String type(){
        return type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String type_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #typeNameFormat()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.nfc.QQmlNdefRecord.@NonNull TypeNameFormat getTypeNameFormat() {
        return typeNameFormat();
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlndefrecord.html#typeNameFormat">QQmlNdefRecord::typeNameFormat()const</a></p>
     */
    @QtPropertyReader(name="typeNameFormat")
    @QtUninvokable
    public final io.qt.nfc.QQmlNdefRecord.@NonNull TypeNameFormat typeNameFormat(){
        return io.qt.nfc.QQmlNdefRecord.TypeNameFormat.resolve(typeNameFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int typeNameFormat_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QQmlNdefRecord(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QQmlNdefRecord(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QQmlNdefRecord instance, QDeclarativeConstructor constructor);
    
}
