package io.qt.nfc;


/**
 * <p>Filter for matching NDEF messages</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qndeffilter.html">QNdefFilter</a></p>
 */
public class QNdefFilter extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt class QNdefFilter::Record</p>
     */
    public static class Record extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public Record(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(Record instance);
        
        @io.qt.QtUninvokable
        public final void setMaximum(int maximum){
            setMaximum_native_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), maximum);
        }
        
        @io.qt.QtUninvokable
        private native void setMaximum_native_unsigned_int(long __this__nativeId, int maximum);
        
        @io.qt.QtUninvokable
        public final int maximum(){
            return maximum_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int maximum_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setMinimum(int minimum){
            setMinimum_native_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), minimum);
        }
        
        @io.qt.QtUninvokable
        private native void setMinimum_native_unsigned_int(long __this__nativeId, int minimum);
        
        @io.qt.QtUninvokable
        public final int minimum(){
            return minimum_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int minimum_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setType(io.qt.core.QByteArray type){
            setType_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(type));
        }
        
        @io.qt.QtUninvokable
        private native void setType_native_cref_QByteArray(long __this__nativeId, long type);
        
        @io.qt.QtUninvokable
        public final io.qt.core.QByteArray type(){
            return type_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QByteArray type_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setTypeNameFormat(io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat){
            setTypeNameFormat_native_cref_QNdefRecord_TypeNameFormat(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value());
        }
        
        @io.qt.QtUninvokable
        private native void setTypeNameFormat_native_cref_QNdefRecord_TypeNameFormat(long __this__nativeId, int typeNameFormat);
        
        @io.qt.QtUninvokable
        public final io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat(){
            return io.qt.nfc.QNdefRecord.TypeNameFormat.resolve(typeNameFormat_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int typeNameFormat_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Record(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public Record clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native Record clone_native(long __this_nativeId);
    }

    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#QNdefFilter">QNdefFilter::QNdefFilter()</a></p>
     */
    public QNdefFilter(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QNdefFilter instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#QNdefFilter-1">QNdefFilter::QNdefFilter(QNdefFilter)</a></p>
     */
    public QNdefFilter(io.qt.nfc.QNdefFilter other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QNdefFilter instance, io.qt.nfc.QNdefFilter other);
    
    /**
     * <p>Overloaded function for {@link #appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray, int, int)}
     *  with <code>max = 1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type, int min) {
        appendRecord(typeNameFormat, type, min, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat, io.qt.core.QByteArray, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>min = 1</code></li>
     * <li><code>max = 1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type) {
        appendRecord(typeNameFormat, type, (int)1, (int)1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#appendRecord-1">QNdefFilter::appendRecord(QNdefRecord::TypeNameFormat,QByteArray,uint,uint)</a></p>
     */
    @io.qt.QtUninvokable
    public final void appendRecord(io.qt.nfc.QNdefRecord.TypeNameFormat typeNameFormat, io.qt.core.QByteArray type, int min, int max){
        appendRecord_native_QNdefRecord_TypeNameFormat_cref_QByteArray_unsigned_int_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), typeNameFormat.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(type), min, max);
    }
    
    @io.qt.QtUninvokable
    private native void appendRecord_native_QNdefRecord_TypeNameFormat_cref_QByteArray_unsigned_int_unsigned_int(long __this__nativeId, int typeNameFormat, long type, int min, int max);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#appendRecord-2">QNdefFilter::appendRecord(QNdefFilter::Record)</a></p>
     */
    @io.qt.QtUninvokable
    public final void appendRecord(io.qt.nfc.QNdefFilter.Record record){
        appendRecord_native_cref_QNdefFilter_Record(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(record));
    }
    
    @io.qt.QtUninvokable
    private native void appendRecord_native_cref_QNdefFilter_Record(long __this__nativeId, long record);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#clear">QNdefFilter::clear()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#orderMatch">QNdefFilter::orderMatch()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean orderMatch(){
        return orderMatch_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean orderMatch_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#recordAt">QNdefFilter::recordAt(int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.nfc.QNdefFilter.Record recordAt(int i){
        return recordAt_native_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), i);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.nfc.QNdefFilter.Record recordAt_native_int_constfct(long __this__nativeId, int i);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#recordCount">QNdefFilter::recordCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int recordCount(){
        return recordCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int recordCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qndeffilter.html#setOrderMatch">QNdefFilter::setOrderMatch(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setOrderMatch(boolean on){
        setOrderMatch_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), on);
    }
    
    @io.qt.QtUninvokable
    private native void setOrderMatch_native_bool(long __this__nativeId, boolean on);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QNdefFilter(QPrivateConstructor p) { super(p); } 
    
    @io.qt.QtUninvokable
    public final void appendRecord(Class<? extends QNdefRecord> type) {
        appendRecord(type, 1, 1);
    }
    
    @io.qt.QtUninvokable
    public final void appendRecord(Class<? extends QNdefRecord> type, int min) {
        appendRecord(type, min, 1);
    }
    
    @io.qt.QtUninvokable
    public final void appendRecord(Class<? extends QNdefRecord> type, int min, int max) {
        if(type==QNdefRecord.class) {
            QNdefRecord record = new QNdefRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else if(type==QNdefNfcSmartPosterRecord.class) {
            QNdefNfcSmartPosterRecord record = new QNdefNfcSmartPosterRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else if(type==QNdefNfcTextRecord.class) {
            QNdefNfcTextRecord record = new QNdefNfcTextRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else if(type==QNdefNfcUriRecord.class) {
            QNdefNfcUriRecord record = new QNdefNfcUriRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else if(type==QNdefNfcIconRecord.class) {
            QNdefNfcIconRecord record = new QNdefNfcIconRecord();
            appendRecord(record.typeNameFormat(), record.type(), min, max);
        }else {
            try {
                QNdefRecord record = type.getConstructor().newInstance();
                appendRecord(record.typeNameFormat(), record.type(), min, max);
            } catch (RuntimeException | Error e) {
                throw e;
            } catch (InstantiationException | IllegalAccessException
                                            | java.lang.reflect.InvocationTargetException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
    
    @Override
    public QNdefFilter clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QNdefFilter clone_native(long __this_nativeId);
}
