#include <QtCore/QtGlobal>
#include <QtNfc/qndefmessage.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>
#include <QtNfc/qndefrecord.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiNfc/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
namespace QtJambiPrivate{
    template<>
    struct supports_less_than<QNdefMessage> : std::false_type{};
    template<>
    struct supports_stream_operators<QNdefMessage> : std::false_type{};
    template<>
    struct supports_debugstream<QNdefMessage> : std::false_type{};
}
QT_WARNING_DISABLE_CLANG("-Wdeprecated-copy")
QT_WARNING_DISABLE_GCC("-Wdeprecated-copy")

void deleter_QNdefMessage(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QNdefMessage")
    QNdefMessage *_ptr = reinterpret_cast<QNdefMessage *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QNdefMessage()
void __qt_construct_QNdefMessage_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNdefMessage()")
    Q_UNUSED(__java_arguments)
    QNdefMessage *__qt_this = new(__qtjambi_ptr) QNdefMessage();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QNdefMessage(QList<QNdefRecord>)
void __qt_construct_QNdefMessage_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNdefMessage(QList<QNdefRecord>)")
    QtJambiScope __qtjambi_scope;
    jobject records0 = __java_arguments[0].l;
    const QList<QNdefRecord>&  __qt_records0 = qtjambi_cast<const QList<QNdefRecord>& >(__jni_env, __qtjambi_scope, records0);
    QNdefMessage *__qt_this = new(__qtjambi_ptr) QNdefMessage(__qt_records0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QNdefMessage(QNdefMessage)
void __qt_construct_QNdefMessage_2(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNdefMessage(QNdefMessage)")
    jobject message0 = __java_arguments[0].l;
    const QNdefMessage& __qt_message0 = qtjambi_cast<const QNdefMessage& >(__jni_env, message0);
    QNdefMessage *__qt_this = new(__qtjambi_ptr) QNdefMessage(__qt_message0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// new QNdefMessage(QNdefRecord)
void __qt_construct_QNdefMessage_3(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QNdefMessage(QNdefRecord)")
    jobject record0 = __java_arguments[0].l;
    const QNdefRecord& __qt_record0 = qtjambi_cast<const QNdefRecord& >(__jni_env, record0);
    QNdefMessage *__qt_this = new(__qtjambi_ptr) QNdefMessage(__qt_record0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QNdefMessage
void __qt_destruct_QNdefMessage(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QNdefMessage")
    reinterpret_cast<QNdefMessage*>(ptr)->~QNdefMessage();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QNdefMessage::QNdefMessage()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_initialize_1native__Lio_qt_nfc_QNdefMessage_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNdefMessage::QNdefMessage()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNdefMessage_0, sizeof(QNdefMessage), typeid(QNdefMessage), false, QtJambiPrivate::QListAccess<QNdefRecord>::newInstance(), &deleter_QNdefMessage, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNdefMessage::QNdefMessage(QList<QNdefRecord>)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_initialize_1native__Lio_qt_nfc_QNdefMessage_2Ljava_util_Collection_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject records0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNdefMessage::QNdefMessage(QList<QNdefRecord>)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = records0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNdefMessage_1, sizeof(QNdefMessage), typeid(QNdefMessage), false, QtJambiPrivate::QListAccess<QNdefRecord>::newInstance(), &deleter_QNdefMessage, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNdefMessage::QNdefMessage(QNdefMessage)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_initialize_1native__Lio_qt_nfc_QNdefMessage_2Lio_qt_nfc_QNdefMessage_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject message0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNdefMessage::QNdefMessage(QNdefMessage)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = message0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNdefMessage_2, sizeof(QNdefMessage), typeid(QNdefMessage), false, QtJambiPrivate::QListAccess<QNdefRecord>::newInstance(), &deleter_QNdefMessage, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNdefMessage::QNdefMessage(QNdefRecord)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_initialize_1native__Lio_qt_nfc_QNdefMessage_2Lio_qt_nfc_QNdefRecord_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject record0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNdefMessage::QNdefMessage(QNdefRecord)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = record0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QNdefMessage_3, sizeof(QNdefMessage), typeid(QNdefMessage), false, QtJambiPrivate::QListAccess<QNdefRecord>::newInstance(), &deleter_QNdefMessage, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QNdefMessage::operator==(QNdefMessage)const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_equals_1native_1cref_1QNdefMessage_1constfct__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QNdefMessage *__qt_this = QtJambiAPI::objectFromNativeId<QNdefMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNdefMessage::operator==(QNdefMessage)const", __qt_this)
        const QNdefMessage& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QNdefMessage>(other0);
        __java_return_value = (*__qt_this) == __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNdefMessage::toByteArray()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_toByteArray_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QNdefMessage *__qt_this = QtJambiAPI::objectFromNativeId<QNdefMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QNdefMessage::toByteArray()const", __qt_this)
        QByteArray __qt_return_value = __qt_this->toByteArray();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QNdefMessage::fromByteArray(QByteArray)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_fromByteArray_1native_1cref_1QByteArray__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID message0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QNdefMessage::fromByteArray(QByteArray)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QByteArray& __qt_message0 = QtJambiAPI::valueReferenceFromNativeId<QByteArray>(message0);
        QNdefMessage __qt_return_value = QNdefMessage::fromByteArray(__qt_message0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QNdefMessage *__qt_this = QtJambiAPI::objectFromNativeId<QNdefMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(hashValue);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_nfc_QNdefMessage_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QNdefMessage *__qt_this = QtJambiAPI::objectFromNativeId<QNdefMessage>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QNdefMessage(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QNdefMessage>("QNdefMessage", "io/qt/nfc/QNdefMessage");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QNdefMessage, {
        ConstructorInfo(&__qt_construct_QNdefMessage_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QNdefMessage_1, "Ljava/util/Collection;")
       ,ConstructorInfo(&__qt_construct_QNdefMessage_2, "Lio/qt/nfc/QNdefMessage;")
       ,ConstructorInfo(&__qt_construct_QNdefMessage_3, "Lio/qt/nfc/QNdefRecord;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QNdefMessage);
    registerMetaType<QNdefMessage>("QNdefMessage");
    registerContainerAccessFactory(typeId, NewContainerAccessFunction(&QtJambiPrivate::QListAccess<QNdefRecord>::newInstance));
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
