package io.qt.network.auth;

import io.qt.*;


/**
 * <p>Implementation of the OAuth 1 Protocol</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qoauth1.html">QOAuth1</a></code></p>
 */
public class QOAuth1 extends io.qt.network.auth.QAbstractOAuth
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QOAuth1.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qoauth1.html#SignatureMethod-enum">QOAuth1::SignatureMethod</a></code></p>
     */
    public enum SignatureMethod implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qoauth1.html#SignatureMethod-enum">QOAuth1::<wbr/>SignatureMethod::<wbr/>Hmac_Sha1</a></code></p>
         */
        Hmac_Sha1(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qoauth1.html#SignatureMethod-enum">QOAuth1::<wbr/>SignatureMethod::<wbr/>Rsa_Sha1</a></code></p>
         */
        Rsa_Sha1(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qoauth1.html#SignatureMethod-enum">QOAuth1::<wbr/>SignatureMethod::<wbr/>PlainText</a></code></p>
         */
        PlainText(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SignatureMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SignatureMethod resolve(int value) {
            switch (value) {
            case 0: return Hmac_Sha1;
            case 1: return Rsa_Sha1;
            case 2: return PlainText;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code>QOAuth1::<wbr/>clientSharedSecretChanged(QString)</code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> clientSharedSecretChanged = new Signal1<>();

    /**
     * <p>See <code>QOAuth1::<wbr/>signatureMethodChanged(QOAuth1::SignatureMethod)</code></p>
     */
    public final @NonNull Signal1<io.qt.network.auth.QOAuth1.@NonNull SignatureMethod> signatureMethodChanged = new Signal1<>();

    /**
     * <p>See <code>QOAuth1::<wbr/>temporaryCredentialsUrlChanged(QUrl)</code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> temporaryCredentialsUrlChanged = new Signal1<>();

    /**
     * <p>See <code>QOAuth1::<wbr/>tokenCredentialsUrlChanged(QUrl)</code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> tokenCredentialsUrlChanged = new Signal1<>();

    /**
     * <p>See <code>QOAuth1::<wbr/>tokenSecretChanged(QString)</code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> tokenSecretChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#QOAuth1-1">QOAuth1::<wbr/>QOAuth1(QNetworkAccessManager*,<wbr/>QObject*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth1(io.qt.network.@Nullable QNetworkAccessManager manager, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, manager, parent);
    }
    
    private native static void initialize_native(QOAuth1 instance, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#QOAuth1">QOAuth1::<wbr/>QOAuth1(QObject*)</a></code></p>
     */
    public QOAuth1(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QOAuth1 instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#QOAuth1-2">QOAuth1::<wbr/>QOAuth1(QString,<wbr/>QString,<wbr/>QNetworkAccessManager*,<wbr/>QObject*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth1(java.lang.@NonNull String clientIdentifier, java.lang.@NonNull String clientSharedSecret, io.qt.network.@Nullable QNetworkAccessManager manager, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, clientIdentifier, clientSharedSecret, manager, parent);
    }
    
    private native static void initialize_native(QOAuth1 instance, java.lang.String clientIdentifier, java.lang.String clientSharedSecret, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#clientCredentials">QOAuth1::<wbr/>clientCredentials()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String> clientCredentials(){
        return clientCredentials_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPair<java.lang.String, java.lang.String> clientCredentials_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#clientSharedSecret">QOAuth1::<wbr/>clientSharedSecret()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String clientSharedSecret(){
        return clientSharedSecret_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String clientSharedSecret_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#continueGrantWithVerifier">QOAuth1::<wbr/>continueGrantWithVerifier(QString)</a></code></p>
     */
    public final void continueGrantWithVerifier(java.lang.@NonNull String verifier){
        continueGrantWithVerifier_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), verifier);
    }
    
    private native void continueGrantWithVerifier_native_cref_QString(long __this__nativeId, java.lang.String verifier);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#requestTemporaryCredentials">QOAuth1::<wbr/>requestTemporaryCredentials(QNetworkAccessManager::Operation,<wbr/>QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.network.@Nullable QNetworkReply requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.@NonNull Operation operation, io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return requestTemporaryCredentials_native_QNetworkAccessManager_Operation_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkReply requestTemporaryCredentials_native_QNetworkAccessManager_Operation_cref_QUrl_cref_QMap(long __this__nativeId, int operation, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#requestTokenCredentials">QOAuth1::<wbr/>requestTokenCredentials(QNetworkAccessManager::Operation,<wbr/>QUrl,<wbr/>std::pair&lt;QString,<wbr/>QString&gt;,<wbr/>QVariantMap)</a></code></p>
     */
    @QtUninvokable
    protected final io.qt.network.@Nullable QNetworkReply requestTokenCredentials(io.qt.network.QNetworkAccessManager.@NonNull Operation operation, io.qt.core.@NonNull QUrl url, io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String> temporaryToken, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return requestTokenCredentials_native_QNetworkAccessManager_Operation_cref_QUrl_cref_QPair_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(url), temporaryToken, parameters);
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkReply requestTokenCredentials_native_QNetworkAccessManager_Operation_cref_QUrl_cref_QPair_cref_QMap(long __this__nativeId, int operation, long url, io.qt.core.QPair<java.lang.String, java.lang.String> temporaryToken, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setClientCredentials-1">QOAuth1::<wbr/>setClientCredentials(QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final void setClientCredentials(java.lang.@NonNull String clientIdentifier, java.lang.@NonNull String clientSharedSecret){
        setClientCredentials_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientIdentifier, clientSharedSecret);
    }
    
    @QtUninvokable
    private native void setClientCredentials_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String clientIdentifier, java.lang.String clientSharedSecret);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setClientCredentials">QOAuth1::<wbr/>setClientCredentials(std::pair&lt;QString,<wbr/>QString&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setClientCredentials(io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String> clientCredentials){
        setClientCredentials_native_cref_QPair(QtJambi_LibraryUtilities.internal.nativeId(this), clientCredentials);
    }
    
    @QtUninvokable
    private native void setClientCredentials_native_cref_QPair(long __this__nativeId, io.qt.core.QPair<java.lang.String, java.lang.String> clientCredentials);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setClientSharedSecret">QOAuth1::<wbr/>setClientSharedSecret(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setClientSharedSecret(java.lang.@NonNull String clientSharedSecret){
        setClientSharedSecret_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientSharedSecret);
    }
    
    @QtUninvokable
    private native void setClientSharedSecret_native_cref_QString(long __this__nativeId, java.lang.String clientSharedSecret);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setSignatureMethod">QOAuth1::<wbr/>setSignatureMethod(QOAuth1::SignatureMethod)</a></code></p>
     */
    @QtUninvokable
    public final void setSignatureMethod(io.qt.network.auth.QOAuth1.@NonNull SignatureMethod value){
        setSignatureMethod_native_QOAuth1_SignatureMethod(QtJambi_LibraryUtilities.internal.nativeId(this), value.value());
    }
    
    @QtUninvokable
    private native void setSignatureMethod_native_QOAuth1_SignatureMethod(long __this__nativeId, int value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setTemporaryCredentialsUrl">QOAuth1::<wbr/>setTemporaryCredentialsUrl(QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setTemporaryCredentialsUrl(io.qt.core.@NonNull QUrl url){
        setTemporaryCredentialsUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setTemporaryCredentialsUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setTokenCredentials-1">QOAuth1::<wbr/>setTokenCredentials(QString,<wbr/>QString)</a></code></p>
     */
    @QtUninvokable
    public final void setTokenCredentials(java.lang.@NonNull String token, java.lang.@NonNull String tokenSecret){
        setTokenCredentials_native_cref_QString_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), token, tokenSecret);
    }
    
    @QtUninvokable
    private native void setTokenCredentials_native_cref_QString_cref_QString(long __this__nativeId, java.lang.String token, java.lang.String tokenSecret);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setTokenCredentials">QOAuth1::<wbr/>setTokenCredentials(std::pair&lt;QString,<wbr/>QString&gt;)</a></code></p>
     */
    @QtUninvokable
    public final void setTokenCredentials(io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String> tokenCredentials){
        setTokenCredentials_native_cref_QPair(QtJambi_LibraryUtilities.internal.nativeId(this), tokenCredentials);
    }
    
    @QtUninvokable
    private native void setTokenCredentials_native_cref_QPair(long __this__nativeId, io.qt.core.QPair<java.lang.String, java.lang.String> tokenCredentials);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setTokenCredentialsUrl">QOAuth1::<wbr/>setTokenCredentialsUrl(QUrl)</a></code></p>
     */
    @QtUninvokable
    public final void setTokenCredentialsUrl(io.qt.core.@NonNull QUrl url){
        setTokenCredentialsUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setTokenCredentialsUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setTokenSecret">QOAuth1::<wbr/>setTokenSecret(QString)</a></code></p>
     */
    @QtUninvokable
    public final void setTokenSecret(java.lang.@NonNull String tokenSecret){
        setTokenSecret_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), tokenSecret);
    }
    
    @QtUninvokable
    private native void setTokenSecret_native_cref_QString(long __this__nativeId, java.lang.String tokenSecret);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setup-1">QOAuth1::<wbr/>setup(QNetworkRequest*,<wbr/>QVariantMap,<wbr/>QByteArray)</a></code></p>
     */
    @QtUninvokable
    protected final void setup(io.qt.network.@Nullable QNetworkRequest request, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> signingParameters, io.qt.core.@NonNull QByteArray operationVerb){
        setup_native_QNetworkRequest_ptr_cref_QMap_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request), signingParameters, QtJambi_LibraryUtilities.internal.checkedNativeId(operationVerb));
    }
    
    @QtUninvokable
    private native void setup_native_QNetworkRequest_ptr_cref_QMap_cref_QByteArray(long __this__nativeId, long request, java.util.Map<java.lang.String, ? extends java.lang.Object> signingParameters, long operationVerb);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#setup">QOAuth1::<wbr/>setup(QNetworkRequest*,<wbr/>QVariantMap,<wbr/>QNetworkAccessManager::Operation)</a></code></p>
     */
    @QtUninvokable
    protected final void setup(io.qt.network.@Nullable QNetworkRequest request, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> signingParameters, io.qt.network.QNetworkAccessManager.@NonNull Operation operation){
        setup_native_QNetworkRequest_ptr_cref_QMap_QNetworkAccessManager_Operation(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request), signingParameters, operation.value());
    }
    
    @QtUninvokable
    private native void setup_native_QNetworkRequest_ptr_cref_QMap_QNetworkAccessManager_Operation(long __this__nativeId, long request, java.util.Map<java.lang.String, ? extends java.lang.Object> signingParameters, int operation);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#signatureMethod">QOAuth1::<wbr/>signatureMethod()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.network.auth.QOAuth1.@NonNull SignatureMethod signatureMethod(){
        return io.qt.network.auth.QOAuth1.SignatureMethod.resolve(signatureMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int signatureMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#temporaryCredentialsUrl">QOAuth1::<wbr/>temporaryCredentialsUrl()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl temporaryCredentialsUrl(){
        return temporaryCredentialsUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl temporaryCredentialsUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#tokenCredentials">QOAuth1::<wbr/>tokenCredentials()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String> tokenCredentials(){
        return tokenCredentials_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPair<java.lang.String, java.lang.String> tokenCredentials_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#tokenCredentialsUrl">QOAuth1::<wbr/>tokenCredentialsUrl()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl tokenCredentialsUrl(){
        return tokenCredentialsUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl tokenCredentialsUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#tokenSecret">QOAuth1::<wbr/>tokenSecret()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String tokenSecret(){
        return tokenSecret_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String tokenSecret_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#deleteResource">QAbstractOAuth::<wbr/>deleteResource(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    @Override
    public io.qt.network.@Nullable QNetworkReply deleteResource(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return deleteResource_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#get">QAbstractOAuth::<wbr/>get(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    @Override
    public io.qt.network.@Nullable QNetworkReply get(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return get_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#grant">QAbstractOAuth::<wbr/>grant()</a></code></p>
     */
    @Override
    public void grant(){
        grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void grant_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#head">QAbstractOAuth::<wbr/>head(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    @Override
    public io.qt.network.@Nullable QNetworkReply head(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return head_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#post">QAbstractOAuth::<wbr/>post(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    @Override
    public io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return post_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#prepareRequest">QAbstractOAuth::<wbr/>prepareRequest(QNetworkRequest*,<wbr/>QByteArray,<wbr/>QByteArray)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    @Override
    public void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, io.qt.core.@NonNull QByteArray verb, io.qt.core.@NonNull QByteArray body){
        prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request), QtJambi_LibraryUtilities.internal.checkedNativeId(verb), QtJambi_LibraryUtilities.internal.checkedNativeId(body));
    }
    
    @QtUninvokable
    private native void prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(long __this__nativeId, long request, long verb, long body);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#put">QAbstractOAuth::<wbr/>put(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    @Override
    public io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return put_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#generateAuthorizationHeader">QOAuth1::<wbr/>generateAuthorizationHeader(QVariantMap)</a></code></p>
     */
    protected native static io.qt.core.@NonNull QByteArray generateAuthorizationHeader(java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> oauthParams);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qoauth1.html#nonce">QOAuth1::<wbr/>nonce()</a></code></p>
     */
    protected native static io.qt.core.@NonNull QByteArray nonce();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QOAuth1(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QOAuth1(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QOAuth1 instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth1(io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth1(io.qt.network.@Nullable QNetworkAccessManager manager) {
        this(manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth1(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QOAuth1() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QOAuth1(java.lang.String, java.lang.String, io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QOAuth1(java.lang.@NonNull String clientIdentifier, java.lang.@NonNull String clientSharedSecret, io.qt.network.@Nullable QNetworkAccessManager manager) {
        this(clientIdentifier, clientSharedSecret, manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded function for {@link #requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.Operation, io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @QtUninvokable
    protected final io.qt.network.@Nullable QNetworkReply requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.@NonNull Operation operation, io.qt.core.@NonNull QUrl url) {
        return requestTemporaryCredentials(operation, url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.Operation, java.lang.String, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @QtUninvokable
    protected final io.qt.network.@Nullable QNetworkReply requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.@NonNull Operation operation, java.lang.@NonNull String url) {
        return requestTemporaryCredentials(operation, url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.Operation, io.qt.core.QUrl, java.util.Map)}.</p>
     */
    @QtUninvokable
    protected final io.qt.network.@Nullable QNetworkReply requestTemporaryCredentials(io.qt.network.QNetworkAccessManager.@NonNull Operation operation, java.lang.@NonNull String url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters) {
        return requestTemporaryCredentials(operation, new io.qt.core.QUrl(url), parameters);
    }
    
    /**
     * <p>Overloaded function for {@link #requestTokenCredentials(io.qt.network.QNetworkAccessManager.Operation, io.qt.core.QUrl, io.qt.core.QPair, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @QtUninvokable
    protected final io.qt.network.@Nullable QNetworkReply requestTokenCredentials(io.qt.network.QNetworkAccessManager.@NonNull Operation operation, io.qt.core.@NonNull QUrl url, io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String> temporaryToken) {
        return requestTokenCredentials(operation, url, temporaryToken, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #requestTokenCredentials(io.qt.network.QNetworkAccessManager.Operation, java.lang.String, io.qt.core.QPair, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @QtUninvokable
    protected final io.qt.network.@Nullable QNetworkReply requestTokenCredentials(io.qt.network.QNetworkAccessManager.@NonNull Operation operation, java.lang.@NonNull String url, io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String> temporaryToken) {
        return requestTokenCredentials(operation, url, temporaryToken, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #requestTokenCredentials(io.qt.network.QNetworkAccessManager.Operation, io.qt.core.QUrl, io.qt.core.QPair, java.util.Map)}.</p>
     */
    @QtUninvokable
    protected final io.qt.network.@Nullable QNetworkReply requestTokenCredentials(io.qt.network.QNetworkAccessManager.@NonNull Operation operation, java.lang.@NonNull String url, io.qt.core.@NonNull QPair<java.lang.@NonNull String, java.lang.@NonNull String> temporaryToken, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters) {
        return requestTokenCredentials(operation, new io.qt.core.QUrl(url), temporaryToken, parameters);
    }
    
    /**
     * <p>Overloaded function for {@link #setTemporaryCredentialsUrl(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setTemporaryCredentialsUrl(java.lang.@NonNull String url) {
        setTemporaryCredentialsUrl(new io.qt.core.QUrl(url));
    }
    
    /**
     * <p>Overloaded function for {@link #setTokenCredentialsUrl(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setTokenCredentialsUrl(java.lang.@NonNull String url) {
        setTokenCredentialsUrl(new io.qt.core.QUrl(url));
    }
    
    /**
     * <p>Overloaded function for {@link #setup(io.qt.network.QNetworkRequest, java.util.Map, io.qt.core.QByteArray)}.</p>
     */
    @QtUninvokable
    protected final void setup(io.qt.network.@Nullable QNetworkRequest request, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> signingParameters, byte @NonNull[] operationVerb) {
        setup(request, signingParameters, new io.qt.core.QByteArray(operationVerb));
    }
}
