package io.qt.network.auth;

import io.qt.*;


/**
 * <p>Handles replies to OAuth authentication requests</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html">QAbstractOAuthReplyHandler</a></code></p>
 */
public abstract class QAbstractOAuthReplyHandler extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractOAuthReplyHandler.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractOAuthReplyHandler {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        public java.lang.@NonNull String callback(){
            return callback_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native java.lang.String callback_native_constfct(long __this__nativeId);
        
        
        @Override
        public void networkReplyFinished(io.qt.network.@Nullable QNetworkReply reply){
            networkReplyFinished_native_QNetworkReply_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reply));
        }
        private native void networkReplyFinished_native_QNetworkReply_ptr(long __this__nativeId, long reply);
        
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#callbackDataReceived">QAbstractOAuthReplyHandler::<wbr/>callbackDataReceived(QByteArray)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> callbackDataReceived = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#callbackReceived">QAbstractOAuthReplyHandler::<wbr/>callbackReceived(QVariantMap)</a></code></p>
     */
    public final @NonNull Signal1<java.util.@NonNull NavigableMap<java.lang.@NonNull String, java.lang.Object>> callbackReceived = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#replyDataReceived">QAbstractOAuthReplyHandler::<wbr/>replyDataReceived(QByteArray)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> replyDataReceived = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#tokenRequestErrorOccurred">QAbstractOAuthReplyHandler::<wbr/>tokenRequestErrorOccurred(QAbstractOAuth::Error,<wbr/>QString)</a></code></p>
     */
    public final @NonNull Signal2<io.qt.network.auth.QAbstractOAuth.@NonNull Error, java.lang.@NonNull String> tokenRequestErrorOccurred = new Signal2<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#tokensReceived">QAbstractOAuthReplyHandler::<wbr/>tokensReceived(QVariantMap)</a></code></p>
     */
    public final @NonNull Signal1<java.util.@NonNull NavigableMap<java.lang.@NonNull String, java.lang.Object>> tokensReceived = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#QAbstractOAuthReplyHandler">QAbstractOAuthReplyHandler::<wbr/>QAbstractOAuthReplyHandler(QObject*)</a></code></p>
     */
    public QAbstractOAuthReplyHandler(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractOAuthReplyHandler instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#callback">QAbstractOAuthReplyHandler::<wbr/>callback()const</a></code></p>
     */
    @QtUninvokable
    public abstract java.lang.@NonNull String callback();
    
    @QtUninvokable
    private native java.lang.String callback_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauthreplyhandler.html#networkReplyFinished">QAbstractOAuthReplyHandler::<wbr/>networkReplyFinished(QNetworkReply*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public abstract void networkReplyFinished(io.qt.network.@Nullable QNetworkReply reply);
    
    private native void networkReplyFinished_native_QNetworkReply_ptr(long __this__nativeId, long reply);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractOAuthReplyHandler(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAbstractOAuthReplyHandler(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractOAuthReplyHandler instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractOAuthReplyHandler(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractOAuthReplyHandler() {
        this((io.qt.core.QObject)null);
    }
}
