package io.qt.network.auth;

import io.qt.*;


/**
 * <p>The base of all implementations of OAuth authentication methods</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstractoauth.html">QAbstractOAuth</a></code></p>
 */
public abstract class QAbstractOAuth extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @QtPropertyMember(enabled=false)
    private Object __rcNetworkAccessManager = null;
    @QtPropertyMember(enabled=false)
    private Object __rcReplyHandler = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractOAuth.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractOAuth {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        public io.qt.network.@Nullable QNetworkReply deleteResource(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
            return deleteResource_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
        
        @Override
        public io.qt.network.@Nullable QNetworkReply get(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
            return get_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
        
        @Override
        public void grant(){
            grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native void grant_native(long __this__nativeId);
        
        
        @Override
        public io.qt.network.@Nullable QNetworkReply head(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
            return head_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
        
        @Override
        public io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
            return post_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
        
        @Override
        @QtUninvokable
        public void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, io.qt.core.@NonNull QByteArray verb, io.qt.core.@NonNull QByteArray body){
            prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request), QtJambi_LibraryUtilities.internal.checkedNativeId(verb), QtJambi_LibraryUtilities.internal.checkedNativeId(body));
        }
        @QtUninvokable
        private native void prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(long __this__nativeId, long request, long verb, long body);
        
        
        @Override
        public io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
            return put_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
        }
        private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstractoauth.html#ContentType-enum">QAbstractOAuth::ContentType</a></code></p>
     */
    @QtUnlistedEnum
    public enum ContentType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#ContentType-enum">QAbstractOAuth::<wbr/>ContentType::<wbr/>WwwFormUrlEncoded</a></code></p>
         */
        WwwFormUrlEncoded(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#ContentType-enum">QAbstractOAuth::<wbr/>ContentType::<wbr/>Json</a></code></p>
         */
        Json(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ContentType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ContentType resolve(int value) {
            switch (value) {
            case 0: return WwwFormUrlEncoded;
            case 1: return Json;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Error-enum">QAbstractOAuth::Error</a></code></p>
     */
    @QtUnlistedEnum
    public enum Error implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Error-enum">QAbstractOAuth::<wbr/>Error::<wbr/>NoError</a></code></p>
         */
        NoError(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Error-enum">QAbstractOAuth::<wbr/>Error::<wbr/>NetworkError</a></code></p>
         */
        NetworkError(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Error-enum">QAbstractOAuth::<wbr/>Error::<wbr/>ServerError</a></code></p>
         */
        ServerError(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Error-enum">QAbstractOAuth::<wbr/>Error::<wbr/>OAuthTokenNotFoundError</a></code></p>
         */
        OAuthTokenNotFoundError(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Error-enum">QAbstractOAuth::<wbr/>Error::<wbr/>OAuthTokenSecretNotFoundError</a></code></p>
         */
        OAuthTokenSecretNotFoundError(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Error-enum">QAbstractOAuth::<wbr/>Error::<wbr/>OAuthCallbackNotVerified</a></code></p>
         */
        OAuthCallbackNotVerified(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return NetworkError;
            case 2: return ServerError;
            case 3: return OAuthTokenNotFoundError;
            case 4: return OAuthTokenSecretNotFoundError;
            case 5: return OAuthCallbackNotVerified;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Stage-enum">QAbstractOAuth::Stage</a></code></p>
     */
    @QtUnlistedEnum
    public enum Stage implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Stage-enum">QAbstractOAuth::<wbr/>Stage::<wbr/>RequestingTemporaryCredentials</a></code></p>
         */
        RequestingTemporaryCredentials(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Stage-enum">QAbstractOAuth::<wbr/>Stage::<wbr/>RequestingAuthorization</a></code></p>
         */
        RequestingAuthorization(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Stage-enum">QAbstractOAuth::<wbr/>Stage::<wbr/>RequestingAccessToken</a></code></p>
         */
        RequestingAccessToken(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Stage-enum">QAbstractOAuth::<wbr/>Stage::<wbr/>RefreshingAccessToken</a></code></p>
         */
        RefreshingAccessToken(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Stage(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Stage resolve(int value) {
            switch (value) {
            case 0: return RequestingTemporaryCredentials;
            case 1: return RequestingAuthorization;
            case 2: return RequestingAccessToken;
            case 3: return RefreshingAccessToken;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Status-enum">QAbstractOAuth::Status</a></code></p>
     */
    @QtUnlistedEnum
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Status-enum">QAbstractOAuth::<wbr/>Status::<wbr/>NotAuthenticated</a></code></p>
         */
        NotAuthenticated(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Status-enum">QAbstractOAuth::<wbr/>Status::<wbr/>TemporaryCredentialsReceived</a></code></p>
         */
        TemporaryCredentialsReceived(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Status-enum">QAbstractOAuth::<wbr/>Status::<wbr/>Granted</a></code></p>
         */
        Granted(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qabstractoauth.html#Status-enum">QAbstractOAuth::<wbr/>Status::<wbr/>RefreshingToken</a></code></p>
         */
        RefreshingToken(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return NotAuthenticated;
            case 1: return TemporaryCredentialsReceived;
            case 2: return Granted;
            case 3: return RefreshingToken;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt callable <code>QAbstractOAuth::ModifyParametersFunction</code></p>
     */
    @FunctionalInterface
    public interface ModifyParametersFunction extends QtObjectInterface, java.util.function.BiConsumer<io.qt.network.auth.QAbstractOAuth.@NonNull Stage, java.util.@Nullable Map<java.lang.@NonNull String, ? extends java.util.List<? extends java.lang.Object>>> {

        @Override
        public void accept(io.qt.network.auth.QAbstractOAuth.@NonNull Stage arg__1, java.util.@Nullable Map<java.lang.@NonNull String, ? extends java.util.List<? extends java.lang.Object>> arg__2);

        /**
         * @hidden
         * <p>Implementor class for interface {@link ModifyParametersFunction}</p>
         */
        public static abstract class Impl extends QtObject implements ModifyParametersFunction{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(ModifyParametersFunction instance);

            @NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public native void accept(io.qt.network.auth.QAbstractOAuth.@NonNull Stage arg__1, java.util.@Nullable Map<java.lang.@NonNull String, ? extends java.util.List<? extends java.lang.Object>> arg__2);
            }

        }
    }


    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#authorizationUrl-prop">QAbstractOAuth::<wbr/>authorizationUrlChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="authorizationUrl")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> authorizationUrlChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#authorizeWithBrowser">QAbstractOAuth::<wbr/>authorizeWithBrowser(QUrl)</a></code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> authorizeWithBrowser = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#clientIdentifier-prop">QAbstractOAuth::<wbr/>clientIdentifierChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="clientIdentifier")
    public final @NonNull Signal1<java.lang.@NonNull String> clientIdentifierChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#contentType-prop">QAbstractOAuth::<wbr/>contentTypeChanged(QAbstractOAuth::ContentType)</a></code></p>
     */
    @QtPropertyNotify(name="contentType")
    public final @NonNull Signal1<io.qt.network.auth.QAbstractOAuth.@NonNull ContentType> contentTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#extraTokens-prop">QAbstractOAuth::<wbr/>extraTokensChanged(QVariantMap)</a></code></p>
     */
    @QtPropertyNotify(name="extraTokens")
    public final @NonNull Signal1<java.util.@NonNull NavigableMap<java.lang.@NonNull String, java.lang.Object>> extraTokensChanged = new Signal1<>();

    /**
     * <p>See <code>QAbstractOAuth::<wbr/>finished(QNetworkReply*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@Nullable QNetworkReply> finished = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#granted">QAbstractOAuth::<wbr/>granted()</a></code></p>
     */
    public final @NonNull Signal0 granted = new Signal0();

    /**
     * <p>See <code>QAbstractOAuth::<wbr/>replyDataReceived(QByteArray)</code></p>
     */
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> replyDataReceived = new Signal1<>();

    /**
     * <p>See <code>QAbstractOAuth::<wbr/>requestFailed(QAbstractOAuth::Error)</code></p>
     */
    public final @NonNull Signal1<io.qt.network.auth.QAbstractOAuth.@NonNull Error> requestFailed = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#status-prop">QAbstractOAuth::<wbr/>statusChanged(QAbstractOAuth::Status)</a></code></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.network.auth.QAbstractOAuth.@NonNull Status> statusChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#token-prop">QAbstractOAuth::<wbr/>tokenChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="token")
    public final @NonNull Signal1<java.lang.@NonNull String> tokenChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#authorizationUrl">QAbstractOAuth::<wbr/>authorizationUrl()const</a></code></p>
     */
    @QtPropertyReader(name="authorizationUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl authorizationUrl(){
        return authorizationUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl authorizationUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#callback">QAbstractOAuth::<wbr/>callback()const</a></code></p>
     */
    @QtUninvokable
    protected final java.lang.@NonNull String callback(){
        return callback_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String callback_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#clientIdentifier">QAbstractOAuth::<wbr/>clientIdentifier()const</a></code></p>
     */
    @QtPropertyReader(name="clientIdentifier")
    @QtUninvokable
    public final java.lang.@NonNull String clientIdentifier(){
        return clientIdentifier_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String clientIdentifier_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#contentType">QAbstractOAuth::<wbr/>contentType()const</a></code></p>
     */
    @QtPropertyReader(name="contentType")
    @QtUninvokable
    public final io.qt.network.auth.QAbstractOAuth.@NonNull ContentType contentType(){
        return io.qt.network.auth.QAbstractOAuth.ContentType.resolve(contentType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int contentType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#extraTokens">QAbstractOAuth::<wbr/>extraTokens()const</a></code></p>
     */
    @QtPropertyReader(name="extraTokens")
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, java.lang.Object> extraTokens(){
        return extraTokens_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMap<java.lang.String, java.lang.Object> extraTokens_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#modifyParametersFunction">QAbstractOAuth::<wbr/>modifyParametersFunction()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.network.auth.QAbstractOAuth.@Nullable ModifyParametersFunction modifyParametersFunction(){
        return modifyParametersFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.auth.QAbstractOAuth.ModifyParametersFunction modifyParametersFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#networkAccessManager">QAbstractOAuth::<wbr/>networkAccessManager()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@Nullable QNetworkAccessManager networkAccessManager(){
        return networkAccessManager_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QNetworkAccessManager networkAccessManager_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#replyHandler">QAbstractOAuth::<wbr/>replyHandler()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.network.auth.@Nullable QAbstractOAuthReplyHandler replyHandler(){
        return replyHandler_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.auth.QAbstractOAuthReplyHandler replyHandler_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#setAuthorizationUrl">QAbstractOAuth::<wbr/>setAuthorizationUrl(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="authorizationUrl")
    @QtUninvokable
    public final void setAuthorizationUrl(io.qt.core.@NonNull QUrl url){
        setAuthorizationUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setAuthorizationUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#setClientIdentifier">QAbstractOAuth::<wbr/>setClientIdentifier(QString)</a></code></p>
     */
    @QtPropertyWriter(name="clientIdentifier")
    @QtUninvokable
    public final void setClientIdentifier(java.lang.@NonNull String clientIdentifier){
        setClientIdentifier_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientIdentifier);
    }
    
    @QtUninvokable
    private native void setClientIdentifier_native_cref_QString(long __this__nativeId, java.lang.String clientIdentifier);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#setContentType">QAbstractOAuth::<wbr/>setContentType(QAbstractOAuth::ContentType)</a></code></p>
     */
    @QtPropertyWriter(name="contentType")
    @QtUninvokable
    public final void setContentType(io.qt.network.auth.QAbstractOAuth.@NonNull ContentType contentType){
        setContentType_native_QAbstractOAuth_ContentType(QtJambi_LibraryUtilities.internal.nativeId(this), contentType.value());
    }
    
    @QtUninvokable
    private native void setContentType_native_QAbstractOAuth_ContentType(long __this__nativeId, int contentType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#setModifyParametersFunction">QAbstractOAuth::<wbr/>setModifyParametersFunction(QAbstractOAuth::ModifyParametersFunction)</a></code></p>
     */
    @QtUninvokable
    public final void setModifyParametersFunction(io.qt.network.auth.QAbstractOAuth.@Nullable ModifyParametersFunction modifyParametersFunction){
        setModifyParametersFunction_native_cref_QAbstractOAuth_ModifyParametersFunction(QtJambi_LibraryUtilities.internal.nativeId(this), modifyParametersFunction);
    }
    
    @QtUninvokable
    private native void setModifyParametersFunction_native_cref_QAbstractOAuth_ModifyParametersFunction(long __this__nativeId, io.qt.network.auth.QAbstractOAuth.ModifyParametersFunction modifyParametersFunction);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#setNetworkAccessManager">QAbstractOAuth::<wbr/>setNetworkAccessManager(QNetworkAccessManager*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setNetworkAccessManager(io.qt.network.@Nullable QNetworkAccessManager networkAccessManager){
        setNetworkAccessManager_native_QNetworkAccessManager_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(networkAccessManager));
        __rcNetworkAccessManager = networkAccessManager;
    }
    
    @QtUninvokable
    private native void setNetworkAccessManager_native_QNetworkAccessManager_ptr(long __this__nativeId, long networkAccessManager);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#setReplyHandler">QAbstractOAuth::<wbr/>setReplyHandler(QAbstractOAuthReplyHandler*)</a></code></p>
     */
    @QtUninvokable
    public final void setReplyHandler(io.qt.network.auth.@Nullable QAbstractOAuthReplyHandler handler){
        setReplyHandler_native_QAbstractOAuthReplyHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(handler));
        __rcReplyHandler = handler;
    }
    
    @QtUninvokable
    private native void setReplyHandler_native_QAbstractOAuthReplyHandler_ptr(long __this__nativeId, long handler);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#setStatus">QAbstractOAuth::<wbr/>setStatus(QAbstractOAuth::Status)</a></code></p>
     */
    @QtUninvokable
    protected final void setStatus(io.qt.network.auth.QAbstractOAuth.@NonNull Status status){
        setStatus_native_QAbstractOAuth_Status(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @QtUninvokable
    private native void setStatus_native_QAbstractOAuth_Status(long __this__nativeId, int status);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#setToken">QAbstractOAuth::<wbr/>setToken(QString)</a></code></p>
     */
    @QtPropertyWriter(name="token")
    @QtUninvokable
    public final void setToken(java.lang.@NonNull String token){
        setToken_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), token);
    }
    
    @QtUninvokable
    private native void setToken_native_cref_QString(long __this__nativeId, java.lang.String token);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#status">QAbstractOAuth::<wbr/>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.network.auth.QAbstractOAuth.@NonNull Status status(){
        return io.qt.network.auth.QAbstractOAuth.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#token">QAbstractOAuth::<wbr/>token()const</a></code></p>
     */
    @QtPropertyReader(name="token")
    @QtUninvokable
    public final java.lang.@NonNull String token(){
        return token_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String token_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#deleteResource">QAbstractOAuth::<wbr/>deleteResource(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.@Nullable QNetworkReply deleteResource(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#get">QAbstractOAuth::<wbr/>get(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.@Nullable QNetworkReply get(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#grant">QAbstractOAuth::<wbr/>grant()</a></code></p>
     */
    public abstract void grant();
    
    private native void grant_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#head">QAbstractOAuth::<wbr/>head(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.@Nullable QNetworkReply head(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#post">QAbstractOAuth::<wbr/>post(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#prepareRequest">QAbstractOAuth::<wbr/>prepareRequest(QNetworkRequest*,<wbr/>QByteArray,<wbr/>QByteArray)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public abstract void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, io.qt.core.@NonNull QByteArray verb, io.qt.core.@NonNull QByteArray body);
    
    @QtUninvokable
    private native void prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(long __this__nativeId, long request, long verb, long body);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#put">QAbstractOAuth::<wbr/>put(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public abstract io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters);
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#resourceOwnerAuthorization">QAbstractOAuth::<wbr/>resourceOwnerAuthorization(QUrl,<wbr/>QMultiMap&lt;QString,<wbr/>QVariant&gt;)</a></code></p>
     */
    @QtUninvokable
    protected void resourceOwnerAuthorization(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.util.List<? extends java.lang.Object>> parameters){
        resourceOwnerAuthorization_native_cref_QUrl_cref_QMultiMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    @QtUninvokable
    private native void resourceOwnerAuthorization_native_cref_QUrl_cref_QMultiMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.util.List<? extends java.lang.Object>> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#generateRandomString">QAbstractOAuth::<wbr/>generateRandomString(quint8)</a></code></p>
     */
    protected native static io.qt.core.@NonNull QByteArray generateRandomString(byte length);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractOAuth(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #authorizationUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getAuthorizationUrl() {
        return authorizationUrl();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #clientIdentifier()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getClientIdentifier() {
        return clientIdentifier();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #contentType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.network.auth.QAbstractOAuth.@NonNull ContentType getContentType() {
        return contentType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #extraTokens()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<java.lang.@NonNull String, java.lang.Object> getExtraTokens() {
        return extraTokens();
    }
    
    /**
     * <p>Overloaded function for {@link #setAuthorizationUrl(io.qt.core.QUrl)}.</p>
     */
    @QtUninvokable
    public final void setAuthorizationUrl(java.lang.@NonNull String url) {
        setAuthorizationUrl(new io.qt.core.QUrl(url));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.network.auth.QAbstractOAuth.@NonNull Status getStatus() {
        return status();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #token()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getToken() {
        return token();
    }
    
    /**
     * <p>Overloaded function for {@link #deleteResource(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply deleteResource(io.qt.core.@NonNull QUrl url) {
        return deleteResource(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #deleteResource(java.lang.String, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply deleteResource(java.lang.@NonNull String url) {
        return deleteResource(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #deleteResource(io.qt.core.QUrl, java.util.Map)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply deleteResource(java.lang.@NonNull String url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters) {
        return deleteResource(new io.qt.core.QUrl(url), parameters);
    }
    
    /**
     * <p>Overloaded function for {@link #get(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply get(io.qt.core.@NonNull QUrl url) {
        return get(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #get(java.lang.String, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply get(java.lang.@NonNull String url) {
        return get(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #get(io.qt.core.QUrl, java.util.Map)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply get(java.lang.@NonNull String url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters) {
        return get(new io.qt.core.QUrl(url), parameters);
    }
    
    /**
     * <p>Overloaded function for {@link #head(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply head(io.qt.core.@NonNull QUrl url) {
        return head(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #head(java.lang.String, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply head(java.lang.@NonNull String url) {
        return head(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #head(io.qt.core.QUrl, java.util.Map)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply head(java.lang.@NonNull String url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters) {
        return head(new io.qt.core.QUrl(url), parameters);
    }
    
    /**
     * <p>Overloaded function for {@link #post(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url) {
        return post(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #post(java.lang.String, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply post(java.lang.@NonNull String url) {
        return post(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #post(io.qt.core.QUrl, java.util.Map)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply post(java.lang.@NonNull String url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters) {
        return post(new io.qt.core.QUrl(url), parameters);
    }
    
    /**
     * <p>Overloaded function for {@link #prepareRequest(io.qt.network.QNetworkRequest, io.qt.core.QByteArray, io.qt.core.QByteArray)}
     *  with <code>body = new io.qt.core.QByteArray()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, io.qt.core.@NonNull QByteArray verb) {
        prepareRequest(request, verb, new io.qt.core.QByteArray());
    }
    
    /**
     * <p>Overloaded function for {@link #prepareRequest(io.qt.network.QNetworkRequest, byte[], io.qt.core.QByteArray)}
     *  with <code>body = new io.qt.core.QByteArray()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, byte @NonNull[] verb) {
        prepareRequest(request, verb, new io.qt.core.QByteArray());
    }
    
    /**
     * <p>Overloaded function for {@link #prepareRequest(io.qt.network.QNetworkRequest, io.qt.core.QByteArray, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, byte @NonNull[] verb, io.qt.core.@NonNull QByteArray body) {
        prepareRequest(request, new io.qt.core.QByteArray(verb), body);
    }
    
    /**
     * <p>Overloaded function for {@link #prepareRequest(io.qt.network.QNetworkRequest, io.qt.core.QByteArray, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, io.qt.core.@NonNull QByteArray verb, byte @NonNull[] body) {
        prepareRequest(request, verb, new io.qt.core.QByteArray(body));
    }
    
    /**
     * <p>Overloaded function for {@link #prepareRequest(io.qt.network.QNetworkRequest, io.qt.core.QByteArray, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, byte @NonNull[] verb, byte @NonNull[] body) {
        prepareRequest(request, new io.qt.core.QByteArray(verb), new io.qt.core.QByteArray(body));
    }
    
    /**
     * <p>Overloaded function for {@link #put(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url) {
        return put(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #put(java.lang.String, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply put(java.lang.@NonNull String url) {
        return put(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #put(io.qt.core.QUrl, java.util.Map)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply put(java.lang.@NonNull String url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters) {
        return put(new io.qt.core.QUrl(url), parameters);
    }
    
    /**
     * <p>Overloaded function for {@link #resourceOwnerAuthorization(io.qt.core.QUrl, java.util.Map)}.</p>
     */
    @QtUninvokable
    protected final void resourceOwnerAuthorization(java.lang.@NonNull String url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.util.List<? extends java.lang.Object>> parameters) {
        resourceOwnerAuthorization(new io.qt.core.QUrl(url), parameters);
    }
}
