package io.qt.network.auth;

import io.qt.*;


/**
 * <p>The base of all implementations of OAuth 2 authentication methods</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qabstractoauth2.html">QAbstractOAuth2</a></code></p>
 */
public abstract class QAbstractOAuth2 extends io.qt.network.auth.QAbstractOAuth
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractOAuth2.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractOAuth2 {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        public void grant(){
            grant_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native void grant_native(long __this__nativeId);
        
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#authorizationCallbackReceived">QAbstractOAuth2::<wbr/>authorizationCallbackReceived(QVariantMap)</a></code></p>
     */
    public final @NonNull Signal1<java.util.@NonNull NavigableMap<java.lang.@NonNull String, java.lang.Object>> authorizationCallbackReceived = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::<wbr/>clientIdentifierSharedKeyChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="clientIdentifierSharedKey")
    public final @NonNull Signal1<java.lang.@NonNull String> clientIdentifierSharedKeyChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#error">QAbstractOAuth2::<wbr/>error(QString,<wbr/>QString,<wbr/>QUrl)</a></code></p>
     */
    public final @NonNull Signal3<java.lang.@NonNull String, java.lang.@NonNull String, io.qt.core.@NonNull QUrl> error = new Signal3<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#expiration-prop">QAbstractOAuth2::<wbr/>expirationAtChanged(QDateTime)</a></code></p>
     */
    @QtPropertyNotify(name="expiration")
    public final @NonNull Signal1<io.qt.core.@NonNull QDateTime> expirationAtChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#refreshToken-prop">QAbstractOAuth2::<wbr/>refreshTokenChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="refreshToken")
    public final @NonNull Signal1<java.lang.@NonNull String> refreshTokenChanged = new Signal1<>();

    /**
     * <p>See <code>QAbstractOAuth2::<wbr/>responseTypeChanged(QString)</code></p>
     */
    public final @NonNull Signal1<java.lang.@NonNull String> responseTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#scope-prop">QAbstractOAuth2::<wbr/>scopeChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="scope")
    public final @NonNull Signal1<java.lang.@NonNull String> scopeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#sslConfigurationChanged">QAbstractOAuth2::<wbr/>sslConfigurationChanged(QSslConfiguration)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public final @NonNull Signal1<io.qt.network.@NonNull QSslConfiguration> sslConfigurationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#state-prop">QAbstractOAuth2::<wbr/>stateChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="state")
    public final @NonNull Signal1<java.lang.@NonNull String> stateChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::<wbr/>userAgentChanged(QString)</a></code></p>
     */
    @QtPropertyNotify(name="userAgent")
    public final @NonNull Signal1<java.lang.@NonNull String> userAgentChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#QAbstractOAuth2-1">QAbstractOAuth2::<wbr/>QAbstractOAuth2(QNetworkAccessManager*,<wbr/>QObject*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractOAuth2(io.qt.network.@Nullable QNetworkAccessManager manager, io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, manager, parent);
    }
    
    private native static void initialize_native(QAbstractOAuth2 instance, io.qt.network.QNetworkAccessManager manager, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#QAbstractOAuth2">QAbstractOAuth2::<wbr/>QAbstractOAuth2(QObject*)</a></code></p>
     */
    public QAbstractOAuth2(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractOAuth2 instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::<wbr/>clientIdentifierSharedKey()const</a></code></p>
     */
    @QtPropertyReader(name="clientIdentifierSharedKey")
    @QtUninvokable
    public final java.lang.@NonNull String clientIdentifierSharedKey(){
        return clientIdentifierSharedKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String clientIdentifierSharedKey_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#expiration-prop">QAbstractOAuth2::<wbr/>expirationAt()const</a></code></p>
     */
    @QtPropertyReader(name="expiration")
    @QtUninvokable
    public final io.qt.core.@NonNull QDateTime expirationAt(){
        return expirationAt_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QDateTime expirationAt_native_constfct(long __this__nativeId);
    
    /**
     * <p>Gets the current refresh token</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#refreshToken">QAbstractOAuth2::<wbr/>refreshToken()const</a></code></p>
     */
    @QtPropertyReader(name="refreshToken")
    @QtUninvokable
    public final java.lang.@NonNull String refreshToken(){
        return refreshToken_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String refreshToken_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#responseType">QAbstractOAuth2::<wbr/>responseType()const</a></code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String responseType(){
        return responseType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String responseType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#scope-prop">QAbstractOAuth2::<wbr/>scope()const</a></code></p>
     */
    @QtPropertyReader(name="scope")
    @QtUninvokable
    public final java.lang.@NonNull String scope(){
        return scope_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String scope_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#clientIdentifierSharedKey-prop">QAbstractOAuth2::<wbr/>setClientIdentifierSharedKey(QString)</a></code></p>
     */
    @QtPropertyWriter(name="clientIdentifierSharedKey")
    @QtUninvokable
    public final void setClientIdentifierSharedKey(java.lang.@NonNull String clientIdentifierSharedKey){
        setClientIdentifierSharedKey_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), clientIdentifierSharedKey);
    }
    
    @QtUninvokable
    private native void setClientIdentifierSharedKey_native_cref_QString(long __this__nativeId, java.lang.String clientIdentifierSharedKey);
    
    /**
     * <p>Sets the new refresh token refreshToken to be used</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#setRefreshToken">QAbstractOAuth2::<wbr/>setRefreshToken(QString)</a></code></p>
     */
    @QtPropertyWriter(name="refreshToken")
    @QtUninvokable
    public final void setRefreshToken(java.lang.@NonNull String refreshToken){
        setRefreshToken_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), refreshToken);
    }
    
    @QtUninvokable
    private native void setRefreshToken_native_cref_QString(long __this__nativeId, java.lang.String refreshToken);
    
    /**
     * <p>See <code>QAbstractOAuth2::<wbr/>setResponseType(QString)</code></p>
     */
    @QtUninvokable
    protected final void setResponseType(java.lang.@NonNull String responseType){
        setResponseType_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), responseType);
    }
    
    @QtUninvokable
    private native void setResponseType_native_cref_QString(long __this__nativeId, java.lang.String responseType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#scope-prop">QAbstractOAuth2::<wbr/>setScope(QString)</a></code></p>
     */
    @QtPropertyWriter(name="scope")
    @QtUninvokable
    public final void setScope(java.lang.@NonNull String scope){
        setScope_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), scope);
    }
    
    @QtUninvokable
    private native void setScope_native_cref_QString(long __this__nativeId, java.lang.String scope);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#setSslConfiguration">QAbstractOAuth2::<wbr/>setSslConfiguration(QSslConfiguration)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setSslConfiguration(io.qt.network.@NonNull QSslConfiguration configuration){
        setSslConfiguration_native_cref_QSslConfiguration(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(configuration));
    }
    
    @QtUninvokable
    private native void setSslConfiguration_native_cref_QSslConfiguration(long __this__nativeId, long configuration);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#state-prop">QAbstractOAuth2::<wbr/>setState(QString)</a></code></p>
     */
    @QtPropertyWriter(name="state")
    @QtUninvokable
    public final void setState(java.lang.@NonNull String state){
        setState_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), state);
    }
    
    @QtUninvokable
    private native void setState_native_cref_QString(long __this__nativeId, java.lang.String state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::<wbr/>setUserAgent(QString)</a></code></p>
     */
    @QtPropertyWriter(name="userAgent")
    @QtUninvokable
    public final void setUserAgent(java.lang.@NonNull String userAgent){
        setUserAgent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), userAgent);
    }
    
    @QtUninvokable
    private native void setUserAgent_native_cref_QString(long __this__nativeId, java.lang.String userAgent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#sslConfiguration">QAbstractOAuth2::<wbr/>sslConfiguration()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.network.@NonNull QSslConfiguration sslConfiguration(){
        return sslConfiguration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.network.QSslConfiguration sslConfiguration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#state-prop">QAbstractOAuth2::<wbr/>state()const</a></code></p>
     */
    @QtPropertyReader(name="state")
    @QtUninvokable
    public final java.lang.@NonNull String state(){
        return state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#userAgent-prop">QAbstractOAuth2::<wbr/>userAgent()const</a></code></p>
     */
    @QtPropertyReader(name="userAgent")
    @QtUninvokable
    public final java.lang.@NonNull String userAgent(){
        return userAgent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String userAgent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#createAuthenticatedUrl">QAbstractOAuth2::<wbr/>createAuthenticatedUrl(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    public io.qt.core.@NonNull QUrl createAuthenticatedUrl(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return createAuthenticatedUrl_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.core.QUrl createAuthenticatedUrl_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#deleteResource">QAbstractOAuth::<wbr/>deleteResource(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @Override
    public io.qt.network.@Nullable QNetworkReply deleteResource(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return deleteResource_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply deleteResource_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#get">QAbstractOAuth::<wbr/>get(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @Override
    public io.qt.network.@Nullable QNetworkReply get(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return get_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply get_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#head">QAbstractOAuth::<wbr/>head(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @Override
    public io.qt.network.@Nullable QNetworkReply head(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return head_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply head_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#post-1">QAbstractOAuth2::<wbr/>post(QUrl,<wbr/>QByteArray)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, io.qt.core.@NonNull QByteArray data){
        return post_native_cref_QUrl_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QByteArray(long __this__nativeId, long url, long data);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#post-2">QAbstractOAuth2::<wbr/>post(QUrl,<wbr/>QHttpMultiPart*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, io.qt.network.@Nullable QHttpMultiPart multiPart){
        return post_native_cref_QUrl_QHttpMultiPart_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(multiPart));
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_QHttpMultiPart_ptr(long __this__nativeId, long url, long multiPart);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#post">QAbstractOAuth::<wbr/>post(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @Override
    public io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return post_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply post_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#prepareRequest">QAbstractOAuth::<wbr/>prepareRequest(QNetworkRequest*,<wbr/>QByteArray,<wbr/>QByteArray)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    @Override
    public void prepareRequest(io.qt.network.@Nullable QNetworkRequest request, io.qt.core.@NonNull QByteArray verb, io.qt.core.@NonNull QByteArray body){
        prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(request), QtJambi_LibraryUtilities.internal.checkedNativeId(verb), QtJambi_LibraryUtilities.internal.checkedNativeId(body));
    }
    
    @QtUninvokable
    private native void prepareRequest_native_QNetworkRequest_ptr_cref_QByteArray_cref_QByteArray(long __this__nativeId, long request, long verb, long body);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#put-1">QAbstractOAuth2::<wbr/>put(QUrl,<wbr/>QByteArray)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, io.qt.core.@NonNull QByteArray data){
        return put_native_cref_QUrl_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(data));
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QByteArray(long __this__nativeId, long url, long data);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth2.html#put-2">QAbstractOAuth2::<wbr/>put(QUrl,<wbr/>QHttpMultiPart*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, io.qt.network.@Nullable QHttpMultiPart multiPart){
        return put_native_cref_QUrl_QHttpMultiPart_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(multiPart));
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_QHttpMultiPart_ptr(long __this__nativeId, long url, long multiPart);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qabstractoauth.html#put">QAbstractOAuth::<wbr/>put(QUrl,<wbr/>QVariantMap)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @Override
    public io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters){
        return put_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), parameters);
    }
    
    private native io.qt.network.QNetworkReply put_native_cref_QUrl_cref_QMap(long __this__nativeId, long url, java.util.Map<java.lang.String, ? extends java.lang.Object> parameters);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractOAuth2(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAbstractOAuth2(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractOAuth2 instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractOAuth2(io.qt.network.QNetworkAccessManager, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractOAuth2(io.qt.network.@Nullable QNetworkAccessManager manager) {
        this(manager, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractOAuth2(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractOAuth2() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #clientIdentifierSharedKey()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getClientIdentifierSharedKey() {
        return clientIdentifierSharedKey();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #expirationAt()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QDateTime getExpiration() {
        return expirationAt();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #refreshToken()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRefreshToken() {
        return refreshToken();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #scope()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getScope() {
        return scope();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #state()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getState() {
        return state();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #userAgent()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getUserAgent() {
        return userAgent();
    }
    
    /**
     * <p>Overloaded function for {@link #createAuthenticatedUrl(io.qt.core.QUrl, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    public final io.qt.core.@NonNull QUrl createAuthenticatedUrl(io.qt.core.@NonNull QUrl url) {
        return createAuthenticatedUrl(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #createAuthenticatedUrl(java.lang.String, java.util.Map)}
     *  with <code>parameters = java.util.Collections.emptyNavigableMap()</code>.</p>
     */
    public final io.qt.core.@NonNull QUrl createAuthenticatedUrl(java.lang.@NonNull String url) {
        return createAuthenticatedUrl(url, java.util.Collections.emptyNavigableMap());
    }
    
    /**
     * <p>Overloaded function for {@link #createAuthenticatedUrl(io.qt.core.QUrl, java.util.Map)}.</p>
     */
    public final io.qt.core.@NonNull QUrl createAuthenticatedUrl(java.lang.@NonNull String url, java.util.@NonNull Map<java.lang.@NonNull String, ? extends java.lang.Object> parameters) {
        return createAuthenticatedUrl(new io.qt.core.QUrl(url), parameters);
    }
    
    /**
     * <p>Overloaded function for {@link #post(io.qt.core.QUrl, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply post(java.lang.@NonNull String url, io.qt.core.@NonNull QByteArray data) {
        return post(new io.qt.core.QUrl(url), data);
    }
    
    /**
     * <p>Overloaded function for {@link #post(io.qt.core.QUrl, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply post(io.qt.core.@NonNull QUrl url, byte @NonNull[] data) {
        return post(url, new io.qt.core.QByteArray(data));
    }
    
    /**
     * <p>Overloaded function for {@link #post(io.qt.core.QUrl, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply post(java.lang.@NonNull String url, byte @NonNull[] data) {
        return post(new io.qt.core.QUrl(url), new io.qt.core.QByteArray(data));
    }
    
    /**
     * <p>Overloaded function for {@link #post(io.qt.core.QUrl, io.qt.network.QHttpMultiPart)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply post(java.lang.@NonNull String url, io.qt.network.@Nullable QHttpMultiPart multiPart) {
        return post(new io.qt.core.QUrl(url), multiPart);
    }
    
    /**
     * <p>Overloaded function for {@link #put(io.qt.core.QUrl, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply put(java.lang.@NonNull String url, io.qt.core.@NonNull QByteArray data) {
        return put(new io.qt.core.QUrl(url), data);
    }
    
    /**
     * <p>Overloaded function for {@link #put(io.qt.core.QUrl, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply put(io.qt.core.@NonNull QUrl url, byte @NonNull[] data) {
        return put(url, new io.qt.core.QByteArray(data));
    }
    
    /**
     * <p>Overloaded function for {@link #put(io.qt.core.QUrl, io.qt.core.QByteArray)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply put(java.lang.@NonNull String url, byte @NonNull[] data) {
        return put(new io.qt.core.QUrl(url), new io.qt.core.QByteArray(data));
    }
    
    /**
     * <p>Overloaded function for {@link #put(io.qt.core.QUrl, io.qt.network.QHttpMultiPart)}.</p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.network.@Nullable QNetworkReply put(java.lang.@NonNull String url, io.qt.network.@Nullable QHttpMultiPart multiPart) {
        return put(new io.qt.core.QUrl(url), multiPart);
    }
}
